---
comments: true
description: Исследуйте YOLOv7, реальный детектор объектов в реальном времени. Познакомьтесь с его высокой скоростью, впечатляющей точностью и уникальным фокусом на тренируемой оптимизации с использованием "мешка бесплатных улучшений".
keywords: YOLOv7, детектор объектов в реальном времени, новейший, Ultralytics, набор данных MS COCO, репараметризация модели, динамическое присвоение меток, расширенное масштабирование, компаунд-масштабирование
---

# YOLOv7: Тренируемый "мешок бесплатных улучшений"

YOLOv7 - это новейший детектор объектов в реальном времени, который превосходит все известные детекторы объектов по скорости и точности в диапазоне от 5 к/с до 160 к/с. У него самая высокая точность (56,8% AP) среди всех известных детекторов объектов в режиме реального времени со скоростью 30 к/с и выше на GPU V100. Кроме того, YOLOv7 превосходит другие детекторы объектов, такие как YOLOR, YOLOX, Scaled-YOLOv4, YOLOv5 и многие другие, в скорости и точности. Модель обучается с нуля на наборе данных MS COCO без использования других наборов данных или предварительно обученных весов. Исходный код для YOLOv7 доступен на GitHub.

![Сравнение YOLOv7 с новейшими детекторами объектов](https://github.com/ultralytics/ultralytics/assets/26833433/5e1e0420-8122-4c79-b8d0-2860aa79af92)
**Сравнение новейших детекторов объектов.** Из результатов в Таблице 2 мы знаем, что предложенный метод обеспечивает лучшее соотношение скорость-точность в целом. Если сравнивать YOLOv7-tiny-SiLU с YOLOv5-N (r6.1), наш метод быстрее на 127 к/с и точнее на 10,7% по AP. Кроме того, YOLOv7 имеет точность AP 51,4% при скорости кадров 161 к/с, в то время как PPYOLOE-L с такой же точностью имеет только скорость кадров 78 к/с. Что касается использования параметров, YOLOv7 сокращает их на 41% по сравнению с PPYOLOE-L. Если сравнить YOLOv7-X с 114 к/с скоростью вывода с YOLOv5-L (r6.1) с 99 к/с скоростью вывода, YOLOv7-X может повысить AP на 3,9%. Если сравнить YOLOv7-X с YOLOv5-X (r6.1) с похожими масштабами, скорость вывода YOLOv7-X на 31 к/с выше. Кроме того, по количеству параметров и вычислений YOLOv7-X сокращает параметры на 22% и вычисления на 8% по сравнению с YOLOv5-X (r6.1), но повышает AP на 2,2% ([Источник](https://arxiv.org/pdf/2207.02696.pdf)).

## Обзор

Детектирование объектов в реальном времени - это важный компонент многих систем компьютерного зрения, включая многотаргетное отслеживание, автономное вождение, робототехнику и анализ медицинских изображений. В последние годы разработка детекторов объектов в реальном времени сосредоточена на проектировании эффективных архитектур и повышении скорости вывода на различных ЦП, ГПУ и нейропроцессорах (NPUs). YOLOv7 поддерживает как мобильные графические процессоры (GPU), так и устройства GPU, от периферии до облачных вычислений.

В отличие от традиционных детекторов объектов в реальном времени, которые сосредоточены на оптимизации архитектуры, YOLOv7 вводит концепцию оптимизации процесса обучения. Это включает модули и методы оптимизации, разработанные для повышения точности детектирования объектов без увеличения стоимости вывода, известного как "тренируемый мешок бесплатных улучшений".

## Основные функции

YOLOv7 предлагает несколько ключевых функций:

1. **Репараметризация модели**: YOLOv7 предлагает запланированную переапарамеризацию модели, которая является стратегией, применимой к слоям в разных сетях с концепцией пути градиентного распространения.

2. **Динамическое присвоение меток**: Обучение модели с несколькими выходными слоями представляет новую проблему: "Как назначить динамические цели для выходов разных ветвей?" Для решения этой проблемы YOLOv7 предлагает новый метод присвоения меток, называемый грубо-тонким присвоением меток с управлением ведущей ветви.

3. **Расширенное и компаунд-масштабирование**: YOLOv7 предлагает методы "расширения" и "компаунд-масштабирования" для детектора объектов в реальном времени, которые эффективно используют параметры и вычисления.

4. **Эффективность**: Метод, предложенный YOLOv7, может эффективно сокращать примерно на 40% количество параметров и на 50% вычислений известного детектора объектов в реальном времени, обеспечивая более быструю скорость вывода и более высокую точность детектирования.

## Примеры использования

На момент написания данного документа Ultralytics в настоящее время не поддерживает модели YOLOv7. Поэтому все пользователи, заинтересованные в использовании YOLOv7, должны обратиться непосредственно к репозиторию YOLOv7 на GitHub для инструкций по установке и использованию.

Вот краткий обзор типичных шагов, которые могут потребоваться для использования YOLOv7:

1. Посетите репозиторий YOLOv7 на GitHub: [https://github.com/WongKinYiu/yolov7](https://github.com/WongKinYiu/yolov7).

2. Следуйте инструкциям, предоставленным в файле README по установке. Обычно это включает клонирование репозитория, установку необходимых зависимостей и настройку необходимых переменных среды.

3. После завершения установки вы можете обучать и использовать модель в соответствии с инструкциями по использованию, предоставленными в репозитории. Обычно это включает подготовку набора данных, настройку параметров модели, обучение модели, а затем использование обученной модели для выполнения детектирования объектов.

Обратите внимание, что конкретные шаги могут варьироваться в зависимости от вашего конкретного случая использования и текущего состояния репозитория YOLOv7. Поэтому настоятельно рекомендуется обратиться непосредственно к инструкциям, предоставленным в репозитории YOLOv7 на GitHub.

Мы сожалеем обо всех неудобствах, которые это может вызвать, и будем стараться обновлять этот документ с примерами использования для Ultralytics, как только будет реализована поддержка YOLOv7.

## Цитирования и благодарности

Мы хотели бы выразить признательность авторам YOLOv7 за их значительный вклад в области детектирования объектов в реальном времени:

!!! Quote ""

    === "BibTeX"

        ```bibtex
        @article{wang2022yolov7,
          title={{YOLOv7}: Trainable bag-of-freebies sets new state-of-the-art for real-time object detectors},
          author={Wang, Chien-Yao and Bochkovskiy, Alexey and Liao, Hong-Yuan Mark},
          journal={arXiv preprint arXiv:2207.02696},
          year={2022}
        }
        ```

Исходную статью YOLOv7 можно найти на [arXiv](https://arxiv.org/pdf/2207.02696.pdf). Авторы опубликовали свою работу публично, и код доступен на [GitHub](https://github.com/WongKinYiu/yolov7). Мы ценим их усилия в совершенствовании этой области и доступности своей работы для широкой общественности.
