---
comments: true
description: Изучение различных наборов данных компьютерного зрения, поддерживаемых Ultralytics, для задач объектного обнаружения, сегментации, оценки поз, классификации изображений и многократного отслеживания объектов.
keywords: компьютерное зрение, наборы данных, Ultralytics, YOLO, обнаружение объектов, индивидуальная сегментация, оценка позы, классификация изображений, многократное отслеживание объектов
---

# Обзор наборов данных

Ultralytics предоставляет поддержку различных наборов данных для выполнения задач компьютерного зрения, таких как обнаружение объектов, индивидуальная сегментация, оценка поз, классификация и многократное отслеживание объектов. Ниже приведен список основных наборов данных Ultralytics, а затем представлены описание каждой задачи компьютерного зрения и соответствующие наборы данных.

!!! Note "Заметка"

    🚧 Наша многоязычная документация в настоящее время находится в стадии разработки, и мы усердно работаем над ее улучшением. Спасибо за терпение! 🙏

## [Наборы данных для обнаружения](../../datasets/detect/index.md)

Обнаружение объектов с помощью ограничивающих рамок - это метод компьютерного зрения, который включает обнаружение и локализацию объектов на изображении путем рисования вокруг каждого объекта прямоугольной рамки.

- [Argoverse](../../datasets/detect/argoverse.md): Набор данных, содержащий данные о 3D отслеживании и прогнозировании движения из городских условий с подробными аннотациями.
- [COCO](../../datasets/detect/coco.md): Масштабный набор данных, предназначенный для обнаружения объектов, сегментации и аннотирования с более чем 200 тыс. помеченных изображений.
- [COCO8](../../datasets/detect/coco8.md): Содержит первые 4 изображения из наборов COCO train и COCO val, подходит для быстрых тестов.
- [Global Wheat 2020](../../datasets/detect/globalwheat2020.md): Набор данных из изображений колосьев пшеницы, собранных со всего мира для задач обнаружения и локализации объектов.
- [Objects365](../../datasets/detect/objects365.md): Качественный набор данных большого масштаба для обнаружения объектов с 365 категориями объектов и более чем 600 тыс. помеченных изображений.
- [OpenImagesV7](../../datasets/detect/open-images-v7.md): Обширный набор данных от Google с 1,7 млн. изображений для обучения и 42 тыс. изображений для проверки.
- [SKU-110K](../../datasets/detect/sku-110k.md): Набор данных для плотного обнаружения объектов в розничной торговле с более чем 11 тыс. изображений и 1,7 млн. ограничивающих рамок.
- [VisDrone](../../datasets/detect/visdrone.md): Набор данных, содержащий данные для обнаружения объектов и многократного отслеживания из изображений, полученных с дронов, с более чем 10 тыс. изображений и видеопоследовательностей.
- [VOC](../../datasets/detect/voc.md): Набор данных Pascal Visual Object Classes (VOC) для обнаружения объектов и сегментации с 20 категориями объектов и более чем 11 тыс. изображений.
- [xView](../../datasets/detect/xview.md): Набор данных для обнаружения объектов на изображениях с воздуха с 60 категориями объектов и более чем 1 млн. аннотированных объектов.

## [Наборы данных для индивидуальной сегментации](../../datasets/segment/index.md)

Индивидуальная сегментация - это метод компьютерного зрения, включающий идентификацию и локализацию объектов на изображении на уровне пикселей.

- [COCO](../../datasets/segment/coco.md): Масштабный набор данных, разработанный для задач обнаружения объектов, сегментации и аннотирования с более чем 200 тыс. помеченных изображений.
- [COCO8-seg](../../datasets/segment/coco8-seg.md): Уменьшенный набор данных для задач индивидуальной сегментации, содержащий подмножество из 8 изображений COCO с аннотациями сегментации.

## [Оценка поз](../../datasets/pose/index.md)

Оценка позы - это техника, используемая для определения позы объекта относительно камеры или системы координат мира.

- [COCO](../../datasets/pose/coco.md): Масштабный набор данных с аннотациями человеческой позы, разработанный для задач оценки позы.
- [COCO8-pose](../../datasets/pose/coco8-pose.md): Уменьшенный набор данных для задач оценки позы, содержащий подмножество из 8 изображений COCO с аннотациями позы человека.
- [Tiger-pose](../../datasets/pose/tiger-pose.md): Компактный набор данных из 263 изображений, сфокусированных на тиграх, аннотированных 12 ключевыми точками на тигре для задач оценки позы.

## [Классификация](../../datasets/classify/index.md)

Классификация изображений - это задача компьютерного зрения, которая включает категоризацию изображения в один или несколько заранее определенных классов или категорий на основе его визуального содержания.

- [Caltech 101](../../datasets/classify/caltech101.md): Набор данных, содержащий изображения 101 категории объектов для задач классификации изображений.
- [Caltech 256](../../datasets/classify/caltech256.md): Расширенная версия Caltech 101 с 256 категориями объектов и более сложными изображениями.
- [CIFAR-10](../../datasets/classify/cifar10.md): Набор данных из 60 тыс. цветных изображений размером 32x32 в 10 классах, по 6 тыс. изображений на класс.
- [CIFAR-100](../../datasets/classify/cifar100.md): Расширенная версия CIFAR-10 со 100 категориями объектов и 600 изображениями на класс.
- [Fashion-MNIST](../../datasets/classify/fashion-mnist.md): Набор данных из 70 тыс. изображений в оттенках серого 10 модных категорий для задач классификации изображений.
- [ImageNet](../../datasets/classify/imagenet.md): Масштабный набор данных для обнаружения объектов и классификации изображений с более чем 14 млн. изображений и 20 тыс. категорий.
- [ImageNet-10](../../datasets/classify/imagenet10.md): Уменьшенное подмножество ImageNet с 10 категориями для более быстрого экспериментирования и тестирования.
- [Imagenette](../../datasets/classify/imagenette.md): Уменьшенное подмножество ImageNet, содержащее 10 легко различаемых классов для более быстрого обучения и тестирования.
- [Imagewoof](../../datasets/classify/imagewoof.md): Более сложное подмножество ImageNet, содержащее 10 категорий пород собак для задач классификации изображений.
- [MNIST](../../datasets/classify/mnist.md): Набор данных из 70 тыс. изображений в оттенках серого рукописных цифр для задач классификации изображений.

## [Ориентированные Ограничивающие Рамки (OBB)](../../datasets/obb/index.md)

Ориентированные ограничивающие рамки (OBB) - это метод в компьютерном зрении для обнаружения наклонных объектов на изображениях с использованием повернутых ограничивающих рамок, часто применяемый к аэрофотосъемке и спутниковым изображениям.

- [DOTAv2](../../datasets/obb/dota-v2.md): Популярный набор данных аэрофотосъемки OBB с 1,7 миллионами инста nces и 11,268 изображениями.

## [Многократное отслеживание объектов](../../datasets/track/index.md)

Многократное отслеживание объектов - это техника компьютерного зрения, которая включает обнаружение и отслеживание нескольких объектов во времени в видеопоследовательности.

- [Argoverse](../../datasets/detect/argoverse.md): Набор данных, содержащий данные о 3D отслеживании и прогнозировании движения из городских условий с подробными аннотациями для задач многократного отслеживания объектов.
- [VisDrone](../../datasets/detect/visdrone.md): Набор данных, содержащий данные для обнаружения объектов и многократного отслеживания из изображений, полученных с дронов, с более чем 10 тыс. изображений и видеопоследовательностей.

## Внесение новых наборов данных

Внесение нового набора данных включает несколько шагов для обеспечения его соответствия существующей инфраструктуре. Ниже приведены необходимые шаги:

### Шаги для внесения нового набора данных

1. **Сбор изображений**: Соберите изображения, которые принадлежат набору данных. Их можно собрать из различных источников, таких как публичные базы данных или ваш собственный сбор.

2. **Аннотация изображений**: Пометьте эти изображения ограничивающими рамками, сегментами или ключевыми точками в зависимости от задачи.

3. **Экспорт аннотаций**: Конвертируйте эти аннотации в формат файлов YOLO *.txt, который поддерживается Ultralytics.

4. **Организация набора данных**: Распределите ваш набор данных в правильную структуру папок. У вас должны быть каталоги верхнего уровня `train/` и `val/`, и в каждом из них подкаталоги `images/` и `labels/`.

    ```
    dataset/
    ├── train/
    │   ├── images/
    │   └── labels/
    └── val/
        ├── images/
        └── labels/
    ```

5. **Создание файла `data.yaml`**: В корневой директории вашего набора данных создайте файл `data.yaml`, который описывает набор данных, классы и другую необходимую информацию.

6. **Оптимизация изображений (опционально)**: Если вы хотите уменьшить размер набора данных для более эффективной обработки, вы можете оптимизировать изображения с помощью приведенного ниже кода. Это не является обязательным, но рекомендуется для уменьшения размеров набора данных и ускорения скорости загрузки.

7. **Архивация набора данных**: Сжать всю папку набора данных в zip-файл.

8. **Документация и Pull Request (PR)**: Создайте страницу документации, описывающую ваш набор данных и его соответствие существующей структуре. После этого отправьте Pull Request. Смотрите [Руководство по внесению вклада в Ultralytics](https://docs.ultralytics.com/help/contributing) для получения более подробной информации о том, как отправить PR.

### Пример кода для оптимизации и архивации набора данных

!!! Example "Оптимизация и архивация набора данных"

    === "Python"

    ```python
    from pathlib import Path
    from ultralytics.data.utils import compress_one_image
    from ultralytics.utils.downloads import zip_directory

    # Определите директорию набора данных
    path = Path('path/to/dataset')

    # Оптимизация изображений в наборе данных (опционально)
    for f in path.rglob('*.jpg'):
        compress_one_image(f)

    # Архивация набора данных в 'path/to/dataset.zip'
    zip_directory(path)
    ```

Следуя этим шагам, вы сможете внести новый набор данных, который хорошо интегрируется с существующей структурой Ultralytics.
