---
comments: true
description: YOLOv7, एक रियल-टाइम ऑब्जेक्ट डिटेक्टर है। इसकी अद्वितीय स्पीड, प्रभावशाली सटीकता, और अद्यतनीय "बैग-ऑफ-फ्रीबीज" अनुकूलन ध्यानदेने योग्यता को समझें।
keywords: YOLOv7, रियल-टाइम ऑब्जेक्ट डिटेक्टर, तकनीक-से-अलावा कुछ औफ़ान, Ultralytics, MS COCO डेटासेट, मॉडल फिर-पैरामीटरीकरण, डायनामिक लेबल असाइनमेंट, विस्तारित मापन, कंपाउंड मापन
---

# YOLOv7: ट्रेनबल बैग-ऑफ-फ्रीबीज़

YOLOv7 एक अद्वितीय रियल-टाइम ऑब्जेक्ट डिटेक्टर है जो 5 FPS से 160 FPS तक की रेंज में सभी ज्ञात ऑब्जेक्ट डिटेक्टर्स को तेज़ी और सटीकता के मामले में पीछे छोड़ देता है। यह 30 FPS या उससे अधिक पर GPU V100 पर सभी ज्ञात रियल-टाइम ऑब्जेक्ट डिटेक्टर्स में सबसे अधिक अक्यूरेट (56.8% AP) है। इसके अलावा, YOLOv7 तेजी और सटीकता के मामले में YOLOR, YOLOX, Scaled-YOLOv4, YOLOv5, और कई अन्य ऑब्जेक्ट डिटेक्टर्स से बेहतर परफॉर्म करता है। यह मॉडल MS COCO डेटासेट पर पहले से ही ट्रेनिंग है और किसी अन्य डेटासेट या पूर्व-ट्रेन हुई वेट्स का प्रयोग नहीं करता है। YOLOv7 के स्रोत कोड [GitHub](https://github.com/WongKinYiu/yolov7) पर उपलब्ध है।

![SOTA ऑब्जेक्ट डिटेक्टर्स के तुलनात्मक मुक़ाबला](https://github.com/ultralytics/ultralytics/assets/26833433/5e1e0420-8122-4c79-b8d0-2860aa79af92)
**वैश्विक-से-अलावा ऑब्जेक्ट डिटेक्टर्स का तुलनात्मक मुक़ाबला।** तालिका 2 में प्रदर्शित परिणामों से हमें यह पता चलता है कि प्रस्तावित विधि संपूर्णता से सबसे अच्छा तेजी-अक्यूरेटता संघर्ष लाती है। अगर हम YOLOv7-tiny-SiLU को YOLOv5-N (r6.1) के साथ तुलना करें, तो हमारी विधि 127 fps तेज़ और AP में 10.7% अधिक सटीक है। साथ ही, YOLOv7 के साथ AP 51.4% है जबकि PPYOLOE-L के साथ एक ही AP के साथ 78 fps फ्रेम रेट है। पैरामीटर उपयोग के मामले में, YOLOv7 PPYOLOE-L की तुलना में 41% कम है। YOLOv7-X को 114 fps इन्फरेंस स्पीड के साथ YOLOv5-L (r6.1) के साथ तुलना करें तो, YOLOv7-X AP को 3.9% बढ़ा सकता है। YOLOv7-X को बराबर स्केल के YOLOv5-X (r6.1) के साथ तुलना करें तो, YOLOv7-X की इन्फेरेंस स्पीड 31 fps तेज़ है। साथ ही, पैरामीटर और परिकलन की मात्रा के मामले में, YOLOv7-X पहले योलोव5-X (r6.1) की तुलना में 22% पैरामीटर कम करता है और 8% परिकलन कम करता है, लेकिन AP को 2.2% बढ़ाता है। ([स्रोत](https://arxiv.org/pdf/2207.02696.pdf))।

## अवलोकन

रियल-टाइम ऑब्जेक्ट डिटेक्शन कंप्यूटर विजन के कई सिस्टमों में एक महत्वपूर्ण घटक है, जिसमें मल्टी-ऑब्जेक्ट ट्रैकिंग, स्वतंत्र चालन, रोबोटिक्स, और मेडिकल इमेज विश्लेषण शामिल हैं। योग्यता के विकास के लिए हाल के वर्षों में रियल-टाइम ऑब्जेक्ट डिटेक्शन विकास ने विभिन्न सीपीयू, जीपीयू, और न्यूरल प्रोसेसिंग यूनिटों (एनपीयू) के कार्यान्वयन की तेजी बढ़ाने और अधिक अधिक ज्ञानसरचकों के लिए। YOLOv7 ने मोबाइल जीपीयू और जीपीयू डिवाइस, इज़्ज टु द क्लाउड, को समर्थन दिया है।

पारंपरिक रियल-टाइम ऑब्जेक्ट डिटेक्टर्स की तुलना में जो कि शारीरिक अभिव्यक्ति अनुकूलन पर ध्यान केंद्रित होते हैं, YOLOv7 ट्रेनिंग प्रक्रिया को अनुकरण करने पर ध्यान केंद्रित करने का सुझाव देता है। इसमें मॉड्यूल्स और ऑप्टिमाइज़ेशन मेथड्स शामिल हैं जिनका उपयोग करके ऑब्जेक्ट डिटेक्शन की अक्यूरेसी में सुधार किया जाता है बिना इन्फेरेंस की लागत बढ़ाए, जिसे "ट्रेनबल बैग-ऑफ-फ्रीबीज़" की एक नई कांसेप्ट के आधार पर कहा जाता है।

## मुख्य विशेषताएँ

YOLOv7 साथ में कई मुख्य विशेषताएँ लाता है:

1. **मॉडल फिर-पैरामीटरीकरण**: YOLOv7 एक योजना बनाकर फिर-पैरामीटराइज़्ड मॉडल प्रस्तावित करता है, जो एक कण्टिनुअस संकर्णन पथ की संकल्पना के साथ विभिन्न नेटवर्कों के लिए लागू करने योग्य है।

2. **डायनामिक लेबल असाइनमेंट**: एकाधिक आउटपुट लेयर्स के साथ मॉडल की ट्रेनिंग करने से एक नया मुद्दा पेश किया जाता है: "अलग-अलग शाखाओं के आउटपुट के लिए डायनामिक निर्धारित लक्ष्य कैसे दें?" इस समस्या को हल करने के लिए, YOLOv7 ने "कॉर्स-टू-फ़ाइन लीड गाइडेड लेबल असाइनमेंट" नामक एक नई लेबल असाइनमेंट विधि पेश की है।

3. **विस्तारित और कंपाउंड मापन**: YOLOv7 वास्तविक समय ऑब्जेक्ट डिटेक्टर के लिए "विस्तारित" और "कंपाउंड मापन" विधियों को प्रस्तावित करता है जो पैरामीटर और परिकलन का सकारात्मक रूप से उपयोग कर सकती हैं।

4. **दक्षता**: YOLOv7 द्वारा प्रस्तावित विधि राष्ट्रीय स्तर के वास्तविक समय ऑब्जेक्ट डिटेक्टर के लगभग 40% पैरामीटर और 50% परिकलन को कम कर सकती है, और बेहतर इन्फेरेंस गति और अधिक डिटेक्शन अक्यूरेसी है।

## उपयोग की उदाहरण

लेख की अवस्था के समय, Ultralytics वर्तमान में YOLOv7 मॉडेल का समर्थन नहीं करता है। इसलिए, YOLOv7 का उपयोग करना चाहने वाले किसी भी उपयोगकर्ता के लिए योग्यता के लिए कृपया सीधे YOLOv7 GitHub रिपॉज़िटरी के निर्देशिका का संदर्भ लें।

यहां YOLOv7 का उपयोग करने के लिए आप निम्नलिखित आम कदमों का सारांश देख सकते हैं:

1. YOLOv7 GitHub रिपॉज़िटरी पर जाएं: [https://github.com/WongKinYiu/yolov7](https://github.com/WongKinYiu/yolov7)।

2. स्थापना के लिए README फ़ाइल में दिए हुए निर्देशों का पालन करें। इसमें आमतौर पर रिपॉज़िटरी क्लोनिंग, आवश्यक डिपेंडेंसियों की स्थापना, और आवश्यक पर्यावरण चरों का सेटअप शामिल होता है।

3. स्थापना सम्पूर्ण होने के बाद, आप मॉडल को ट्रेन कर सकते हैं और विशेषताओं का उपयोग करके ऑब्जेक्ट डिटेक्शन कर सकते हैं, जैसा कि रेपॉज़िटरी में उपयोग के निर्देश दिए गए हैं। यह आमतौर पर अपने डेटासेट को तैयार करना, मॉडल पैरामीटर कॉन्फ़िगर करना, मॉडल को ट्रेन करना, और फिर ट्रेन किए गए मॉडल का उपयोग करके ऑब्जेक्ट डिटेक्शन करना शामिल होता है।

कृपया ध्यान दें कि निर्दिष्ट कदम आपके विशिष्ट उपयोग मामले और YOLOv7 रिपॉज़िटरी की वर्तमान स्थिति पर निर्भर कर सकते हैं। इसलिए, योग्यता के लिए सीधे YOLOv7 GitHub रिपॉज़िटरी में दिए गए निर्देशों का संदर्भ लेना माज़बूती से अनुशंसित है।

हम इससे होने वाली किसी भी असुविधा के लिए खेद प्रकट करते हैं और YOLOv7 के समर्थन को Ultralytics में लागू होने पर उदाहरणों के साथ इस दस्तावेज़ को अद्यतित करने का प्रयास करेंगे।

## संदर्भ और आभार

हम YOLOv7 लेखकों को यहां उल्लेख करना चाहेंगे, उनके वास्तविक समय ऑब्जेक्ट डिटेक्शन क्षेत्र में महत्वपूर्ण योगदान के लिए:

!!! Quote ""

    === "BibTeX"

        ```bibtex
        @article{wang2022yolov7,
          title={{YOLOv7}: ट्रेनबल बैग-ऑफ-फ्रीबीज हासिल करता है वास्तविक समय ऑब्जेक्ट डिटेक्टर्स के लिए नई राष्ट्रीय स्तर को},
          author={Wang, Chien-Yao and Bochkovskiy, Alexey and Liao, Hong-Yuan Mark},
          journal={arXiv preprint arXiv:2207.02696},
          year={2022}
        }
        ```

YOLOv7 के मूल लेख को [arXiv](https://arxiv.org/pdf/2207.02696.pdf) पर पाया जा सकता है। लेखकों ने अपना काम सार्वजनिक रूप से उपलब्ध किया है और कोडबेस [GitHub](https://github.com/WongKinYiu/yolov7) पर एक्सेस किया जा सकता है। हम उनके प्रयासों की सराहना करते हैं जो क्षेत्र को आगे बढ़ाने और उसे व्यापक समुदाय के लिए सुलभ बनाने में किए गए हैं।
