---
comments: true
description: YOLOv4 के बारे में हमारे विस्तृत गाइड पर आपका स्वागत है, जो एक नवीनतम समय मेंकिए गए वास्तविक समय वस्तुओं का पता लगाने वाला उत्कृष्ट ऑब्जेक्ट डिटेक्टर है। इसे योग्यता से उपयोग करने, आर्किटेक्चर के प्रमुख बिंदुओं को समझने और उपयोग की दृष्टि से कुछ उदाहरणों को देखने के लिए पढ़ें।
keywords: ultralytics, YOLOv4, ऑब्जेक्ट डिटेक्शन, न्यूरल नेटवर्क, वास्तविक समय में पता लगाने वाला, ऑब्जेक्ट डिटेक्टर, मशीन लर्निंग
---

# YOLOv4: उच्च गति और सटीक ऑब्जेक्ट डिटेक्शन

YOLOv4, जो 2020 में अलेक्सी बोचकोवस्की (Alexey Bochkovskiy) द्वारा [https://github.com/AlexeyAB/darknet](https://github.com/AlexeyAB/darknet) पर लॉन्च हुआ एक उत्कृष्ट बाज़ार में समयविशेषी-मेंट करने वाले ऑब्जेक्ट डिटेक्टर है, के बारे में Ultralytics दस्तावेज़ीकरण पेज में आपका स्वागत है। YOLOv4 गति और सटीकता के बीच आदर्श संतुलन प्रदान करने के लिए डिज़ाइन किया गया है, जो इसे बहुत सारे एप्लिकेशन के लिए एक उत्कृष्ट विकल्प बनाता है।

![YOLOv4 आर्किटेक्चर आरेख](https://user-images.githubusercontent.com/26833433/246185689-530b7fe8-737b-4bb0-b5dd-de10ef5aface.png)
**YOLOv4 आर्किटेक्चर आरेख**। YOLOv4 की जटिल नेटवर्क डिज़ाइन का प्रदर्शन, जिसमें बैकबोन, नेक और हेड घटक और उनके जोड़े गए स्तरों की दिखावटी तस्वीर है, ताकि वास्तविक समय ऑब्जेक्ट डिटेक्शन के लिए उनका उपयोग किया जा सके।

## परिचय

YOLOv4 का मतलब होता है 'You Only Look Once' संस्करण 4। यह एक वास्तविक समय ऑब्जेक्ट डिटेक्शन मॉडल है जो पिछले YOLO संस्करणों जैसे YOLOv3 और अन्य ऑब्जेक्ट डिटेक्शन मॉडलों की सीमाओं का सामना करने के लिए विकसित किया गया है। अन्य कन्वोल्यूशनल न्यूरल नेटवर्क (CNN) आधारित ऑब्जेक्ट डिटेक्टरों के विपरीत, YOLOv4 का उपयोग सिर्फ अनुशंसा प्रणालियों के लिए ही नहीं, बल्कि स्वतंत्र प्रक्रिया प्रबंधन और मानव इनपुट को कम करने के लिए भी किया जा सकता है। यह एक साधारण ग्राफ़िक्स प्रोसेसिंग इकाइयां (जीपीयू) पर अपना कार्य संपादित करने की अनुमति देता है और केवल एक ऐसे जीपीयू के लिए प्रशिक्षण के लिए एक ही जीपीयू की आवश्यकता होती है।

## आर्किटेक्चर

YOLOv4 अपने प्रदर्शन को अनुकूलित करने के लिए कई नवाचारी विशेषताओं का उपयोग करता है। इनमें वेटेड-रेजिड्यूल-कनेक्शंस (WRC), क्रॉस-स्टेज-पार्शल-कनेक्शंस (CSP), क्रॉस मिनी-बैच नियमन (CmBN), सेल्फ-प्रतिहिंसा-प्रशिक्षण (SAT), मिश ऐक्टिवेशन, मोज़ेक डेटा वृद्धि, ड्रॉपब्लॉक नियमन और सीआईओयू हानि शामिल हैं। ये विशेषताएँ संयुक्त रूप से बेहतरीन परिणाम प्राप्त करने के लिए संयोजित की जाती हैं।

आमतौर पर, एक ऑब्जेक्ट डिटेक्टर में कई हिस्से होते हैं जिनमें इनपुट, बैकबोन, नेक और हेड शामिल होते हैं। YOLOv4 का बैकबोन ImageNet पर पूरी तरह से प्रशिक्षित होता है और यह वस्तुओं के वर्गों और बाउंडिंग बॉक्स का अनुमान लगाने के लिए उपयोग किया जाता है। बैकबोन विभिन्न मॉडलों में से हो सकता है, जैसे VGG, ResNet, ResNeXt या DenseNet। डिटेक्शन हेड भाग ताकि अंतिम ऑब्जेक्ट डिटेक्शन और श्रेणीकरण किए जा सकें।

## फ्रीबीज़ सूचना

YOLOv4 उन विधियों का उपयोग करता है जिन्हें "फ्रीबीज़ का संग्रह" कहा जाता है, जो मॉडल की उन्नतता को प्रशिक्षण के दौरान बढ़ाने और संविधान के लागू होने की कीमत बढ़ाते हैं। डाटा वृद्धि ऑब्जेक्ट डिटेक्शन में उपयोग होने वाली एक सामान्य फ्रीबीज़ टिकनिक है, जो मॉडल की संवेगीता बढ़ाने के लिए इनपुट छवियों की विविधता बढ़ाती है। डाटा वृद्धि के कुछ उदाहरण हैं जिनमें फोटोमेट्रिक दिसंगत (चित्र के एक छवि के तेजी, बंदिश, सोने, उष्णता और आवाज़ को समायोजित करना) और ज्यामितिक दिसंगत (एक छवि के रैंडम स्केलिंग, क्रॉपिंग, फ्लिपिंग और घुमाने के जोड़ने) शामिल होते हैं। ये टिकनिक मॉडल को अलग-अलग प्रकार की छवियों में बेहतर सामान्यीकरण करने में सहायता करते हैं।

## विशेषताएँ और प्रदर्शन

YOLOv4 को वास्तविक समय ऑब्जेक्ट डिटेक्शन में उच्च गति और सटीकता के लिए डिज़ाइन किया गया है। YOLOv4 की आर्किटेक्चर में CSPDarknet53 बैकबोन के रूप में, नेक के रूप में PANet, और डिटेक्शन हेड के रूप में YOLOv3 शामिल हैं। यह डिज़ाइन YOLOv4 को एक प्रभावशाली गति पर ऑब्जेक्ट डिटेक्शन करने की अनुमति देता है, जिससे यह वास्तविक समय में उपयुक्त होता है। YOLOv4 ऑब्जेक्ट डिटेक्शन मानकों में उच्च गुणवत्ता हासिल करने में भी उत्कृष्टता करता है।

## उपयोग की उदाहरण

मामले से आप योग्यता संबंधित विस्तारित चरणों का उपयोग करने के लिए YOLOv4 का उपयोग करना चाहेंगे:

1. YOLOv4 GitHub रिपॉज़िटरी पर जाएं: [https://github.com/AlexeyAB/darknet](https://github.com/AlexeyAB/darknet)।

2. स्थापना के लिए readme फ़ाइल में दिए गए निर्देशों का पालन करें। इसमें सामान्यतया रिपॉज़िटरी क्लोन करना, आवश्यक डिपेंडेंसियों को स्थापित करना और किसी आवश्यक पर्यावरण चर पर सेटअप करना शामिल होता है।

3. स्थापना पूरी होने पर, आप मॉडल को प्रशिक्षित कर सकते हैं और उसे ऑब्जेक्ट डिटेक्शन करने के लिए उपयोग कर सकते हैं हमॉडन/रिपॉज़िटरी में दिए गए उपयोग के निर्देशों के अनुसार। यह आमतौर पर अपने डेटासेट को तैयार करना, मॉडल पैरामीटर्स को कॉन्फ़िगर करना, मॉडल को प्रशिक्षित करना और फिर प्रशिक्षित मॉडल का उपयोग ऑब्जेक्ट डिटेक्शन करने के लिए करता है।

कृपया ध्यान दें कि विशिष्ट चरण आपके विशिष्ट उपयोग मामले और YOLOv4 रेपोज़िटरी की स्थिति पर निर्भर कर सकते हैं। इसलिए, YOLOv4 गिद्धशाली रिपॉज़िटरी में दिए गए निर्देशों का उपयोग करने की कड़ी सलाह दी जाती है।

हम इस बात की असुविधा के लिए माफी चाहते हैं और YOLOv4 के समर्थन को Ultralytics के लिए लागू किया जाने पर उपयोग की उदाहरणों के साथ इस दस्तावेज़ को अद्यतित करने की कोशिश करेंगे।

## निष्कर्ष

YOLOv4 एक शक्तिशाली और कुशल ऑब्जेक्ट डिटेक्शन मॉडल है जो गति और सटीकता के बीच संतुलन स्थापित करता है। प्रशिक्षण के दौरान उनिक विशेषताओं और फ्रीबीज़ तकनीकों का उपयोग करके, यह वास्तविक समय ऑब्जेक्ट डिटेक्शन कार्यों में उत्कृष्ट प्रदर्शन करता है। किसी आम जीपीयू के साथ किसी भी व्यक्ति द्वारा प्रशिक्षित और उपयोग किया जा सकता है, जो इसे विभिन्न एप्लिकेशन के लिए पहुंच योग्य और व्यावहारिक बनाता है।

## संदर्भ और प्रशंसा

हम YOLOv4 लेखकों को इस फ़ील्ड में उनके महत्वपूर्ण योगदानों के लिए आभार व्यक्त करना चाहेंगे:

!!! Quote ""

    === "BibTeX"

        ```bibtex
        @misc{bochkovskiy2020yolov4,
              title={YOLOv4: Optimal Speed and Accuracy of Object Detection},
              author={Alexey Bochkovskiy and Chien-Yao Wang and Hong-Yuan Mark Liao},
              year={2020},
              eprint={2004.10934},
              archivePrefix={arXiv},
              primaryClass={cs.CV}
        }
        ```

मूल YOLOv4 पेपर [arXiv](https://arxiv.org/pdf/2004.10934.pdf) पर मिल सकता है। लेखकों ने अपने कार्य को पब्लिकली उपलब्ध कराया है, और कोडबेस [GitHub](https://github.com/AlexeyAB/darknet) पर एक्सेस किया जा सकता है। हम उनके कोशिशों की सराहना करते हैं जो क्षेत्र को आगे बढ़ाने और उनके काम को व्यापक समुदाय के लिए उपलब्ध कराने में करते हैं।
