# YOLOv8
## 论文
无
## 模型结构
yolov8是一种单阶段目标检测算法，该算法在YOLOV5的基础上添加了一些新的改进思路，使其速度与精度都得到了极大的性能提升。<br>
![block.jpg](asserts%2Fblock.jpg)
## 算法原理
YOLOv8算法通过将图像划分为不同大小的网格，预测每个网格中的目标类别和边界框，利用特征金字塔结构和自适应的模型缩放来实现高效准确的实时目标检测。
- 骨干网络和 Neck 部分将 YOLOv5 的 C3 结构换成了梯度流更丰富的 C2f 结构，并对不同尺度模型调整了不同的通道数，大幅提升了模型性能。
- Head 部分相比 YOLOv5 改动较大，换成了目前主流的解耦头结构，将分类和检测头分离，同时也从 Anchor-Based 换成了 Anchor-Free.
- Loss 计算方面采用了 TaskAlignedAssigner 正样本分配策略，并引入了 Distribution Focal Loss.
- 训练的数据增强部分引入了 YOLOX 中的最后 10 epoch 关闭 Mosiac 增强的操作，可以有效地提升精度
![model_framework.png](asserts%2Fmodel_framework.png)
## 环境配置
### Docker（方法一）

```
docker pull image.sourcefind.cn:5000/dcu/admin/base/pytorch:2.1.0-centos7.6-dtk24.04-py310
docker run -it -v /path/your_code_data/:/path/your_code_data/ -v /opt/hyhal/:/opt/hyhal/:ro --shm-size=80G --privileged=true --device=/dev/kfd --device=/dev/dri/ --group-add video --name docker_name imageID bash

cd /your_code_path/yolov8_pytorch
pip install -e . -i https://mirrors.aliyun.com/pypi/simple/

```
### Dockerfile（方法二）
```
cd ./docker
docker build --no-cache -t yolov8:last .
docker run -it -v /path/your_code_data/:/path/your_code_data/ -v /opt/hyhal/:/opt/hyhal/:ro --shm-size=80G --privileged=true --device=/dev/kfd --device=/dev/dri/ --group-add video --name docker_name imageID bash
cd /your_code_path/yolov8_pytorch
pip install -e . -i https://mirrors.aliyun.com/pypi/simple/
```
### Anaconda（方法三）
1、关于本项目DCU显卡所需的特殊深度学习库可从光合开发者社区下载安装： https://developer.sourcefind.cn/tool/
```
DTK软件栈: dtk24.04
python: python3.10
torch: 2.1
```

Tips：以上dtk软件栈、python、torch、mmcv等DCU相关工具版本需要严格一一对应

2、其他非特殊库直接按照requirements.txt安装

```
cd /your_code_path/yolov8_pytorch
pip install -e . -i https://mirrors.aliyun.com/pypi/simple/
```

## 数据集
COCO2017（在网络良好的情况下，如果没有下载数据集，程序会默认在线下载数据集）:

训练数据快速下载中心:[SCNet AIDatasets](https://www.scnet.cn/ui/aihub/datasets) ,项目中的训练数据下载地址[COCO2017](https://www.scnet.cn/ui/aihub/datasets/yiziqinx/COCO2017)

[训练数据](http://images.cocodataset.org/zips/train2017.zip)

[验证数据](http://images.cocodataset.org/zips/val2017.zip)

[测试数据](http://images.cocodataset.org/zips/test2017.zip)

[标签数据](https://github.com/ultralytics/yolov5/releases/download/v1.0/coco2017labels.zip)

数据集的目录结构如下：

```
├── images 
│   ├── train2017
│   ├── val2017
│   ├── test2017
├── labels
│   ├── train2017
│   ├── val2017
├── annotations
│   ├── instances_val2017.json
├── LICENSE
├── README.txt 
├── test-dev2017.txt
├── train2017.txt
├── val2017.txt

```
我们通过了coco128数据集，供验证训练使用，如需正式使用，请下载完整COCO数据集或使用定制化数据集。
```bash
cd /your_code_path/yolov8_pytorch
cd datasets/
unzip  coco128.zip
```
## 训练
- 数据集放置位置默认为当前目录下 datasets/
- 如需要正式训练COCO2017请修改[coco.yaml](ultralytics%2Fcfg%2Fdatasets%2Fcoco.yaml)下的 path
- 当前使用coco128.yaml进行训练测试[coco128.yaml](ultralytics%2Fcfg%2Fdatasets%2Fcoco128.yaml)
### 单机四卡
```bash
cd /your_code_path/yolov8_pytorch
chmod -R 7777 train_multi.sh 
bash ./train_multi.sh
# 若遇到dataset路径找不到的报错，修改官方默认的dataset数据集地址 datasets_dir: /home/yolov8_pytorch/
vim /root/.config/Ultralytics/settings.yaml
```
### 单机单卡
```bash
cd /your_code_path/yolov8_pytorch
chmod -R 7777 train.sh 
bash ./train.sh
```
## 推理
- 可使用官方模型权重进行推理，也可使用自己训练模型权重进行推理
- 这里以官方模型推理举例[[下载地址：yolov8s.pt](https://github.com/ultralytics/assets/releases/download/v8.2.0/yolov8s.pt)]
```bash
# 官方推理代码
HIP_VISIBLE_DEVICES=0 python inference.py
```
## result
![result.jpg](asserts%2Fresult.jpg)
### 精度
|  模型名称   |      amp混精       | Box AP |
|:------:|:----------------:|:------:|
| yolo8s |        on        |  44.1   |

## 应用场景
### 算法类别
`目标检测`
### 热点应用行业
`金融,交通,教育`
## 源码仓库及问题反馈
- https://developer.sourcefind.cn/codes/modelzoo/yolov8_pytorch
## 参考资料
- https://github.com/ultralytics/ultralytics
