---
comments: true
description: YOLO-NAS एक बेहतर वस्तु पहचान मॉडल है। इसकी विशेषताएँ, प्री-प्रशित मॉडल, Ultralytics Python API के साथ उपयोग और अधिक के बारे में विस्तृत दस्तावेज़ीकरण जानें।
keywords: YOLO-NAS, Deci AI, object detection, deep learning, neural architecture search, Ultralytics Python API, YOLO model, pre-trained models, quantization, optimization, COCO, Objects365, Roboflow 100
---

# YOLO-NAS

## अवलोकन

डेसी एआई द्वारा विकसित YOLO-NAS एक महत्वपूर्ण वस्तु पहचान मूलभूत मॉडल है। यह पिछले YOLO मॉडलों की सीमाओं का समाधान करने के लिए मानकर्मशास्त्रीय संरचना खोज प्रौद्योगिकी का उत्पाद है। क्वांटाइज़ेशन समर्थन और सटीकता-लेटेंसी विनिमय में काफी सुधार के साथ, YOLO-NAS वस्तु पहचान में एक महत्वपूर्ण आगे की लड़ाई प्रस्तुत करता है।

![मॉडल उदाहरण छवि](https://learnopencv.com/wp-content/uploads/2023/05/yolo-nas_COCO_map_metrics.png)
**YOLO-NAS का अवलोकन।**  YOLO-NAS आपेक्षिकता के लिए ब्लॉक्स और वैकल्पिक क्वांटाइज़ेशन के साथ क्वांटाइज़ेशन योग्य ब्लॉक का उपयोग करता है। मॉडल को INT8 क्वांटाइज़ेशन में रूपांतरित किया जाने पर, अन्य मॉडलों की तुलना में केवल थोड़ी सी सटीकता नुकसान होती है। ये उन्नति सभी विकसित विशेषताओं द्वारा योग्यतापूर्वक वस्तु पहचान क्षमताओं और अद्वितीय प्रदर्शन में समाप्त होती है।

### मुख्य विशेषताएँ

- **क्वांटाइज़ेशन-मित्रशील मूल ब्लॉक:** YOLO-NAS पिछले YOLO मॉडलों की एक महत्वपूर्ण सीमा को समाप्त करने के लिए एक नया मूल ब्लॉक पेश करता है।
- **सुरुचिपूर्वक प्रशिक्षण और क्वांटाइज़ेशन:** YOLO-NAS उन्नत प्रशिक्षण योजनाएं और पोस्ट-प्रशिक्षण क्वांटाइज़ेशन का उपयोग करता है ताकि प्रदर्शन में सुधार हो सके।
- **ऑटोएनएसी अनुकूलन और प्री-प्रशित:** YOLO-NAS ऑटोएनएसी अनुकूलन का उपयोग करता है और COCO, Objects365 और Roboflow 100 जैसे प्रमुख डेटासेटों पर प्री-प्रशित होता है। यह प्री-प्रशित इसे उत्पादन वातावरण में नीचे पड़ने वाले वस्तु पहचान कार्यों के लिए अत्यंत उपयुक्त बनाता है।

## प्री-प्रशित मॉडल

Ultralytics द्वारा प्रदान की गई प्री-प्रशित YOLO-NAS मॉडल के साथ आगामी पीढ़ी की वस्तु पहचान की शक्ति का अनुभव करें। ये मॉडल स्पीड और सटीकता दोनों में उत्कृष्ट प्रदर्शन करने के लिए डिज़ाइन किए गए हैं। अपनी विशिष्ट आवश्यकताओं के लिए विभिन्न विकल्पों में से चुनें:

| मॉडल             | mAP   | लेटेंसी (मिलीसेकंड) |
|------------------|-------|---------------------|
| YOLO-NAS S       | 47.5  | 3.21                |
| YOLO-NAS M       | 51.55 | 5.85                |
| YOLO-NAS L       | 52.22 | 7.87                |
| YOLO-NAS S INT-8 | 47.03 | 2.36                |
| YOLO-NAS M INT-8 | 51.0  | 3.78                |
| YOLO-NAS L INT-8 | 52.1  | 4.78                |

प्रत्येक मॉडल वेरिएंट mAP और लेटेंसी के बीच संतुलन का प्रस्ताव करने के लिए डिज़ाइन किए गए हैं, जो आपके वस्तु पहचान कार्यों को प्रदर्शन और गति दोनों के लिए आपकी आवश्यकताओं के लिए अनुकूलित करने में मदद करेगा।

## उपयोग उदाहरण

Ultralytics ने YOLO-NAS मॉडलों को आपके Python ऐप्लिकेशन में आसानी से एकीकृत करने के लिए हमारे `ultralytics` पाइथन पैकेज के माध्यम से सुविधाजनक पायथन API प्रदान किया है। पैकेज प्रक्रिया को सुगठित करने के लिए एक उपयोगकर्ता-मित्रपूर्ण पाइथन API प्रदान करता है।

निम्न उदाहरण दिखाते हैं कि `उल्ट्रालिटिक्स` पैकेज के साथ YOLO-NAS मॉडलों का उपयोग `ultralytics` पैकेज के साथ कैसे करें:

### पहचान और मान्यता उदाहरण

इस उदाहरण में हम COCO8 डेटासेट पर YOLO-NAS-s की मान्यता करते हैं।

!!! Example "उदाहरण"

    इस उदाहरण में हम YOLO-NAS के लिए सरल पहचान और मान्यता कोड प्रदान करते हैं। पहचान परिणामों का हैंडलिंग करने के लिए देखें [भविष्यवाणी](../प्राथमिकताएँ/भविष्यवाणी.md) मोड को। अतिरिक्त मोड के साथ YOLO-NAS का उपयोग करने के लिए [मान्यता](../प्राथमिकताएँ/मान्यता.md) और [निर्यात](../प्राथमिकताएँ/निर्यात.md) को देखें। `उल्ट्रालिटिक्स` पैकेज पर YOLO-NAS का प्रशिक्षण समर्थन नहीं करती है।

    === "Python"

        PyTorch प्री-प्रशित `*.pt` मॉडल फ़ाइलों को उल्ट्रालिटिक्स क्लास 'नास()' को पास किया जा सकता है ताकि पायथन में एक मॉडल मामला बनाया जा सके:

        ```python
        from ultralytics import NAS

        # COCO-pretrained YOLO-NAS-s मॉडल लोड करें
        model = NAS('yolo_nas_s.pt')

        # मॉडल की जानकारी दिखाएँ (वैकल्पिक)
        model.info()

        # COCO8 उदाहरण डेटासेट पर मॉडल की मान्यता करें
        results = model.val(data='coco8.yaml')

        # 'bus.jpg' छवि पर YOLO-NAS-s मॉडल के साथ पहचान चलाएं
        results = model('path/to/bus.jpg')
        ```

    === "CLI"

        मॉडलों को सीधे चलाने के लिए CLI कमांड उपलब्ध हैं:

        ```bash
        # COCO-pretrained YOLO-NAS-s मॉडल लोड करें और उसकी प्रदर्शन मान्यता करें COCO8 उदाहरण डेटासेट पर
        yolo val model=yolo_nas_s.pt data=coco8.yaml

        # COCO-pretrained YOLO-NAS-s मॉडल लोड करें और 'bus.jpg' छवि पर पहचान चलाएं
        yolo predict model=yolo_nas_s.pt source=path/to/bus.jpg
        ```

## समर्थित कार्य और मोड

हम तीन YOLO-NAS मॉडल वेरिएंट प्रदान करते हैं: छोटा (s), मध्यम (m) और बड़ा (l)। प्रत्येक वेरिएंट विभिन्न कंप्यूटेशनल और प्रदर्शन आवश्यकताओं के लिए डिज़ाइन किए गए हैं:

- **YOLO-NAS-s**: कम्प्यूटेशन संसाधन सीमित होते हैं लेकिन दक्षता महत्वपूर्ण हैं, ऐसे वातावरणों के लिए अनुकूलित।
- **YOLO-NAS-m**: एक संतुलित दृष्टिकोण प्रदान करता है, जिससे आपके पास उच्च सटीकता वाले सामान्य-उद्देश्य वस्तु पहचान के लिए उपयुक्तता होती है।
- **YOLO-NAS-l**: सबसे अधिक सटीकता की आवश्यकता होने वाले स्थितियों के लिए विशेष रूप से तैयार किया जाता है, जहां गणना संसाधनों की कम बाधा होती है।

नीचे प्रत्येक मॉडल के बारे में एक विस्तृत अवलोकन दिया गया है, जिसमें उनकी प्री-प्रशित वेट, ये कार्य समर्थित करते हैं, और इनकी आपरेटिंग मोड के साथ उनका संगतता शामिल है।

| मॉडल प्रकार | प्री-प्रशित वेट                                                                               | समर्थित कार्य                          | पहचान | मान्यता | प्रशिक्षण | निर्यात |
|-------------|-----------------------------------------------------------------------------------------------|----------------------------------------|-------|---------|-----------|---------|
| YOLO-NAS-s  | [yolo_nas_s.pt](https://github.com/ultralytics/assets/releases/download/v0.0.0/yolo_nas_s.pt) | [वस्तु पहचान](../कार्य/चित्र_पहचान.md) | ✅     | ✅       | ❌         | ✅       |
| YOLO-NAS-m  | [yolo_nas_m.pt](https://github.com/ultralytics/assets/releases/download/v0.0.0/yolo_nas_m.pt) | [वस्तु पहचान](../कार्य/चित्र_पहचान.md) | ✅     | ✅       | ❌         | ✅       |
| YOLO-NAS-l  | [yolo_nas_l.pt](https://github.com/ultralytics/assets/releases/download/v0.0.0/yolo_nas_l.pt) | [वस्तु पहचान](../कार्य/चित्र_पहचान.md) | ✅     | ✅       | ❌         | ✅       |

## उद्धरण और प्रशंसापत्र

यदि आप अपने शोध या विकास कार्य में YOLO-NAS का उपयोग करते हैं, कृपया SuperGradients को उद्धरण दें:

!!! Quote ""

    === "BibTeX"

        ```bibtex
        @misc{supergradients,
              doi = {10.5281/ZENODO.7789328},
              url = {https://zenodo.org/record/7789328},
              author = {Aharon,  Shay and {Louis-Dupont} and {Ofri Masad} and Yurkova,  Kate and {Lotem Fridman} and {Lkdci} and Khvedchenya,  Eugene and Rubin,  Ran and Bagrov,  Natan and Tymchenko,  Borys and Keren,  Tomer and Zhilko,  Alexander and {Eran-Deci}},
              title = {Super-Gradients},
              publisher = {GitHub},
              journal = {GitHub repository},
              year = {2021},
        }
        ```

हम Deci AI के [SuperGradients](https://github.com/Deci-AI/super-gradients/) टीम के प्रयासों के लिए आभार प्रकट करते हैं जिन्होंने इस महत्वपूर्ण संसाधन को बनाने और बनाए रखने के लिए। हम मानते हैं कि YOLO-NAS, अपने नवाचारी श्रेणीबद्ध संरचना और उत्कृष्ट वस्तु पहचान क्षमताओं के साथ एक महत्वपूर्ण उपकरण बनेगा जिसे उद्यमियों और शोधकर्ताओं के लिए आवश्यक साधन बना रखा जाएगा।
