---
comments: true
description: Découvrez un guide complet du modèle Ultralytics YOLOv8, un modèle de détection d'objets et de segmentation d'images à haute vitesse et haute précision. Tutoriels d'installation, de prédiction, d'entraînement et plus encore.
keywords: Ultralytics, YOLOv8, détection d'objets, segmentation d'images, apprentissage automatique, apprentissage profond, vision par ordinateur, installation de YOLOv8, prédiction avec YOLOv8, entraînement de YOLOv8, histoire de YOLO, licences de YOLO
---

<div align="center">
  <p>
    <a href="https://yolovision.ultralytics.com" target="_blank">
    <img width="1024" src="https://raw.githubusercontent.com/ultralytics/assets/main/yolov8/banner-yolov8.png" alt="Bannière Ultralytics YOLO"></a>
  </p>
  <a href="https://github.com/ultralytics"><img src="https://github.com/ultralytics/assets/raw/main/social/logo-social-github.png" width="3%" alt="GitHub Ultralytics"></a>
  <img src="https://github.com/ultralytics/assets/raw/main/social/logo-transparent.png" width="3%">
  <a href="https://www.linkedin.com/company/ultralytics/"><img src="https://github.com/ultralytics/assets/raw/main/social/logo-social-linkedin.png" width="3%" alt="LinkedIn Ultralytics"></a>
  <img src="https://github.com/ultralytics/assets/raw/main/social/logo-transparent.png" width="3%">
  <a href="https://twitter.com/ultralytics"><img src="https://github.com/ultralytics/assets/raw/main/social/logo-social-twitter.png" width="3%" alt="Twitter Ultralytics"></a>
  <img src="https://github.com/ultralytics/assets/raw/main/social/logo-transparent.png" width="3%">
  <a href="https://youtube.com/ultralytics"><img src="https://github.com/ultralytics/assets/raw/main/social/logo-social-youtube.png" width="3%" alt="YouTube Ultralytics"></a>
  <img src="https://github.com/ultralytics/assets/raw/main/social/logo-transparent.png" width="3%">
  <a href="https://www.tiktok.com/@ultralytics"><img src="https://github.com/ultralytics/assets/raw/main/social/logo-social-tiktok.png" width="3%" alt="TikTok Ultralytics"></a>
  <img src="https://github.com/ultralytics/assets/raw/main/social/logo-transparent.png" width="3%">
  <a href="https://www.instagram.com/ultralytics/"><img src="https://github.com/ultralytics/assets/raw/main/social/logo-social-instagram.png" width="3%" alt="Instagram Ultralytics"></a>
  <img src="https://github.com/ultralytics/assets/raw/main/social/logo-transparent.png" width="3%">
  <a href="https://ultralytics.com/discord"><img src="https://github.com/ultralytics/assets/raw/main/social/logo-social-discord.png" width="3%" alt="Discord Ultralytics"></a>
  <br>
  <br>
  <a href="https://github.com/ultralytics/ultralytics/actions/workflows/ci.yaml"><img src="https://github.com/ultralytics/ultralytics/actions/workflows/ci.yaml/badge.svg" alt="Intégration continue Ultralytics"></a>
  <a href="https://codecov.io/github/ultralytics/ultralytics"><img src="https://codecov.io/github/ultralytics/ultralytics/branch/main/graph/badge.svg?token=HHW7IIVFVY" alt="Couverture de code Ultralytics"></a>
  <a href="https://zenodo.org/badge/latestdoi/264818686"><img src="https://zenodo.org/badge/264818686.svg" alt="Citation YOLOv8"></a>
  <a href="https://hub.docker.com/r/ultralytics/ultralytics"><img src="https://img.shields.io/docker/pulls/ultralytics/ultralytics?logo=docker" alt="Téléchargements Docker"></a>
  <br>
  <a href="https://console.paperspace.com/github/ultralytics/ultralytics"><img src="https://assets.paperspace.io/img/gradient-badge.svg" alt="Exécuter sur Gradient"></a>
  <a href="https://colab.research.google.com/github/ultralytics/ultralytics/blob/main/examples/tutorial.ipynb"><img src="https://colab.research.google.com/assets/colab-badge.svg" alt="Ouvrir dans Colab"></a>
  <a href="https://www.kaggle.com/ultralytics/yolov8"><img src="https://kaggle.com/static/images/open-in-kaggle.svg" alt="Ouvrir dans Kaggle"></a>
</div>

Présentation d'[Ultralytics](https://ultralytics.com) [YOLOv8](https://github.com/ultralytics/ultralytics), la dernière version du modèle réputé de détection d'objets en temps réel et de segmentation d'images. YOLOv8 est construit sur des avancées de pointe en apprentissage profond et vision par ordinateur, offrant des performances inégalées en termes de vitesse et de précision. Sa conception épurée le rend adapté à diverses applications et facilement adaptable à différentes plateformes matérielles, des appareils de bord aux API cloud.

Explorez les Docs YOLOv8, une ressource complète conçue pour vous aider à comprendre et à utiliser ses fonctionnalités et capacités. Que vous soyez un praticien chevronné de l'apprentissage automatique ou nouveau dans le domaine, ce hub vise à maximiser le potentiel de YOLOv8 dans vos projets.

!!! Note "Note"

    🚧 Notre documentation multilingue est actuellement en construction et nous travaillons dur pour l'améliorer. Merci de votre patience ! 🙏

## Par où commencer

- **Installer** `ultralytics` avec pip et démarrer en quelques minutes &nbsp; [:material-clock-fast: Commencer](quickstart.md){ .md-button }
- **Prédire** de nouvelles images et vidéos avec YOLOv8 &nbsp; [:octicons-image-16: Prédire sur Images](modes/predict.md){ .md-button }
- **Entraîner** un nouveau modèle YOLOv8 sur votre propre ensemble de données customisé &nbsp; [:fontawesome-solid-brain: Entraîner un modèle](modes/train.md){ .md-button }
- **Explorer** les tâches YOLOv8 comme la segmentation, la classification, l'estimation de pose et le suivi &nbsp; [:material-magnify-expand: Explorer les tâches](tasks/index.md){ .md-button }

<p align="center">
  <br>
  <iframe width="720" height="405" src="https://www.youtube.com/embed/LNwODJXcvt4?si=7n1UvGRLSd9p5wKs"
    title="Lecteur vidéo YouTube" frameborder="0"
    allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture; web-share"
    allowfullscreen>
  </iframe>
  <br>
  <strong>Regarder :</strong> Comment entraîner un modèle YOLOv8 sur votre ensemble de données customisé dans <a href="https://colab.research.google.com/github/ultralytics/ultralytics/blob/main/examples/tutorial.ipynb" target="_blank">Google Colab</a>.
</p>

## YOLO : Un bref historique

[YOLO](https://arxiv.org/abs/1506.02640) (You Only Look Once), un modèle populaire de détection d'objets et de segmentation d'images, a été développé par Joseph Redmon et Ali Farhadi à l'Université de Washington. Lancé en 2015, YOLO a rapidement gagné en popularité pour sa vitesse et sa précision élevées.

- [YOLOv2](https://arxiv.org/abs/1612.08242), publié en 2016, a amélioré le modèle original en intégrant la normalisation par lots, les boîtes d'ancrage et les clusters de dimensions.
- [YOLOv3](https://pjreddie.com/media/files/papers/YOLOv3.pdf), lancé en 2018, a davantage amélioré la performance du modèle en utilisant un réseau dorsal plus efficace, des ancres multiples et un pool pyramidal spatial.
- [YOLOv4](https://arxiv.org/abs/2004.10934) a été publié en 2020, introduisant des innovations telles que l'augmentation de données Mosaic, une nouvelle tête de détection sans ancre et une nouvelle fonction de perte.
- [YOLOv5](https://github.com/ultralytics/yolov5) a encore amélioré la performance du modèle et a ajouté des fonctionnalités nouvelles telles que l'optimisation des hyperparamètres, le suivi intégré des expériences et l'export automatique vers des formats d'exportation populaires.
- [YOLOv6](https://github.com/meituan/YOLOv6) a été rendu open-source par [Meituan](https://about.meituan.com/) en 2022 et est utilisé dans de nombreux robots de livraison autonomes de l'entreprise.
- [YOLOv7](https://github.com/WongKinYiu/yolov7) a ajouté des tâches supplémentaires telles que l'estimation de pose sur le jeu de données de points clés COCO.
- [YOLOv8](https://github.com/ultralytics/ultralytics) est la dernière version de YOLO par Ultralytics. En tant que modèle de pointe et dernier cri (state-of-the-art, SOTA), YOLOv8 s'appuie sur le succès des versions précédentes, introduisant de nouvelles fonctionnalités et améliorations pour des performances, une flexibilité et une efficacité renforcées. YOLOv8 prend en charge une gamme complète de tâches d'intelligence artificielle visuelle, y compris la [détection](tasks/detect.md), la [segmentation](tasks/segment.md), l'[estimation de pose](tasks/pose.md), le [suivi](modes/track.md) et la [classification](tasks/classify.md). Cette polyvalence permet aux utilisateurs de tirer parti des capacités de YOLOv8 dans diverses applications et domaines.

## Licences YOLO : Comment est licencié Ultralytics YOLO ?

Ultralytics offre deux options de licence pour répondre aux différents cas d'utilisation :

- **Licence AGPL-3.0** : Cette licence open source [approuvée par OSI](https://opensource.org/licenses/) est idéale pour les étudiants et les passionnés, favorisant la collaboration ouverte et le partage des connaissances. Voir le fichier [LICENSE](https://github.com/ultralytics/ultralytics/blob/main/LICENSE) pour plus de détails.
- **Licence Enterprise** : Conçue pour un usage commercial, cette licence permet l'intégration transparente des logiciels et modèles d'IA Ultralytics dans des biens et services commerciaux, en contournant les exigences open source de l'AGPL-3.0. Si votre scénario implique l'incorporation de nos solutions dans une offre commerciale, n'hésitez pas à contacter [Ultralytics Licensing](https://ultralytics.com/license).

Notre stratégie de licence est conçue pour garantir que toute amélioration de nos projets open source soit restituée à la communauté. Nous tenons les principes de l'open source à cœur ❤️, et notre mission est de garantir que nos contributions puissent être utilisées et développées de manière bénéfique pour tous.
