---
comments: true
description: من التدريب إلى التتبع، استفد من YOLOv8 مع Ultralytics. احصل على نصائح وأمثلة لكل وضع مدعوم بما في ذلك التحقق والتصدير واختبار الأداء.
keywords: Ultralytics, YOLOv8, التعلم الآلي، كشف الكائنات، التدريب، التحقق، التنبؤ، التصدير، التتبع، اختبار الأداء
---

# أوضاع Ultralytics YOLOv8

<img width="1024" src="https://github.com/ultralytics/assets/raw/main/yolov8/banner-integrations.png" alt="بيئة عمل Ultralytics YOLO والتكاملات">

## المقدمة

YOLOv8 من Ultralytics ليست مجرد نموذج لكشف الكائنات آخر؛ إنها إطار متعدد الاستخدامات مصمم لتغطية دورة حياة نماذج التعلم الآلي بأكملها - من امتصاص البيانات وتدريب النموذج إلى التحقق والنشر وتتبع الواقع الحقيقي. يخدم كل وضع غرضًا محددًا وهو مصمم لتوفير المرونة والكفاءة المطلوبة للمهام والحالات الاستخدام المختلفة.

!!! Note "ملاحظة"

    🚧 توثيقنا متعدد اللغات قيد الإنشاء حاليًا، ونحن نعمل بجهد لتحسينه. شكرًا لك على صبرك! 🙏

<p align="center">
  <br>
  <iframe width="720" height="405" src="https://www.youtube.com/embed/j8uQc0qB91s?si=dhnGKgqvs7nPgeaM"
    title="مشغل فيديو يوتيوب" frameborder="0"
    allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture; web-share"
    allowfullscreen>
  </iframe>
  <br>
  <strong>شاهد:</strong> برنامج التعليم Ultralytics: تدريب، التحقق، التنبؤ، التصدير، واختبار الأداء.
</p>

### أوضاع مختصرة

فهم ال**أوضاع** المختلفة المدعومة بواسطة Ultralytics YOLOv8 مهم جدًا للاستفادة القصوى من النماذج الخاصة بك:

- وضع **التدريب**: قم بضبط نموذجك على مجموعة بيانات مخصصة أو محملة مسبقًا.
- وضع **التحقق**: نقطة فحص بعد التدريب لتقييم أداء النموذج.
- وضع **التنبؤ**: اطلق قوة التنبؤ الخاصة بنموذجك على البيانات الحقيقية.
- وضع **التصدير**: قم بتجهيز نموذجك للاستخدام في صيغ مختلفة.
- وضع **التتبع**: قم بتوسيع نموذج الكشف عن الكائنات الخاص بك إلى تطبيقات التتبع في الوقت الحقيقي.
- وضع **اختبار الأداء**: قم بتحليل سرعة ودقة نموذجك في بيئات نشر متنوعة.

يهدف هذا الدليل الشامل إلى تقديم لمحة عامة ونصائح عملية حول كل وضع، لمساعدتك في استغلال كامل إمكانات YOLOv8.

## [وضع التدريب](train.md)

يتم استخدام وضع التدريب لتدريب نموذج YOLOv8 على مجموعة بيانات مخصصة. في هذا الوضع، يتم تدريب النموذج باستخدام مجموعة البيانات والمعلمات الهايبر للحصول على دقة في توقع الفئات ومواقع الكائنات في الصورة.

[أمثلة التدريب](train.md){ .md-button .md-button--primary}

## [وضع التحقق](val.md)

يتم استخدام وضع التحقق للتحقق من نموذج YOLOv8 بعد تدريبه. في هذا الوضع، يتم تقييم النموذج على مجموعة التحقق لقياس دقته وأداء التعميم. يمكن استخدام هذا الوضع لتعديل المعلمات الهايبر للنموذج لتحسين أدائه.

[أمثلة التحقق](val.md){ .md-button .md-button--primary}

## [وضع التنبؤ](predict.md)

يتم استخدام وضع التنبؤ لإجراء تنبؤات باستخدام نموذج YOLOv8 المدرب على صور أو فيديوهات جديدة. في هذا الوضع، يتم تحميل النموذج من ملف الفحص، ويمكن للمستخدم توفير الصور أو مقاطع الفيديو لإجراء استدلال. يقوم النموذج بتوقع الفئات ومواقع الكائنات في الصور أو مقاطع الفيديو المدخلة.

[أمثلة التنبؤ](predict.md){ .md-button .md-button--primary}

## [وضع التصدير](export.md)

يتم استخدام وضع التصدير لتصدير نموذج YOLOv8 إلى صيغة يمكن استخدامها للنشر. في هذا الوضع، يتم تحويل النموذج إلى صيغة يمكن استخدامها من قبل تطبيقات البرامج الأخرى أو الأجهزة الأجهزة. يكون هذا الوضع مفيدًا عند نشر النموذج في بيئات الإنتاج.

[أمثلة التصدير](export.md){ .md-button .md-button--primary}

## [وضع التتبع](track.md)

يتم استخدام وضع التتبع لتتبع الكائنات في الوقت الحقيقي باستخدام نموذج YOLOv8. في هذا الوضع، يتم تحميل النموذج من ملف الفحص، ويمكن للمستخدم توفير تيار فيديو مباشر لأداء تتبع الكائنات في الوقت الفعلي. يكون هذا الوضع مفيدًا لتطبيقات مثل أنظمة المراقبة أو السيارات ذاتية القيادة.

[أمثلة التتبع](track.md){ .md-button .md-button--primary}

## [وضع اختبار الأداء](benchmark.md)

يتم استخدام وضع اختبار الأداء لتقييم سرعة ودقة صيغ التصدير المختلفة لـ YOLOv8. تقدم الاختبارات معلومات حول حجم الصيغة المصدر، معيار الأداء `mAP50-95` (لكشف الكائنات والتقسيم والتصوير) أو المعيار `accuracy_top5` (للتصنيف)، ووقت الاستدلال بالملي ثانية لكل صورة في صيغ التصدير المختلفة مثل ONNX و OpenVINO و TensorRT وغيرها. يمكن لهذه المعلومات مساعدة المستخدمين على اختيار صيغة التصدير الأمثل لحالتهم الاستخدامية المحددة بناءً على متطلبات السرعة والدقة.

[أمثلة اختبار الأداء](benchmark.md){ .md-button .md-button--primary}
