---
comments: true
description: Пошаговое руководство по обучению моделей YOLOv8 с использованием Ultralytics YOLO, включая примеры обучения на одном и нескольких GPU
keywords: Ultralytics, YOLOv8, YOLO, обнаружение объектов, режим обучения, настраиваемый набор данных, обучение на GPU, много-GPU, гиперпараметры, примеры CLI, примеры Python
---

# Обучение моделей с помощью Ultralytics YOLO

<img width="1024" src="https://github.com/ultralytics/assets/raw/main/yolov8/banner-integrations.png" alt="Экосистема и интеграции Ultralytics YOLO">

## Введение

Обучение глубокой обучающей модели включает в себя подачу данных и настройку её параметров, так чтобы она могла делать точные прогнозы. Режим обучения в Ultralytics YOLOv8 предназначен для эффективного и результативного обучения моделей обнаружения объектов с полным использованием возможностей современной аппаратуры. Это руководство нацелено на описание всех деталей, необходимых для начала обучения ваших моделей с использованием богатого набора функций YOLOv8.

<p align="center">
  <br>
  <iframe width="720" height="405" src="https://www.youtube.com/embed/LNwODJXcvt4?si=7n1UvGRLSd9p5wKs"
    title="YouTube video player" frameborder="0"
    allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture; web-share"
    allowfullscreen>
  </iframe>
  <br>
  <strong>Смотреть:</strong> Как обучить модель YOLOv8 на вашем настраиваемом наборе данных в Google Colab.
</p>

## Почему стоит выбрать Ultralytics YOLO для обучения?

Вот несколько убедительных причин использовать режим Train YOLOv8:

- **Эффективность:** Используйте максимум возможностей вашего оборудования, будь то настройка с одним GPU или распределение нагрузки на несколько GPU.
- **Универсальность:** Обучайте на настраиваемых наборах данных, помимо уже доступных, таких как COCO, VOC и ImageNet.
- **Дружелюбный интерфейс:** Простой, но мощный интерфейс командной строки (CLI) и Python для прямолинейного опыта обучения.
- **Гибкость гиперпараметров:** Широкий спектр настраиваемых гиперпараметров для тонкой настройки производительности модели.

### Ключевые особенности режима Train

Вот некоторые заметные особенности режима Train YOLOv8:

- **Автоматическая загрузка набора данных:** Стандартные наборы данных, такие как COCO, VOC и ImageNet, загружаются автоматически при первом использовании.
- **Поддержка многих GPU:** Масштабируйте усилия по обучению без проблем на нескольких GPU, чтобы ускорить процесс.
- **Настройка гиперпараметров:** Возможность изменения гиперпараметров через файлы конфигурации YAML или аргументы CLI.
- **Визуализация и мониторинг:** Отслеживание метрик обучения в реальном времени и визуализация процесса обучения для лучшего понимания.

!!! Tip "Совет"

    * Наборы данных YOLOv8, такие как COCO, VOC, ImageNet и многие другие, автоматически загружаются при первом использовании, например, `yolo train data=coco.yaml`

## Примеры использования

Обучение YOLOv8n на наборе данных COCO128 в течение 100 эпох с размером изображения 640. Устройство для обучения может быть указано с помощью аргумента `device`. Если аргумент не передан, будет использоваться GPU `device=0`, если доступен, в противном случае будет использоваться `device=cpu`. Смотрите раздел Аргументы ниже для полного списка аргументов обучения.

!!! Example "Пример обучения на одном GPU и CPU"

    Устройство определяется автоматически. Если доступен GPU, то он будет использован, иначе обучение начнется на CPU.

    === "Python"

        ```python
        from ultralytics import YOLO

        # Загрузить модель
        model = YOLO('yolov8n.yaml')  # создать новую модель из YAML
        model = YOLO('yolov8n.pt')  # загрузить предобученную модель (рекомендуется для обучения)
        model = YOLO('yolov8n.yaml').load('yolov8n.pt')  # создать из YAML и перенести веса

        # Обучить модель
        results = model.train(data='coco128.yaml', epochs=100, imgsz=640)
        ```

    === "CLI"

        ```bash
        # Создать новую модель из YAML и начать обучение с нуля
        yolo detect train data=coco128.yaml model=yolov8n.yaml epochs=100 imgsz=640

        # Начать обучение с предобученной модели *.pt
        yolo detect train data=coco128.yaml model=yolov8n.pt epochs=100 imgsz=640

        # Создать новую модель из YAML, перенести предобученные веса и начать обучение
        yolo detect train data=coco128.yaml model=yolov8n.yaml pretrained=yolov8n.pt epochs=100 imgsz=640
        ```

### Обучение на нескольких GPU

Обучение на нескольких GPU позволяет более эффективно использовать доступные аппаратные ресурсы, распределяя нагрузку по обучению на несколько GPU. Эта функция доступна как через Python API, так и через командный интерфейс. Чтобы включить обучение на нескольких GPU, укажите идентификаторы устройств GPU, которые вы хотите использовать.

!!! Example "Пример обучения на нескольких GPU"

    Чтобы обучить с использованием 2 GPU, устройств CUDA 0 и 1 используйте следующие команды. Расширьте до дополнительных GPU по мере необходимости.

    === "Python"

        ```python
        from ultralytics import YOLO

        # Загрузить модель
        model = YOLO('yolov8n.pt')  # загрузить предобученную модель (рекомендуется для обучения)

        # Обучить модель с использованием 2 GPU
        results = model.train(data='coco128.yaml', epochs=100, imgsz=640, device=[0, 1])
        ```

    === "CLI"

        ```bash
        # Начать обучение с предобученной модели *.pt используя GPU 0 и 1
        yolo detect train data=coco128.yaml model=yolov8n.pt epochs=100 imgsz=640 device=0,1
        ```

### Обучение на Apple M1 и M2 с использованием MPS

С интеграцией поддержки чипов Apple M1 и M2 в модели Ultralytics YOLO теперь можно обучать ваши модели на устройствах, использующих мощную платформу Metal Performance Shaders (MPS). MPS предлагает производительный способ выполнения вычислений и задач обработки изображений на пользовательских кремниевых чипах Apple.

Чтобы запустить обучение на чипах Apple M1 и M2, вы должны указать 'mps' в качестве вашего устройства при запуске процесса обучения. Ниже приведены примеры использования Python и командной строки:

!!! Example "Пример обучения с MPS"

    === "Python"

        ```python
        from ultralytics import YOLO

        # Загрузить модель
        model = YOLO('yolov8n.pt')  # загрузить предобученную модель (рекомендуется для обучения)

        # Обучить модель с использованием MPS
        results = model.train(data='coco128.yaml', epochs=100, imgsz=640, device='mps')
        ```

    === "CLI"

        ```bash
        # Начать обучение с предобученной модели *.pt используя MPS
        yolo detect train data=coco128.yaml model=yolov8n.pt epochs=100 imgsz=640 device=mps
        ```

Используя вычислительные возможности чипов M1/M2, это позволяет более эффективно обрабатывать задачи обучения. Для более подробного руководства и расширенных параметров конфигурации, пожалуйста, обратитесь к [документации PyTorch MPS](https://pytorch.org/docs/stable/notes/mps.html).

## Логирование

В процессе обучения модели YOLOv8 вы можете найти ценным отслеживание производительности модели со временем. Здесь на помощь приходит логирование. YOLO от Ultralytics поддерживает три типа логгеров - Comet, ClearML и TensorBoard.

Чтобы использовать логгер, выберите его из выпадающего меню в приведенном выше примере кода и запустите его. Выбранный логгер будет установлен и инициализирован.

### Comet

[Comet](https://www.comet.ml/site/) - это платформа, которая позволяет ученым и разработчикам отслеживать, сравнивать, объяснять и оптимизировать эксперименты и модели. Она предоставляет такие функции, как метрики в реальном времени, сравнение кода и отслеживание гиперпараметров.

Чтобы использовать Comet:

!!! Example "Пример"

    === "Python"
        ```python
        # pip install comet_ml
        import comet_ml

        comet_ml.init()
        ```

Не забудьте войти в свою учетную запись Comet на их сайте и получить свой API-ключ. Вам нужно будет добавить его в переменные среды или в свой скрипт, чтобы вести журнал своих экспериментов.

### ClearML

[ClearML](https://www.clear.ml/) - это открытая платформа, которая автоматизирует отслеживание экспериментов и помогает в эффективном обмене ресурсами. Она предназначена для помощи командам в управлении, выполнении и воспроизведении их работы в области ML более эффективно.

Чтобы использовать ClearML:

!!! Example "Пример"

    === "Python"
        ```python
        # pip install clearml
        import clearml

        clearml.browser_login()
        ```

После запуска этого скрипта вам нужно будет войти в вашу учетную запись ClearML в браузере и аутентифицировать вашу сессию.

### TensorBoard

[TensorBoard](https://www.tensorflow.org/tensorboard) - это инструмент визуализации для TensorFlow. Он позволяет вам визуализировать граф TensorFlow, выводить количественные метрики о выполнении вашего графа и показывать дополнительные данные, такие как изображения, проходящие через него.

Чтобы использовать TensorBoard в [Google Colab](https://colab.research.google.com/github/ultralytics/ultralytics/blob/main/examples/tutorial.ipynb):

!!! Example "Пример"

    === "CLI"
        ```bash
        load_ext tensorboard
        tensorboard --logdir ultralytics/runs  # заменить на директорию 'runs'
        ```

Чтобы использовать TensorBoard локально, запустите приведенную ниже команду и просмотрите результаты по адресу http://localhost:6006/.

!!! Example "Пример"

    === "CLI"
        ```bash
        tensorboard --logdir ultralytics/runs  # заменить на директорию 'runs'
        ```

Это загрузит TensorBoard и направит его к каталогу, где сохраняются ваши журналы обучения.

После настройки вашего логгера вы можете продолжать обучение модели. Все метрики обучения будут автоматически записаны на выбранной вами платформе, и вы сможете получить доступ к этим журналам, чтобы отслеживать производительность вашей модели со временем, сравнивать различные модели и определять области для улучшения.
