---
comments: true
description: Исследуйте разнообразный спектр поддерживаемых Ultralytics моделей семейства YOLO, SAM, MobileSAM, FastSAM, YOLO-NAS и RT-DETR. Начните работу с примерами использования как для CLI, так и для Python.
keywords: Ultralytics, документация, YOLO, SAM, MobileSAM, FastSAM, YOLO-NAS, RT-DETR, модели, архитектуры, Python, CLI
---

# Поддерживаемые модели Ultralytics

Добро пожаловать в документацию по моделям Ultralytics! Мы поддерживаем широкий спектр моделей, каждая из которых адаптирована для конкретных задач, таких как [обнаружение объектов](../tasks/detect.md), [сегментация на уровне инстанций](../tasks/segment.md), [классификация изображений](../tasks/classify.md), [оценка позы](../tasks/pose.md) и [слежение за несколькими объектами](../modes/track.md). Если вы заинтересованы в добавлении архитектуры своей модели в Ultralytics, ознакомьтесь с нашим [Руководством для участников](../../help/contributing.md).

!!! Note "Примечание"

    🚧 Наша документация на разных языках находится в стадии разработки, и мы усердно работаем над ее улучшением. Спасибо за ваше терпение! 🙏

## Особенные модели

Вот некоторые ключевые поддерживаемые модели:

1. **[YOLOv3](yolov3.md)**: Третье поколение семейства моделей YOLO, авторства Джозефа Редмона, известное своей эффективностью в реальном времени для обнаружения объектов.
2. **[YOLOv4](yolov4.md)**: Нативное для darknet обновление YOLOv3, выпущенное Алексеем Бочковским в 2020 году.
3. **[YOLOv5](yolov5.md)**: Улучшенная версия архитектуры YOLO от Ultralytics, предлагающая лучшие компромиссы производительности и скорости по сравнению с предыдущими версиями.
4. **[YOLOv6](yolov6.md)**: Выпущенная в 2022 году компанией [Meituan](https://about.meituan.com/) и используемая во многих роботах автономной доставки компании.
5. **[YOLOv7](yolov7.md)**: Обновленные модели YOLO, выпущенные в 2022 году авторами YOLOv4.
6. **[YOLOv8](yolov8.md) НОВИНКА 🚀**: Последняя версия семейства YOLO, обладающая расширенными возможностями, такими как сегментация на уровне инстанций, оценка позы/ключевых точек и классификация.
7. **[Segment Anything Model (SAM)](sam.md)**: Модель сегментации всего и вся (SAM) от Meta.
8. **[Mobile Segment Anything Model (MobileSAM)](mobile-sam.md)**: MobileSAM для мобильных приложений от университета Kyung Hee.
9. **[Fast Segment Anything Model (FastSAM)](fast-sam.md)**: FastSAM от Группы анализа изображений и видео, Института автоматики, Китайской академии наук.
10. **[YOLO-NAS](yolo-nas.md)**: Модели нейронной архитектуры поиска YOLO (NAS).
11. **[Realtime Detection Transformers (RT-DETR)](rtdetr.md)**: Модели трансформеров реального времени для обнаружения объектов (RT-DETR) от Baidu PaddlePaddle.

<p align="center">
  <br>
  <iframe width="720" height="405" src="https://www.youtube.com/embed/MWq1UxqTClU?si=nHAW-lYDzrz68jR0"
    title="YouTube video player" frameborder="0"
    allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture; web-share"
    allowfullscreen>
  </iframe>
  <br>
  <strong>Смотрите:</strong> Запуск моделей YOLO от Ultralytics всего в несколько строк кода.
</p>

## Начало работы: Примеры использования

Этот пример предоставляет простые примеры обучения и вывода для YOLO. Полная документация по этим и другим [режимам](../modes/index.md) представлена на страницах документации [Predict](../modes/predict.md), [Train](../modes/train.md), [Val](../modes/val.md) и [Export](../modes/export.md).

Обратите внимание, что ниже приведен пример для моделей [Detect](../tasks/detect.md) YOLOv8 для обнаружения объектов. Для дополнительных поддерживаемых задач смотрите документацию по [Segment](../tasks/segment.md), [Classify](../tasks/classify.md) и [Pose](../tasks/pose.md).

!!! Example "Пример"

    === "Python"

        Предобученные модели PyTorch `*.pt`, а также конфигурационные файлы `*.yaml` могут быть переданы в классы `YOLO()`, `SAM()`, `NAS()` и `RTDETR()`, чтобы создать экземпляр модели на Python:

        ```python
        from ultralytics import YOLO

        # Загрузить предварительно обученную модель YOLOv8n для COCO
        model = YOLO('yolov8n.pt')

        # Отобразить информацию о модели (необязательно)
        model.info()

        # Обучить модель на примерном наборе данных COCO8 в течение 100 эпох
        results = model.train(data='coco8.yaml', epochs=100, imgsz=640)

        # Запустить вывод с помощью модели YOLOv8n на изображении 'bus.jpg'
        results = model('path/to/bus.jpg')
        ```

    === "CLI"

        Команды CLI доступны для непосредственного запуска моделей:

        ```bash
        # Загрузить предварительно обученную модель YOLOv8n для COCO и обучить её на примерном наборе данных COCO8 в течение 100 эпох
        yolo train model=yolov8n.pt data=coco8.yaml epochs=100 imgsz=640

        # Загрузить предварительно обученную модель YOLOv8n для COCO и запустить вывод на изображении 'bus.jpg'
        yolo predict model=yolov8n.pt source=path/to/bus.jpg
        ```

## Вклад в новые модели

Заинтересованы в том, чтобы внести свою модель в Ultralytics? Отлично! Мы всегда открыты для расширения нашего портфолио моделей.

1. **Сделайте Fork Репозитория**: Начните с создания форка [репозитория Ultralytics на GitHub](https://github.com/ultralytics/ultralytics).

2. **Склонируйте свой Fork**: Склонируйте ваш форк на локальную машину и создайте новую ветку для работы.

3. **Реализуйте свою Модель**: Добавьте вашу модель, следуя стандартам программирования и руководящим принципам, указанным в нашем [Руководстве для участников](../../help/contributing.md).

4. **Тщательно протестируйте**: Убедитесь, что вы тщательно протестировали свою модель, как изолированно, так и как часть пайплайна.

5. **Создайте Pull Request**: Как только вы будете удовлетворены своей моделью, создайте pull request в основной репозиторий для рассмотрения.

6. **Код-ревью и Слияние**: После рассмотрения, если ваша модель соответствует нашим критериям, она будет объединена с основным репозиторием.

Для подробных инструкций см. наше [Руководство для участников](../../help/contributing.md).
