---
comments: true
description: YOLOv4は、2020年にAlexey Bochkovskiyによってリリースされた最先端のリアルタイムオブジェクト検出器に関する詳細なガイドをご覧ください。そのアーキテクチャのハイライト、革新的な機能、および応用例を理解してください。
keywords: ultralytics、YOLOv4、オブジェクト検出、ニューラルネットワーク、リアルタイム検出、オブジェクト検出器、機械学習
---

# YOLOv4: 高速で正確なオブジェクト検出

YOLOv4のUltralyticsドキュメンテーションページへようこそ。YOLOv4は、2020年にAlexey Bochkovskiyによってリリースされた最先端のリアルタイムオブジェクト検出器です。速度と精度の最適なバランスを提供するよう設計されており、さまざまなアプリケーションに優れた選択肢です。

![YOLOv4アーキテクチャ図](https://user-images.githubusercontent.com/26833433/246185689-530b7fe8-737b-4bb0-b5dd-de10ef5aface.png)
**YOLOv4アーキテクチャ図**。YOLOv4の複雑なネットワーク設計を示しており、最適なリアルタイムオブジェクト検出のためのバックボーン、ネック、およびヘッドコンポーネント、およびそれらの相互接続されたレイヤーが表示されています。

## 導入

YOLOv4は、You Only Look Once version 4の略で、[YOLOv3](yolov3.md)や他のオブジェクト検出モデルなど、以前のYOLOバージョンの制約に対処するために開発されたリアルタイムオブジェクト検出モデルです。他の畳み込みニューラルネットワーク（CNN）ベースのオブジェクト検出器とは異なり、YOLOv4は推薦システムだけでなく、スタンドアロンのプロセス管理や人間の入力削減にも適用可能です。従来のグラフィックスプロセッシングユニット（GPU）上での動作は、手ごろな価格で大量の使用が可能であり、トレーニングには1つのGPUのみが必要です。

## アーキテクチャ

YOLOv4は、パフォーマンスの最適化に一緒に機能するいくつかの革新的な機能を利用しています。これには、Weighted-Residual-Connections（WRC）、Cross-Stage-Partial-connections（CSP）、Cross mini-Batch Normalization（CmBN）、Self-adversarial-training（SAT）、Mish-activation、Mosaic data augmentation、DropBlock regularization、およびCIoU lossが含まれます。これらの機能は組み合わせて、最先端の結果を達成するために使用されます。

典型的なオブジェクト検出器は、入力、バックボーン、ネック、そしてヘッドの複数の部分で構成されています。YOLOv4のバックボーンはImageNetで事前にトレーニングされ、オブジェクトのクラスと境界ボックスを予測するために使用されます。バックボーンはVGG、ResNet、ResNeXt、またはDenseNetなどの複数のモデルから選択できます。ディテクターのネック部分は、異なるステージからの特徴マップを収集するために使用され、通常、複数のボトムアップパスと複数のトップダウンパスが含まれます。ヘッド部分は、最終的なオブジェクトの検出と分類に使用されます。

## フリービーのバッグ

YOLOv4は、「フリービーのバッグ」として知られる手法も使用しており、これは推論のコストを増やさずにモデルの精度を向上させる技術です。データ拡張は、オブジェクト検出で使用される一般的なフリービーのバッグの技術の一つであり、入力画像の変動性を増加させることでモデルの堅牢性を向上させます。データ拡張の例には、光度の歪み（画像の明るさ、コントラスト、色調、彩度、ノイズの調整）や幾何学的歪み（ランダムなスケーリング、クロッピング、反転、回転の追加）があります。これらの技術は、モデルが異なる種類の画像に対してより良い一般化をするのに役立ちます。

## 機能と性能

YOLOv4は、オブジェクト検出の最適な速度と精度を目指して設計されています。YOLOv4のアーキテクチャには、バックボーンとしてCSPDarknet53、ネックとしてPANet、検出ヘッドとしてYOLOv3が含まれています。この設計により、YOLOv4は印象的な速度でオブジェクト検出を実行できるため、リアルタイムアプリケーションに適しています。YOLOv4は精度でも優れており、オブジェクト検出のベンチマークで最先端の結果を達成しています。

## 使用例

現時点では、Ultralyticsは現在、YOLOv4モデルをサポートしていません。そのため、YOLOv4を使用したいユーザーは、インストールおよび使用方法に関する情報は直接YOLOv4のGitHubリポジトリを参照する必要があります。

ここでは、YOLOv4を使用するための一般的な手順の概要を示します。

1. YOLOv4のGitHubリポジトリにアクセスします: [https://github.com/AlexeyAB/darknet](https://github.com/AlexeyAB/darknet).

2. インストールのためにREADMEファイルに記載されている指示に従います。一般的には、リポジトリのクローン、必要な依存関係のインストール、および必要な環境変数のセットアップが含まれます。

3. インストールが完了したら、データセットの準備、モデルパラメータの設定、モデルのトレーニング、トレーニングされたモデルを使用してオブジェクト検出を実行するなど、リポジトリで提供されている使用方法に従ってモデルをトレーニングおよび使用できます。

特定の手順は、特定のユースケースとYOLOv4リポジトリの現在の状態によって変わる場合があります。したがって、YOLOv4 GitHubリポジトリで提供されている指示に直接参照することを強くお勧めします。

YOLOv4のサポートが実装され次第、Ultralyticsの使用例のためにこのドキュメントを更新することをお詫び申し上げます。

## 結論

YOLOv4は、速度と精度のバランスを取った強力で効率的なオブジェクト検出モデルです。トレーニング中にユニークな機能とバッグのフリービーの技術を使用することで、リアルタイムのオブジェクト検出タスクで優れたパフォーマンスを発揮します。通常のGPUを持つ誰でもがトレーニングと使用を行うことができるため、幅広いアプリケーションにアクセス可能かつ実用的です。

## 引用と謝辞

リアルタイムオブジェクト検出の分野での重要な貢献に対して、YOLOv4の著者に謝意を表します:

!!! Quote ""

    === "BibTeX"

        ```bibtex
        @misc{bochkovskiy2020yolov4,
              title={YOLOv4: Optimal Speed and Accuracy of Object Detection},
              author={Alexey Bochkovskiy and Chien-Yao Wang and Hong-Yuan Mark Liao},
              year={2020},
              eprint={2004.10934},
              archivePrefix={arXiv},
              primaryClass={cs.CV}
        }
        ```

オリジナルのYOLOv4の論文は[arXiv](https://arxiv.org/pdf/2004.10934.pdf)で見つけることができます。著者は彼らの仕事を一般に公開しており、コードベースは[GitHub](https://github.com/AlexeyAB/darknet)でアクセスできます。私たちは、彼らの努力に感謝し、彼らの仕事を広いコミュニティにアクセス可能にしてくれたことに感謝しています。
