---
comments: true
description: योलोवी 8 के अल्ट्रालायटिक्स पूर्वानुमान मोड का उपयोग करना सीखें और विभिन्न कार्यों के लिए विभिन्न पूर्वानुमान स्रोतों के बारे में जानें। इमेजेस, वीडियोज़ और डेटा प्रारूपों जैसे पूर्वानुमान स्रोतों के बारे में जानें।
keywords: Ultralytics, YOLOv8, पूर्वानुमान मोड, पूर्वानुमान स्रोत, पूर्वानुमान कार्य, धारणा योजना, छवि प्रसंस्करण, वीडियो प्रसंस्करण, मशीन लर्निंग, एआई
---

# अल्ट्रालायटिक्स YOLO मॉडल पूर्वानुमान

<img width="1024" src="https://github.com/ultralytics/assets/raw/main/yolov8/banner-integrations.png" alt="अल्ट्रालायटिक्स YOLO संघटना और एकीकरण">

## परिचय

मशीन लर्निंग और कंप्यूटर विजन की दुनिया में दृश्यांश से समझने की प्रक्रिया को 'पूर्वानुमान' या 'पूर्वानुमान' कहा जाता है। अल्ट्रालायटिक्स YOLOv8 एक शक्तिशाली विशेषता प्रदान करता है जिसे **पूर्वानुमान मोड** कहा जाता है, जो व्यापक डेटा स्रोतों पर उच्च प्रदर्शन, वास्तुकालिक पूर्वानुमान के लिए विशेष रूप से तैयार किया गया है।

<p align="center">
  <br>
  <iframe width="720" height="405" src="https://www.youtube.com/embed/QtsI0TnwDZs?si=ljesw75cMO2Eas14"
    title="YouTube video player" frameborder="0"
    allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture; web-share"
    allowfullscreen>
  </iframe>
  <br>
  <strong>देखें:</strong> अल्ट्रालायटिक्स YOLOv8 मॉडल से आउटपुट निकालने का तरीका कस्टम परियोजनाओं के लिए।
</p>

## वास्तविक जगत में अनुप्रयोग

|                  विनिर्माण                  |                      खेल संघ                       |                    सुरक्षा                    |
|:-------------------------------------------:|:--------------------------------------------------:|:---------------------------------------------:|
| ![वाहन के पुर्जे डिटेक्शन][car spare parts] | ![फुटबॉल खिलाड़ी डिटेक्शन][football player detect] | ![लोगों का गिरना डिटेक्शन][human fall detect] |
|           वाहन के पुर्जे डिटेक्शन           |              फुटबॉल खिलाड़ी डिटेक्शन               |                लोगों का गिरना                 |

## पूर्वानुमान के लिए अल्ट्रालायटिक्स YOLO का उपयोग क्यों करें?

यहां आपको योलोवी 8 के पूर्वानुमान मोड का उपयोग अपने विभिन्न पूर्वानुमान की आवश्यकताओं के लिए करना चाहिए का कारण है:

- **बहुमुखीपन:** छवियों, वीडियोज और यह तक कि लाइव स्ट्रीम की पूर्वानुमान पर योग्य हैं।
- **प्रदर्शन:** मुख्यतः बिना सटीकता पर बलवर्धित, रियल-टाइम, उच्च गति प्रसंस्करण के लिए engineering किए गए हैं।
- **उपयोग सहज:** खद्य पाइथन और यथार्थता (CLI) इंटरफ़ेसों को जल्दी विपणन और परीक्षण के लिए।
- **ऊच्चतम अनुकूलनयोग्यता:** अपनी विशिष्ट आवश्यकताओं के अनुसार मॉडल के पूर्वानुमान कृति को निर्धारित करने के लिए विभिन्न सेटिंग और पैरामीटर।

### पूर्वानुमान मोड की प्रमुख सुविधाएँ

YOLOv8 का पूर्वानुमान मोड मजबूत और विशेषता प्राप्त करने के लिए डिज़ाइन किया गया है, जिसमें शामिल हैं:

- **यदि आपके डेटा के कई स्रोतों के पंजीकरण:** चाहे आपका डेटा व्यक्तिगत छवियों, छोटू माला छवियों, वीडियो फ़ाइलों या वास्तविक समय वीडियो स्ट्रीमों की रूप में हो, पूर्वानुमान मोड आपके लिए उपयुक्त है।
- **स्ट्रीमिंग मोड:** `स्ट्रीमिंग` सुविधाका उपयोग करें और `पूर्वानुमान की कॉल विधि` में `स्ट्रीम = ट्रू` सेट करके `रिजल्ट्स` ऑब्जेक्ट के एक मेमोरी-पर्याप्त जेनरेटर का उत्पादन करें।
- **बैच प्रोसेसिंग:** एक ही बैच में कई छवियों या वीडियो फ़्रेम्स की प्रोसेसिंग करने की क्षमता, पूर्वानुमान समय को और तेज़ करती है।
- **इंटीग्रेशन फ्रेंडली:** लचीली API के कारण मौजूदा डेटा पाईपलाइन और अन्य सॉफ़्टवेयर घटकों के साथ आसानी से इंटीग्रेट करें।

जब पूर्वानुमान के दौरान मॉडल को `गेनरेटर की `रूप में लोड किया जाता है, तो अल्ट्रालायटिक्स YOLO मॉडल निम्नलिखित मेथड से `रिजल्ट` ऑब्जेक्ट के एक पायथन सूची या यादृच्छिक संख्यकारी जनरेटर लौटाते हैं:

!!! Example "पूर्वानुमान"

    === "`स्ट्रीम = फाल्स` के साथ सूची यादृच्छिक"
        ```python
        from ultralytics import YOLO

        # एक मॉडल लोड करें
        model = YOLO('yolov8n.pt')  # पूर्व-प्रशिक्षित YOLOv8n मॉडल

        # सूची के लिए बैच्ड पूर्वानुमान चलाएं
        results = model(['im1.jpg', 'im2.jpg'])  # रिजल्ट्स ऑब्जेक्ट की सूची लौटाएँ

        # परिणाम सूची को प्रोसेस करें
        for result in results:
            boxes = result.boxes  # बॉक्स के लिए बॉक्स ऑब्जेक्ट
            masks = result.masks  # सेगमेंटेशन मोड के लिए मास्क्स ऑब्जेक्ट
            keypoints = result.keypoints  # पोज़ के लिए कीपॉइंट्स ऑब्जेक्ट
            probs = result.probs  # वर्गीकरण के लिए प्रोब्स ऑब्जेक्ट
        ```

    === "`स्ट्रीम = ट्रू के साथ जेनरेटर` की प्राथमिकता"
        ```python
        from ultralytics import YOLO

        # एक मॉडल लोड करें
        model = YOLO('yolov8n.pt')  # पूर्व-प्रशिक्षित YOLOv8n मॉडल

        # सूची के लिए बैच्ड पूर्वानुमान चलाएं
        results = model(['im1.jpg', 'im2.jpg'], stream=True)  # रिजल्ट्स ऑब्जेक्ट का जनरेटर लौटाएँ

        # रिजल्ट्स जनरेटर को प्रोसेस करें
        for result in results:
            boxes = result.boxes  # बॉक्स के लिए बॉक्स ऑब्जेक्ट
            masks = result.masks  # सेगमेंटेशन मास्क्स के लिए मास्क्स ऑब्जेक्ट
            keypoints = result.keypoints  # पोज़ के लिए कीपॉइंट्स ऑब्जेक्ट
            probs = result.probs  # वर्गीकरण के लिए प्रोब्स ऑब्जेक्ट
        ```

## पूर्वानुमान स्रोत

YOLOv8 पूर्वानुमान के लिए विभिन्न प्रकार के इनपुट स्रोतों को process कर सकता है, जैसा कि नीचे दिए गए तालिका में दिखाया गया है। स्रोतों में स्थिर छवियाँ, वीडियो स्ट्रीम्स, और विभिन्न डेटा प्रारूपों को विकास के साथ उपयोग किया जा सकता है। यह तालिका भी इंगित करती है कि क्या प्रत्येक स्रोत को स्ट्रीमिंग मोड में `द्वारा इस्तेमाल किया जा सकता है।' यहां स्ट्रीमिंग मोड का उपयोग वीडियो या लाइव स्ट्रीम को प्रोसेस करने के लिए उपयोगी है क्योंकि इसमें सभी फ्रेम्स को मेमोरी में लोड किए बिना एक रिजल्ट की generator बनाई जाती है।

!!! Tip "सुझाव"

    `स्ट्रीम = ट्रू` का उपयोग बड़ी वीडियोज़ या विशाल डेटासेट को संचालित करने के लिए करें ताकि मेमोरी का दक्षिणा प्रबंधित किया जा सके। `स्ट्रीम = फाल्स` के खंड के खंड में सभी फ्रेम्स या डेटा बिंदुओं के लिए परिणाम स्तोर किए जाते हैं, जो अधिकांशता में मेमोरी में लोड हो सकते हैं और बड़े इनपुट के लिए आउट-ऑफ-मेमोरी त्रुटियां उत्पन्न कर सकते हैं। इसके बराबर उपयोग करके `स्ट्रीम= True` एक जेनरेटर का उपयोग करता है, जिसके संचित होने वाले

केवल ब्रह्मण्ड के परिणामों को सीमित संग्रह किया जाता है, बहुत कम मेमोरी खपत करता है और बड़े इनपुट के लिए आउट ऑफमेमोरीनुमान syllabus नुकसान होने से बचाता है।

| स्रोत           | तर्क                                      | प्रकार        | टिप्पणियाँ                                                                                                  |
|-----------------|-------------------------------------------|---------------|-------------------------------------------------------------------------------------------------------------|
| छवि             | `'छवि.जेपीजी'`                            | `श. या पथ`    | एकल छवि फ़ाइल।                                                                                              |
| यूआरएल          | `'https://ultralytics.com/छवि/बस.जेपीजी'` | `शः`          | छवि होस्टेड रिमोटली उन्नत करने के लिए यूआरएल ।                                                              |
| स्क्रीनशॉट      | `'स्क्रीन'`                               | `शः`          | स्क्रीन की वर्तमान सामग्री के रूप में कैप्चर ।                                                              |
| आदर्श           | `इमेज.ओपन('चित्र.जेपीजी')`                | `पीआईएल.इमेज` | HWC format with RGB channels।                                                                               |
| ओपनसीवी         | `ओपेंसीवी.इमरेड('चित्र.जेपीजी')`          | `एनपी.न्डआरे` | HWC format with BGR channels `uint8 (0-255)`।                                                               |
| नम्पी           | `नपाई.जीरोस((640,1280,३))`                | `एनपी.नडअरे`  | HWC format with BGR channels `uint8 (0-255)`।                                                               |
| टॉर्च           | `टॉर्च.जीरोस(16,3,320,640)`               | `टॉर्च.टेंसर` | BCHW format with RGB channels `float32 (0.0-1.0)`।                                                          |
| सीएसवी          | `'स्रोत.सीएसवी'`                          | `शः`  or `पथ` | छवियों, वीडियोज़, या निर्देशिकाओं की पथों को समेटने वाली CSV फ़ाइल।                                         |
| वीडियो ✅        | `'वीडियो.म्प४'`                           | `पथ`  or `पथ` | MP4, AVI, आदि जैसे वीडियो फ़ाइल में वीडियो।                                                                 |
| निर्देशिका ✅    | `'पथ/'`                                   | `शः`  or `पथ` | छवियों या वीडियोज़ को समेटने वाली एक निर्देशिका का पथ।                                                      |
| ग्लॉब ✅         | `'पथ/ *.जेपीजी'`                          | `शः`          | एकाधिक फ़ाइलों के मिलते-जुलते गोलियाँ। वाइल्डकार्ड के रूप में `*` चरित्र का उपयोग करें।                     |
| यूट्यूब ✅       | `'https://youtu.be/LNwODJXcvt4'`          | `शः`          | एक यूट्यूब वीडियो के लिए यूआरएल।                                                                            |
| स्ट्रीम ✅       | `'rtsp://माद्यदिनता.कॉम/media.म्प४'`      | `शः`          | RTSP, RTMP, TCP या IP पते जैसे स्ट्रीमिंग प्रोटोकॉल्स के लिए पता।                                           |
| मल्टी-स्ट्रीम ✅ | `'सूची.स्ट्रीम्स'`                        | `शः`  or `पथ` | प्रति पंक्ति एक स्ट्रिम URL के साथ `*.streams` पाठ फ़ाइल, उदाहरण के लिए 8 स्ट्रीम 8 बैच-आकार के साथ चलेंगे। |

लेखक आदान प्रियतमानसों का सुझाव देते हैं:

!!! Example "पूर्वानुमान स्रोत"

    === "छवि"
        एक छवि फ़ाइल पर पूर्वानुमान चलाएं।
        ```python
        from ultralytics import YOLO

        # पूर्व-प्रशिक्षित YOLOv8n मॉडल लोड करें
        model = YOLO('yolov8n.pt')

        # छवि फ़ाइल के लिए पथ निर्धारित करें
        स्रोत = 'फाईल/पर/चित्र.jpg'

        # छवि पर पूर्वानुमान चलाएं
        परिणाम = model(स्रोत)  # रिजल्ट्स ऑब्जेक्ट की सूची

        # परिणाम सूची को प्रोसेस करें
        for परिणाम in परिणाम:
            बॉक्स = परिणाम.बॉक्स  # बॉक्स आउटपुट्स के लिए बॉक्स ऑब्जेक्ट
            मास्क्स = परिणाम.मास्क्स  # सेगमेंटेशन मास्क्स आउटपुट्स के लिए मास्क्स ऑब्जेक्ट
            कीपॉइंट्स = परिणाम.कीपॉइंट्स  # पोज के लिए कीपॉइंट्स ऑब्जेक्ट
            प्रोब्स = परिणाम.प्रोब्स  # वर्गीकरण आउटपुट्स के लिए प्रोब्स ऑब्जेक्ट
        ```

    === "स्क्रीनशॉट"
        वर्तमान स्क्रीन सामग्री पर पूर्वानुमान चलाएं।
        ```python
        from ultralytics import YOLO

        # पूर्व-प्रशिक्षित YOLOv8n मॉडल लोड करें
        model = YOLO('yolov8n.pt')

        # वर्तमान स्क्रीन सामग्री को स्रोत रूप में परिभाषित करें
        स्रोत = 'स्क्रीन'

        # वर्तमान सामग्री पर पूर्वानुमान चलाएं
        परिणाम = model(स्रोत)  # रिजल्ट्स ऑब्जेक्ट की सूची
        ```

    === "यूआरएल"
        दूरस्थ छवि या वीडियो पर पूर्वानुमान चलाएं।
        ```python
        from ultralytics import YOLO

        # पूर्व-प्रशिक्षित YOLOv8n मॉडल लोड करें
        model = YOLO('yolov8n.pt')

        # गहनर् रूप से निर्धारित दूरस्थ छवि या वीडियो की यूआरएल
        स्रोत = 'https://ultralytics.com/छवि/बस.जेपीजी'

        # यूआरएल पर पूर्वानुमान चलाएं
        परिणाम = model(स्रोत)  # रिजल्ट्स ऑब्जेक्ट की सूची
        ```

    === "आदर्श"
        Python Imaging Library (PIL) के साथ खोली गई छवि पर पूर्वानुमान चलाएं।
        ```python
        from PIL import Image
        from ultralytics import YOLO

        # पूर्व-प्रशिक्षित YOLOv8n मॉडल लोड करें
        model = YOLO('yolov8n.pt')

        # Python Imaging Library (PIL) के साथ खोली गई छवि
        स्रोत = Image.open('छवि.जेपीजी')

        # आदर्श पर पूर्वानुमान चलाएं
        परिणाम = model(स्रोत)  # रिजल्ट्स ऑब्जेक्ट की सूची
        ```

    === "ओपेंसीवी"
        OpenCV के साथ पढ़ी गई छवि पर पूर्वानुमान चलाएं।
        ```python
        import cv2
        from ultralytics import YOLO

        # पूर्व-प्रशिक्षित YOLOv8n मॉडल लोड करें
        model = YOLO('yolov8n.pt')

        # OpenCV के साथ पढ़ी गई छवि
        स्रोत = cv2.imread('छवि.जेपीजी')

        # ओपेंसीवी पर पूर्वानुमान चलाएं
        परिणाम = model(स्रोत)  # रिजल्ट्स ऑब्जेक्ट की सूची
        ```

    === "नम्पी"
        numpy array के रूप में प्रस्तुत छवि पर पूर्वानुमान चलाएं।
        ```python
        import numpy as np
        from ultralytics import YOLO

        # पूर्व-प्रशिक्षित YOLOv8n मॉडल लोड करें
        model = YOLO('yolov8n.pt')

        # छवि रूप में एक हिंदी छवि को बनाएँ
        स्रोत = np.zeros((640, 640, 3))

        # नम्पी पर पूर्वानुमान चलाएं
        परिणाम = model(स्रोत)  # रिजल्ट्स ऑब्जेक्ट की सूची
        ```

[वाहन के पुर्जे डिटेक्शन]: https://github.com/RizwanMunawar/ultralytics/assets/62513924/a0f802a8-0776-44cf-8f17-93974a4a28a1

[फुटबॉल खिलाड़ी डिटेक्शन]: https://github.com/RizwanMunawar/ultralytics/assets/62513924/7d320e1f-fc57-4d7f-a691-78ee579c3442

[लोगों का गिरना डिटेक्शन]: https://github.com/RizwanMunawar/ultralytics/assets/62513924/86437c4a-3227-4eee-90ef-9efb697bdb43
