---
comments: true
description: प्रशिक्षण से ट्रैकिंग तक, Ultralytics के साथ YOLOv8 का अधिकतम लाभ उठाएं। मान्यता प्राप्त मोड, जैसे पुष्टीकरण, निर्यात और बेंचमार्किंग, के लिए अवधारणाओं और उदाहरण प्राप्त करें।
keywords: Ultralytics, YOLOv8, मशीन लर्निंग, ऑब्जेक्ट डिटेक्शन, प्रशिक्षण, पुष्टीकरण, पूर्वावलोकन, निर्यात, ट्रैकिंग, बेंचमार्किंग
---

# Ultralytics YOLOv8 मोड

<img width="1024" src="https://github.com/ultralytics/assets/raw/main/yolov8/banner-integrations.png" alt="Ultralytics YOLO ecosystem and integrations">

## परिचय

Ultralytics YOLOv8 सिर्फ एक ओब्जेक्ट डिटेक्शन मॉडल नहीं है; यह मशीन लर्निंग मॉडलों के पूर्ण जीवन चक्र के लिए एक विकशील फ्रेमवर्क है—डेटा संग्रह और मॉडल प्रशिक्षण से पुष्टीकरण, डिप्लॉयमेंट और वास्तविक दुनिया के ट्रैकिंग तक। प्रत्येक मोड का एक विशेष उद्देश्य होता है और आपको विभिन्न कार्यों और यूज-केस के लिए आवश्यक लचीलापन और कार्यक्षमता प्रदान करने के लिए बनाया जाता है।

!!! Note "नोट"

    🚧 हमारी बहुभाषीय दस्तावेज़ीकरण वर्तमान में निर्माणाधीन है, और हम इसे सुधारने के लिए कड़ी मेहनत कर रहे हैं। आपकी सहनशीलता के लिए धन्यवाद! 🙏

<p align="center">
  <br>
  <iframe width="720" height="405" src="https://www.youtube.com/embed/j8uQc0qB91s?si=dhnGKgqvs7nPgeaM"
    title="YouTube वीडियो प्लेयर" frameborder="0"
    allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture; web-share"
    allowfullscreen>
  </iframe>
  <br>
  <strong>देखें:</strong> Ultralytics मोड ट्यूटोरियल: प्रशिक्षण, पुष्टीकरण, पूर्वावलोकन, निर्यात और बेंचमार्किंग।
</p>

### एक पल मोडें

Ultralytics YOLOv8 के समर्थित **मोड** को समझना आपके मॉडल का अधिकतम उपयोग करने के लिए महत्वपूर्ण है:

- **प्रशिक्षण** मोड: अपने मॉडल को कस्टम या पूर्व-भर्ती डेटासेट में संशोधित करें।
- **पुष्टीकरण** मोड: मॉडल प्रदर्शन को मान्यता प्राप्त करने के लिए प्रशिक्षण के बाद के चेकप्वाइंट का उपयोग करें।
- **पूर्वावलोकन** मोड: नए छवियों या वीडियो का उपयोग करके प्रशिक्षित YOLOv8 मॉडल के माध्यम से पूर्वानुमान करें।
- **निर्यात** मोड: डिप्लॉयमेंट के लिए मॉडल को विभिन्न प्रारूपों में तैयार करें।
- **ट्रैक** मोड: रीयल-टाइम ट्रैकिंग अनुप्रयोगों में योजित आइटम डिटेक्शन मॉडल का विस्तार करें।
- **बेंचमार्क** मोड: विविध डिप्लॉयमेंट वातावरणों में मॉडल की गति और सटीकता का विश्लेषण करें।

यह सामग्री आपको प्रत्येक मोड का अवलोकन और व्यावहारिक अंदाज़ देने का उद्देश्य रखती है, जिससे आप YOLOv8 की पूरी क्षमता का उपयोग कर सकें।

## [प्रशिक्षण](train.md)

प्रशिक्षण मोड का उपयोग कस्टम डेटासेट पर YOLOv8 मॉडल के प्रशिक्षण के लिए किया जाता है। इस मोड में, मॉडल को निर्दिष्ट डेटासेट और हाइपरपैरामीटर का उपयोग करके प्रशिक्षित किया जाता है। प्रशिक्षण प्रक्रिया में, मॉडल के पैरामीटरों को अनुकूलित किया जाता है ताकि यह छवियों में ऑब्जेक्टों की कक्षाओं और स्थानों का सटीक पूर्वानुमान कर सके।

[प्रशिक्षण उदाहरण](train.md){ .md-button .md-button--primary}

## [पुष्टीकरण](val.md)

पुष्टीकरण मोड का उपयोग YOLOv8 मॉडल के प्रशिक्षण के बाद मॉडल की मान्यता और सामान्यीकरण प्रदर्शन को मापने के लिए किया जाता है। इस मोड में, मॉडल को एक प्रमाणीकरण सेट पर मूल्यांकन किया जाता है ताकि उसकी सटीकता और सामान्यीकरण प्रदर्शन को मापा जा सके। इस मोड का उपयोग मॉडल के प्रदर्शन को सुधारने के लिए मॉडल के हाइपरपैरामीटरों को ट्यून करने के लिए किया जा सकता है।

[पुष्टीकरण उदाहरण](val.md){ .md-button .md-button--primary}

## [पूर्वानुमान](predict.md)

पूर्वानुमान मोड का उपयोग नई छवियों या वीडियो पर प्रशिक्षित YOLOv8 मॉडल का उपयोग करके पूर्वानुमान बनाने के लिए किया जाता है। इस मोड में, मॉडल एक चेकप्वाइंट फ़ाइल से लोड किया जाता है, और उपयोगकर्ता छवियों या वीडियों को उपयोग करके इन्फेरेंस कर सकता है। मॉडल उपयोगकर्ता को इनपुट छवियों या वीडियों में ऑब्जेक्टों की कक्षाओं और स्थानों का पूर्वानुमान करता है।

[पूर्वानुमान उदाहरण](predict.md){ .md-button .md-button--primary}

## [निर्यात](export.md)

निर्यात मोड का उपयोग एक YOLOv8 मॉडल को इस्तेमाल करने के लिए एक प्रारूप में करने के लिए किया जाता है जो कि अन्य सॉफ़्टवेयर अनुप्रयोगों या हार्डवेयर उपकरणों द्वारा इस्तेमाल किया जा सकता है। यह मोडल को उत्पादन उद्योगों में डिप्लॉय करने के लिए उपयोगी होता है।

[निर्यात उदाहरण](export.md){ .md-button .md-button--primary}

## [ट्रैक](track.md)

ट्रैक मोड का उपयोग एक YOLOv8 मॉडल का उपयोग करके वास्तविक समय में वस्तुओं का ट्रैकिंग करने के लिए किया जाता है। इस मोड में, मॉडल एक चेकप्वाइंट फ़ाइल से लोड किया जाता है, और उपयोगकर्ता एक लाइव वीडियो स्ट्रीम प्रदान कर सकता है ताकि वास्तविक समय में वस्तुओं का ट्रैकिंग किया जा सके। यह मोड सतर्कता प्रणालियों या स्वयं चालित कार जैसे अनुप्रयोगों के लिए उपयोगी होता है।

[ट्रैक उदाहरण](track.md){ .md-button .md-button--primary}

## [बेंचमार्क](benchmark.md)

बेंचमार्क मोड का उपयोग YOLOv8 के विभिन्न निर्यात प्रारूपों की गति और सटीकता का प्रोफ़ाइल बनाने के लिए किया जाता है। बेंचमार्क से प्राप्त जानकारी निर्यात प्रारूप के आकार, उसकी `mAP50-95` metric (ऑब्जेक्ट डिटेक्शन, सेगमेंटेशन और पोज़ के लिए)
या `accuracy_top5` metric (वर्गीकरण के लिए), और चित्र माध्यमिक समय के मिलीसेकंड प्रति इमेज के अलग-अलग निर्यात प्रारूपों की जानकारी प्रदान करता है। यह जानकारी उपयोगकर्ताओं को उनकी विशेष उपयोग के मामले में उनकी खासियतों के लिए मिति और सटीकता के लिए सर्वोत्तम निर्यात प्रारूप का चयन करने में मदद कर सकती है।

[बेंचमार्क उदाहरण](benchmark.md){ .md-button .md-button--primary}
