---
comments: true
description: एक उत्कृष्ट वस्तु पहचानने मॉडल में स्पीड और सटीकता के बीच एक सामंजस्य स्थापित करने वाला, रीयल-टाइम एप्लिकेशन्स के लिए लोकप्रिय भारतीय ब्रांड योलोवी6 का अध्ययन करें। उल्ट्रालिटिक्स के लिए मीथुन योलोवी6, फ़ीचर्स, पूर्व-प्रशिक्षित मॉडल्स और पायथन उपयोग पर डाइव करें।
keywords: मिथुन योलोवी6, वस्तु पहचान, Ultralytics, योलोवी6 दस्तावेज़, प्रतिस्थापन में द्विदिशीय जोड़, एंकर-सहायित प्रशिक्षण, पूर्व-प्रशिक्षित मॉडल, वास्तविक समय एप्लिकेशन्स
---

# मिथुन योलोवी6

## परियोजना

[मिथुन](https://about.meituan.com/) योलोवी6 एक नवीनतम वस्तु पहचानकर्ता है जो स्पीड और सटीकता के बीच अद्वितीय संतुलन प्रदान करता है, जिसके कारण यह वास्तविक समय एप्लिकेशन्स के लिए एक लोकप्रिय विकल्प है। इस मॉडल ने अपने आर्किटेक्चर और प्रशिक्षण योजना पर कई आदर्श नवीनतमान वृद्धियों को पेश किया है, जिसमें एक जोड़ने-द्विदिशीकरण (BiC) मॉड्यूल, एंकर-सहायित प्रशिक्षण (AAT) स्ट्रेटेजी, और COCO डेटासेट पर अद्वितीय सटीकता के लिए सुधारित बैकबोन और गर्दन डिज़ाइन का क्रियान्वयन शामिल है।

![मिथुन योलोवी6](https://user-images.githubusercontent.com/26833433/240750495-4da954ce-8b3b-41c4-8afd-ddb74361d3c2.png)
![माॅडेल उदाहरण छवि](https://user-images.githubusercontent.com/26833433/240750557-3e9ec4f0-0598-49a8-83ea-f33c91eb6d68.png)
**योलोवी6 का अवलोकन।** मॉडल आर्किटेक्चर आरेख आपको बड़ी प्रदर्शन वृद्धि करने वाले संकरणों और प्रशिक्षण रणनीतियों का आभास कराता है। (a) योलोवी6 का गर्दन (N और S दिखाए गए हैं)। M/L के लिए, रिपब्लॉक को सीएसपीस्टैकरेप से बदल दिया गया है। (b) बीसी मॉड्यूल का संरचना। (c) एक सिमकुस्पस्पफ ब्लॉक। ([स्रोत](https://arxiv.org/pdf/2301.05586.pdf))।

### मुख्य विशेषताएं

- **द्विदिशीय जोड़ने (BiC) मॉड्यूल:** योलोवी6 डिटेक्टर के गर्दन में BiC मॉड्यूल प्रस्तुत करता है, जिससे स्थानांतरण सिग्नल में सुधार होती है और ज्ञानसंक्षेप में गतिविधि के साथ प्रदर्शन सुधार होता है।
- **एंकर-सहायित प्रशिक्षण (AAT) स्ट्रेटेजी:** यह मॉडल AAT प्रस्तावित करता है ताकि यह एंकर-आधारित और एंकर-मुक्त दोनों परंपराओं के लाभ प्राप्त कर सके और अंतर्निहित क्षमता पर खराब प्रभाव न हो।
- **सुधारित बैकबोन और गर्दन डिज़ाइन:** YOLOv6 को बैकबोन और गर्दन में एक और स्टेज शामिल करके, इस मॉडल ने कोको डेटासेट पर अद्वितीय प्रदर्शन को उच्च-संकल्पन इनपुट पर प्राप्त किया है।
- **स्व-स्त्रावबद्धि (Self-Distillation) स्ट्रेटेजी:** छोटे YOLOv6 मॉडलों के प्रदर्शन को बढ़ाने के लिए, यहां नई स्व-स्त्रावबद्धि स्ट्रेटेजी का अमल किया गया है, जिससे प्रशिक्षण के दौरान मददगार संश्लेषण शाखा को सुधारा जाता है और प्रशिक्षण में इसे हटा दिया जाता है ताकि मार्क की गति में प्रमुख गिरावट न हो।

## प्रदर्शन माप

YOLOv6 विभिन्न पूर्व-प्रशिक्षित मॉडलों के साथ प्रदान करता है जिनमें अलग-अलग स्केल होती हैं:

- YOLOv6-N: NVIDIA Tesla T4 GPU पर 1187 फ्रेम प्रति सेकंड पर COCO val2017 में 37.5% एपी।
- YOLOv6-S: 484 फ्रेम प्रति सेकंड पर 45.0% एपी।
- YOLOv6-M: 226 फ्रेम प्रति सेकंड पर 50.0% एपी।
- YOLOv6-L: 116 फ्रेम प्रति सेकंड पर 52.8% एपी।
- YOLOv6-L6: वास्तविक समय में पराकाष्ठा की सटीकता।

YOLOv6 ऐसे पालटने वाले मॉडल भी प्रदान करता है जिनमें विभिन्न परिशुद्धियां होती हैं और मोबाइल प्लेटफ़ॉर्म के लिए अनुकूलित मॉडल्स होती हैं।

## उपयोग उदाहरण

यह उदाहरण आसान YOLOv6 प्रशिक्षण और संदर्भ उदाहरण प्रदान करता है। इन और अन्य [modes](../modes/index.md) के लिए पूर्ण दस्तावेज़ीकरण के लिए [Predict](../modes/predict.md), [Train](../modes/train.md), [Val](../modes/val.md) और [Export](../modes/export.md) डॉक्स पेज देखें।

!!! Example "उदाहरण"

    === "पायथन"

        PyTorch से पूर्व-प्रशिक्षित `*.pt` मॉडल और कॉन्फ़िगरेशन `*.yaml` फ़ाइलें पास करके `YOLO()` कक्षा में एक मॉडल उदाहरण बनाया जा सकता है:

        ```python
        from ultralytics import YOLO

        # खाली स्थान से एक YOLOv6n मॉडल बनाएँ
        model = YOLO('yolov6n.yaml')

        # मॉडल की जानकारी प्रदर्शित करें (वैकल्पिक)
        model.info()

        # COCO8 उदाहरण डेटासेट पर मॉडल को 100 एपोक के लिए प्रशिक्षित करें
        results = model.train(data='coco8.yaml', epochs=100, imgsz=640)

        # 'bus.jpg' छवि पर YOLOv6n मॉडल के साथ निर्धारण चलाएँ
        results = model('path/to/bus.jpg')
        ```

    === "CLI"

        मॉडल को निर्धारित करने के लिए सीएलआई कमांड उपलब्ध हैं:

        ```bash
        # शुरू से एक YOLOv6n मॉडल बनाएँ और इसे COCO8 उदाहरण डेटासेट पर 100 एपोक के लिए प्रशिक्षित करें
        yolo train model=yolov6n.yaml data=coco8.yaml epochs=100 imgsz=640

        # शुरू से एक YOLOv6n मॉडल बनाएँ और 'bus.jpg' छवि पर निधारण चलाएँ
        yolo predict model=yolov6n.yaml source=path/to/bus.jpg
        ```

## समर्थित कार्य और मोड

YOLOv6 श्रृंखला उच्च प्रदर्शन [वस्तु पहचान](../tasks/detect.md) के लिए विभिन्न मॉडल प्रदान करती है। इन मॉडल्स में विभिन्न गणना और सटीकता की आवश्यकताओं के लिए आदर्श होते हैं, जिससे इन्हें विभिन्न अनुप्रयोगों के लिए विचारशील होता है।

| मॉडल का प्रकार | पूर्व-प्रशिक्षित भार | समर्थित कार्य                     | निर्धारण | मान्यीकरण | प्रशिक्षण | निर्यात |
|----------------|----------------------|-----------------------------------|----------|-----------|-----------|---------|
| YOLOv6-N       | `yolov6-n.pt`        | [वस्तु पहचान](../tasks/detect.md) | ✅        | ✅         | ✅         | ✅       |
| YOLOv6-S       | `yolov6-s.pt`        | [वस्तु पहचान](../tasks/detect.md) | ✅        | ✅         | ✅         | ✅       |
| YOLOv6-M       | `yolov6-m.pt`        | [वस्तु पहचान](../tasks/detect.md) | ✅        | ✅         | ✅         | ✅       |
| YOLOv6-L       | `yolov6-l.pt`        | [वस्तु पहचान](../tasks/detect.md) | ✅        | ✅         | ✅         | ✅       |
| YOLOv6-L6      | `yolov6-l6.pt`       | [वस्तु पहचान](../tasks/detect.md) | ✅        | ✅         | ✅         | ✅       |

यह तालिका योलोवी6 मॉडल वेरिएंट्स का विस्तृत अवलोकन प्रदान करती है, जो वस्तु पहचान कार्यों में उनकी क्षमताओं और विभिन्न संचालन मोडों के साथ [निर्धारण](../modes/predict.md), [मान्यीकरण](../modes/val.md), [प्रशिक्षण](../modes/train.md), और [निर्यात](../modes/export.md) के संगतता को हाइलाइट करते हैं। इस व्यापक समर्थन से उपयोगकर्ताओं को योलोवी6 मॉडलों की क्षमताओं का पूरा उपयोग करने की सुविधा होती है एक व्यापक वस्तु पहचान स्थिति में।

## सन्दर्भ और पुन:ज्ञानजनक

हम मूल योलोवी6 कागज पर [arXiv](https://arxiv.org/abs/2301.05586) में उपलब्ध हैं काम के लिए संघ द्वारा स्विकृति दी जाती है। लेखकों ने अपने काम को सार्वजनिक रूप से उपलब्ध कराया है, और कोडबेस [GitHub](https://github.com/meituan/YOLOv6) पर पहुंचने के लिए है। हम उनके प्रयासों की प्रशंसा करते हैं क्योंकि वे क्षेत्र को आगे बढ़ाने और अपने काम को आपातकालीन रूप से ब्रॉडर समुदाय को सुलभ बनाने के लिए उनके प्रयासों को पहुंचने में लगे हैं।
