---
comments: true
description: Ultralytics के Segment Anything Model (SAM) की अभिनव सेगमेंटेशन मॉडल का पता लगाएं जो रीयल-टाइम छवि सेगमेंटेशन की अनुमति देता है। समझें कि इसमें promptable सेगमेंटेशन, zero-shot प्रदर्शन शामिल है और यह कैसे उपयोग किया जाता है।
keywords: Ultralytics, Image segmentation, Segment Anything Model, SAM, SA-1B डेटासेट, रीयल-टाइम प्रदर्शन, zero-shot ट्रांसफर, वस्तु पहचानन, छवि विश्लेषण, मशीन लर्निंग
---

# Segment Anything Model (SAM)

Segment Anything Model (SAM), यानी वस्तु को के सिलसीलेबंद छवि सेगमेंटेशन के पहले खंड "SAM"में आपका स्वागत है। यह क्रांतिकारी मॉडल समयबद्ध प्रदर्शन के साथ promptable छवि सेगमेंटेशन द्वारा खेल को बदल चुका है और क्षेत्र में नई मानकों को स्थापित किए हैं।

## SAM: Segment Anything Model का परिचय

Segment Anything Model (SAM), यानी SAM, एक अभिनव छवि सेगमेंटेशन मॉडल है जो promptable सेगमेंटेशन की अनुमति देता है, जिससे छवि विश्लेषण कार्यों में अविश्वसनीय विविधता प्राप्त होती है। SAM, Segment Anything पहल के दिल में आता है, जो छवि सेगमेंटेशन के लिए नई मॉडल, कार्य और डेटासेट का परिचय कराता है।

SAM का उन्नत डिजाइन इसे नई छवि वितरणों और कार्यों के लिए पूर्वज्ञान के बिना सामायिक होने देता है, जिसे जीरो-शॉट ट्रांसफर के नाम से जाना जाता है। विस्तारशील [SA-1B डेटासेट](https://ai.facebook.com/datasets/segment-anything/) पर (जिसमें 1 अरब से अधिक मास्क हैं जो 11 मिलियन सावधानीपूर्वक इच्छीत छवियों पर बिखेरे गए हैं), SAM ने वास्तव में दिखाया है कि यह बेहद श्रेष्ठ जीरो-शॉट प्रदर्शन का anomaly-detection करने वाले पहले परिणामों को हर हाल में छू सकता है।

![सैंपल डेटासेट छवि](https://user-images.githubusercontent.com/26833433/238056229-0e8ffbeb-f81a-477e-a490-aff3d82fd8ce.jpg)
हमारे नई पेशकश डेटासेट, SA-1B से दिए गए ओवरले मास्क वाली उदाहरण छवियाँ। SA-1B में 11M विविध, उच्च-रिजोल्यूशन, लाइसेंस और प्राइवेसी संरक्षण योग्य छवियाँ और 1.1B उच्च-गुणवत्ता वाले सेगमेंटेशन मास्क मौजूद हैं। इन मास्क को SAM द्वारा पूर्णतः स्वचालित रूप से टिप्पणी की गई हैं, और मानवीय रेटिंग और अनेक अभ्यासों से सत्यापित हुए अनुसार, इनकी गुणवत्ता और विविधता प्रमुख हैं। छवियों की संख्या के आधार पर छवियाँ समूहित की गई हैं (औसतन प्रति छवि पर लगभग 100 मास्क होती हैं)।

## Segment Anything Model (SAM) की मुख्य विशेषताएं

- **Promptable Segmentation Task:** SAM का निर्माण promptable सेगमेंटेशन कार्य के साथ किया गया है, जिसके बाद वह कोई भी प्रोम्प्ट देकर मान्य सेगमेंटेशन मास्क उत्पन्न कर सकता है, जैसे कि वस्तु का निर्देश करने वाले स्थानिक या पाठ संकेत।
- **उन्नत वास्तविकता:** Segment Anything Model में एक शक्तिशाली छवि इनकोडर, प्रोम्प्ट इनकोडर, और हल्की वजन के मास्क डीकोडर की बाईं लगाम लगातार बदलाव और अस्पष्टता की जागरूकता पर आधारित होती है। यह विशेष आर्किटेक्चर प्रारंभिक जोखिम ज्ञान के बिना नए क्षेत्रों और छवि वितरणों के लिए सुविधाजनक होने की अनुमति देता है।
- **SA-1B डेटासेट:** SAM पहल के द्वारा प्रस्तुत किए गए SA-1B डेटासेट में 11 मिलियन छवियों पर 1 अरब से अधिक मास्क होती हैं। इसे अब तक का सबसे बड़ा सेगमेंटेशन डेटासेट माना जाता है, जिससे SAM को विविधतापूर्ण और बड़े पैमाने पर भड़ास ट्रेनिंग डेटा स्रोत प्राप्त होता है।
- **जीरो-शॉट प्रदर्शन:** SAM विभिन्न सेगमेंटेशन कार्यों में उत्कृष्ट जीरो-शॉट प्रदर्शन प्रदर्शित करता है, जिससे यह विविध अनुप्रयोगों के लिए तत्परता के आवश्यकता के साथ तत्परता के यन्त्रियों के लिए तत्परता के यंत्रों के लिए तत्पर करने योग्य एक तत्परता यंत्र बन गया है।

Segment Anything Model और SA-1B डेटासेट की गहन जानकारी के लिए, कृपया [Segment Anything वेबसाइट](https://segment-anything.com) पर जाएं और शोध पेपर [Segment Anything](https://arxiv.org/abs/2304.02643) की जाँच करें।

## उपलब्ध मॉडल, समर्थित कार्य और संचालनिक विधियाँ

यह तालिका उपलब्ध मॉडल, उनकी विशेष पूर्व-प्रशिक्षित वेट, उनके समर्थित कार्य और इंफरेंस, मान्यीकरण, प्रशिक्षण और निर्यात जैसे विभिन्न संचालित विधियों के साथ उनकी संबद्धता का प्रस्ताव प्रस्तुत करती है.

| मॉडल प्रकार | पूर्व-प्रशिक्षित वेट | समर्थित कार्य       | Inference | Validation | Training | Export |
|-------------|----------------------|---------------------|-----------|------------|----------|--------|
| SAM बेस     | `sam_b.pt`           | इंस्टेंस सेगमेंटेशन | ✅         | ❌          | ❌        | ✅      |
| SAM लार्ज   | `sam_l.pt`           | इंस्टेंस सेगमेंटेशन | ✅         | ❌          | ❌        | ✅      |

## SAM का उपयोग कैसे करें: छवि सेगमेंटेशन में यथार्थता और शक्ति

Segment Anything Model का उपयोग उपस्थित डेटा से आगे के कार्यों के लिए किया जा सकता है। इसमें एज डिटेक्शन, निवेदन प्रस्ताव उत्पादन, इंस्टेंस सेगमेंटेशन, और प्राथमिक पाठ-तो-मास्क पूर्वानुमान शामिल हैं। प्रोम्प्ट इंजीनियरिंग के साथ, SAM नए कार्यों और डेटा वितरणों के लिए जीरो-शॉट तरीके में शीघ्र रूप से अनुकूलित हो सकता है, जिससे यह आपकी सभी छवि सेगमेंटेशन आवश्यकताओं के लिए एक सुगम और प्रभावी उपकरण बन जाता है।

### SAM पूर्वानुमान उदाहरण

!!! Example "निर्दिष्ट प्रप्ति के साथ सेगमेंट तय करें"

    निर्दिष्ट प्रप्ति के साथ चित्रीय भविष्यवाणी करें।

    === "टख्ती"

        ```python
        from ultralytics import SAM

        # एक मॉडल लोड करें
        model = SAM('sam_b.pt')

        # मॉडल सूचना प्रदर्शित करें (वैकल्पिक)
        model.info()

        # बॉक्स प्रम्प्ट के साथ इनफ़रन्स चलाएं
        model('ultralytics/assets/zidane.jpg', bboxes=[439, 437, 524, 709])

        # बिंदु प्रम्प्ट के साथ इनफ़रन्स चलाएं
        model('ultralytics/assets/zidane.jpg', points=[900, 370], labels=[1])
        ```

!!! Example "सब कुछ सेगमेंट करें"

    पूरी छवि को सेगमेंट करें।

    === "टख्ती"

        ```python
        from ultralytics import SAM

        # एक मॉडल लोड करें
        model = SAM('sam_b.pt')

        # मॉडल सूचना प्रदर्शित करें (वैकल्पिक)
        model.info()

        # इनफ़रेंस चलाएं
        model('पथ/फ़ाइल/सदृश छवि.जेपीजी')
        ```

    === "CLI"

        ```बैश
        # सब कुछ SEKैग के साथ SAM मॉडल के साथ इनफ़रन्स चलाएं
        yolo predict model=sam_b.pt source=पथ/फ़ाइल/सदृश छवि.जेपीजी
        ```

- यहां यह तर्क है कि आप प्रोम्प्ट (बॉक्स / पॉइंट / मास्क) पास नहीं करते हैं तो पूरी छवि को सेगमेंट करें।

!!! Example "SAMPredictor उदाहरण"

    इस तरह से आप एक बार छवि सेट कर सकते हैं और बार-बार प्रोम्प्ट इन्फ़रेंस चला सकते हैं। छवि को बार बार इन्कोडर के मध्य में नहीं चलाने के लिए।

    === "प्रोम्प्ट भविष्यवाणी करना"

        ```python
        from ultralytics.models.sam import Predictor as SAMPredictor

        # SAMPredictor बनाएं
        overrides = dict(conf=0.25, task='कटा', mode='पूर्वानुमान', imgsz=1024, model="mobile_sam.pt")
        predictor = SAMPredictor(overrides=overrides)

        # चित्र सेट करें
        predictor.set_image("ultralytics/assets/zidane.jpg")  # चित्र फ़ाइल के साथ सेट करें
        predictor.set_image(cv2.imread("ultralytics/assets/zidane.jpg"))  # एनपी. एस. एन. द्वारा सेट करें
        results = predictor(bboxes=[439, 437, 524, 709])
        results = predictor(points=[900, 370], labels=[1])

        # चित्र रीसेट करें
        predictor.reset_image()
        ```

    अतिरिक्त तत्वों के साथ सब कुछ को टुकड़ों में विभाजित करें।

    === "सब कुछ का सेगमेंट"

        ```python
        from ultralytics.models.sam import Predictor as SAMPredictor

        # SAMPredictor बनाएं
        overrides = dict(conf=0.25, task='सेगमेंट', mode='पूर्वानुमान', imgsz=1024, model="mobile_sam.pt")
        predictor = SAMPredictor(overrides=overrides)

        # अतिरिक्त तत्वों के साथ सेगमेंट
        results = predictor(source="ultralytics/assets/zidane.jpg", crop_n_layers=1, points_stride=64)
        ```

- `सब कुछ का सेगमेंट` के लिए अतिरिक्त तत्वों के लिए अधिक देखें [`Predictor/generate` Reference](../../reference/models/sam/predict.md).

## SAM की तुलना YOLOv8 के बनाम

यहां हम SAM के सबसे छोटे मॉडल, SAM-b, की तुलना Ultralytics के सबसे छोटे सेगमेंट मॉडल, [YOLOv8n-seg](../टास्क/सेगमेंट.md), के साथ करते हैं:

| मॉडल                                                               | आकार                        | पैरामीटर             | गति (सीपीयू)            |
|--------------------------------------------------------------------|-----------------------------|----------------------|-------------------------|
| SAM का सबसे छोटा, SAM-b                                            | 358 MB                      | 94.7 M               | 51096 ms/im             |
| [मोबाइल SAM](mobile-sam.md)                                        | 40.7 MB                     | 10.1 M               | 46122 ms/im             |
| [अग्री सेगमेंटेशन वाली FastSAM-s, YOLOv8 बैकबोन सहित](fast-sam.md) | 23.7 MB                     | 11.8 M               | 115 ms/im               |
| Ultralytics [योलोवी8न-seg](../टास्क/सेगमेंट.md)                    | **6.7 MB** (53.4 गुना छोटा) | **3.4 M** (27.9x कम) | **59 ms/im** (866x तेज) |

यह तुलना मॉडल के आकार और गति में दस्तावेजीय अंतर दिखाती है। जहां SAM स्वचालित सेगमेंटेशन के लिए अद्वितीय क्षमताओं को प्रस्तुत करता है, वहीं Ultralytics विद्यमान सेगमेंटेशन मानदंडों के तुलनात्मक आकार, गति और संचालन क्षमता में समर्थन प्रदान करती है।

एक 2023 Apple M2 Macbook (16GB रैम के साथ) पर चलाई गई परीक्षा। इस परीक्षण को दोहराने के लिए:

!!! Example "उदाहरण"

    === "Python"
        ```python
        from ultralytics import FastSAM, SAM, YOLO

        # SAM-b प्रोफाइल करें
        model = SAM('sam_b.pt')
        model.info()
        model('ultralytics/assets')

        # मोबाइलSAM प्रोफाइल करें
        model = SAM('mobile_sam.pt')
        model.info()
        model('ultralytics/assets')

        # FastSAM-s प्रोफाइल करें
        model = FastSAM('FastSAM-s.pt')
        model.info()
        model('ultralytics/assets')

        # YOLOv8n-seg प्रोफाइल करें
        model = YOLO('yolov8n-seg.pt')
        model.info()
        model('ultralytics/assets')
        ```

## स्वत: टिपण्णीकरण: सेगमेंटेशन डेटासेट के लिए एक त्वरित मार्ग

स्वत: टिपण्णीकरण SAM की एक मुख्य सुविधा है जो उपयोगकर्ताओं को एक पूर्व-प्रशिक्षित डिटेक्शन मॉडल का उपयोग करके [सेगमेंटेशन डेटासेट](https://docs.ultralytics.com/datasets/segment) उत्पन्न करने की अनुमति देती है। यह सुविधा बड़ी संख्या में छवियों को क्वालिटी कंट्रोल से आनोत करने की जरूरत के दौरान समयरोकी मूल्य अंकन की जरूरत छोड़ती है।

### अपने सेगमेंटेशन डेटासेट के उपयोग के लिए गतिशीलता निर्मित करें

Ultralytics फ़्रेमवर्क के साथ स्‍वस्‍थ दिखाई देने वाले वर्गानुसार [सेगमेंटेशन डेटासेट](https://docs.ultralytics.com/datasets/segment) बनाएं। एपनी में दिए गए आदेश का उपयोग करके।

!!! Example "उदाहरण"

    === "Python"
        ```python
        from ultralytics.data.annotator import auto_annotate

        auto_annotate(data="पथ/सामग्री", det_model="yolov8x.pt", sam_model='sam_b.pt')
        ```

| तत्व       | प्रकार            | विवरण                                                                                                                                      | डिफ़ॉल्ट     |
|------------|-------------------|--------------------------------------------------------------------------------------------------------------------------------------------|--------------|
| डेटा       | str               | अनुमानित मूल छवियाँ जो आंशिक प्रतिसादान के लिए अनुमानित हैं।                                                                               |              |
| det_model  | str, वैकल्पिक     | पूर्व-प्रशिक्षित YOLO डिटेक्शन मॉडल। 'yolov8x.pt' डिफ़ॉल्ट रूप से होता है।                                                                 | 'yolov8x.pt' |
| sam_model  | str, वैकल्पिक     | पूर्व-प्रशिक्षित SAM सेगमेंटेशन मॉडल। डिफ़ॉल्ट रूप से 'sam_b.pt' है।                                                                       | 'sam_b.pt'   |
| device     | str, वैकल्पिक     | मॉडल को चलाने के लिए डिवाइस। डिफ़ॉल्ट रूप से एक खाली स्ट्रिंग होता है (सीपीयू या जीपीयू, यदि उपलब्ध है)।                                   |              |
| output_dir | str, कोई वैकल्पिक | टिपण्णीत परिणाम सहेजने के लिए निर्देशिका। इसे 'डेटा' के समान डिरेक्टरी में "निर्देशिकाएं" निर्दिष्ट करने के लिए डिफ़ॉल्ट मान नहीं होता है। | कोई          |

`ऑटो_तिपण्णी` फ़ंक्शन आपकी छवियों के लिए यातायात का कार्यक्रम देखती है और सेगमेंटेशन सेट को आपके छवि के पथ सेट करती है, वैकल्पिक तत्वों के लिए पूर्व-प्रशिक्षित डिटेक्शन और SAM सेगमेंटेशन मॉडल, मॉडल को चलाने के लिए डिवाइस और टिपण्णीत परिणाम सहेजने के लिए निर्देशिका जैसे, इन कार्यक्रम तत्वों का उपयोग करते हुए।

पूर्व-प्रशिक्षित मॉडल के साथ स्वत: टिपण्णीकरण छवि एनोटेशन एक बड़े पैमाने पर सेगमेंटेशन डेटासेट बनाने के लिए प्रायोगिक और ऊर्जावान उपकारण है। यह सुविधा विशेष रूप से उस समय सुरेखितह रेखांकीकरण के लिए समय-शीघ्रता द्वारा तय कार्यों के साथ, उच्च गुणवत्ता वाले सेगमेंटेशन डेटासेट बनाने के लिए अधिक जरूरी होता है। इस सुविधा का उद्देश्यसिद्ध उपयोगकर्ताओं और डेवलपर्स के लिए विद्यमान छवि संग्रहों के साथ जटिल सूक्ष्म मॉडल विकास और मान्यानुयोग का महत्वपूर्ण विकल्प प्रदान करती है।

## प्रशंसा और आभार

यदि आप अपने शोध या विकास के लिए SAM का उपयोगकर्ता करते हैं, तो कृपया हमारे पेपर को उदाहरणित करने को विचार करें:

!!! Quote ""

    === "BibTeX"

        ```bibtex
        @misc{kirillov2023segment,
              title={Segment Anything},
              author={Alexander Kirillov and Eric Mintun and Nikhila Ravi and Hanzi Mao and Chloe Rolland and Laura Gustafson and Tete Xiao and Spencer Whitehead and Alexander C. Berg and Wan-Yen Lo and Piotr Dollár and Ross Girshick},
              year={2023},
              eprint={2304.02643},
              archivePrefix={arXiv},
              primaryClass={cs.CV}
        }
        ```

हम कंप्यूटर विज्ञान समुदाय के लिए इस मूल्यवान संसाधन को निर्मित और बनाए रखने के लिए तारीफ करना चाहेंगे।

*संकेत: Segment Anything, Segment Anything Model, समुद्री, Meta SAM, छवि सेगमेंटेशन, promptable सेगमेंटेशन, zero-shot प्रदर्शन, SA-1B डेटा सेट, उन्नत आर्किटेक्चर, स्वत: टिपण्णीकरण, Ultralytics, पूर्व-प्रशिक्षित मॉडलें, SAM बेस, SAM-लार्ज, इंस्टेंस सेगमेंटेशन, कंप्यूटर विज्ञान, AI, artificial intelligence, machine learning, data annotation, segmentation masks, डिटेक्शन मॉडल, YOLO डिटेक्शन मॉडल, bibtex, Meta AI.
