---
comments: true
description: Découvrez les tâches fondamentales de vision par ordinateur que YOLOv8 peut effectuer, y compris la détection, la segmentation, la classification et l'estimation de la pose. Comprenez leur utilité dans vos projets d'IA.
keywords: Ultralytics, YOLOv8, Détection, Segmentation, Classification, Estimation de la Pose, Cadre IA, Tâches de Vision par Ordinateur
---

# Tâches d'Ultralytics YOLOv8

<br>
<img width="1024" src="https://raw.githubusercontent.com/ultralytics/assets/main/im/banner-tasks.png" alt="Tâches prises en charge par Ultralytics YOLO">

YOLOv8 est un cadre d'intelligence artificielle qui prend en charge de multiples tâches de **vision par ordinateur**. Le cadre peut être utilisé pour effectuer de la [détection](detect.md), de la [segmentation](segment.md), de la [classification](classify.md) et de l'estimation de la [pose](pose.md). Chacune de ces tâches a un objectif et un cas d'utilisation différents.

!!! Note "Note"

    🚧 Notre documentation multilingue est actuellement en construction et nous travaillons dur pour l'améliorer. Merci de votre patience ! 🙏

<p align="center">
  <br>
  <iframe width="720" height="405" src="https://www.youtube.com/embed/NAs-cfq9BDw"
    title="Lecteur vidéo YouTube" frameborder="0"
    allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture; web-share"
    allowfullscreen>
  </iframe>
  <br>
  <strong>Regardez :</strong> Explorez les Tâches YOLO Ultralytics : Détection d'Objets, Segmentation, Suivi et Estimation de la Pose.
</p>

## [Détection](detect.md)

La détection est la tâche principale prise en charge par YOLOv8. Elle implique de détecter des objets dans une image ou une trame vidéo et de dessiner des boîtes englobantes autour d'eux. Les objets détectés sont classés dans différentes catégories en fonction de leurs caractéristiques. YOLOv8 peut détecter plusieurs objets dans une seule image ou trame vidéo avec une grande précision et rapidité.

[Exemples de Détection](detect.md){ .md-button .md-button--primary}

## [Segmentation](segment.md)

La segmentation est une tâche qui implique de segmenter une image en différentes régions en fonction du contenu de l'image. Chaque région se voit attribuer une étiquette en fonction de son contenu. Cette tâche est utile dans des applications telles que la segmentation d'image et l'imagerie médicale. YOLOv8 utilise une variante de l'architecture U-Net pour effectuer la segmentation.

[Exemples de Segmentation](segment.md){ .md-button .md-button--primary}

## [Classification](classify.md)

La classification est une tâche qui implique de classer une image dans différentes catégories. YOLOv8 peut être utilisé pour classifier des images en fonction de leur contenu. Il utilise une variante de l'architecture EfficientNet pour effectuer la classification.

[Exemples de Classification](classify.md){ .md-button .md-button--primary}

## [Pose](pose.md)

La détection de pose/points clés est une tâche qui implique de détecter des points spécifiques dans une image ou une trame vidéo. Ces points sont appelés points clés et sont utilisés pour suivre le mouvement ou pour l'estimation de la pose. YOLOv8 peut détecter des points clés dans une image ou une trame vidéo avec une grande précision et rapidité.

[Exemples de Pose](pose.md){ .md-button .md-button--primary}

## Conclusion

YOLOv8 prend en charge de multiples tâches, y compris la détection, la segmentation, la classification et la détection de points clés. Chacune de ces tâches a des objectifs et des cas d'utilisation différents. En comprenant les différences entre ces tâches, vous pouvez choisir la tâche appropriée pour votre application de vision par ordinateur.
