---
comments: true
description: Entdecken Sie einen vollständigen Leitfaden zu Ultralytics YOLOv8, einem schnellen und präzisen Modell zur Objekterkennung und Bildsegmentierung. Installations-, Vorhersage-, Trainingstutorials und mehr.
keywords: Ultralytics, YOLOv8, Objekterkennung, Bildsegmentierung, maschinelles Lernen, Deep Learning, Computer Vision, YOLOv8 Installation, YOLOv8 Vorhersage, YOLOv8 Training, YOLO-Geschichte, YOLO-Lizenzen
---

<div align="center">
  <p>
    <a href="https://yolovision.ultralytics.com" target="_blank">
    <img width="1024" src="https://raw.githubusercontent.com/ultralytics/assets/main/yolov8/banner-yolov8.png" alt="Ultralytics YOLO Banner"></a>
  </p>
  <a href="https://github.com/ultralytics"><img src="https://github.com/ultralytics/assets/raw/main/social/logo-social-github.png" width="3%" alt="Ultralytics GitHub"></a>
  <img src="https://github.com/ultralytics/assets/raw/main/social/logo-transparent.png" width="3%">
  <a href="https://www.linkedin.com/company/ultralytics/"><img src="https://github.com/ultralytics/assets/raw/main/social/logo-social-linkedin.png" width="3%" alt="Ultralytics LinkedIn"></a>
  <img src="https://github.com/ultralytics/assets/raw/main/social/logo-transparent.png" width="3%">
  <a href="https://twitter.com/ultralytics"><img src="https://github.com/ultralytics/assets/raw/main/social/logo-social-twitter.png" width="3%" alt="Ultralytics Twitter"></a>
  <img src="https://github.com/ultralytics/assets/raw/main/social/logo-transparent.png" width="3%">
  <a href="https://youtube.com/ultralytics"><img src="https://github.com/ultralytics/assets/raw/main/social/logo-social-youtube.png" width="3%" alt="Ultralytics YouTube"></a>
  <img src="https://github.com/ultralytics/assets/raw/main/social/logo-transparent.png" width="3%">
  <a href="https://www.tiktok.com/@ultralytics"><img src="https://github.com/ultralytics/assets/raw/main/social/logo-social-tiktok.png" width="3%" alt="Ultralytics TikTok"></a>
  <img src="https://github.com/ultralytics/assets/raw/main/social/logo-transparent.png" width="3%">
  <a href="https://www.instagram.com/ultralytics/"><img src="https://github.com/ultralytics/assets/raw/main/social/logo-social-instagram.png" width="3%" alt="Ultralytics Instagram"></a>
  <img src="https://github.com/ultralytics/assets/raw/main/social/logo-transparent.png" width="3%">
  <a href="https://ultralytics.com/discord"><img src="https://github.com/ultralytics/assets/raw/main/social/logo-social-discord.png" width="3%" alt="Ultralytics Discord"></a>
  <br>
  <br>
  <a href="https://github.com/ultralytics/ultralytics/actions/workflows/ci.yaml"><img src="https://github.com/ultralytics/ultralytics/actions/workflows/ci.yaml/badge.svg" alt="Ultralytics CI"></a>
  <a href="https://codecov.io/github/ultralytics/ultralytics"><img src="https://codecov.io/github/ultralytics/ultralytics/branch/main/graph/badge.svg?token=HHW7IIVFVY" alt="Ultralytics Code Coverage"></a>
  <a href="https://zenodo.org/badge/latestdoi/264818686"><img src="https://zenodo.org/badge/264818686.svg" alt="YOLOv8 Zitation"></a>
  <a href="https://hub.docker.com/r/ultralytics/ultralytics"><img src="https://img.shields.io/docker/pulls/ultralytics/ultralytics?logo=docker" alt="Docker Ziehungen"></a>
  <br>
  <a href="https://console.paperspace.com/github/ultralytics/ultralytics"><img src="https://assets.paperspace.io/img/gradient-badge.svg" alt="Auf Gradient ausführen"/></a>
  <a href="https://colab.research.google.com/github/ultralytics/ultralytics/blob/main/examples/tutorial.ipynb"><img src="https://colab.research.google.com/assets/colab-badge.svg" alt="In Colab öffnen"></a>
  <a href="https://www.kaggle.com/ultralytics/yolov8"><img src="https://kaggle.com/static/images/open-in-kaggle.svg" alt="In Kaggle öffnen"></a>
</div>

Wir stellen [Ultralytics](https://ultralytics.com) [YOLOv8](https://github.com/ultralytics/ultralytics) vor, die neueste Version des renommierten Echtzeit-Modells zur Objekterkennung und Bildsegmentierung. YOLOv8 basiert auf den neuesten Erkenntnissen im Bereich Deep Learning und Computer Vision und bietet eine unvergleichliche Leistung hinsichtlich Geschwindigkeit und Genauigkeit. Sein optimiertes Design macht es für verschiedene Anwendungen geeignet und leicht an verschiedene Hardwareplattformen anpassbar, von Edge-Geräten bis hin zu Cloud-APIs.

Erkunden Sie die YOLOv8-Dokumentation, eine umfassende Ressource, die Ihnen helfen soll, seine Funktionen und Fähigkeiten zu verstehen und zu nutzen. Ob Sie ein erfahrener Machine-Learning-Praktiker sind oder neu in diesem Bereich, dieses Hub zielt darauf ab, das Potenzial von YOLOv8 in Ihren Projekten zu maximieren

!!! Note "Hinweis"

    🚧 Unsere mehrsprachige Dokumentation wird derzeit entwickelt und wir arbeiten intensiv an ihrer Verbesserung. Wir danken für Ihre Geduld! 🙏

## Wo Sie beginnen sollten

- **Installieren** Sie `ultralytics` mit pip und starten Sie in wenigen Minuten &nbsp; [:material-clock-fast: Loslegen](quickstart.md){ .md-button }
- **Vorhersagen** Sie neue Bilder und Videos mit YOLOv8 &nbsp; [:octicons-image-16: Auf Bilder vorhersagen](modes/predict.md){ .md-button }
- **Trainieren** Sie ein neues YOLOv8-Modell mit Ihrem eigenen benutzerdefinierten Datensatz &nbsp; [:fontawesome-solid-brain: Ein Modell trainieren](modes/train.md){ .md-button }
- **Erforschen** Sie YOLOv8-Aufgaben wie Segmentieren, Klassifizieren, Posenschätzung und Verfolgen &nbsp; [:material-magnify-expand: Aufgaben erkunden](tasks/index.md){ .md-button }

<p align="center">
  <br>
  <iframe width="720" height="405" src="https://www.youtube.com/embed/LNwODJXcvt4?si=7n1UvGRLSd9p5wKs"
    title="YouTube-Video-Player" frameborder="0"
    allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture; web-share"
    allowfullscreen>
  </iframe>
  <br>
  <strong>Ansehen:</strong> Wie Sie ein YOLOv8-Modell auf Ihrem eigenen Datensatz in <a href="https://colab.research.google.com/github/ultralytics/ultralytics/blob/main/examples/tutorial.ipynb" target="_blank">Google Colab</a> trainieren.
</p>

## YOLO: Eine kurze Geschichte

[YOLO](https://arxiv.org/abs/1506.02640) (You Only Look Once), ein beliebtes Modell zur Objekterkennung und Bildsegmentierung, wurde von Joseph Redmon und Ali Farhadi an der Universität von Washington entwickelt. Seit seiner Einführung im Jahr 2015 erfreut es sich aufgrund seiner hohen Geschwindigkeit und Genauigkeit großer Beliebtheit.

- [YOLOv2](https://arxiv.org/abs/1612.08242), veröffentlicht im Jahr 2016, verbesserte das Originalmodell durch die Einführung von Batch-Normalisierung, Ankerkästen und Dimensionsclustern.
- [YOLOv3](https://pjreddie.com/media/files/papers/YOLOv3.pdf), eingeführt im Jahr 2018, erhöhte die Leistung des Modells weiter mit einem effizienteren Backbone-Netzwerk, mehreren Ankern und räumlichem Pyramid-Pooling.
- [YOLOv4](https://arxiv.org/abs/2004.10934) wurde 2020 veröffentlicht und brachte Neuerungen wie Mosaic-Datenerweiterung, einen neuen ankerfreien Erkennungskopf und eine neue Verlustfunktion.
- [YOLOv5](https://github.com/ultralytics/yolov5) verbesserte die Leistung des Modells weiter und führte neue Funktionen ein, wie Hyperparameter-Optimierung, integriertes Experiment-Tracking und automatischen Export in beliebte Exportformate.
- [YOLOv6](https://github.com/meituan/YOLOv6) wurde 2022 von [Meituan](https://about.meituan.com/) als Open Source zur Verfügung gestellt und wird in vielen autonomen Lieferrobotern des Unternehmens eingesetzt.
- [YOLOv7](https://github.com/WongKinYiu/yolov7) führte zusätzliche Aufgaben ein, wie Posenschätzung auf dem COCO-Keypoints-Datensatz.
- [YOLOv8](https://github.com/ultralytics/ultralytics) ist die neueste Version von YOLO von Ultralytics. Als Spitzenmodell der neuesten Generation baut YOLOv8 auf dem Erfolg vorheriger Versionen auf und führt neue Funktionen und Verbesserungen für erhöhte Leistung, Flexibilität und Effizienz ein. YOLOv8 unterstützt eine vollständige Palette an Vision-KI-Aufgaben, einschließlich [Erkennung](tasks/detect.md), [Segmentierung](tasks/segment.md), [Posenschätzung](tasks/pose.md), [Verfolgung](modes/track.md) und [Klassifizierung](tasks/classify.md). Diese Vielseitigkeit ermöglicht es Benutzern, die Fähigkeiten von YOLOv8 in verschiedenen Anwendungen und Domänen zu nutzen.

## YOLO-Lizenzen: Wie wird Ultralytics YOLO lizenziert?

Ultralytics bietet zwei Lizenzoptionen, um unterschiedliche Einsatzszenarien zu berücksichtigen:

- **AGPL-3.0-Lizenz**: Diese [OSI-geprüfte](https://opensource.org/licenses/) Open-Source-Lizenz ist ideal für Studenten und Enthusiasten und fördert offene Zusammenarbeit und Wissensaustausch. Weitere Details finden Sie in der [LIZENZ](https://github.com/ultralytics/ultralytics/blob/main/LICENSE)-Datei.
- **Enterprise-Lizenz**: Für die kommerzielle Nutzung konzipiert, ermöglicht diese Lizenz die problemlose Integration von Ultralytics-Software und KI-Modellen in kommerzielle Produkte und Dienstleistungen und umgeht die Open-Source-Anforderungen der AGPL-3.0. Wenn Ihr Szenario die Einbettung unserer Lösungen in ein kommerzielles Angebot beinhaltet, kontaktieren Sie uns über [Ultralytics-Lizenzierung](https://ultralytics.com/license).

Unsere Lizenzstrategie ist darauf ausgerichtet sicherzustellen, dass jegliche Verbesserungen an unseren Open-Source-Projekten der Gemeinschaft zurückgegeben werden. Wir halten die Prinzipien von Open Source in Ehren ❤️ und es ist unser Anliegen, dass unsere Beiträge auf Weisen genutzt und erweitert werden können, die für alle vorteilhaft sind.
