---
comments: true
description: استكشف النموذج القاطع للشيء أيا كان (SAM) الحديث من Ultralytics الذي يتيح الت segment تشفير صور الوقت الحقيقي. تعرف على مرونته في مجال الت segment، وأداء نقل انيفورم زيرو شوت، وكيفية استخدامه.
keywords: Ultralytics, قسيمة الصور, Segment Anything Model, SAM, سلسلة بيانات SA-1B, مرونة الصور في الوقت الحقيقي, نقل الانيفورم زيرو شوت, الكشف عن الكائنات, تحليل الصور, التعلم الآلي
---

# نموذج القطعة شيء ما (SAM)

مرحبًا بك في الجبهة الأولى لقطع الصور مع نموذج القطعة شيء ما ، أو SAM. هذا النموذج الثوري قد غير اللعبة من خلال إدخال التشفير القراءة للصور مع أداء في الوقت الحقيقي، وتحديد معايير جديدة في هذا المجال.

## مقدمة إلى SAM: القطعة شيء ما نموذج

نموذج القطعة شيء ما ، أو SAM، هو نموذج شفاف اول في فصل الصور الرقمية التي تتيح قدرة شهير على التشفير، توفر مرونة فريدة من نوعها في مهام التحليل اللازمة للصور. نموذج SAM هو أساس مشروع 'أي شيء في شيء' الابتكاري و هو مشروع يقدم نموذجا جديدا ، مهمة وسلسلة بيانات مبتكرة للفصل البصري.

يتيح تصميم SAM المتقدم له التكيف مع توزيعات صور جديدة ومهام جديدة دون الحاجة إلى معرفة مسبقة، وهذه الميزة تعرف بالكفاءة المطلوبة. حيث يتم تدريبه على سلسلة البيانات الواسعة [سلسلة  SA-1B](https://ai.facebook.com/datasets/segment-anything/)، التي تحتوي على أكثر من ملياري قناع معروض على 11 مليون صورة تمت المحافظة عليها بعناية، وقد عرض SAM أداء مثير للإعجاب مع نقل انيفورم زيرو شوت فاق النتائج المراقبة السابقة بالتدريب الكامل في العديد من الحالات.

![صورة مثالية لسلسة البيانات](https://user-images.githubusercontent.com/26833433/238056229-0e8ffbeb-f81a-477e-a490-aff3d82fd8ce.jpg)
صور مثالية مع قناع محاط بها من سلسلة البيانات التي قدمناها حديثًا ، SA-1B. يحتوي سلسلة SA-1B على 11 مليون صورة متنوعة ، عالية الدقة ، مرخصة وتحمي الخصوصية و 1.1 مليار قناع فصل جودة عالية. تم توجيه هذه القناع تمامًا بتقويم آلي من قبل SAM وتم التحقق من جودتها وتنوعها من خلال تصنيفات بشرية وتجارب عديدة. يتم تجميع الصور حسب عدد الأقنعة في كل صورة للتصوير (هناك حوالي 100 قناع في الصورة في المتوسط).

## السمات الرئيسية لنموذج القطعة شيء ما (SAM)

- **مهمة التشفير القضائية:** تم تصميم SAM بهدف مهمة التشفير القابلة للتشفير ، مما يتيح له إنشاء قناع تشفير صالح من أي تلميح معين ، مثل الدلائل المكانية أو النصية التي تحدد الكائن.
- **بنية متقدمة:** يستخدم نموذج القطعة شيء ما مُشفر صورة قوي ، مشفر تشفير ومُشفر بسهولة الويغورة. تمكن هذه البنية الفريدة من فتح المجال للتشفير المرن ، وحساب القناع في الوقت الحقيقي ، والاستعداد للغموض في مهام التشفير.
- **سلسلة البيانات SA-1B:** التي قدمها مشروع أي شيء في شيء، تعرض سلسلة البيانات SA-1B أكثر من ملياري قناع على 11 مليون صورة. كأكبر سلسلة بيانات للفصل حتى الآن، توفر نموذج SAM مصدر تدريب ضخم ومتنوع.
- **أداء نقل الانيفورم زيرو شوت:** يعرض نموذج SAM أداء رائع في نقل الانيفورم زيرو شوت في مهام القطع المختلفة، مما يجعله أداة قوية جاهزة للاستخدام في تطبيقات متنوعة مع حاجة قليلة جدًا لهندسة التشفير الخاصة.

للحصول على نظرة شاملة على نموذج القطعة شيء ما وسلسلة SA-1B، يرجى زيارة [موقع أي شيء في شيء](https://segment-anything.com) واطلع على بحث [أي شيء في شيء](https://arxiv.org/abs/2304.02643).

## النماذج المتاحة والمهام المدعومة ووضعيات العمل

تقدم هذه الجدول النماذج المتاحة مع أوزان محددة مسبقًا والمهام التي يدعمونها وتوافقهم مع وضعيات العمل المختلفة مثل [قراءة الصورة](../modes/predict.md)، [التحقق](../modes/val.md)، [التدريب](../modes/train.md)، و [التصدير](../modes/export.md) ، مما يشير إلى ✅ رموز الدعم و ❌ للوضعيات غير المدعومة.

| نوع النموذج | الأوزان المدربة مسبقًا | المهام المدعومة                    | قراءة الصورة | التحقق | التدريب | التصدير |
|-------------|------------------------|------------------------------------|--------------|--------|---------|---------|
| SAM الأساسي | `sam_b.pt`             | [تجزئة النسخ](../tasks/segment.md) | ✅            | ❌      | ❌       | ✅       |
| SAM الكبير  | `sam_l.pt`             | [تجزئة النسخ](../tasks/segment.md) | ✅            | ❌      | ❌       | ✅       |

## كيفية استخدام SAM: مرونة وقوة في تجزئة الصورة

يمكن استخدام نموذج القطعة شيء من أجل العديد من المهام التابعة إلى تدريبه. يشمل ذلك الكشف عن الحافة، إنشاء ترشيح للكائنات، تجزئة نسخة وتوقع نص مبدئي للتشفير. مع التشفير المهني ، يمكن لـ SAM التكيف بسرعة مع المهمات وتوزيعات البيانات الجديدة بطريقة transfer zero-shot، وبالتالي يعتبر أداة متعددة الاستخدامات وفعالة لجميع احتياجات تجزئة الصورة.

### مثال لدمج SAM

!!! Example "القسم بالاشارات"

    تقسيم الصورة مع الإشارات المعطاة.

    === "البايثون"

        ```python
        from ultralytics import SAM

        # تحميل النموذج
        model = SAM('sam_b.pt')

        # عرض معلومات النموذج (اختياري)
        model.info()

        # تشغيل التنبوء بواسطة الدلائل
        model('ultralytics/assets/zidane.jpg', bboxes=[439, 437, 524, 709])

        # تشغيل التنبوء بواسطة نقاط الإشارة
        model('ultralytics/assets/zidane.jpg', points=[900, 370], labels=[1])
        ```

!!! Example "قطع كل الشيء"

    قم بتجزئة الصورة بأكملها.

    === "البايثون"

        ```python
        from ultralytics import SAM

        # تحميل النموذج
        model = SAM('sam_b.pt')

        # عرض معلومات النموذج (اختياري)
        model.info()

        # تشغيل التنبوء
        model('مسار/إلى/صورة.jpg')
        ```

    === "صفيحة"

        ```البايش
        # تشغيل التنبوء بنموذج SAM
        yolo predict model=sam_b.pt source=path/to/image.jpg
        ```

- المنطق هنا هو تجزئة الصورة كلها إذا لم تمر عبر أي إشارات (bboxes/ points / masks).

!!! Example "مثال على SAMPredictor"

    بواسطة هذا الطريق ، يمكنك تعيين الصورة مرة واحدة وتشغيل الإشارات مرارًا وتكرارًا دون تشغيل مشفر الصورة مرة أخرى.

    === "التنبؤ بالإشارة"

        ```البايثون
        from ultralytics.models.sam import Predictor as SAMPredictor

        # إنشاء SAMPredictor
        الأعلى = dict (الثقة = 0.25، task ='segment'، النمط = 'تنبؤ'، imgsz = 1024، نموذج = "mobile_sam.pt")
        predictor = SAMPredictor (overrides = التجاوز الأعلى)

        # تعيين الصورة
        predictor.set_image("ultralytics/assets/zidane.jpg")  # تعيين بواسطة ملف صورة
        predictor.set_image(cv2.imread("ultralytics/assets/zidane.jpg"))  # تعيين مع np.ndarray
        results = predictor(bboxes=[439, 437, 524, 709])
        results = predictor(points=[900, 370], labels=[1])

        # إعادة تعيين الصورة
        predictor.reset_image()
        ```

    قطع كل شيء مع وجود معطيات اختيارية.

    === "تقطيع كل شيء"

        ```البايثون
        from ultralytics.models.sam import Predictor as SAMPredictor

        # إنشاء SAMPredictor
        الأعلى = dict (الثقة = 0.25، task ='segment'، النمط = 'تنبؤ'، imgsz = 1024، نموذج = "mobile_sam.pt")
        predictor = SAMPredictor (overrides = التجاوز الأعلى)

        # تجزئة مع بيانات إضافية
        results = predictor(source="ultralytics/assets/zidane.jpg"، crop_n_layers=1، points_stride=64)
        ```

- المزيد args إضافي للتقطيع كل شيء شاهد التوثيق مرجع [`السلبي/تقديم` مرجع](../../reference/models/sam/predict.md).

## مقارنة SAM مقابل YOLOv8

في هذا المكان نقارن نموذج SAM الأصغر سام، SAM-b ، مع نموذج التجزئة YOLOv8 الصغيرة Ultralytics، [YOLOv8n-seg](../tasks/segment.md):

| النموذج                                      | الحجم                      | المعلمات              | السرعة (المعالج)         |
|----------------------------------------------|----------------------------|-----------------------|--------------------------|
| سام SAM-b                                    | 358 م.بايت                 | 94.7 M                | 51096 ms/im              |
| [MobileSAM](mobile-sam.md)                   | 40.7 MB                    | 10.1 M                | 46122 ms/im              |
| [FastSAM-s](fast-sam.md) with YOLOv8 حافظة   | 23.7 MB                    | 11.8 M                | 115 ms/im                |
| [YOLOv8n-seg](../tasks/segment.md) ل Ultraly | **6.7 MB** (53.4 مرة أصغر) | **3.4 M** (27.9x أقل) | **59 ms/im** (866x أسرع) |

هذه المقارنة تظهر الاختلافات في أمر المقدار والسرعة بين النماذج. في حين يقدم SAM قدرات فريدة للتجزئة التلقائية ، إلا أنه ليس منافسًا مباشرًا لنماذج التجزئة YOLOv8 ، حيث تكون أصغر وأسرع وأكثر كفاءة.

اكتنزات التجريب على ماكينة Apple M2 Macbook 2023 مع 16GB من الذاكرة. لإعادة إنتاج هذا الاختبار:

!!! Example "مثال"

    === "البايثون"
        ```البايثون
        from ultralytics import FastSAM, SAM, YOLO

        # تحليل يام-b
        model = SAM('sam_b.pt')
        model.info()
        model('ultralytics/assets')

        # تحليل MobileSAM
        model = SAM('mobile_sam.pt')
        model.info()
        model('ultralytics/assets')

        # تحليل FastSAM-s
        model = FastSAM('FastSAM-s.pt')
        model.info()
        model('ultralytics/assets')

        # تحليل YOLOv8n-seg
        model = YOLO('yolov8n-seg.pt')
        model.info()
        model('ultralytics/assets')
        ```

## تعلم تلقائي: مسار سريع إلى سلاسل البيانات الخاصة بالتجزئة

التعلم التلقائي هو ميزة رئيسية لـ SAM، حيث يسمح للمستخدمين بإنشاء [سلاسل بيانات تجزئة](https://docs.ultralytics.com/datasets/segment) باستخدام نموذج الكشف الجاهز. يتيح هذا الميزة إنشاء وتحديث سريع ودقيق لعدد كبير من الصور بدون الحاجة إلى عملية التسمية اليدوية البطيئة.

### إنشاء سلاسل البيانات الخاصة بالتجزئة باستخدام نموذج الكشف

للتعليم التلقائي لسلاسل البيانات الخاصة بالتجزئة باستخدام إطار العمل Ultralytics ، استخدم وظيفة 'auto_annotate' كما هو موضح أدناه:

!!! Example "مثال"

    === "البايثون"
        ```البايثون
        from ultralytics.data.annotator import auto_annotate

        auto_annotate(data="مسار/إلى/صور", det_model="yolov8x.pt", sam_model='sam_b.pt')
        ```

| الوسيطة    | النوع                  | الوصف                                                                                                                     | الافتراضي    |
|------------|------------------------|---------------------------------------------------------------------------------------------------------------------------|--------------|
| البيانات   | سلسلة                  | المسار إلى المجلد الذي يحتوي على الصور التي سيتم الإشارة إليها.                                                           |              |
| det_model  | سلسلة، اختياري         | نموذج الكشف المدرب المسبق لـ YOLO. الافتراضي هو 'yolov8x.pt'.                                                             | 'yolov8x.pt' |
| sam_model  | سلسلة، اختياري         | نموذج القطعة أيا شيء من Ultralytics. الافتراضي هو 'sam_b.pt'.                                                             | 'sam_b.pt'   |
| device     | سلسلة، اختياري         | الجهاز الذي يتم تشغيل النماذج عليه. الافتراضي هو سلسلة فارغة (وحدة المعالجة المركزية أو وحدة معالجة الرسومات إذا توافرت). |              |
| output_dir | سلسلة، لا شيء، اختياري | الدليل لحفظ النتائج المرئية. الافتراضي هو مجلد 'التسميات' في نفس دليل 'البيانات'.                                         | لا شيء       |

يأخذ تابع 'auto_annotate' المسار إلى الصور الخاصة بك مع وسيطات اختيارية لتحديد نموذج الكشف المدرب مسبقًا ونموذج التجزئة SAM والجهاز الذي سيتم تشغيل النماذج به والدليل الخروج لحفظ النتائج المرئية.

تعلم تلقائيًا باستخدام نماذج مدربة مسبقًا يمكن أن يقلل بشكل كبير من الوقت والجهد المطلوب لإنشاء سلاسل بيانات تجزئة عالية الجودة. يكون هذا الأمر مفيدًا خصوصًا للباحثين والمطورين الذين يتعاملون مع مجموعات صور كبيرة ، حيث يتيح لهم التركيز على تطوير النماذج وتقييمها بدلاً من التسمية اليدوية البطيئة.

## الاقتباسات والتقديرات

إذا وجدت SAM مفيدًا في البحث أو العمل التطويري الخاص بك ، يرجى النظر في استشهاد بحثنا:

!!! Quote ""

    === "البيبتيكس"
        ```البيبتيكس
        @misc{kirillov2023segment,
              title={Segment Anything},
              author={Alexander Kirillov and Eric Mintun and Nikhila Ravi and Hanzi Mao and Chloe Rolland and Laura Gustafson and Tete Xiao and Spencer Whitehead and Alexander C. Berg and Wan-Yen Lo and Piotr Dollár and Ross Girshick},
              year={2023},
              eprint={2304.02643},
              archivePrefix={arXiv},
              primaryClass={cs.CV}
        }
        ```

نود أن نعبر عن امتناننا لـ Meta AI لإنشاء وصيانة هذا المورد القيم لمجتمع البصريات الحواسيبية.

*أكلمات دالة: سلسلة المفعولة, نموذج القطعة شيء ما, SAM, Meta SAM, التجزئة, التشفير المميز, آلة آي, segment, Ultralytics, نماذج مدربة مسبقا, SAM الاساسي, SAM الكبير, تجزئة الكيانات, الرؤية الكمبيوترية, آي الاصطناعية, التعلم الآلي, تسمية بيانات, قناع التجزئة, نموذج الكشف, نموذج الكشف YOLO, البيبتكس, Meta AI.*
