---
comments: true
description: اكتشف ميزات وفوائد RT-DETR من Baidu، وهو كاشف كائنات فعال وقابل للتكيف في الوقت الفعلي يعتمد على Vision Transformers، بما في ذلك النماذج المدربة مسبقًا.
keywords: RT-DETR, Baidu, Vision Transformers, كشف كائنات, أداء فوري, CUDA, TensorRT, اختيار الاستعلام المرتبط بـ IoU, Ultralytics, واجهة برمجة التطبيقات الخاصة بلغة Python, PaddlePaddle
---

# RT-DETR من Baidu: اكتشاف كائنات في الوقت الفعلي يعتمد على Vision Transformer

## النظرة العامة

Real-Time Detection Transformer (RT-DETR)، المطور من قبل Baidu، هو كاشف حديث الطراز يوفر أداءً فعليًا في الوقت الفعلي مع الحفاظ على دقة عالية. يستفيد من قوة Vision Transformers (ViT) في معالجة الميزات متعددة المقياس عن طريق فصل التفاعلات داخل المقياس ودمج التفاعلات بين المقاييس المختلفة. يتكيف RT-DETR بشكل كبير ويدعم ضبط سرعة الاستعلام باستخدام طبقات مختلفة في المفكرة بدون إعادة التدريب. يتفوق هذا النموذج على العديد من كاشفات الكائنات في الوقت الفعلي الأخرى، ويستفيد من المنصات القوية مثل CUDA مع TensorRT.

![نموذج مثال](https://user-images.githubusercontent.com/26833433/238963168-90e8483f-90aa-4eb6-a5e1-0d408b23dd33.png)
**نظرة عامة على RT-DETR من Baidu.** يعرض مخطط معمارية نموذج RT-DETR مراحل الظهر الثلاث الأخيرة {S3، S4، S5} كإدخال للمشفر. يحول المشفر الهجين الفعال الميزات متعددة المقياس إلى تسلسل من ميزات الصورة من خلال تفاعل الميزات داخل المقياس (AIFI) ووحدة دمج الميزات بين المقاييس المختلفة (CCFM). يتم استخدام اختيار الاستعلام المرتبط بـ IoU لاختيار عدد ثابت من ميزات الصورة لتكون استعلامات الكائن الأولية لفك الترميز. أخيرًا، يحسن فك الترميز مع رؤوس التنبؤ الإضافية الاستعلامات الكائنية لتوليد المربعات وتقييمات الثقة ([المصدر](https://arxiv.org/pdf/2304.08069.pdf)).

### الميزات الرئيسية

- **مشفر هجين فعال:** يستخدم RT-DETR من Baidu مشفر هجين فعال يعمل على معالجة الميزات متعددة المقياس من خلال فصل التفاعلات داخل المقياس ودمج التفاعلات بين المقاييس المختلفة. يقلل هذا التصميم الفريد القائم على Vision Transformers من تكاليف الحسابات ويتيح الكشف عن الكائنات في الوقت الفعلي.
- **اختيار الاستعلام المرتبط بـ IoU:** يعمل RT-DETR من Baidu على تحسين بدء استعلام الكائنات من خلال استخدام اختيار الاستعلام المرتبط بـ IoU. يتيح هذا للنموذج التركيز على الكائنات الأكثر صلة في السيناريو، مما يعزز دقة الكشف.
- **سرعة الاستنتاج قابلة للتكيف:** يدعم RT-DETR من Baidu ضبط سرعة الاستنتاج بشكل مرن باستخدام طبقات مختلفة في المفكرة دون الحاجة لإعادة التدريب. يسهل هذا التكيف التطبيق العملي في العديد من سيناريوهات كشف الكائنات في الوقت الفعلي.

## النماذج المدربة مسبقًا

تقدم واجهة برمجة التطبيقات الخاصة بلغة Python في Ultralytics نماذج PaddlePaddle RT-DETR مدربة مسبقًا بمقاييس مختلفة:

- RT-DETR-L: 53.0% AP على COCO val2017، 114 FPS على GPU T4
- RT-DETR-X: 54.8% AP على COCO val2017، 74 FPS على GPU T4

## أمثلة الاستخدام

يوفر هذا المثال أمثلة بسيطة لتدريب واختبار RT-DETRR. للحصول على وثائق كاملة حول هذه الأمثلة وأوضاع أخرى [انقر هنا](../modes/index.md) للاطلاع على صفحات الوثائق [التنبؤ](../modes/predict.md)، [التدريب](../modes/train.md)، [التصحيح](../modes/val.md) و [التصدير](../modes/export.md).

!!! Example "مثال"

    === "Python"

        ```python
        from ultralytics import RTDETR

        # تحميل نموذج RT-DETR-l محمي بواسطة COCO مسبقًا
        model = RTDETR('rtdetr-l.pt')

        # عرض معلومات النموذج (اختياري)
        model.info()

        # تدريب النموذج على مجموعة بيانات المثال COCO8 لـ 100 دورة
        results = model.train(data='coco8.yaml', epochs=100, imgsz=640)

        # تشغيل الاستدلال باستخدام النموذج RT-DETR-l على صورة 'bus.jpg'
        results = model('path/to/bus.jpg')
        ```

    === "CLI"

        ```bash
        # تحميل نموذج RT-DETR-l محمي بواسطة COCO مسبقًا وتدريبه على مجموعة بيانات المثال COCO8 لـ 100 دورة
        yolo train model=rtdetr-l.pt data=coco8.yaml epochs=100 imgsz=640

        # تحميل نموذج RT-DETR-l محمي بواسطة COCO مسبقًا وتشغيل الاستدلال على صورة 'bus.jpg'
        yolo predict model=rtdetr-l.pt source=path/to/bus.jpg
        ```

## المهام والأوضاع المدعومة

يقدم هذا الجدول أنواع النماذج والأوزان المدربة مسبقًا المحددة والمهام المدعومة بواسطة كل نموذج، والأوضاع المختلفة ([التدريب](../modes/train.md)، [التصحيح](../modes/val.md)، [التنبؤ](../modes/predict.md)، [التصدير](../modes/export.md)) التي يتم دعمها، ممثلة برموز الـ ✅.

| نوع النموذج           | الأوزان المدربة مسبقًا | المهام المدعومة                  | استنتاج | تحقق صحة | تدريب | استيراد |
|-----------------------|------------------------|----------------------------------|---------|----------|-------|---------|
| RT-DETR الكبير        | `rtdetr-l.pt`          | [كشف كائنات](../tasks/detect.md) | ✅       | ✅        | ✅     | ✅       |
| RT-DETR الكبير الزائد | `rtdetr-x.pt`          | [كشف كائنات](../tasks/detect.md) | ✅       | ✅        | ✅     | ✅       |

## الاستشهادات والتقديرات

إذا استخدمت RT-DETR من Baidu في أعمال البحث أو التطوير الخاصة بك، يرجى الاستشهاد بـ [الورقة الأصلية](https://arxiv.org/abs/2304.08069):

!!! Quote ""

    === "BibTeX"

        ```bibtex
        @misc{lv2023detrs,
              title={DETRs Beat YOLOs on Real-time Object Detection},
              author={Wenyu Lv and Shangliang Xu and Yian Zhao and Guanzhong Wang and Jinman Wei and Cheng Cui and Yuning Du and Qingqing Dang and Yi Liu},
              year={2023},
              eprint={2304.08069},
              archivePrefix={arXiv},
              primaryClass={cs.CV}
        }
        ```

نحن نود أن نعرب عن امتناننا لـ Baidu وفريق [PaddlePaddle](https://github.com/PaddlePaddle/PaddleDetection) لإنشاء وصيانة هذ المورد القيم لمجتمع الرؤية الحاسوبية. نقدر تفاعلهم مع المجال من خلال تطوير كاشف الكائنات الحقيقي في الوقت الفعلي القائم على Vision Transformers، RT-DETR.

*keywords: RT-DETR، الناقل، Vision Transformers، Baidu RT-DETR، PaddlePaddle، Paddle Paddle RT-DETR، كشف كائنات في الوقت الفعلي، كشف كائنات قائم على Vision Transformers، نماذج PaddlePaddle RT-DETR مدربة مسبقًا، استخدام Baidu's RT-DETR، واجهة برمجة التطبيقات الخاصة بلغة Python في Ultralytics*
