---
comments: true
description: Изучите передовую модель сегментации изображений "Segment Anything Model" (SAM) от компании Ultralytics, которая позволяет выполнять сегментацию изображений в режиме реального времени. Узнайте о возможности дать подсказки модели для выполнения сегментации, о ее возможностях нулевой настройки и о том, как ее использовать.
keywords: Ultralytics, сегментация изображений, "Segment Anything Model", SAM, набор данных SA-1B, работа в режиме реального времени, нулевая настройка, обнаружение объектов, анализ изображений, машинное обучение
---

# Segment Anything Model (SAM)

Добро пожаловать в мир передовой модели сегментации изображений "Segment Anything Model" (SAM). Эта революционная модель установила новые стандарты в области сегментации изображений, предоставляя возможность ввода подсказок для выполнения сегментации в реальном времени.

## Введение в Segment Anything Model (SAM)

Segment Anything Model (SAM) - это передовая модель сегментации изображений, позволяющая осуществлять сегментацию с возможностью задавать подсказки, что обеспечивает уникальную гибкость в задачах анализа изображений. SAM является ключевым элементом инициативы "Segment Anything", которая вводит новую модель, задачу и набор данных для сегментации изображений.

Благодаря своему передовому дизайну, SAM может адаптироваться к новым распределениям изображений и задачам без предварительных знаний, что называется возможностью нулевой настройки. Обученная на обширном наборе данных [SA-1B](https://ai.facebook.com/datasets/segment-anything/), который содержит более 1 миллиарда масок, распределенных на 11 миллионов тщательно отобранных изображений, модель SAM проявила впечатляющую производительность в задачах нулевой настройки, превосходя предыдущие полностью надзираемые результаты во многих случаях.

![Пример изображения из набора данных](https://user-images.githubusercontent.com/26833433/238056229-0e8ffbeb-f81a-477e-a490-aff3d82fd8ce.jpg)
Изображения с наложенными масками из нашего нового набора данных SA-1B. SA-1B содержит 11 млн. разнообразных лицензированных изображений высокого разрешения, сгенерированных полностью автоматически SAM, и 1,1 млрд. высококачественных масок сегментации. Эти маски были аннотированы полностью автоматически SAM, и, как показали человеческие оценки и множество экспериментов, они являются высококачественными и разнообразными. Изображения сгруппированы по количеству масок на изображение для наглядности (в среднем на изображение приходится около 100 масок).

## Основные особенности модели Segment Anything (SAM)

- **Задача предоставления подсказок для сегментации:** SAM была разработана с учетом задачи предоставления подсказок для сегментации, что позволяет ей генерировать корректные маски сегментации на основе любых подсказок, таких как пространственные или текстовые подсказки, идентифицирующие объект.
- **Расширенная архитектура:** Модель Segment Anything использует мощный кодировщик изображений, кодировщик подсказок и легкий декодер масок. Эта уникальная архитектура обеспечивает гибкое использование подсказок, вычисление масок в реальном времени и учет неопределенности в задачах сегментации.
- **Набор данных SA-1B:** Набор данных SA-1B, предложенный проектом Segment Anything, содержит более 1 миллиарда масок на 11 миллионах изображений. Как самый большой набор данных для сегментации на сегодняшний день, он обеспечивает модели SAM разнообразный и масштабный источник данных для обучения.
- **Производительность при нулевой настройке:** Модель SAM проявляет выдающуюся производительность при выполнении задач сегментации в режиме нулевой настройки, что делает ее готовым к использованию инструментом для различных приложений с минимальной необходимостью настраивать подсказки.

Для более подробного рассмотрения модели Segment Anything и набора данных SA-1B, пожалуйста, посетите [веб-сайт Segment Anything](https://segment-anything.com) и ознакомьтесь с исследовательской статьей [Segment Anything](https://arxiv.org/abs/2304.02643).

## Доступные модели, поддерживаемые задачи и режимы работы

В таблице представлены доступные модели с их специфическими заранее обученными весами, поддерживаемыми задачами и их совместимость с различными режимами работы, такими как [Inference](../modes/predict.md), [Validation](../modes/val.md), [Training](../modes/train.md) и [Export](../modes/export.md), обозначенная символами ✅ для поддерживаемых режимов и символами ❌ для неподдерживаемых режимов.

| Тип модели                         | Заранее обученные веса | Поддерживаемые задачи                       | Inference | Validation | Training | Export |
|------------------------------------|------------------------|---------------------------------------------|-----------|------------|----------|--------|
| Базовая версия SAM (SAM base)      | `sam_b.pt`             | [Сегментация объектов](../tasks/segment.md) | ✅         | ❌          | ❌        | ✅      |
| Расширенная версия SAM (SAM large) | `sam_l.pt`             | [Сегментация объектов](../tasks/segment.md) | ✅         | ❌          | ❌        | ✅      |

## Как использовать модель SAM: гибкость и мощность в сегментации изображений

Модель Segment Anything может использоваться для множества задач, выходящих за рамки ее тренировочных данных. Это включает обнаружение границ, генерацию предложений объектов, сегментацию экземпляров и предварительное преобразование текста в маску. С использованием подсказок, SAM может быстро адаптироваться к новым задачам и распределениям данных в режиме нулевой настройки, делая его гибким и мощным инструментом для всех ваших потребностей в сегментации изображений.

### Пример прогнозирования с использованием SAM

!!! Example "Сегментация с указанием подсказки"

    Выполнение сегментации изображения с указанными подсказками.

    === "Python"

        ```python
        from ultralytics import SAM

        # Загрузка модели
        model = SAM('sam_b.pt')

        # Вывод информации о модели (по желанию)
        model.info()

        # Выполнение вывода с указанием границы объекта (bboxes prompt)
        model('ultralytics/assets/zidane.jpg', bboxes=[439, 437, 524, 709])

        # Выполнение вывода с указанием точки (points prompt)
        model('ultralytics/assets/zidane.jpg', points=[900, 370], labels=[1])
        ```

!!! Example "Сегментация всего изображения"

    Сегментация всего изображения.

    === "Python"

        ```python
        from ultralytics import SAM

        # Загрузка модели
        model = SAM('sam_b.pt')

        # Вывод информации о модели (по желанию)
        model.info()

        # Выполнение вывода
        model('путь/к/изображению.jpg')
        ```

    === "CLI"

        ```bash
        # Выполнение вывода с помощью модели SAM
        yolo predict model=sam_b.pt source=путь/к/изображению.jpg
        ```

- Логика здесь состоит в том, чтобы выполнить сегментацию всего изображения, если вы не передаете никаких подсказок (bboxes/points/masks).

!!! Example "Пример SAMPredictor"

    В этом примере вы можете установить изображение один раз и выполнить множество прогнозирований с использованием подсказок, не запуская кодировщик изображения несколько раз.

    === "Прогнозирование с подсказками"

        ```python
        from ultralytics.models.sam import Predictor as SAMPredictor

        # Создание SAMPredictor
        overrides = dict(conf=0.25, task='segment', mode='predict', imgsz=1024, model="mobile_sam.pt")
        predictor = SAMPredictor(overrides=overrides)

        # Установка изображения
        predictor.set_image("ultralytics/assets/zidane.jpg")  # установить с помощью файла изображения
        predictor.set_image(cv2.imread("ultralytics/assets/zidane.jpg"))  # установить с помощью np.ndarray
        results = predictor(bboxes=[439, 437, 524, 709])
        results = predictor(points=[900, 370], labels=[1])

        # Сброс изображения
        predictor.reset_image()
        ```

    Сегментация всего изображения с дополнительными аргументами.

    === "Сегментация всего изображения"

        ```python
        from ultralytics.models.sam import Predictor as SAMPredictor

        # Создание SAMPredictor
        overrides = dict(conf=0.25, task='segment', mode='predict', imgsz=1024, model="mobile_sam.pt")
        predictor = SAMPredictor(overrides=overrides)

        # Сегментация с дополнительными аргументами
        results = predictor(source="ultralytics/assets/zidane.jpg", crop_n_layers=1, points_stride=64)
        ```

- Больше дополнительных аргументов для `Сегментации всего изображения` см. [Ссылка на`Predictor/generate`](../../reference/models/sam/predict.md).

## Сравнение SAM и YOLOv8

Здесь мы сравниваем самую маленькую модель SAM, SAM-b, с самой маленькой моделью сегментации Ultralytics, [YOLOv8n-seg](../tasks/segment.md):

| Модель                                         | Размер                         | Параметры                        | Скорость (CPU)                            |
|------------------------------------------------|--------------------------------|----------------------------------|-------------------------------------------|
| SAM-b                                          | 358 МБ                         | 94.7 млн.                        | 51096 мс/изображение                      |
| [MobileSAM](mobile-sam.md)                     | 40.7 МБ                        | 10.1 млн.                        | 46122 мс/изображение                      |
| [FastSAM-s](fast-sam.md) с основой YOLOv8      | 23.7 МБ                        | 11.8 млн.                        | 115 мс/изображение                        |
| Ultralytics [YOLOv8n-seg](../tasks/segment.md) | **6.7 МБ** (в 53.4 раз меньше) | **3.4 млн.** (в 27.9 раз меньше) | **59 мс/изображение** (в 866 раз быстрее) |

Это сравнение показывает разницу в порядке величины между моделями по их размерам и скорости. В то время как SAM предлагает уникальные возможности автоматической сегментации, он не является прямым конкурентом моделям сегментации YOLOv8, которые являются более маленькими, быстрее и эффективнее.

Тесты проводились на ноутбуке Apple M2 с 16 ГБ оперативной памяти 2023 года. Чтобы воспроизвести этот тест:

!!! Example "Пример"

    === "Python"
        ```python
        from ultralytics import FastSAM, SAM, YOLO

        # Анализ SAM-b
        model = SAM('sam_b.pt')
        model.info()
        model('ultralytics/assets')

        # Анализ MobileSAM
        model = SAM('mobile_sam.pt')
        model.info()
        model('ultralytics/assets')

        # Анализ FastSAM-s
        model = FastSAM('FastSAM-s.pt')
        model.info()
        model('ultralytics/assets')

        # Анализ YOLOv8n-seg
        model = YOLO('yolov8n-seg.pt')
        model.info()
        model('ultralytics/assets')
        ```

## Авто-аннотация: быстрый путь к наборам данных для сегментации

Авто-аннотация - это ключевая функция SAM, позволяющая пользователям генерировать [наборы данных для сегментации](https://docs.ultralytics.com/datasets/segment) с использованием предварительно обученной модели обнаружения. Эта функция позволяет быстро и точно аннотировать большое количество изображений, обходя необходимость трудоемкой ручной разметки.

### Создание набора данных для сегментации с использованием модели обнаружения

Для авто-аннотации набора данных с использованием фреймворка Ultralytics используйте функцию `auto_annotate`, как показано ниже:

!!! Example "Пример"

    === "Python"
        ```python
        from ultralytics.data.annotator import auto_annotate

        auto_annotate(data="path/to/images", det_model="yolov8x.pt", sam_model='sam_b.pt')
        ```

| Аргумент   | Тип                    | Описание                                                                                                     | Значение по умолчанию |
|------------|------------------------|--------------------------------------------------------------------------------------------------------------|-----------------------|
| data       | str                    | Путь к папке с изображениями, которые должны быть аннотированы.                                              |                       |
| det_model  | str, опционально       | Предварительно обученная модель обнаружения YOLO. По умолчанию 'yolov8x.pt'.                                 | 'yolov8x.pt'          |
| sam_model  | str, опционально       | Предварительно обученная модель сегментации SAM. По умолчанию 'sam_b.pt'.                                    | 'sam_b.pt'            |
| device     | str, опционально       | Устройство для запуска моделей. По умолчанию пустая строка (ЦП или ГП, если доступно).                       |                       |
| output_dir | str, None, опционально | Каталог для сохранения результатов аннотации. По умолчанию - папка "labels" в том же каталоге, что и "data". | None                  |

Функция `auto_annotate` принимает путь к вашим изображениям со всеми опциональными аргументами для указания предварительно обученных моделей обнаружения и сегментации SAM, устройства для запуска моделей и каталога вывода для сохранения аннотированных результатов.

Авто-аннотация с помощью предварительно обученных моделей может существенно сократить время и усилия, затрачиваемые на создание высококачественных наборов данных для сегментации. Эта функция особенно полезна для исследователей и разработчиков, работающих с большими сборниками изображений, поскольку она позволяет им сконцентрироваться на разработке и оценке моделей, а не на ручной разметке.

## Цитирование и благодарности

Если вам пригодилась модель SAM в вашей исследовательской или разработческой работе, пожалуйста, рассмотрите возможность цитирования нашей статьи:

!!! Quote ""

    === "BibTeX"

        ```bibtex
        @misc{kirillov2023segment,
              title={Segment Anything},
              author={Alexander Kirillov and Eric Mintun and Nikhila Ravi and Hanzi Mao and Chloe Rolland and Laura Gustafson and Tete Xiao and Spencer Whitehead and Alexander C. Berg and Wan-Yen Lo and Piotr Dollár and Ross Girshick},
              year={2023},
              eprint={2304.02643},
              archivePrefix={arXiv},
              primaryClass={cs.CV}
        }
        ```

Мы хотели бы выразить свою благодарность компании Meta AI за создание и поддержку этого ценного ресурса для сообщества визуального анализа.

*keywords: Segment Anything, Segment Anything Model, SAM, Meta SAM, сегментация изображений, возможность давать подсказки для выполнения сегментации, производительность с нулевой настройкой, набор данных SA-1B, передовая архитектура, авто-аннотация, Ultralytics, предварительно обученные модели, базовая версия SAM, расширенная версия SAM, сегментация экземпляров, визуальный анализ, искусственный интеллект, машинное обучение, аннотация данных, маски сегментации, модель обнаружения, модель обнаружения YOLOv8, библиографическая ссылка, Meta AI.*
