---
comments: true
description: Узнайте о возможностях и преимуществах RT-DETR от Baidu - эффективного и гибкого детектора объектов в реальном времени, основанного на Vision Transformers. Включает предобученные модели.
keywords: RT-DETR, Baidu, Vision Transformers, object detection, real-time performance, CUDA, TensorRT, IoU-aware query selection, Ultralytics, Python API, PaddlePaddle
---

# RT-DETR от Baidu: детектор объектов в реальном времени на основе Vision Transformers

## Обзор

Real-Time Detection Transformer (RT-DETR), разработанный компанией Baidu, является передовым энд-ту-энд детектором объектов, который обеспечивает высокую точность при работе в реальном времени. Он использует преимущества Vision Transformers (ViT) для эффективной обработки мультимасштабных признаков путем разделения взаимодействия внутри масштаба и слияния между масштабами. RT-DETR легко адаптируется для поддержки гибкой настройки скорости вывода с использованием разных слоев декодера без необходимости повторного обучения. Модель показывает высокую производительность на ускоренных вычислительных платформах, таких как CUDA с TensorRT, превосходя многие другие детекторы объектов в реальном времени.

![Пример модели](https://user-images.githubusercontent.com/26833433/238963168-90e8483f-90aa-4eb6-a5e1-0d408b23dd33.png)
**Обзор RT-DETR от Baidu.** Схема архитектуры модели RT-DETR показывает последние три стадии основной сети {S3, S4, S5} в качестве входных данных для энкодера. Эффективный гибридный энкодер преобразует мультимасштабные признаки в последовательность признаков изображения с помощью интерактивного интраскального взаимодействия признаков (AIFI) и модуля слияния признаков между кросс-масштабами (CCFM). Для начальной инициализации объектных запросов декодера используется выбор запросов с учетом оценки пересечения объединения (IoU-aware query selection). Наконец, декодер с вспомогательными головами предсказания итеративно оптимизирует объектные запросы для генерации рамок и вероятностей ([источник](https://arxiv.org/pdf/2304.08069.pdf)).

### Основные особенности

- **Эффективный гибридный энкодер:** RT-DETR от Baidu использует эффективный гибридный энкодер, который обрабатывает мультимасштабные признаки путем разделения взаимодействия внутри масштаба и слияния между масштабами. Это уникальное решение на основе Vision Transformers снижает вычислительные затраты и позволяет осуществлять детекцию объектов в реальном времени.
- **Выбор запроса с учетом оценки пересечения объединения (IoU-aware):** RT-DETR от Baidu улучшает инициализацию запросов объектов путем использования осознанного запроса с учетом оценки пересечения объединения (IoU-aware query selection). Это позволяет модели фокусироваться на наиболее значимых объектах на сцене и повышает точность детектирования.
- **Гибкая скорость вывода:** RT-DETR от Baidu поддерживает гибкую настройку скорости вывода с использованием различных слоев декодера без необходимости повторного обучения. Гибкость данного подхода упрощает его применение в различных сценариях детекции объектов в реальном времени.

## Предобученные модели

Python API Ultralytics предоставляет предобученные модели RT-DETR от PaddlePaddle с различными масштабами:

- RT-DETR-L: 53.0% AP на COCO val2017, 114 FPS на GPU T4
- RT-DETR-X: 54.8% AP на COCO val2017, 74 FPS на GPU T4

## Примеры использования

В этом примере представлены простые примеры обучения и вывода модели RT-DETR. Для полной документации по этим и другим [режимам](../modes/index.md) смотрите страницы документации [Predict](../modes/predict.md),  [Train](../modes/train.md), [Val](../modes/val.md) и [Export](../modes/export.md).

!!! Example "Пример"

    === "Python"

        ```python
        from ultralytics import RTDETR

        # Загрузка предобученной модели RT-DETR-l на COCO
        model = RTDETR('rtdetr-l.pt')

        # Отображение информации о модели (по желанию)
        model.info()

        # Обучение модели на примере набора данных COCO8 в течение 100 эпох
        results = model.train(data='coco8.yaml', epochs=100, imgsz=640)

        # Осуществление вывода модели RT-DETR-l на изображении 'bus.jpg'
        results = model('path/to/bus.jpg')
        ```

    === "CLI"

        ```bash
        # Загрузка предобученной модели RT-DETR-l на COCO и ее обучение на примере набора данных COCO8 в течение 100 эпох
        yolo train model=rtdetr-l.pt data=coco8.yaml epochs=100 imgsz=640

        # Загрузка предобученной модели RT-DETR-l на COCO и вывод ее на изображении 'bus.jpg'
        yolo predict model=rtdetr-l.pt source=path/to/bus.jpg
        ```

## Поддерживаемые задачи и режимы

В таблице представлены типы моделей, конкретные предобученные веса, задачи, поддерживаемые каждой моделью, а также различные режимы ([Train](../modes/train.md) , [Val](../modes/val.md), [Predict](../modes/predict.md), [Export](../modes/export.md)), поддерживаемые каждой моделью, что обозначено символом ✅.

| Тип модели          | Предобученные веса | Поддерживаемые задачи                      | Вывод | Валидация | Обучение | Экспорт |
|---------------------|--------------------|--------------------------------------------|-------|-----------|----------|---------|
| RT-DETR Large       | `rtdetr-l.pt`      | [Обнаружение объектов](../tasks/detect.md) | ✅     | ✅         | ✅        | ✅       |
| RT-DETR Extra-Large | `rtdetr-x.pt`      | [Обнаружение объектов](../tasks/detect.md) | ✅     | ✅         | ✅        | ✅       |

## Цитирование и благодарности

Если вы используете Baidu RT-DETR в своих исследованиях или разработке, пожалуйста, процитируйте [оригинальную статью](https://arxiv.org/abs/2304.08069):

!!! Quote ""

    === "BibTeX"

        ```bibtex
        @misc{lv2023detrs,
              title={DETRs Beat YOLOs on Real-time Object Detection},
              author={Wenyu Lv and Shangliang Xu and Yian Zhao and Guanzhong Wang and Jinman Wei and Cheng Cui and Yuning Du and Qingqing Dang and Yi Liu},
              year={2023},
              eprint={2304.08069},
              archivePrefix={arXiv},
              primaryClass={cs.CV}
        }
        ```

Мы хотели бы выразить свою благодарность компании Baidu и команде [PaddlePaddle](https://github.com/PaddlePaddle/PaddleDetection) за создание и поддержку этого ценного ресурса для сообщества компьютерного зрения. Мы очень ценим их вклад в области разработки детекторов объектов в реальном времени на основе Vision Transformers, RT-DETR.

*Keywords: RT-DETR, Transformer, ViT, Vision Transformers, Baidu RT-DETR, PaddlePaddle, Paddle Paddle RT-DETR, real-time object detection, Vision Transformers-based object detection, pre-trained PaddlePaddle RT-DETR models, Baidu's RT-DETR usage, Ultralytics Python API*
