---
comments: true
description: Explore um guia completo do Ultralytics YOLOv8, um modelo de detecção de objetos e segmentação de imagens de alta velocidade e precisão. Tutoriais de instalação, previsão, treinamento e muito mais.
keywords: Ultralytics, YOLOv8, detecção de objetos, segmentação de imagens, aprendizado de máquina, aprendizado profundo, visão computacional, instalação do YOLOv8, previsão do YOLOv8, treinamento do YOLOv8, história do YOLO, licenças do YOLO
---

<div align="center">
  <p>
    <a href="https://yolovision.ultralytics.com" target="_blank">
    <img width="1024" src="https://raw.githubusercontent.com/ultralytics/assets/main/yolov8/banner-yolov8.png" alt="Banner Ultralytics YOLO"></a>
  </p>
  <a href="https://github.com/ultralytics"><img src="https://github.com/ultralytics/assets/raw/main/social/logo-social-github.png" width="3%" alt="GitHub da Ultralytics"></a>
  <img src="https://github.com/ultralytics/assets/raw/main/social/logo-transparent.png" width="3%">
  <a href="https://www.linkedin.com/company/ultralytics/"><img src="https://github.com/ultralytics/assets/raw/main/social/logo-social-linkedin.png" width="3%" alt="LinkedIn da Ultralytics"></a>
  <img src="https://github.com/ultralytics/assets/raw/main/social/logo-transparent.png" width="3%">
  <a href="https://twitter.com/ultralytics"><img src="https://github.com/ultralytics/assets/raw/main/social/logo-social-twitter.png" width="3%" alt="Twitter da Ultralytics"></a>
  <img src="https://github.com/ultralytics/assets/raw/main/social/logo-transparent.png" width="3%">
  <a href="https://youtube.com/ultralytics"><img src="https://github.com/ultralytics/assets/raw/main/social/logo-social-youtube.png" width="3%" alt="YouTube da Ultralytics"></a>
  <img src="https://github.com/ultralytics/assets/raw/main/social/logo-transparent.png" width="3%">
  <a href="https://www.tiktok.com/@ultralytics"><img src="https://github.com/ultralytics/assets/raw/main/social/logo-social-tiktok.png" width="3%" alt="TikTok da Ultralytics"></a>
  <img src="https://github.com/ultralytics/assets/raw/main/social/logo-transparent.png" width="3%">
  <a href="https://www.instagram.com/ultralytics/"><img src="https://github.com/ultralytics/assets/raw/main/social/logo-social-instagram.png" width="3%" alt="Instagram da Ultralytics"></a>
  <img src="https://github.com/ultralytics/assets/raw/main/social/logo-transparent.png" width="3%">
  <a href="https://ultralytics.com/discord"><img src="https://github.com/ultralytics/assets/raw/main/social/logo-social-discord.png" width="3%" alt="Discord da Ultralytics"></a>
  <br>
  <br>
  <a href="https://github.com/ultralytics/ultralytics/actions/workflows/ci.yaml"><img src="https://github.com/ultralytics/ultralytics/actions/workflows/ci.yaml/badge.svg" alt="Integração Contínua da Ultralytics"></a>
  <a href="https://codecov.io/github/ultralytics/ultralytics"><img src="https://codecov.io/github/ultralytics/ultralytics/branch/main/graph/badge.svg?token=HHW7IIVFVY" alt="Cobertura de Código da Ultralytics"></a>
  <a href="https://zenodo.org/badge/latestdoi/264818686"><img src="https://zenodo.org/badge/264818686.svg" alt="Citação do YOLOv8"></a>
  <a href="https://hub.docker.com/r/ultralytics/ultralytics"><img src="https://img.shields.io/docker/pulls/ultralytics/ultralytics?logo=docker" alt="Contagem de Pulls no Docker"></a>
  <br>
  <a href="https://console.paperspace.com/github/ultralytics/ultralytics"><img src="https://assets.paperspace.io/img/gradient-badge.svg" alt="Executar no Gradient"/></a>
  <a href="https://colab.research.google.com/github/ultralytics/ultralytics/blob/main/examples/tutorial.ipynb"><img src="https://colab.research.google.com/assets/colab-badge.svg" alt="Abrir no Colab"></a>
  <a href="https://www.kaggle.com/ultralytics/yolov8"><img src="https://kaggle.com/static/images/open-in-kaggle.svg" alt="Abrir no Kaggle"></a>
</div>

Apresentamos o [Ultralytics](https://ultralytics.com) [YOLOv8](https://github.com/ultralytics/ultralytics), a mais recente versão do aclamado modelo de detecção de objetos em tempo real e segmentação de imagens. O YOLOv8 é baseado nos mais recentes avanços do aprendizado profundo e visão computacional, oferecendo um desempenho sem paralelo em termos de velocidade e precisão. Seu design simplificado o torna adequado para várias aplicações e facilmente adaptável a diferentes plataformas de hardware, desde dispositivos de borda até APIs na nuvem.

Explore os Documentos do YOLOv8, um recurso abrangente projetado para ajudá-lo a entender e utilizar suas características e capacidades. Seja você um praticante experiente de aprendizado de máquina ou novo no campo, este hub tem como objetivo maximizar o potencial do YOLOv8 em seus projetos

!!! Note "Nota"

    🚧 Nossa documentação em vários idiomas está atualmente em construção e estamos trabalhando arduamente para aprimorá-la. Agradecemos sua paciência! 🙏

## Por Onde Começar

- **Instalar** `ultralytics` com pip e começar a funcionar em minutos &nbsp; [:material-clock-fast: Começar](quickstart.md){ .md-button }
- **Prever** novas imagens e vídeos com o YOLOv8 &nbsp; [:octicons-image-16: Prever em Imagens](modes/predict.md){ .md-button }
- **Treinar** um novo modelo YOLOv8 em seu próprio conjunto de dados personalizado &nbsp; [:fontawesome-solid-brain: Treinar um Modelo](modes/train.md){ .md-button }
- **Explorar** tarefas do YOLOv8 como segmentar, classificar, estimar pose e rastrear &nbsp; [:material-magnify-expand: Explorar Tarefas](tasks/index.md){ .md-button }

<p align="center">
  <br>
  <iframe width="720" height="405" src="https://www.youtube.com/embed/LNwODJXcvt4?si=7n1UvGRLSd9p5wKs"
    title="Reprodutor de vídeo do YouTube" frameborder="0"
    allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture; web-share"
    allowfullscreen>
  </iframe>
  <br>
  <strong>Assistir:</strong> Como Treinar um Modelo YOLOv8 em Seu Conjunto de Dados Personalizado no <a href="https://colab.research.google.com/github/ultralytics/ultralytics/blob/main/examples/tutorial.ipynb" target="_blank">Google Colab</a>.
</p>

## YOLO: Uma Breve História

[YOLO](https://arxiv.org/abs/1506.02640) (You Only Look Once), um popular modelo de detecção de objetos e segmentação de imagens, foi desenvolvido por Joseph Redmon e Ali Farhadi na Universidade de Washington. Lançado em 2015, o YOLO rapidamente ganhou popularidade por sua alta velocidade e precisão.

- [YOLOv2](https://arxiv.org/abs/1612.08242), lançado em 2016, aprimorou o modelo original incorporando normalização em lote, caixas âncora e aglomerados dimensionais.
- [YOLOv3](https://pjreddie.com/media/files/papers/YOLOv3.pdf), lançado em 2018, melhorou ainda mais o desempenho do modelo usando uma rede dorsal mais eficiente, múltiplas âncoras e pooling piramidal espacial.
- [YOLOv4](https://arxiv.org/abs/2004.10934) foi lançado em 2020, introduzindo inovações como a ampliação de dados Mosaic, uma nova cabeça de detecção sem âncoras e uma nova função de perda.
- [YOLOv5](https://github.com/ultralytics/yolov5) melhorou ainda mais o desempenho do modelo e adicionou novos recursos, como otimização de hiperparâmetros, rastreamento integrado de experimentos e exportação automática para formatos de exportação populares.
- [YOLOv6](https://github.com/meituan/YOLOv6) foi disponibilizado em código aberto por [Meituan](https://about.meituan.com/) em 2022 e está em uso em muitos dos robôs autônomos de entrega da empresa.
- [YOLOv7](https://github.com/WongKinYiu/yolov7) adicionou tarefas adicionais, como estimativa de pose no conjunto de dados de keypoints COCO.
- [YOLOv8](https://github.com/ultralytics/ultralytics), a mais recente versão do YOLO pela Ultralytics. Como um modelo de última geração, o YOLOv8 baseia-se no sucesso das versões anteriores, introduzindo novos recursos e melhorias para desempenho, flexibilidade e eficiência aprimorados. O YOLOv8 suporta uma gama completa de tarefas de IA de visão, incluindo [detecção](tasks/detect.md), [segmentação](tasks/segment.md), [estimativa de pose](tasks/pose.md), [rastreamento](modes/track.md) e [classificação](tasks/classify.md). Essa versatilidade permite que os usuários aproveitem as capacidades do YOLOv8 em diversas aplicações e domínios.

## Licenças YOLO: Como o YOLO da Ultralytics é licenciado?

A Ultralytics oferece duas opções de licença para acomodar casos de uso diversos:

- **Licença AGPL-3.0**: Essa licença de código aberto [aprovada pela OSI](https://opensource.org/licenses/) é ideal para estudantes e entusiastas, promovendo colaboração aberta e compartilhamento de conhecimento. Veja o arquivo [LICENSE](https://github.com/ultralytics/ultralytics/blob/main/LICENSE) para mais detalhes.
- **Licença Empresarial**: Projetada para uso comercial, esta licença permite a integração perfeita do software Ultralytics e modelos de IA em bens e serviços comerciais, contornando os requisitos de código aberto da AGPL-3.0. Se o seu cenário envolver a incorporação de nossas soluções em uma oferta comercial, entre em contato através do [Licenciamento da Ultralytics](https://ultralytics.com/license).

Nossa estratégia de licenciamento é projetada para garantir que qualquer melhoria em nossos projetos de código aberto retorne à comunidade. Mantemos os princípios de código aberto próximos ao nosso coração ❤️, e nossa missão é garantir que nossas contribuições possam ser utilizadas e expandidas de formas que beneficiem todos.
