---
comments: true
description: トレーニングからトラッキングまで、UltralyticsのYOLOv8を活用して最大限に活用します。検証、エクスポート、ベンチマーキングなど、各サポートモードの洞察と例を得る。
keywords: Ultralytics, YOLOv8, 機械学習, オブジェクト検出, トレーニング, 検証, 予測, エクスポート, トラッキング, ベンチマーキング
---

# Ultralytics YOLOv8 モード

<img width="1024" src="https://github.com/ultralytics/assets/raw/main/yolov8/banner-integrations.png" alt="Ultralytics YOLOエコシステムと統合">

## はじめに

Ultralytics YOLOv8は、単なるオブジェクト検出モデルではありません; これは、データ収集、モデルトレーニングから検証、デプロイメント、実際のトラッキングに至るまでの機械学習モデルのライフサイクル全体をカバーするように設計された多用途フレームワークです。各モードは特定の目的に役立ち、異なるタスクやユースケースに必要な柔軟性と効率を提供するように工夫されています。

<p align="center">
  <br>
  <iframe width="720" height="405" src="https://www.youtube.com/embed/j8uQc0qB91s?si=dhnGKgqvs7nPgeaM"
    title="YouTube video player" frameborder="0"
    allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture; web-share"
    allowfullscreen>
  </iframe>
  <br>
  <strong>視聴する:</strong> Ultralytics モードチュートリアル: トレーニ、検証、予測、エクスポート ＆ ベンチマーキング。
</p>

### モードの概要

Ultralytics YOLOv8がサポートする異なる**モード**を理解することは、モデルから最大限に活用するためには欠かせません：

- **トレーニング**モード：カスタムまたは事前読み込みされたデータセットでのモデルの微調整を行います。
- **バリデーション**モード：トレーニング後のチェックポイントとして、モデルの性能を検証します。
- **予測**モード：実世界のデータでモデルの予測能力を発揮します。
- **エクスポート**モード：様々な形式でデプロイメント準備ができたモデルを作成します。
- **トラッキング**モード：オブジェクト検出モデルをリアルタイム追跡アプリケーションに拡張します。
- **ベンチマーキング**モード：様々なデプロイメント環境でモデルの速度と精度を分析します。

この包括的なガイドは、YOLOv8の全潜在能力を引き出すための概要と実践的な洞察を提供することを目指しています。

## [トレーニング](train.md)

トレーニングモードは、カスタムデータセットでYOLOv8モデルのトレーニングを行うために使用されます。このモードでは、指定されたデータセットとハイパーパラメータを使用してモデルがトレーニングされます。トレーニングプロセスには、モデルのパラメータを最適化して、写真内のオブジェクトのクラスと位置を正確に予測できるようにする作業が含まれます。

[トレーニング例](train.md){ .md-button .md-button--primary}

## [バリデーション](val.md)

バリデーションモードは、トレーニングされたYOLOv8モデルを検証するために使用されます。このモードでは、モデルがバリデーションセットで評価され、その精度と一般化性能を測定します。このモードは、モデルのハイパーパラメータを調整し、そのパフォーマンスを向上させるために利用できます。

[バリデーション例](val.md){ .md-button .md-button--primary}

## [予測](predict.md)

予測モードは、新しい画像やビデオでトレーニングされたYOLOv8モデルを使用して予測を行うために使用されます。このモードでは、モデルがチェックポイントファイルから読み込まれ、ユーザーが推論を行うために画像やビデオを提供できます。モデルは、入力した画像やビデオ内のオブジェクトのクラスと位置を予測します。
