---
comments: true
description: Explore una guía completa sobre Ultralytics YOLOv8, un modelo de alta velocidad y precisión para detección de objetos y segmentación de imágenes. Tutoriales de instalación, predicción, entrenamiento y más.
keywords: Ultralytics, YOLOv8, detección de objetos, segmentación de imágenes, aprendizaje automático, aprendizaje profundo, visión por computadora, instalación YOLOv8, predicción YOLOv8, entrenamiento YOLOv8, historia de YOLO, licencias YOLO
---

<div align="center">
  <p>
    <a href="https://yolovision.ultralytics.com" target="_blank">
    <img width="1024" src="https://raw.githubusercontent.com/ultralytics/assets/main/yolov8/banner-yolov8.png" alt="Banner de Ultralytics YOLO"></a>
  </p>
  <a href="https://github.com/ultralytics"><img src="https://github.com/ultralytics/assets/raw/main/social/logo-social-github.png" width="3%" alt="GitHub de Ultralytics"></a>
  <img src="https://github.com/ultralytics/assets/raw/main/social/logo-transparent.png" width="3%">
  <a href="https://www.linkedin.com/company/ultralytics/"><img src="https://github.com/ultralytics/assets/raw/main/social/logo-social-linkedin.png" width="3%" alt="LinkedIn de Ultralytics"></a>
  <img src="https://github.com/ultralytics/assets/raw/main/social/logo-transparent.png" width="3%">
  <a href="https://twitter.com/ultralytics"><img src="https://github.com/ultralytics/assets/raw/main/social/logo-social-twitter.png" width="3%" alt="Twitter de Ultralytics"></a>
  <img src="https://github.com/ultralytics/assets/raw/main/social/logo-transparent.png" width="3%">
  <a href="https://youtube.com/ultralytics"><img src="https://github.com/ultralytics/assets/raw/main/social/logo-social-youtube.png" width="3%" alt="YouTube de Ultralytics"></a>
  <img src="https://github.com/ultralytics/assets/raw/main/social/logo-transparent.png" width="3%">
  <a href="https://www.tiktok.com/@ultralytics"><img src="https://github.com/ultralytics/assets/raw/main/social/logo-social-tiktok.png" width="3%" alt="TikTok de Ultralytics"></a>
  <img src="https://github.com/ultralytics/assets/raw/main/social/logo-transparent.png" width="3%">
  <a href="https://www.instagram.com/ultralytics/"><img src="https://github.com/ultralytics/assets/raw/main/social/logo-social-instagram.png" width="3%" alt="Instagram de Ultralytics"></a>
  <img src="https://github.com/ultralytics/assets/raw/main/social/logo-transparent.png" width="3%">
  <a href="https://ultralytics.com/discord"><img src="https://github.com/ultralytics/assets/raw/main/social/logo-social-discord.png" width="3%" alt="Discord de Ultralytics"></a>
  <br>
  <br>
  <a href="https://github.com/ultralytics/ultralytics/actions/workflows/ci.yaml"><img src="https://github.com/ultralytics/ultralytics/actions/workflows/ci.yaml/badge.svg" alt="Integración continua de Ultralytics"></a>
  <a href="https://codecov.io/github/ultralytics/ultralytics"><img src="https://codecov.io/github/ultralytics/ultralytics/branch/main/graph/badge.svg?token=HHW7IIVFVY" alt="Cobertura de código de Ultralytics"></a>
  <a href="https://zenodo.org/badge/latestdoi/264818686"><img src="https://zenodo.org/badge/264818686.svg" alt="Cita de YOLOv8"></a>
  <a href="https://hub.docker.com/r/ultralytics/ultralytics"><img src="https://img.shields.io/docker/pulls/ultralytics/ultralytics?logo=docker" alt="Descargas de Docker"></a>
  <br>
  <a href="https://console.paperspace.com/github/ultralytics/ultralytics"><img src="https://assets.paperspace.io/img/gradient-badge.svg" alt="Ejecutar en Gradient"/></a>
  <a href="https://colab.research.google.com/github/ultralytics/ultralytics/blob/main/examples/tutorial.ipynb"><img src="https://colab.research.google.com/assets/colab-badge.svg" alt="Abrir en Colab"></a>
  <a href="https://www.kaggle.com/ultralytics/yolov8"><img src="https://kaggle.com/static/images/open-in-kaggle.svg" alt="Abrir en Kaggle"></a>
</div>

Presentamos [Ultralytics](https://ultralytics.com) [YOLOv8](https://github.com/ultralytics/ultralytics), la última versión del aclamado modelo para detección de objetos y segmentación de imágenes en tiempo real. YOLOv8 está construido sobre avances de vanguardia en aprendizaje profundo y visión por computadora, ofreciendo un rendimiento sin paralelo en términos de velocidad y precisión. Su diseño simplificado lo hace adecuado para varias aplicaciones y fácilmente adaptable a diferentes plataformas de hardware, desde dispositivos de borde hasta API en la nube.

Explore los documentos de YOLOv8, un recurso integral diseñado para ayudarle a comprender y utilizar sus características y capacidades. Independientemente de que sea un practicante experimentado en aprendizaje automático o nuevo en el campo, este centro tiene como objetivo maximizar el potencial de YOLOv8 en sus proyectos.

!!! Note "Nota"

    🚧 Nuestra documentación en varios idiomas está actualmente en construcción y estamos trabajando duro para mejorarla. ¡Gracias por su paciencia! 🙏

## Dónde empezar

- **Instalar** `ultralytics` con pip y comenzar a funcionar en minutos &nbsp; [:material-clock-fast: Comenzar](quickstart.md){ .md-button }
- **Predecir** nuevas imágenes y videos con YOLOv8 &nbsp; [:octicons-image-16: Predecir en Imágenes](modes/predict.md){ .md-button }
- **Entrenar** un nuevo modelo YOLOv8 en su propio conjunto de datos personalizado &nbsp; [:fontawesome-solid-brain: Entrenar un Modelo](modes/train.md){ .md-button }
- **Explorar** tareas de YOLOv8 como segmentar, clasificar, posar y seguir &nbsp; [:material-magnify-expand: Explorar Tareas](tasks/index.md){ .md-button }

<p align="center">
  <br>
  <iframe width="720" height="405" src="https://www.youtube.com/embed/LNwODJXcvt4?si=7n1UvGRLSd9p5wKs"
    title="Reproductor de video de YouTube" frameborder="0"
    allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture; web-share"
    allowfullscreen>
  </iframe>
  <br>
  <strong>Ver:</strong> Cómo entrenar un modelo YOLOv8 en Su Conjunto de Datos Personalizado en <a href="https://colab.research.google.com/github/ultralytics/ultralytics/blob/main/examples/tutorial.ipynb" target="_blank">Google Colab</a>.
</p>

## YOLO: Una Breve Historia

[YOLO](https://arxiv.org/abs/1506.02640) (You Only Look Once), un modelo popular de detección de objetos y segmentación de imágenes, fue desarrollado por Joseph Redmon y Ali Farhadi en la Universidad de Washington. Lanzado en 2015, YOLO rápidamente ganó popularidad por su alta velocidad y precisión.

- [YOLOv2](https://arxiv.org/abs/1612.08242), lanzado en 2016, mejoró el modelo original incorporando normalización por lotes, cajas ancla y clústeres de dimensiones.
- [YOLOv3](https://pjreddie.com/media/files/papers/YOLOv3.pdf), lanzado en 2018, mejoró aún más el rendimiento del modelo usando una red dorsal más eficiente, múltiples anclas y agrupación piramidal espacial.
- [YOLOv4](https://arxiv.org/abs/2004.10934) fue lanzado en 2020, introduciendo innovaciones como la ampliación de datos del mosaico, un nuevo cabezal de detección sin ancla y una nueva función de pérdida.
- [YOLOv5](https://github.com/ultralytics/yolov5) mejoró aún más el rendimiento del modelo y agregó nuevas características como la optimización de hiperparámetros, seguimiento de experimentos integrados y exportación automática a formatos de exportación populares.
- [YOLOv6](https://github.com/meituan/YOLOv6) fue publicado en código abierto por [Meituan](https://about.meituan.com/) en 2022 y se utiliza en muchos de los robots de entrega autónomos de la empresa.
- [YOLOv7](https://github.com/WongKinYiu/yolov7) añadió tareas adicionales como la estimación de posturas en el conjunto de datos COCO keypoints.
- [YOLOv8](https://github.com/ultralytics/ultralytics) es la última versión de YOLO de Ultralytics. Como un modelo de vanguardia y del estado del arte (SOTA), YOLOv8 se basa en el éxito de las versiones anteriores, introduciendo nuevas características y mejoras para obtener un rendimiento mejorado, flexibilidad y eficiencia. YOLOv8 soporta una gama completa de tareas de IA de visión, incluyendo [detección](tasks/detect.md), [segmentación](tasks/segment.md), [estimación de pose](tasks/pose.md), [seguimiento](modes/track.md) y [clasificación](tasks/classify.md). Esta versatilidad permite a los usuarios aprovechar las capacidades de YOLOv8 en una amplia gama de aplicaciones y dominios.

## Licencias de YOLO: ¿Cómo están licenciados los YOLO de Ultralytics?

Ultralytics ofrece dos opciones de licencia para acomodar casos de uso diversos:

- **Licencia AGPL-3.0**: Esta licencia de código abierto aprobada por [OSI](https://opensource.org/licenses/) es ideal para estudiantes y entusiastas, promoviendo la colaboración abierta y el intercambio de conocimiento. Consulte el archivo [LICENSE](https://github.com/ultralytics/ultralytics/blob/main/LICENSE) para obtener más detalles.
- **Licencia Empresarial**: Diseñada para uso comercial, esta licencia permite la integración sin problemas de software de Ultralytics y modelos de IA en bienes y servicios comerciales, eludiendo los requisitos de código abierto de AGPL-3.0. Si su escenario implica la incorporación de nuestras soluciones en una oferta comercial, póngase en contacto a través de [Licencias de Ultralytics](https://ultralytics.com/license).

Nuestra estrategia de licenciamiento está diseñada para asegurar que cualquier mejora a nuestros proyectos de código abierto se devuelva a la comunidad. Mantenemos los principios del código abierto cerca de nuestros corazones ❤️, y nuestra misión es garantizar que nuestras contribuciones puedan ser utilizadas y ampliadas de formas que sean beneficiosas para todos.
