---
comments: true
description: استكشف دليل كامل لـ Ultralytics YOLOv8 ، نموذج كشف الكائنات وتجزئة الصور ذو السرعة العالية والدقة العالية. تثبيت المحررة ، والتنبؤ ، والتدريب والمزيد.
keywords: Ultralytics، YOLOv8، كشف الكائنات، تجزئة الصور، التعلم الآلي، التعلم العميق، الرؤية الحاسوبية، YOLOv8 installation، YOLOv8 prediction، YOLOv8 training، تاريخ YOLO، تراخيص YOLO
---

<div align="center">
  <p>
    <a href="https://yolovision.ultralytics.com" target="_blank">
    <img width="1024" src="https://raw.githubusercontent.com/ultralytics/assets/main/yolov8/banner-yolov8.png" alt="Ultralytics YOLO banner"></a>
  </p>
  <a href="https://github.com/ultralytics"><img src="https://github.com/ultralytics/assets/raw/main/social/logo-social-github.png" width="3%" alt="Ultralytics GitHub"></a>
  <img src="https://github.com/ultralytics/assets/raw/main/social/logo-transparent.png" width="3%">
  <a href="https://www.linkedin.com/company/ultralytics/"><img src="https://github.com/ultralytics/assets/raw/main/social/logo-social-linkedin.png" width="3%" alt="Ultralytics LinkedIn"></a>
  <img src="https://github.com/ultralytics/assets/raw/main/social/logo-transparent.png" width="3%">
  <a href="https://twitter.com/ultralytics"><img src="https://github.com/ultralytics/assets/raw/main/social/logo-social-twitter.png" width="3%" alt="Ultralytics Twitter"></a>
  <img src="https://github.com/ultralytics/assets/raw/main/social/logo-transparent.png" width="3%">
  <a href="https://youtube.com/ultralytics"><img src="https://github.com/ultralytics/assets/raw/main/social/logo-social-youtube.png" width="3%" alt="Ultralytics YouTube"></a>
  <img src="https://github.com/ultralytics/assets/raw/main/social/logo-transparent.png" width="3%">
  <a href="https://www.tiktok.com/@ultralytics"><img src="https://github.com/ultralytics/assets/raw/main/social/logo-social-tiktok.png" width="3%" alt="Ultralytics TikTok"></a>
  <img src="https://github.com/ultralytics/assets/raw/main/social/logo-transparent.png" width="3%">
  <a href="https://www.instagram.com/ultralytics/"><img src="https://github.com/ultralytics/assets/raw/main/social/logo-social-instagram.png" width="3%" alt="Ultralytics Instagram"></a>
  <img src="https://github.com/ultralytics/assets/raw/main/social/logo-transparent.png" width="3%">
  <a href="https://ultralytics.com/discord"><img src="https://github.com/ultralytics/assets/raw/main/social/logo-social-discord.png" width="3%" alt="Ultralytics Discord"></a>
  <br>
  <br>
  <a href="https://github.com/ultralytics/ultralytics/actions/workflows/ci.yaml"><img src="https://github.com/ultralytics/ultralytics/actions/workflows/ci.yaml/badge.svg" alt="Ultralytics CI"></a>
  <a href="https://codecov.io/github/ultralytics/ultralytics"><img src="https://codecov.io/github/ultralytics/ultralytics/branch/main/graph/badge.svg?token=HHW7IIVFVY" alt="Ultralytics Code Coverage"></a>
  <a href="https://zenodo.org/badge/latestdoi/264818686"><img src="https://zenodo.org/badge/264818686.svg" alt="YOLOv8 Citation"></a>
  <a href="https://hub.docker.com/r/ultralytics/ultralytics"><img src="https://img.shields.io/docker/pulls/ultralytics/ultralytics?logo=docker" alt="Docker Pulls"></a>
  <br>
  <a href="https://console.paperspace.com/github/ultralytics/ultralytics"><img src="https://assets.paperspace.io/img/gradient-badge.svg" alt="Run on Gradient"/></a>
  <a href="https://colab.research.google.com/github/ultralytics/ultralytics/blob/main/examples/tutorial.ipynb"><img src="https://colab.research.google.com/assets/colab-badge.svg" alt="Open In Colab"></a>
  <a href="https://www.kaggle.com/ultralytics/yolov8"><img src="https://kaggle.com/static/images/open-in-kaggle.svg" alt="Open In Kaggle"></a>
</div>

يتم تقديم [Ultralytics](https://ultralytics.com) [YOLOv8](https://github.com/ultralytics/ultralytics) ، أحدث إصدار من نموذج كشف الكائنات وتجزئة الصور المشهورة للوقت الفعلي. يعتمد YOLOv8 على التطورات المتقدمة في التعلم العميق والرؤية الحاسوبية ، ويقدم أداءً فائقًا من حيث السرعة والدقة. يجعل التصميم البسيط له مناسبًا لمختلف التطبيقات وقابلًا للتكيف بسهولة مع منصات الأجهزة المختلفة ، من الأجهزة الحافة إلى واجهات برمجة التطبيقات في السحابة.

استكشف أدلة YOLOv8 ، وهي مورد شامل يهدف إلى مساعدتك في فهم واستخدام ميزاته وقدراته. سواء كنت ممارسًا في مجال التعلم الآلي من ذوي الخبرة أو جديدًا في هذا المجال ، فإن الهدف من هذا المركز هو تحقيق الحد الأقصى لإمكانات YOLOv8 في مشاريعك.

!!! Note "ملاحظة"

    🚧 تم تطوير وثائقنا متعددة اللغات حاليًا ، ونعمل بجد لتحسينها. شكراً لصبرك! 🙏

## من أين أبدأ

- **تثبيت** `ultralytics` بواسطة pip والبدء في العمل في دقائق &nbsp; [:material-clock-fast: ابدأ الآن](quickstart.md){ .md-button }
- **توقع** الصور ومقاطع الفيديو الجديدة بواسطة YOLOv8 &nbsp; [:octicons-image-16: توقع على الصور](modes/predict.md){ .md-button }
- **تدريب** نموذج YOLOv8 الجديد على مجموعة البيانات المخصصة الخاصة بك &nbsp; [:fontawesome-solid-brain: قم بتدريب نموذج](modes/train.md){ .md-button }
- **استكشاف** مهام YOLOv8 مثل التجزئة والتصنيف والوضع والتتبع &nbsp; [:material-magnify-expand: استكشاف المهام](tasks/index.md){ .md-button }

<p align="center">
  <br>
  <iframe width="720" height="405" src="https://www.youtube.com/embed/LNwODJXcvt4?si=7n1UvGRLSd9p5wKs"
    title="مشغل فيديو يوتيوب" frameborder="0"
    allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture; web-share"
    allowfullscreen>
  </iframe>
  <br>
  <strong> مشاهدة: </strong> كيفية تدريب نموذج YOLOv8 على مجموعة بيانات مخصصة في <a href="https://colab.research.google.com/github/ultralytics/ultralytics/blob/main/examples/tutorial.ipynb" target="_blank">جوجل كولاب</a>.
</p>

## YOLO: نبذة تاريخية

تم تطوير [YOLO](https://arxiv.org/abs/1506.02640) (You Only Look Once) ، نموذج شهير لكشف الكائنات وتجزئة الصور ، من قبل جوزيف ريدمون وعلي فرهادي في جامعة واشنطن. في عام 2015 ، حققت YOLO شهرة سريعة بفضل سرعتها العالية ودقتها.

- [YOLOv2](https://arxiv.org/abs/1612.08242) ، الذي تم إصداره في عام 2016 ، قام بتحسين النموذج الأصلي من خلال دمج التطبيع التشغيلي ، ومربعات الربط ، ومجموعات الأبعاد.
- [YOLOv3](https://pjreddie.com/media/files/papers/YOLOv3.pdf) ، الذي تم إطلاقه في عام 2018 ، قدم تحسينات إضافية لأداء النموذج باستخدام شبكة ظهر أكثر كفاءة ومرشحات متعددة وتجميع هرم المساحة.
- تم إصدار [YOLOv4](https://arxiv.org/abs/2004.10934) في عام 2020 ، وقدم ابتكارات مثل زيادة المساعدات في البيانات ، ورأس جديد للكشف غير المرتبط بالمرابط ، ووظيفة فقدان جديدة.
- [YOLOv5](https://github.com/ultralytics/yolov5) قام بتحسين أداء النموذج وأضاف ميزات جديدة مثل تحسين ثوابت النموذج ، وتعقب التجارب المتكامل والتصدير التلقائي إلى تنسيقات التصدير الشهيرة.
- [YOLOv6](https://github.com/meituan/YOLOv6) تم تَوْزيعه على [Meituan](https://about.meituan.com/) في عام 2022 وهو قيد الاستخدام في العديد من روبوتات التسليم الذاتي للشركة.
- [YOLOv7](https://github.com/WongKinYiu/yolov7) أضاف مهمات إضافية مثل تقدير الوضع على مجموعة بيانات نقاط COCO الرئيسية.
- [YOLOv8](https://github.com/ultralytics/ultralytics) هو أحدث إصدار من YOLO بواسطة Ultralytics. باعتباره نموذجًا حديثًا وفريدًا من نوعه ، فإن YOLOv8 يبني على نجاح الإصدارات السابقة ، ويقدم ميزات وتحسينات جديدة لتحسين الأداء والمرونة والكفاءة. يدعم YOLOv8 مجموعة كاملة من مهام الذكاء الصناعي للرؤية ، بما في ذلك [الكشف](tasks/detect.md) ، [التجزئة](tasks/segment.md) ، [تقدير الوضع](tasks/pose.md) ، [التتبع](modes/track.md) ، و [التصنيف](tasks/classify.md). تتيح هذه القابلية للتكيف للمستخدمين استغلال قدرات YOLOv8 في تطبيقات ومجالات متنوعة.

## تراخيص YOLO: كيف يتم ترخيص Ultralytics YOLO؟

يوفر Ultralytics خيارين للترخيص لاستيعاب الحالات الاستخدام المتنوعة:

- **ترخيص AGPL-3.0**: هذا الترخيص مفتوح المصدر والمعتمد من [OSI](https://opensource.org/licenses/) وهو مثالي للطلاب والهواة ، ويشجع على التعاون المفتوح ومشاركة المعرفة. راجع ملف [LICENSE](https://github.com/ultralytics/ultralytics/blob/main/LICENSE) لمزيد من التفاصيل.
- **ترخيص المؤسسة**: صمم للاستخدام التجاري ، يسمح هذا الترخيص بدمج سلس للبرمجيات ونماذج AI الخاصة بشركة Ultralytics في السلع والخدمات التجارية ، وتفادي متطلبات المصدر المفتوح لـ AGPL-3.0. إذا تشمل سيناريو الخاص بك تضمين حلولنا في عرض تجاري ، فيرجى التواصل من خلال [Ultralytics Licensing](https://ultralytics.com/license).

تم تصميم استراتيجية الترخيص الخاصة بنا لضمان أن أي تحسينات على مشاريعنا مفتوحة المصدر يتم إرجاعها إلى المجتمع. نحمل مبادئ المصدر المفتوح قريبة من قلوبنا ❤️ ، ومهمتنا هي ضمان أن يمكن استخدام وتوسيع مساهماتنا بطرق تعود بالنفع على الجميع.
