---
comments: true
description: Изучите подробную документацию YOLO-NAS, превосходной модели обнаружения объектов. Узнайте о ее функциях, предварительно обученных моделях, использовании с помощью Ultralytics Python API и многом другом.
keywords: YOLO-NAS, Deci AI, обнаружение объектов, глубокое обучение, поиск нейроархитектур, Ultralytics Python API, модель YOLO, предварительно обученные модели, квантизация, оптимизация, COCO, Objects365, Roboflow 100
---

# YOLO-NAS

## Обзор

Разработанный компанией Deci AI, YOLO-NAS является революционной фундаментальной моделью обнаружения объектов. Она является продуктом продвинутой технологии поиска нейроархитектур и специально разработана для преодоления ограничений предыдущих моделей YOLO. Благодаря существенному улучшению поддержки квантования и компромисса между точностью и задержкой, YOLO-NAS представляет собой значительный прорыв в области обнаружения объектов.

![Иллюстрация модели](https://learnopencv.com/wp-content/uploads/2023/05/yolo-nas_COCO_map_metrics.png)
**Обзор YOLO-NAS.** YOLO-NAS использует блоки, поддерживающие квантование, и селективное квантование для достижения оптимальной производительности. Модель, когда переводится в квантованную версию INT8, имеет минимальное падение точности, что является значительным улучшением по сравнению с другими моделями. Эти достижения приводят к превосходной архитектуре с беспрецедентными возможностями обнаружения объектов и выдающей производительностью.

### Основные функции

- **Базовый блок поддерживающий квантование:** YOLO-NAS предлагает новый базовый блок, который хорошо работает с квантованием, что позволяет преодолеть одно из значительных ограничений предыдущих моделей YOLO.
- **Совершенствование тренировки и квантования:** YOLO-NAS использует продвинутые схемы тренировки и пост-тренировочное квантование для улучшения производительности.
- **Оптимизация AutoNAC и предварительная обучение:** YOLO-NAS использует оптимизацию AutoNAC и предварительное обучение на известных наборах данных, таких как COCO, Objects365 и Roboflow 100. Это предварительное обучение делает модель идеально подходящей для решений по обнаружению объектов в производственных средах.

## Предварительно обученные модели

Ощутите мощь обнаружения объектов нового поколения с предварительно обученными моделями YOLO-NAS, предоставленными компанией Ultralytics. Эти модели разработаны для обеспечения высокой производительности как в плане скорости, так и точности. Выберите из различных вариантов, настроенных под ваши конкретные потребности:

| Модель           | mAP   | Задержка (ms) |
|------------------|-------|---------------|
| YOLO-NAS S       | 47.5  | 3.21          |
| YOLO-NAS M       | 51.55 | 5.85          |
| YOLO-NAS L       | 52.22 | 7.87          |
| YOLO-NAS S INT-8 | 47.03 | 2.36          |
| YOLO-NAS M INT-8 | 51.0  | 3.78          |
| YOLO-NAS L INT-8 | 52.1  | 4.78          |

Каждый вариант модели разработан для достижения баланса между средней точностью обнаружения (mAP) и задержкой, помогая вам оптимизировать задачи по обнаружению объектов с точки зрения производительности и скорости.

## Примеры использования

Компания Ultralytics сделала интеграцию моделей YOLO-NAS в ваши приложения на Python максимально простой с помощью нашего пакета `ultralytics`. Пакет предоставляет удобный API на Python, чтобы упростить весь процесс.

Ниже приведены примеры использования моделей YOLO-NAS с пакетом `ultralytics` для вывода результатов и их проверки:

### Примеры вывода результатов и проверки

В этом примере мы проверяем модель YOLO-NAS-s на наборе данных COCO8.

!!! Example "Пример"

    В этом примере представлен простой код вывода результатов и проверки для YOLO-NAS. Для обработки результатов вывода см. режим [Predict](../modes/predict.md). Для использования YOLO-NAS с другими режимами см. [Val](../modes/val.md) и [Export](../modes/export.md). Пакет `ultralytics` для YOLO-NAS не поддерживает обучение.

    === "Python"

        Файлы предварительно обученных моделей PyTorch `*.pt` могут быть переданы в класс `NAS()` для создания экземпляра модели на Python:

        ```python
        from ultralytics import NAS

        # Загрузка предварительно обученной модели YOLO-NAS-s на наборе данных COCO
        model = NAS('yolo_nas_s.pt')

        # Вывод информации о модели (опционально)
        model.info()

        # Проверка модели на примере набора данных COCO8
        results = model.val(data='coco8.yaml')

        # Вывод результатов работы модели YOLO-NAS-s на изображении 'bus.jpg'
        results = model('path/to/bus.jpg')
        ```

    === "CLI"

        Для прямого запуска моделей доступны следующие команды:

        ```bash
        # Загрузка предварительно обученной модели YOLO-NAS-s на наборе данных COCO и проверка ее производительности на примере набора данных COCO8
        yolo val model=yolo_nas_s.pt data=coco8.yaml

        # Загрузка предварительно обученной модели YOLO-NAS-s на наборе данных COCO и запуск вывода результатов на изображении 'bus.jpg'
        yolo predict model=yolo_nas_s.pt source=path/to/bus.jpg
        ```

## Поддерживаемые задачи и режимы

Мы предлагаем три варианта моделей YOLO-NAS: Small (s), Medium (m) и Large (l). Каждый вариант разработан для различных вычислительных и производственных потребностей:

- **YOLO-NAS-s**: Оптимизирована для сред с ограниченными вычислительными ресурсами, где эффективность является ключевым фактором.
- **YOLO-NAS-m**: Предлагает сбалансированный подход, подходит для общих задач обнаружения объектов с более высокой точностью.
- **YOLO-NAS-l**: Адаптирована для сценариев, требующих максимальной точности, где вычислительные ресурсы менее ограничены.

Ниже приведен подробный обзор каждой модели, включая ссылки на их предварительно обученные веса, задачи, которые они поддерживают, и их совместимость с различными режимами работы.

| Тип модели | Предварительно обученные веса                                                                 | Поддерживаемые задачи                      | Вывод результатов | Проверка | Обучение | Экспорт |
|------------|-----------------------------------------------------------------------------------------------|--------------------------------------------|-------------------|----------|----------|---------|
| YOLO-NAS-s | [yolo_nas_s.pt](https://github.com/ultralytics/assets/releases/download/v0.0.0/yolo_nas_s.pt) | [Обнаружение объектов](../tasks/detect.md) | ✅                 | ✅        | ❌        | ✅       |
| YOLO-NAS-m | [yolo_nas_m.pt](https://github.com/ultralytics/assets/releases/download/v0.0.0/yolo_nas_m.pt) | [Обнаружение объектов](../tasks/detect.md) | ✅                 | ✅        | ❌        | ✅       |
| YOLO-NAS-l | [yolo_nas_l.pt](https://github.com/ultralytics/assets/releases/download/v0.0.0/yolo_nas_l.pt) | [Обнаружение объектов](../tasks/detect.md) | ✅                 | ✅        | ❌        | ✅       |

## Цитирование и благодарности

Если вы используете YOLO-NAS в своей научно-исследовательской или разработочной работе, пожалуйста, ссылайтесь на SuperGradients:

!!! Quote ""

    === "BibTeX"

        ```bibtex
        @misc{supergradients,
              doi = {10.5281/ZENODO.7789328},
              url = {https://zenodo.org/record/7789328},
              author = {Aharon,  Shay and {Louis-Dupont} and {Ofri Masad} and Yurkova,  Kate and {Lotem Fridman} and {Lkdci} and Khvedchenya,  Eugene and Rubin,  Ran and Bagrov,  Natan and Tymchenko,  Borys and Keren,  Tomer and Zhilko,  Alexander and {Eran-Deci}},
              title = {Super-Gradients},
              publisher = {GitHub},
              journal = {GitHub repository},
              year = {2021},
        }
        ```

Мы выражаем благодарность команде [SuperGradients](https://github.com/Deci-AI/super-gradients/) компании Deci AI за их усилия в создании и поддержке этого ценного ресурса для компьютерного зрения. Мы считаем, что YOLO-NAS со своей инновационной архитектурой и улучшенными возможностями обнаружения объектов станет важным инструментом как для разработчиков, так и для исследователей.

*keywords: YOLO-NAS, Deci AI, обнаружение объектов, глубокое обучение, поиск нейроархитектур, Ultralytics Python API, модель YOLO, SuperGradients, предварительно обученные модели, базовый блок, дружественный квантованию, продвинутые схемы тренировки, пост-тренировочное квантование, оптимизация AutoNAC, COCO, Objects365, Roboflow 100*
