---
comments: true
description: Узнайте больше о MobileSAM, его реализации, сравнении с оригинальным SAM и о том, как его загрузить и протестировать в фреймворке Ultralytics. Улучшите свои мобильные приложения уже сегодня.
keywords: MobileSAM, Ultralytics, SAM, мобильные приложения, Arxiv, GPU, API, кодировщик изображений, декодер масок, загрузка модели, метод тестирования
---

![Логотип MobileSAM](https://github.com/ChaoningZhang/MobileSAM/blob/master/assets/logo2.png?raw=true)

# Mobile Segment Anything (MobileSAM)

Теперь доступна статья MobileSAM в [архиве arXiv](https://arxiv.org/pdf/2306.14289.pdf).

Демонстрацию работы MobileSAM на CPU можно найти по этой [ссылке](https://huggingface.co/spaces/dhkim2810/MobileSAM). Время выполнения на Mac i5 CPU составляет примерно 3 секунды. В демонстрационной версии Hugging Face интерфейс и менее производительные процессоры CPU могут вызывать замедление работы, но она продолжает работать эффективно.

MobileSAM реализован в различных проектах, включая [Grounding-SAM](https://github.com/IDEA-Research/Grounded-Segment-Anything), [AnyLabeling](https://github.com/vietanhdev/anylabeling) и [Segment Anything in 3D](https://github.com/Jumpat/SegmentAnythingin3D).

MobileSAM обучается на одном графическом процессоре (GPU) со 100 тысячами данных (1% от оригинальных изображений) за менее чем день. Код для обучения будет доступен в будущем.

## Доступные модели, поддерживаемые задачи и режимы работы

В таблице представлены доступные модели с соответствующими предварительно обученными весами, поддерживаемыми задачами и их совместимостью с различными режимами работы, такими как [вывод](../modes/predict.md), [валидация](../modes/val.md), [тренировка](../modes/train.md) и [экспорт](../modes/export.md), указанными с помощью эмодзи ✅ для поддерживаемых режимов и эмодзи ❌ для неподдерживаемых.

| Тип модели | Предварительно обученные веса | Поддерживаемые задачи                          | Вывод | Валидация | Тренировка | Экспорт |
|------------|-------------------------------|------------------------------------------------|-------|-----------|------------|---------|
| MobileSAM  | `mobile_sam.pt`               | [Сегментация экземпляров](../tasks/segment.md) | ✅     | ❌         | ❌          | ✅       |

## Переход от SAM к MobileSAM

Поскольку MobileSAM сохраняет ту же самую последовательность операций, что и оригинальный SAM, в него интегрированы все интерфейсы для предобработки, постобработки и прочие интерфейсы. В результате, пользователи, уже использующие оригинальный SAM, могут легко перейти на MobileSAM.

MobileSAM работает сравнимо с оригинальным SAM и имеет ту же самую последовательность операций, за исключением изменения кодировщика изображений. В частности, мы заменяем оригинальный "тяжёлый" кодировщик изображений ViT-H (632M) на более компактный Tiny-ViT (5M). На одном графическом процессоре MobileSAM работает примерно за 12 мс на изображение: 8 мс на кодировщик изображений и 4 мс на декодер масок.

В таблице представлено сравнение кодировщиков изображений на базе ViT:

| Кодировщик изображений | Оригинальный SAM | MobileSAM |
|------------------------|------------------|-----------|
| Параметры              | 611M             | 5M        |
| Скорость               | 452 мс           | 8 мс      |

Как оригинальный SAM, так и MobileSAM используют один и тот же декодер масок, управляемый подсказками:

| Декодер масок | Оригинальный SAM | MobileSAM |
|---------------|------------------|-----------|
| Параметры     | 3.876M           | 3.876M    |
| Скорость      | 4 мс             | 4 мс      |

Ниже приведено сравнение всей последовательности операций:

| Полная последовательность операций (Enc+Dec) | Оригинальный SAM | MobileSAM |
|----------------------------------------------|------------------|-----------|
| Параметры                                    | 615M             | 9.66M     |
| Скорость                                     | 456 мс           | 12 мс     |

Производительность MobileSAM и оригинального SAM демонстрируется с использованием подсказок в форме точки и прямоугольника.

![Изображение с подсказкой в виде точки](https://raw.githubusercontent.com/ChaoningZhang/MobileSAM/master/assets/mask_box.jpg?raw=true)

![Изображение с подсказкой в виде прямоугольника](https://raw.githubusercontent.com/ChaoningZhang/MobileSAM/master/assets/mask_box.jpg?raw=true)

MobileSAM обеспечивает примерно в 5 раз меньший размер и в 7 раз большую скорость работы по сравнению с текущим FastSAM. Более подробная информация доступна на [странице проекта MobileSAM](https://github.com/ChaoningZhang/MobileSAM).

## Тестирование MobileSAM в Ultralytics

Как и оригинальный SAM, мы предлагаем простой метод тестирования в Ultralytics, включая режимы тестирования с использованием подсказок в форме точки и прямоугольника.

### Загрузка модели

Вы можете загрузить модель [здесь](https://github.com/ChaoningZhang/MobileSAM/blob/master/weights/mobile_sam.pt).

### Подсказка в форме точки

!!! Example "Пример"

    === "Python"
        ```python
        from ultralytics import SAM

        # Загрузка модели
        model = SAM('mobile_sam.pt')

        # Предсказание сегмента на основе подсказки в форме точки
        model.predict('ultralytics/assets/zidane.jpg', points=[900, 370], labels=[1])
        ```

### Подсказка в форме прямоугольника

!!! Example "Пример"

    === "Python"
        ```python
        from ultralytics import SAM

        # Загрузка модели
        model = SAM('mobile_sam.pt')

        # Предсказание сегмента на основе подсказки в форме прямоугольника
        model.predict('ultralytics/assets/zidane.jpg', bboxes=[439, 437, 524, 709])
        ```

Мы реализовали `MobileSAM` и `SAM` с использованием одного и того же API. Для получения дополнительной информации о использовании, пожалуйста, см. [страницу SAM](sam.md).

## Цитирование и благодарности

Если вы считаете MobileSAM полезным в своей научно-исследовательской или разработочной работе, пожалуйста, рассмотрите возможность цитирования нашей статьи:

!!! Quote ""

    === "BibTeX"

        ```bibtex
        @article{mobile_sam,
          title={Faster Segment Anything: Towards Lightweight SAM for Mobile Applications},
          author={Zhang, Chaoning and Han, Dongshen and Qiao, Yu and Kim, Jung Uk and Bae, Sung Ho and Lee, Seungkyu and Hong, Choong Seon},
          journal={arXiv preprint arXiv:2306.14289},
          year={2023}
        }
