---
comments: true
description: Aprenda sobre as principais tarefas de visão computacional que o YOLOv8 pode realizar, incluindo detecção, segmentação, classificação e estimativa de pose. Entenda seus usos em seus projetos de IA.
keywords: Ultralytics, YOLOv8, Detecção, Segmentação, Classificação, Estimativa de Pose, Framework de IA, Tarefas de Visão Computacional
---

# Tarefas do Ultralytics YOLOv8

<br>
<img width="1024" src="https://raw.githubusercontent.com/ultralytics/assets/main/im/banner-tasks.png" alt="Tarefas suportadas pelo Ultralytics YOLO">

YOLOv8 é um framework de IA que suporta múltiplas tarefas de **visão computacional**. O framework pode ser usado para realizar [detecção](detect.md), [segmentação](segment.md), [classificação](classify.md) e estimativa de [pose](pose.md). Cada uma dessas tarefas tem um objetivo e caso de uso diferente.

!!! Note "Nota"

    🚧 Nossa documentação multilíngue está atualmente em construção e estamos trabalhando para aprimorá-la. Agradecemos sua paciência! 🙏

<p align="center">
  <br>
  <iframe width="720" height="405" src="https://www.youtube.com/embed/NAs-cfq9BDw"
    title="Reprodutor de vídeo do YouTube" frameborder="0"
    allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture; web-share"
    allowfullscreen>
  </iframe>
  <br>
  <strong>Assista:</strong> Explore as Tarefas do Ultralytics YOLO: Detecção de Objetos, Segmentação, Rastreamento e Estimativa de Pose.
</p>

## [Detecção](detect.md)

A detecção é a principal tarefa suportada pelo YOLOv8. Envolve detectar objetos em uma imagem ou quadro de vídeo e desenhar caixas delimitadoras ao redor deles. Os objetos detectados são classificados em diferentes categorias com base em suas características. YOLOv8 pode detectar múltiplos objetos em uma única imagem ou quadro de vídeo com alta precisão e velocidade.

[Exemplos de Detecção](detect.md){ .md-button .md-button--primary}

## [Segmentação](segment.md)

Segmentação é uma tarefa que envolve segmentar uma imagem em diferentes regiões com base no conteúdo da imagem. Cada região recebe um rótulo com base em seu conteúdo. Essa tarefa é útil em aplicações como segmentação de imagens e imagiologia médica. YOLOv8 usa uma variante da arquitetura U-Net para realizar a segmentação.

[Exemplos de Segmentação](segment.md){ .md-button .md-button--primary}

## [Classificação](classify.md)

Classificação é uma tarefa que envolve classificar uma imagem em diferentes categorias. YOLOv8 pode ser usado para classificar imagens com base em seu conteúdo. Utiliza uma variante da arquitetura EfficientNet para realizar a classificação.

[Exemplos de Classificação](classify.md){ .md-button .md-button--primary}

## [Pose](pose.md)

A detecção de pose/pontos-chave é uma tarefa que envolve detectar pontos específicos em uma imagem ou quadro de vídeo. Esses pontos são chamados de keypoints e são usados para rastrear movimento ou estimar poses. YOLOv8 pode detectar keypoints em uma imagem ou quadro de vídeo com alta precisão e velocidade.

[Exemplos de Pose](pose.md){ .md-button .md-button--primary}

## Conclusão

YOLOv8 suporta múltiplas tarefas, incluindo detecção, segmentação, classificação e detecção de keypoints. Cada uma dessas tarefas tem objetivos e casos de uso diferentes. Ao entender as diferenças entre essas tarefas, você pode escolher a tarefa apropriada para sua aplicação de visão computacional.
