---
comments: true
description: वीडियो स्ट्रीम में आवक ट्रेक करने के लिए Ultralytics YOLO का उपयोग कैसे करें। ट्रैकर्स का उपयोग करने और ट्रैकर कॉन्फ़िगरेशन को अनुकूलित करने के लिए गाइड।
keywords: Ultralytics, YOLO, आवक ट्रैकिंग, वीडियो स्ट्रीम, BoT-SORT, ByteTrack, पायथन गाइड, CLI गाइड
---

# Ultralytics YOLO के साथ मल्टी-ऑब्जेक्ट ट्रैकिंग

<img width="1024" src="https://user-images.githubusercontent.com/26833433/243418637-1d6250fd-1515-4c10-a844-a32818ae6d46.png" alt="Multi-object tracking examples">

वीडियो एनालिटिक्स के क्षेत्र में, ऑब्जेक्ट ट्रैकिंग एक महत्वपूर्ण कार्य है जो केवल फ्रेम में वस्तुओं के स्थान और वर्ग की पहचान करने के अलावा वीडियो के प्रगति के साथ-साथ प्रत्येक खोजी गई वस्तु के लिए एक अद्वितीय आईडी बनाए रखता है। इसके अनुप्रयोग हैं असीमित—निगरानी और सुरक्षा से लेकर रियल-टाइम स्पोर्ट्स एनालिटिक्स तक।

## ऑब्जेक्ट ट्रैकिंग के लिए Ultralytics YOLO क्यों चुनें?

Ultralytics ट्रैकरों से उत्पन्न परिणाम मानक ऑब्जेक्ट डिटेक्शन के साथ मेल खाते हैं, लेकिन वीडियो स्ट्रीम में ऑब्जेक्टों को ट्रैक करने और उपयोगी गणना करने में आसान हो जाता है। यहाँ आपको Ultralytics YOLO का उपयोग अपनी ऑब्जेक्ट ट्रैकिंग की जरूरतों के लिए करने की सलाह दी जा रही है:

- **प्रदर्शनशीलता:** सटीकता के मामले में समय-सत्य ही होने के साथ वीडियो स्ट्रीम को प्रक्रिया करें।
- **लचीलापन:** विभिन्न ट्रैकिंग ऍल्गोरिदम और विन्यास पर समर्थन करें।
- **उपयोग करने में आसानी:** झटपट एकीकरण और डिप्लॉय करने के लिए सरल पायथन API और CLI विकल्प।
- **कस्टमाइज़ेबिलिटी:** कस्टम ट्रेन किए गए YOLO मॉडल के साथ उपयोग में आसान, जिससे डोमेन-विशिष्ट एप्लिकेशन में समावेश करना संभव होता है।

<p align="center">
  <br>
  <iframe width="720" height="405" src="https://www.youtube.com/embed/hHyHmOtmEgs?si=VNZtXmm45Nb9s-N-"
    title="YouTube video player" frameborder="0"
    allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture; web-share"
    allowfullscreen>
  </iframe>
  <br>
  <strong>देखें:</strong> Ultralytics YOLOv8 के साथ ऑब्जेक्ट डिटेक्शन और ट्रैकिंग।
</p>

## वास्तविक दुनिया के अनुप्रयोग

|             परिवहन              |          खुदराबाज़ार           |     जलजीवाणुजनित उत्पादन     |
|:-------------------------------:|:-----------------------------:|:----------------------------:|
| ![वाहन ट्रैकिंग][vehicle track] | ![लोग ट्रैकिंग][people track] | ![मछली ट्रैकिंग][fish track] |
|          वाहन ट्रैकिंग          |         लोग ट्रैकिंग          |        मछली ट्रैकिंग         |

## विशेषताएँ एक झलक में

Ultralytics YOLO अपनी ऑब्जेक्ट डिटेक्शन विशेषताओं को बढ़ाकर मज़बूत और बहुमुखी ऑब्जेक्ट ट्रैकिंग प्रदान करता है:

- **रीयल-टाइम ट्रैकिंग:** उच्च फ्रेम दर वाले वीडियो में समयबद्ध रूप से ऑब्जेक्ट्स को ट्रैक करें।
- **एकाधिक ट्रैकर समर्थन:** इस्थापित ट्रैकिंग ऍल्गोरिदमों में से एक चुनें।
- **कस्टमाइज़ेबल ट्रैकर कॉन्फ़िगरेशन:** विभिन्न पैरामीटर्स को समायोजित करके विशेष आवश्यकताओं को पूरा करने के लिए ट्रैकिंग ऍल्गोरिदम को अनुकूलित करें।

## उपलब्ध ट्रैकर्स

Ultralytics YOLO निम्नलिखित ट्रैकिंग ऍल्गोरिदमों का समर्थन करता है। आप इन्हें योग्य YAML कॉन्फ़िगरेशन फ़ाइल (`tracker=tracker_type.yaml`) पारित करके सक्षम कर सकते हैं:

* [BoT-SORT](https://github.com/NirAharon/BoT-SORT) - इस ट्रैकर को सक्षम करने के लिए `botsort.yaml` का उपयोग करें।
* [ByteTrack](https://github.com/ifzhang/ByteTrack) - इस ट्रैकर को सक्षम करने के लिए `bytetrack.yaml` का उपयोग करें।

डिफ़ॉल्ट ट्रैकर BoT-SORT है।

## ट्रैकिंग

वीडियो स्ट्रीम्स पर ट्रैकर चलाने के लिए, YOLOv8n, YOLOv8n-seg और YOLOv8n-pose जैसे प्रशिक्षित Detect, Segment या Pose मॉडल का उपयोग करें।

!!! Example "उदाहरण"

    === "पायथन"

        ```python
        from ultralytics import YOLO

        # एक आधिकारिक या कस्टम मॉडल लोड करें
        model = YOLO('yolov8n.pt')  # एक आधिकारिक Detect मॉडल लोड करें
        model = YOLO('yolov8n-seg.pt')  # एक आधिकारिक Segment मॉडल लोड करें
        model = YOLO('yolov8n-pose.pt')  # एक आधिकारिक Pose मॉडल लोड करें
        model = YOLO('path/to/best.pt')  # एक कस्टम प्रशिक्षित मॉडल लोड करें

        # मॉडल के साथ ट्रैकिंग करें
        results = model.track(source="https://youtu.be/LNwODJXcvt4", show=True)  # डिफ़ॉल्ट ट्रैकर के साथ ट्रैकिंग करें
        results = model.track(source="https://youtu.be/LNwODJXcvt4", show=True, tracker="bytetrack.yaml")  # ByteTrack ट्रैकर के साथ ट्रैकिंग करें
        ```

    === "CLI"

        ```बैश
        # CLI के साथ विभिन्न मॉडल के साथ ट्रैकिंग करें
        योलो ट्रैक मॉडल=yolov8n.pt स्रोत="https://youtu.be/LNwODJXcvt4"  # आधिकारिक डिटेक्ट मॉडल
        योलो ट्रैक मॉडल=yolov8n-seg.pt स्रोत="https://youtu.be/LNwODJXcvt4"  # आधिकारिक सेगमेंट मॉडल
        योलो ट्रैक मॉडल=yolov8n-pose.pt स्रोत="https://youtu.be/LNwODJXcvt4"  # आधिकारिक पोज मॉडल
        योलो ट्रैक मॉडल=path/to/best.pt स्रोत="https://youtu.be/LNwODJXcvt4"  # कस्टम प्रशिक्षित मॉडल

        # ByteTrack ट्रैकर का उपयोग करें
        योलो ट्रैक मॉडल=path/to/best.pt ट्रैकर="bytetrack.yaml"
        ```

ऊपर के उपयोग में उंगलियों के निचले हिस्से के द्वारा ट्रैकिंग उपलब्ध है सभी डिटेक्ट, सेगमेंट और पोज मॉडल्स के लिए जो वीडियो या स्ट्रीमिंग स्रोत पर चला जा सकते हैं।

## कॉन्फ़िगरेशन

### ट्रैकिंग आर्ग्युमेंट्स

ट्रैकिंग कॉन्फ़िगरेशन, जैसे कि `conf`, `iou` और `show`, ने प्रेडिक्शन मोड के साथ गुणों को साझा करता है। और विन्यास करने के लिए, कृपया [प्रेडिक्शन](../modes/predict.md#inference-arguments) मॉडल पृष्ठ पर संदर्भ करें।

!!! Example "उदाहरण"

    === "पायथन"

        ```python
        from ultralytics import YOLO

        # ट्रैकिंग पैरामीटर आवंटन करें और ट्रैकर चलाएं
        model = YOLO('yolov8n.pt')
        results = model.track(source="https://youtu.be/LNwODJXcvt4", conf=0.3, iou=0.5, show=True)
        ```

    === "CLI"

        ```बैश
        # कमांड लाइन इंटरफेस का उपयोग करें ट्रैकिंग पैरामीटर कॉन्फ़िगर करें और ट्रैकर चलाएं
        योलो ट्रैक मॉडल=yolov8n.pt स्रोत="https://youtu.be/LNwODJXcvt4" conf=0.3, iou=0.5 show
        ```

### ट्रैकर चयन

Ultralytics आपको एक संशोधित ट्रैकर कॉन्फ़िगरेशन फ़ाइल का उपयोग करने की भी अनुमति देता है। ऐसा करने के लिए, बस [ultralytics/cfg/trackers](https://github.com/ultralytics/ultralytics/tree/main/ultralytics/cfg/trackers) से एक ट्रैकर कॉन्फ़िगरेशन फ़ाइल (जैसे `custom_tracker.yaml`) की एक प्रतिलिपि बनाएँ और किसी भी विन्यास को संशोधित करें ( `tracker_type` को छोड़कर) अपनी जरूरतों के अनुसार।

!!! Example "उदाहरण"

    === "पायथन"

        ```python
        from ultralytics import YOLO

        # मॉडल लोड करें और एक कस्टम कॉन्फ़िगरेशन फ़ाइल के साथ ट्रैकर चलाएं
        model = YOLO('yolov8n.pt')
        results = model.track(source="https://youtu.be/LNwODJXcvt4", tracker='custom_tracker.yaml')
        ```

    === "CLI"

        ```बैश
        # ट्रैकर के साथ एक कस्टम कॉन्फ़िगरेशन फ़ाइल का उपयोग करके मॉडल लोड करें और ट्रैकर चलाएं
        योलो ट्रैक मॉडल=yolov8n.pt स्रोत="https://youtu.be/LNwODJXcvt4" tracker='custom_tracker.yaml'
        ```

ट्रैकिंग आर्ग्युमेंट्स की एक व्यापक सूची के लिए, [ultralytics/cfg/trackers](https://github.com/ultralytics/ultralytics/tree/main/ultralytics/cfg/trackers) पेज पर संदर्भ करें।

## पायथन उदाहरण

### ट्रैक पर्सिस्ट करना

यहाँ एक Python स्क्रिप्ट है जो OpenCV (`cv2`) और YOLOv8 का उपयोग करके वीडियो फ़्रेम पर ऑब्जेक्ट ट्रैकिंग चलाने के लिए है। इस स्क्रिप्ट में यह मान लिया गया है कि आपने पहले ही आवश्यक पैकेज (`opencv-python` और `ultralytics`) इंस्टॉल कर लिए हैं। `persist=True` आर्ग्युमेंट ये ट्रैकर को बताता है कि मौजूदा इमेज या फ़्रेम उन अनुसरण तथ्यों के लिए होता है जो पिछले इमेज में से बनाए गए होते हैं।

!!! Example "ट्रैकिंग के लिए स्ट्रीमिंग फ़ोर-लूप"

    ```python
    import cv2
    from ultralytics import YOLO

    # YOLOv8 मॉडल लोड करें
    model = YOLO('yolov8n.pt')

    # वीडियो फ़ाइल खोलें
    video_path = "path/to/video.mp4"
    cap = cv2.VideoCapture(video_path)

    # वीडियो फ़्रेम्स पर लूप चलाएं
    while cap.isOpened():
        # वीडियो से एक फ्रेम पढ़ें
        success, frame = cap.read()

        if success:
            # फ्रेम पर YOLOv8 ट्रैकिंग चलाएं, फ़्रेम के बीच ट्रैक पर्सिस्ट करता है
            results = model.track(frame, persist=True)

            # परिणामों को फ़्रेम पर दिखाएं
            annotated_frame = results[0].plot()

            # ट्रैक करें फ़्रेम को प्रदर्शित करें
            cv2.imshow("YOLOv8 ट्रैकिंग", annotated_frame)

            # 'q' दबाएं तो फ़्रेम से बाहर निकलें
            if cv2.waitKey(1) & 0xFF == ord("q"):
                break
        else:
            # वीडियो के अंत तक पहुँचने पर भी फ़्रेम से बाहर निकलें
            break

    # वीडियो कैप्चर ऑब्जेक्ट छोड़ें और प्रदर्शन विंडो बंद करें
    cap.release()
    cv2.destroyAllWindows()
    ```

मैने फ़्रेम से ट्रैकिंग के लिए 'model(frame)' से 'model.track(frame)' में बदलाव किया है, जो साधारण डिटेक्शन की बजाय ऑब्जेक्ट ट्रैकिंग को सक्षम करता है। यह संशोधित स्क्रिप्ट प्रति फ़्रेम वाली वीडियो पर ट्रैकर चलाएगा, परिणामों को दिखाएगा और एक विंडो में दिखाएगा। 'q' दबाने पर फ़्रेम से बाहर निकला जा सकता है।

### समय के साथ ट्रैक चित्रित करना

संबंधित वीडियो फ्रेम पर ऑब्जेक्ट ट्रैक्स को प्लॉट करके समान्तर स्थानीय मार्गों को प्रदर्शित करने से हमें चित्रित पथ के माध्यम से पहले के अंतरालों और पतों की आपूर्ति में मूल्यवान प्रेरणा मिल सकती है। Ultralytics YOLOv8 के साथ समय के साथ ट्रैक्स को प्लॉट करना एक चुस्त और कुशल प्रक्रिया है।

निम्न उदाहरण में, हम दिखाए गए वीडियो फ्रेम्स पर YOLO मॉडल का उपयोग करके विभिन्न ऑब्जेक्ट की गति को चित्रित करने के लिए कैसे करेंगे। यह स्क्रिप्ट एक वीडियो फ़ाइल को खोलता है, फ्रेम दर फ्रेम यह पढ़ता है, और YOLO मॉडल का उपयोग करके विभिन्न ऑब्जेक्ट की पहचान और ट्रैक करता है। पहचान वाले बॉक्स के केंद्रीय प्रांक्तियों को संवेदी करके उन्हें जोड़ते हैं, हम ट्रैक किए गए वस्तुओं द्वारा फ़ालतू की जगहों को चूंकियों का संग्रहित करने के लिए लाइनें खींच सकते हैं।

!!! Example "कई वीडियो फ़्रेम्स पर पथ चित्रित करना"

    ```python
    from collections import defaultdict

    import cv2
    import numpy as np

    from ultralytics import YOLO

    # YOLOv8 मॉडल लोड करें
    model = YOLO('yolov8n.pt')

    # वीडियो फ़ाइल खोलें
    video_path = "path/to/video.mp4"
    cap = cv2.VideoCapture(video_path)

    # ट्रैक इतिहास को संग्रहीत करें
    track_history = defaultdict(lambda: [])

    # वीडियो फ्रेम्स पर लूप चलाएं
    while cap.isOpened():
        # वीडियो से एक फ्रेम पढ़ें
        success, frame = cap.read()

        if success:
            # फ्रेम पर YOLOv8 ट्रैकिंग चलाएं, फ़्रेम के बीच ट्रैक पर्सिस्ट करता है
            results = model.track(frame, persist=True)

            # बॉक्स और ट्रैक आईडी प्राप्त करें
            boxes = results[0].boxes.xywh.cpu()
            track_ids = results[0].boxes.id.int().cpu().tolist()

            # रिज़ल्ट पर विजुअलाइज़ करें
            annotated_frame = results[0].plot()

            # पथ चित्रित करें
            for box, track_id in zip(boxes, track_ids):
                x, y, w, h = box
                track = track_history[track_id]
                track.append((float(x), float(y)))  # x, y centre point
                if len(track) > 30:  # 90 फ़्रेम्स के लिए 90 ट्रैक्स को जमा करें
                    track.pop(0)

                # ट्रैकिंग लाइनें खींचें
                points = np.hstack(track).astype(np.int32).reshape((-1, 1, 2))
                cv2.polylines(annotated_frame, [points], isClosed=False, color=(230, 230, 230), thickness=10)

            # पथ को प्रदर्शित करें
            cv2.imshow("YOLOv8 ट्रैकिंग", annotated_frame)

            # 'q' दबायें तो फ़्रेम से बाहर निकलें
            if cv2.waitKey(1) & 0xFF == ord("q"):
                break
        else:
            # वीडियो के अंत तक पहुँचने पर भी फ़्रेम से बाहर निकलें
            break

    # वीडियो कैप्चर ऑब्जेक्ट छोड़ें और प्रदर्शन विंडो बंद करें
    cap.release()
    cv2.destroyAllWindows()
    ```

### मल्टीथ्रेड ट्रैकिंग

मल्टीथ्रेड ट्रैकिंग एक साथ कई वीडियो स्ट्रीमों पर ऑब्जेक्ट ट्रैकिंग चलाने की क्षमता प्रदान करता है। यह खासकर उपयोगी होता है जब हम कई निगरानी कैमरों से जैसे कि वहां से मौजूद वीडियो इनपुट को संभालने के लिए परस्पर प्रोसेसिंग करने की क्षमता बढ़ा सकते हैं।

प्रदान किए गए पायथन स्क्रिप्ट में हम Python के `threading` मॉड्यूल का उपयोग करके यह संभव करते हैं कि कई इंस्टेंसेज को एक साथ ट्रैकर चलाया जा सके। यह हर थ्रेड के लिए एक ट्रैकर चलाने की जिम्मेदारी होती है, और सभी थ्रेड संघ थ्रेड बैकग्राउंड में एक साथ चलते हैं।

हर थ्रेड को सही पैरामीटर्स (वीडियो फ़ाइल, उपयोग करने के लिए मॉडल और फ़ाइल इंडेक्स) प्राप्त करने के लिए, हम `run_tracker_in_thread` नामक एक फ़ंक्शन को परिभाषित करते हैं जो इन पैरामीटर्स को स्वीकार करता है और मुख्य ट्रैकिंग लूप को संबंधित करता है। यह फ़ंक्शन वीडियो फ्रेम्स को फ्रेम द्वारा पढकर, ट्रैकर चलाने और परिणामों को प्रदर्शित कर रही है।

इस उदाहरण में दो अलग मॉडल इस्तेमाल होते हैं: `yolov8n.pt` और `yolov8n-seg.pt`, जो हर एक अलग वीडियो फ़ाइल में ऑब्जेक्ट को ट्रैक करते हैं। वीडियो फाइल `video_file1` और `video_file2` में निर्दिष्ट किए गए हैं। `threading.Thread` में `daemon=True` विधिमति का उपयोग संकेत करता है कि यह सुनिश्चित करता है कि जब प्रमुख कार्यक्रम समाप्त हो जाए, तो ये सभी थ्रेड बंद हो जाएंगे। हम `start()` का उपयोग करके थ्रेडों को शुरू करते हैं और `join()` का उपयोग करके मुख्य थ्रेड को प्रतीक्षा करने के लिए बनाते हैं जब तक कि ट्रैकर थ्रेड खत्म नहीं हो जाते।

चूंकि सभी थ्रेडों ने अपना कार्य पूरा कर लिया है, इसलिए `cv2.destroyAllWindows()` का उपयोग करके परिणामों को दिखाने वाली विंडो को बंद करते हैं।

!!! Example "ट्रैकिंग के लिए स्ट्रीमिंग फ़ोर-लूप"

    ```python
    import threading
    import cv2
    from ultralytics import YOLO


    def run_tracker_in_thread(filename, model, file_index):
        """
        थ्रेडिंग के साथ YOLOv8 मॉडल के साथ एक वीडियो फ़ाइल या webcam स्रोत संगतरूप पर ट्रैकर चलाता है।

        यह फ़ंक्शन एक वेदनीय वीडियो फ़ाइल या कैमरा स्रोत से वीडियो फ़्रेमों को पकड़ता है और ऑब्जेक्ट ट्रैकिंग के लिए YOLOv8 मॉडल का उपयोग करता है। यह फ़ंक्शन अपनी थ्रेड में चलता है जो कार्य प्रसंस्करण के रूप में एक साथ चलता है।

        Args:
            filename (str): वीडियो फ़ाइल के पथ या कैमरे / बाहरी कैमरे स्रोत का पहचानकर्ता।
            model (obj): YOLOv8 मॉडल ऑब्जेक्ट।
            file_index (int): फ़ाइल को पहचानने के लिए ऐंद्रिक कोड।

        ध्यान दें:
        वीडियो डिस्प्ले विंडो बंद करने के लिए 'q' दबाएं।
        """
        वीडियो = cv2.VideoCapture(filename)  # वीडियो फ़ाइल पढ़ें

        while True:
            सफलता, फ़्रेम = वीडियो.read()  # वीडियो फ़्रेम पढ़ें

            # कोई भी फ़्रेम न बचा हो, तो लूप से बाहर निकलें
            if not सफलता:
                तोड़ो
                तोड़ो

            # ऑब्जेक्ट्स को ट्रैक करें यदि उपलब्ध हों
            results = model.track(फ़्रेम, persist=True)
            res_plotted = results[0].plot()
            cv2.imshow(f"स्रोत_{file_index} पर ट्रैकिंग", res_plotted)

            कुंजी = cv2.waitKey(1)
            if कुंजी == ord('q'):
                तोड़ो

        # वीडियो स्रोतों को छोड़ें
        वीडियो.रिलीज़े()


    # मॉडल लोड करें
    model1 = YOLO('yolov8n.pt')
    model2 = YOLO('yolov8n-seg.pt')

    # ट्रैकर के लिए वीडियो फ़ाइलें परिभाषित करें
    video_file1 = "path/to/video1.mp4"  # वीडियो फ़ाइल का पथ, वेबकैम के लिए 0
    video_file2 = 0  # वीडियो फ़ाइल का पथ, वेबकैम के लिए 0, बाहरी कैमरा के लिए 1

    # ट्रैकर थ्रेड सबसे ऊपर बनाएं
    tracker_thread1 = threading.Thread(target=run_tracker_in_thread, args=(video_file1, model1, 1), daemon=True)
    tracker_thread2 = threading.Thread(target=run_tracker_in_thread, args=(video_file2, model2, 2), daemon=True)

    # ट्रैकर थ्रेड प्रारंभ करें
    tracker_thread1.start()
    tracker_thread2.start()

    # ट्रैकर थ्रेड की प्रतीक्षा करें
    tracker_thread1.join()
    tracker_thread2.join()

    # सभी ट्रैकर थ्रेडों के निपटाए जाने के बाद, परिणामों को प्रदर्शन विंडोज बंद करें
    cv2.destroyAllWindows()
    ```

यह उदाहरण स्क्रिप्ट जोड़कर और इसी मार्गदर्शन का उपयोग करके और अधिक वीडियो फ़ाइल और मॉडल के लिए बाहरी थ्रेड बना कर इसे कार्यान्वित करने के लिए आसानी से विस्तारित किया जा सकता है।

## नए ट्रैकरों में सहयोग दें

क्या आप बहु-ऑब्जेक्ट ट्रैकिंग में माहिर हैं और उल्ट्रालिटिक्स YOLO के साथ एक ट्रैकिंग ऍल्गोरिदम को सफलतापूर्वक अमल में लाया है? हम आपको [ultralytics/cfg/trackers](https://github.com/ultralytics/ultralytics/tree/main/ultralytics/cfg/trackers) में हमारे ट्रैकर खंड के लिए योगदान देने के लिए आमंत्रित करते हैं! आपका वास्तविक दुनिया के अनुप्रयोग और समाधान आपके समुदाय के लिए अमूल्य हो सकते हैं।

इस खंड में योगदान देकर, आप उल्ट्रालिटिक्स YOLO फ्रेमवर्क के भीतर उपलब्ध ट्रैकिंग समाधानों की विस्तारवादी सूची बढ़ा सकते हैं, जो उल्ट्रालिटिक्स YOLO माध्यम से काम कर रहे उपयोगकर्ताओं के लिए अत्यधिक समर्पणशीलता और उपयोगीता जोड़ते हैं।

अपनी योगदान की शुरुआत करने के लिए, कृपया हमारे [योगदान गाइड](https://docs.ultralytics.com/help/contributing) का संदर्भ लें जहां परामर्शिका प्रस्तुत करने के सचेत निर्देश दिए गए हैं। हम इंतजार कर रहे हैं देखें आप क्या लाते हैं!

साथ में, चलिए Ultralytics YOLO पारिस्थितिकी की गतिशीलता को मजबूत करें 🙏!

[वाहन ट्रैकिंग]: https://github.com/RizwanMunawar/ultralytics/assets/62513924/ee6e6038-383b-4f21-ac29-b2a1c7d386ab

[लोग ट्रैकिंग]:  https://github.com/RizwanMunawar/ultralytics/assets/62513924/93bb4ee2-77a0-4e4e-8eb6-eb8f527f0527

[मछली ट्रैकिंग]:    https://github.com/RizwanMunawar/ultralytics/assets/62513924/a5146d0f-bfa8-4e0a-b7df-3c1446cd8142
