---
comments: true
description: FastSAM एक सीएनएन पर आधारित समाधान है जो छवियों में वास्तविक समय ऑब्जेक्ट सेगमेंटेशन के लिए बनाया गया है। यह यूजर इंटरेक्शन, संगणनीय प्रभावशीलता और विजन कार्यों को अनुकूलित करने में सक्षम है।
keywords: FastSAM, machine learning, CNN-based solution, object segmentation, वास्तविक समय का समाधान, Ultralytics, विजन कार्य, छवि प्रोसेसिंग, उद्योगिक अनुप्रयोग, यूजर इंटरैक्शन
---

# Fast Segment Anything Model (FastSAM)

फास्ट सेगमेंट एनीथिंग मॉडल (फास्टएसएएम) एक नवीन, वास्तविक समय में कार्यरत सीएनएन पर आधारित समाधान है जो एनीथिंग टास्क को सेगमेंट करने के लिए बनाया गया है। इस टास्क का उद्देश्य विभिन्न संभावित उपयोक्ता इंटरेक्शन प्रोम्प्ट्स पर आधारित छवियों में किसी भी ऑब्जेक्ट को सेगमेंट करना है। फास्टएसएएम ने संगणनात्मक मांग को कम करते हुए मुकाबले क्षमता को बरकरार रखते हुए संगणकीय मांगों को काफी कम किया है, जिसके कारण यह विभिन्न विजन कार्यों के लिए एक व्यावहारिक विकल्प बनाता है।

![फास्ट सेगमेंट एनीथिंग मॉडल (फास्टएसएएम) आर्किटेक्चर इंट्रो](https://user-images.githubusercontent.com/26833433/248551984-d98f0f6d-7535-45d0-b380-2e1440b52ad7.jpg)

## अवलोकन

FastSAM, [सेगमेंट एनीथिंग मॉडल (एसएएम)](sam.md) की सीमाओं का सामना करने के लिए बनाया गया है, जो एक भारी ट्रांसफॉर्मर मॉडल है और उचित संसाधन आवश्यकताओं को है। फास्टएसएएम ने सार्वभौमिक चरणों में सेगमेंट एनीथिंग टास्क को अलग-अलग दो साँप्रदायिक चरणों में अलग किया है: सभी इंस्टेंस सेगमेंटेशन और प्रॉम्प्ट-गाइडेड चयन। पहले चरण में, यह [व्योलोवी8-सेग](../tasks/segment.md) का उपयोग करके छवि में सभी इंस्टेंस की सेगमेंटेशन मास्क उत्पन्न करता है। दूसरे चरण में, यह प्रोम्प्ट के बराबर क्षेत्र-ऑफ-इंटरेस्ट को आउटपुट करता है।

## प्रमुख सुविधाएं

1. **वास्तविक समय का समाधान:** सीएनएन की संगणनात्मक प्रभावशीलता का उपयोग करके, फास्टएसएएम एनीथिंग टास्क के लिए वास्तविक समय समाधान प्रदान करता है, जिससे यह उद्योगिक अनुप्रयोगों के लिए महत्वपूर्ण परिणामों की आवश्यकता होती है।

2. **प्रदार्थी और प्रदर्शन क्षमता:** फास्टएसएएम संगणनात्मक और संसाधन मांग में काफी कमी प्रदान करता है बिना प्रदर्शन गुणवत्ता पर कुछ बदले के। यह संसाधनों की बहुत अधिक कमी के साथ एसएएम के लगभग तुलनात्मक प्रदर्शन प्राप्त करता है, जिससे वास्तविक समय अनुप्रयोग संभव होता है।

3. **प्रोम्प्ट-गाइडेड सेगमेंटेशन:** फास्टएसएएम कई संभावित उपयोक्ता इंटरेक्शन प्रोम्प्ट्स द्वारा निर्दिष्ट छवि में किसी भी ऑब्जेक्ट को सेगमेंट कर सकता है, जो विभिन्न परिस्थितियों में लचीलापूर्णता और अनुकूलन प्रदान करता है।

4. **व्योलोवी8-सेग पर आधारित:** फास्टएसएएम [व्योलोवी8-सेग](../tasks/segment.md) पर आधारित है, जो एक ऑब्जेक्ट डिटेक्टर है जिसमें एक इंस्टेंस सेगमेंटेशन टास्क है। इससे यह संभव होता है कि यह छवि में सभी इंस्टेंस की सेगमेंटेशन मास्क प्रभावी ढंग से उत्पन्न करें।

5. **बेंचमार्क पर प्रतिस्पर्धी परिणाम:** MS COCO पर ऑब्जेक्ट प्रासलन टास्क पर, फास्टएसएएम एकल NVIDIA RTX 3090 पर [एसएएम](sam.md) की तुलना में काफी तेज गति में उच्च अंक प्राप्त करता है, जो इसकी प्रभावशीलता और क्षमता को दिखाता है।

6. **वास्तविक अनुप्रयोग:** प्रस्तावित दृष्टांत एक नए, वास्तविक समय में कई विजन कार्यों के लिए एक नया, व्यावहारिक समाधान प्रदान करता है, जिसमें मौजूदा विधियों से कई या सौ गुना तेज तरीके से किया जाता है।

7. **मॉडल संक्षिप्ति क्षमता:** फास्टएसएएम ने प्रवेशी अभिकरण के लिए एक कृत्रिम प्राथमिकता को संरचना में परिचय कराने के द्वारा कंप्यूटेशनल प्रयास को काफी कम करने की संभावना दिखाई है, इस प्रकार सामान्य विजन कार्यों के लिए बड़े मॉडल आर्किटेक्चर के लिए नए संभावनाओं को खोलती है।

## उपलब्ध मॉडल, समर्थित कार्य और ऑपरेटिंग मोड

इस सारणी में उपलब्ध मॉडल, उनके विशिष्ट पूर्व-प्रशिक्षित वेट और उनके समर्थनित कार्यों को पेश किया गया है, साथ ही उनकी विभिन्न ऑपरेटिंग मोड के साथ संगतता को दर्शाने के लिए समर्थित मोजी में ✅ इमोज़ी और असमर्थित मोजी में ❌ इमोज़ी लगाए गए हैं।

| मॉडल प्रकार     | पूर्व-प्रशिक्षित वेट्स | समर्थित कार्य                              | भावना | मान्यीकरण | प्रशिक्षण | निर्यात |
|-----------------|------------------------|--------------------------------------------|-------|-----------|-----------|---------|
| फास्टएसएएम-एस   | `FastSAM-s.pt`         | [इंस्टेंस सेगमेंटेशन](../tasks/segment.md) | ✅     | ❌         | ❌         | ✅       |
| फास्टएसएएम-एक्स | `FastSAM-x.pt`         | [इंस्टेंस सेगमेंटेशन](../tasks/segment.md) | ✅     | ❌         | ❌         | ✅       |

## उपयोग के उदाहरण

फास्टएसएएम मॉडल को अपने पायथन ऐप्लिकेशन में आसानी से एकीकृत करना आसान है। उल्ट्राल्याटिक्स उपयोगकर्ता-मित्रपूर्ण पायथन API और CLI कमांड्स प्रदान करता है ताकि विकास को सरल बनाया जा सके।

### पूर्वानुमान उपयोग

एक छवि पर ऑब्जेक्ट डिटेक्शन करने के लिए, नीचे दिए गए उदाहरण का उपयोग करें:

!!! Example "उदाहरण"

    === "पायथन"
        ```python
        from ultralytics import FastSAM
        from ultralytics.models.fastsam import FastSAMPrompt

        # एक inference source निर्धारित करें
        source = 'path/to/bus.jpg'

        # एक फास्टएसएएम मॉडल बनाएं
        model = FastSAM('FastSAM-s.pt')  # या FastSAM-x.pt

        # छवि पर inference चलाएं
        everything_results = model(source, device='cpu', retina_masks=True, imgsz=1024, conf=0.4, iou=0.9)

        # प्रोम्प्ट प्रक्रिया वस्तु को तैयार करें
        prompt_process = FastSAMPrompt(source, everything_results, device='cpu')

        # सब कुछ प्रोम्प्ट
        ann = prompt_process.everything_prompt()

        # बॉक्स डिफ़ॉल्टवत आकार [0,0,0,0] -> [x1,y1,x2,y2]
        ann = prompt_process.box_prompt(bbox=[200, 200, 300, 300])

        # पाठ प्रोम्प्ट
        ann = prompt_process.text_prompt(text='a photo of a dog')

        # पॉइंट प्रोम्प्ट
        # डिफ़ॉल्ट point [[0,0]] [[x1,y1],[x2,y2]]
        # डिफ़ॉल्ट point_label [0] [1,0] 0:background, 1:foreground
        ann = prompt_process.point_prompt(points=[[200, 200]], pointlabel=[1])
        prompt_process.plot(annotations=ann, output='./')
        ```

    === "CLI"
        ```bash
        # शीघ्रदर्शन मॉडल को लोड करें और उसे कुछ वस्तुओं के साथ सेगमेंट करें
        yolo segment predict model=FastSAM-s.pt source=path/to/bus.jpg imgsz=640
        ```

यह स्निपेट प्रशिक्षित मॉडल को लोड करने और एक इमेज पर प्रभासिती का निर्धारण करने की सरलता का दिखावा करता है।

### वैल उपयोग

एक डेटासेट पर मॉडल की मान्यीकरण करने के लिए निम्नलिखित तरीके का उपयोग किया जा सकता है:

!!! Example "उदाहरण"

    === "पायथन"
        ```python
        from ultralytics import FastSAM

        # एक फास्टएसएएम मॉडल बनाएं
        model = FastSAM('FastSAM-s.pt')  # या FastSAM-x.pt

        # मॉडल को मान्यित करें
        results = model.val(data='coco8-seg.yaml')
        ```

    === "CLI"
        ```bash
        # शीघ्रदर्शन मॉडल को लोड करें और इसे साइज़ 640 पर COCO8 उदाहरण डेटासेट पर मान्यित करें
        yolo segment val model=FastSAM-s.pt data=coco8.yaml imgsz=640
        ```

कृपया ध्यान दें कि फास्टएसएएम केवल एकल वस्तु कार और सेगमेंटेशन का समर्थन करता है। इसका मतलब है कि यह सभी ऑब्जेक्टों को एक ही वर्ग के रूप में मान्यता देगा और सभी ऑब्जेक्ट्स को एक ही वर्ग के रूप में सेगमेंट करेगा। इसलिए, डेटासेट को तैयार करते समय, आपको सभी ऑब्जेक्ट श्रेणी आईडी को 0 में रूपांतरित करने की आवश्यकता होगी।

## फास्टएसएएम आधिकारिक उपयोग

फास्टएसएएम को [https://github.com/CASIA-IVA-Lab/FastSAM](https://github.com/CASIA-IVA-Lab/FastSAM) रिपॉजिटरी से सीधे भी उपयोग किया जा सकता है। यहां आपको फास्टएसएएम का उपयोग करने के लिए आमतौर पर लिए जाने वाले कदमों का संक्षेपिक अवलोकन है:

### स्थापना

1. फास्टएसएएम रिपॉजिटरी क्लोन करें:
   ```शेल
   git clone https://github.com/CASIA-IVA-Lab/FastSAM.git
   ```

2. पायथन 3.9 के साथ एक रुपे में संचालित करने के लिए एक Conda वातावरण बनाएं और सक्रिय करें:
   ```शेल
   conda create -n FastSAM python=3.9
   conda activate FastSAM
   ```

3. क्लोन किए गए रिपॉजिटरी में जाएं और आवश्यक पैकेजों को स्थापित करें:
   ```शेल
   cd FastSAM
   pip install -r requirements.txt
   ```

4. CLIP मॉडल स्थापित करें:
   ```शेल
   pip install git+https://github.com/openai/CLIP.git
   ```

### उदाहरण उपयोग

1. [मॉडल चेकपॉइंट](https://drive.google.com/file/d/1m1sjY4ihXBU1fZXdQ-Xdj-mDltW-2Rqv/view?usp=sharing)डाउनलोड करें।

2. FastSAM का उपयोग करके इंफरेंस करें। उदाहरण कमांड:

    - छवि में सब कुछ सेगमेंट करें:
      ```शेल
      python Inference.py --model_path ./weights/FastSAM.pt --img_path ./images/dogs.jpg
      ```

    - पाठ प्रोम्प्ट का उपयोग करके विशेष ऑब्जेक्ट सेगमेंट करें:
      ```शेल
      python Inference.py --model_path ./weights/FastSAM.pt --img_path ./images/dogs.jpg --text_prompt "the yellow dog"
      ```

    - एक बाउंडिंग बॉक्स के भीतर बाउंडर ऑब्जेक्ट को सेगमेंट करें (xywh स्वरूप में बॉक्स की कोणयों की निर्धारण करें):
      ```शेल
      python Inference.py --model_path ./weights/FastSAM.pt --img_path ./images/dogs.jpg --box_prompt "[570,200,230,400]"
      ```

    - विशेष बिंदुओं के पास ऑब्जेक्ट को सेगमेंट करें:
      ```शेल
      python Inference.py --model_path ./weights/FastSAM.pt --img_path ./images/dogs.jpg --point_prompt "[[520,360],[620,300]]" --point_label "[1,0]"
      ```

इसके अलावा, आप फास्टएसएएम का उपयोग करने के लिए एक [कोलैब डेमो](https://colab.research.google.com/drive/1oX14f6IneGGw612WgVlAiy91UHwFAvr9?usp=sharing) या एक [हगिंगफेस वेब डेमो](https://huggingface.co/spaces/An-619/FastSAM) पर भी प्रयास कर सकते हैं।

## उद्धृति और प्रशंसापत्र

हम वास्तविक समय आवंटन संबंधी क्षेत्र में महत्वपूर्ण योगदान देने के लिए फास्टएसएएम लेखकों को प्रशंसा करते हैं:

!!! Quote ""

    === "बिबटेक्स्ट"

      ```बिबटेक्स्ट
      @misc{zhao2023fast,
            title={Fast Segment Anything},
            author={Xu Zhao and Wenchao Ding and Yongqi An and Yinglong Du and Tao Yu and Min Li and Ming Tang and Jinqiao Wang},
            year={2023},
            eprint={2306.12156},
            archivePrefix={arXiv},
            primaryClass={cs.CV}
      }
      ```

[FastSAM](https://arxiv.org/abs/2306.12156) पेपर आरएक्सिव में मौजूद है। लेखकों ने अपना काम सार्वजनिक रूप से उपलब्ध कराया है, और कोडबेस [गिटहब](https://github.com/CASIA-IVA-Lab/FastSAM) पर उपलब्ध है। हम इन दोनों के प्रयासों की कीमत करते हैं और उनके प्रयास के लिए धन्यवाद देते हैं जो क्षेत्र को आगे बढ़ाने और अपने काम को व्यापक समुदाय के लिए उपलब्ध कराने में समर्थ हैं।
