---
comments: true
description: Erfahren Sie, welche grundlegenden Aufgaben im Bereich der Computer Vision YOLOv8 durchführen kann, einschließlich Erkennung, Segmentierung, Klassifizierung und Haltungsschätzung, und wie sie in Ihren KI-Projekten verwendet werden können.
keywords: Ultralytics, YOLOv8, Erkennung, Segmentierung, Klassifizierung, Pose-Schätzung, KI-Framework, Computer Vision-Aufgaben
---

# Ultralytics YOLOv8 Aufgaben

<br>
<img width="1024" src="https://raw.githubusercontent.com/ultralytics/assets/main/im/banner-tasks.png" alt="Ultralytics YOLO unterstützte Aufgaben">

YOLOv8 ist ein KI-Framework, das mehrere Aufgaben im Bereich der Computer Vision **unterstützt**. Das Framework kann für die [Erkennung](detect.md), [Segmentierung](segment.md), [Klassifizierung](classify.md) und die [Pose](pose.md)-Schätzung verwendet werden. Jede dieser Aufgaben hat ein unterschiedliches Ziel und Anwendungsgebiete.

!!! Note "Hinweis"

    🚧 Unsere mehrsprachigen Dokumentation befindet sich derzeit im Aufbau und wir arbeiten hart daran, sie zu verbessern. Danke für Ihre Geduld! 🙏

<p align="center">
  <br>
  <iframe width="720" height="405" src="https://www.youtube.com/embed/NAs-cfq9BDw"
    title="YouTube video player" frameborder="0"
    allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture; web-share"
    allowfullscreen>
  </iframe>
  <br>
  <strong>Schauen Sie zu:</strong> Entdecken Sie Ultralytics YOLO Aufgaben: Objekterkennung, Segmentierung, Verfolgung und Pose-Schätzung.
</p>

## [Erkennung](detect.md)

Erkennung ist die primäre von YOLOv8 unterstützte Aufgabe. Sie beinhaltet das Erkennen von Objekten in einem Bild oder Videobild und das Zeichnen von Rahmen um sie herum. Die erkannten Objekte werden anhand ihrer Merkmale in verschiedene Kategorien klassifiziert. YOLOv8 kann mehrere Objekte in einem einzelnen Bild oder Videobild mit hoher Genauigkeit und Geschwindigkeit erkennen.

[Beispiele für Erkennung](detect.md){ .md-button .md-button--primary}

## [Segmentierung](segment.md)

Segmentierung ist eine Aufgabe, die das Aufteilen eines Bildes in unterschiedliche Regionen anhand des Bildinhalts beinhaltet. Jeder Region wird basierend auf ihrem Inhalt eine Markierung zugewiesen. Diese Aufgabe ist nützlich in Anwendungen wie der Bildsegmentierung und medizinischen Bildgebung. YOLOv8 verwendet eine Variante der U-Net-Architektur, um die Segmentierung durchzuführen.

[Beispiele für Segmentierung](segment.md){ .md-button .md-button--primary}

## [Klassifizierung](classify.md)

Klassifizierung ist eine Aufgabe, die das Einordnen eines Bildes in verschiedene Kategorien umfasst. YOLOv8 kann genutzt werden, um Bilder anhand ihres Inhalts zu klassifizieren. Es verwendet eine Variante der EfficientNet-Architektur, um die Klassifizierung durchzuführen.

[Beispiele für Klassifizierung](classify.md){ .md-button .md-button--primary}

## [Pose](pose.md)

Die Pose-/Keypoint-Erkennung ist eine Aufgabe, die das Erkennen von spezifischen Punkten in einem Bild oder Videobild beinhaltet. Diese Punkte werden als Keypoints bezeichnet und werden zur Bewegungsverfolgung oder Pose-Schätzung verwendet. YOLOv8 kann Keypoints in einem Bild oder Videobild mit hoher Genauigkeit und Geschwindigkeit erkennen.

[Beispiele für Posen](pose.md){ .md-button .md-button--primary}

## Fazit

YOLOv8 unterstützt mehrere Aufgaben, einschließlich Erkennung, Segmentierung, Klassifizierung und Keypoint-Erkennung. Jede dieser Aufgaben hat unterschiedliche Ziele und Anwendungsgebiete. Durch das Verständnis der Unterschiede zwischen diesen Aufgaben können Sie die geeignete Aufgabe für Ihre Anwendung im Bereich der Computer Vision auswählen.
