---
comments: true
description: دليل خطوة بخطوة لتدريب نماذج YOLOv8 باستخدام Ultralytics YOLO بما في ذلك أمثلة على التدريب باستخدام بطاقة رسومات منفصلة ومتعددة البطاقات الرسومية
keywords: Ultralytics، YOLOv8، YOLO، كشف الكائنات، وضع تدريب، مجموعة بيانات مخصصة، تدريب بطاقة رسومات، متعددة البطاقات الرسومية، معلمات تكبير، أمثلة سطر الأوامر، أمثلة بايثون
---

# تدريب النموذج باستخدام Ultralytics YOLO

<img width="1024" src="https://github.com/ultralytics/assets/raw/main/yolov8/banner-integrations.png" alt="بيئة ومدمجات Ultralytics YOLO">

## المقدمة

يتضمن تدريب نموذج التعلم العميق تزويده بالبيانات وضبط معلماته بحيث يتمكن من إجراء توقعات دقيقة. يتم تصميم وضع التدريب في Ultralytics YOLOv8 لتدريب فعال وفعال لنماذج كشف الكائنات، مستغلاً تمامًا إمكانات الأجهزة الحديثة. يهدف هذا الدليل إلى شرح جميع التفاصيل التي تحتاج إلى البدء في تدريب النماذج الخاصة بك باستخدام مجموعة متينة من ميزات YOLOv8.

<p align="center">
  <br>
  <iframe width="720" height="405" src="https://www.youtube.com/embed/LNwODJXcvt4?si=7n1UvGRLSd9p5wKs"
    title="مشغل فيديو YouTube" frameborder="0"
    allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture; web-share"
    allowfullscreen>
  </iframe>
  <br>
  <strong>شاهد:</strong> كيفية تدريب نموذج YOLOv8 على مجموعة البيانات المخصصة الخاصة بك في Google Colab.
</p>

## لماذا اختيار Ultralytics YOLO للتدريب؟

إليك بعض الأسباب المقنعة لاختيار وضع التدريب في YOLOv8:

- **الكفاءة:** استفد إلى أقصى حد من الأجهزة الخاصة بك، سواء كنت تستخدم بطاقة رسومات واحدة أو توسيعها عبر عدة بطاقات رسومات.
- **تعدد الاستخدامات:** قم بالتدريب على مجموعات البيانات المخصصة بالإضافة إلى المجموعات المتاحة بسهولة مثل COCO و VOC و ImageNet.
- **سهل الاستخدام:** واجهة سطر الأوامر CLI وواجهة Python البسيطة والقوية لتجربة تدريب مباشرة.
- **مرونة المعلمات:** مجموعة واسعة من المعلمات القابلة للتخصيص لضبط أداء النموذج.

### الميزات الرئيسية لوضع التدريب

تتمثل الميزات البارزة لوضع التدريب في YOLOv8 في ما يلي:

- **تنزيل مجموعة البيانات تلقائيًا:** تقوم مجموعات البيانات القياسية مثل COCO و VOC و ImageNet بالتنزيل تلقائيًا عند أول استخدام.
- **دعم متعدد البطاقات الرسومية:** قم بتوزيع العمليات التدريبية بسلاسة عبر عدة بطاقات رسومات لتسريع العملية.
- **ضبط المعلمات:** الخيار لتعديل المعلمات التكبير من خلال ملفات تكوين YAML أو وسائط سطر الأوامر.
- **مراقبة وتتبع:** تتبع في الوقت الفعلي لمقاييس التدريب وتصور عملية التعلم لتحقيق رؤى أفضل.

!!! Example "نصيحة"

    * يتم تنزيل مجموعات YOLOv8 القياسية مثل COCO و VOC و ImageNet وغيرها تلقائيًا عند الاستخدام الأول، على سبيل المثال: `yolo train data=coco.yaml`

## أمثلة استخدام

تدريب YOLOv8n على مجموعة بيانات COCO128 لمدة 100 حقبة بحجم صورة 640. يمكن تحديد جهاز التدريب باستخدام الوسيطة `device`. إذا لم يتم تمرير وسيطة، سيتم استخدام الجهاز بطاقة الرسومات "device=0" إذا كانت متاحة، وإلا سيتم استخدام `device=cpu`. استعرض الجدول الزمني أدناه للحصول على قائمة كاملة بوسائط التدريب.

!!! Example "أمثلة سطر الأوامر للتدريب باستخدام بطاقة رسومات مستقلة ومعالج مركزي"

    يتم تحديد الجهاز تلقائيًا. إذا كانت بطاقة رسومات متاحة، سيتم استخدامها، وإلا ستبدأ التدريب على المعالج المركزي.

    === "بايثون"
        ```python
        from ultralytics import YOLO

        # تحميل النموذج
        model = YOLO('yolov8n.yaml')  # إنشاء نموذج جديد من ملف YAML
        model = YOLO('yolov8n.pt')  # تحميل نموذج مدرب مسبقًا (الأكثر توصية للتدريب)
        model = YOLO('yolov8n.yaml').load('yolov8n.pt')  # إنشاء من ملف YAML ونقل الأوزان

        # تدريب النموذج
        results = model.train(data='coco128.yaml', epochs=100, imgsz=640)
        ```

    === "سطر الأوامر"
        ```bash
        # إنشاء نموذج جديد من ملف YAML وبدء التدريب من البداية
        yolo detect train data=coco128.yaml model=yolov8n.yaml epochs=100 imgsz=640

        # بدء التدريب من نموذج *.pt مدرب مسبقًا
        yolo detect train data=coco128.yaml model=yolov8n.pt epochs=100 imgsz=640

        # إنشاء نموذج جديد من ملف YAML ونقل الأوزان المدربة مسبقًا وبدء التدريب
        yolo detect train data=coco128.yaml model=yolov8n.yaml pretrained=yolov8n.pt epochs=100 imgsz=640
        ```

### التدريب متعدد البطاقات الرسومية

يتيح التدريب متعدد البطاقات الرسومية استخدام الموارد الأجهزة المتاحة بكفاءة أكبر من خلال توزيع أعباء التدريب عبر عدة بطاقات رسومية. هذه الميزة متاحة من خلال واجهة برمجة التطبيقات باستخدام Python وسطر الأوامر. لتمكين التدريب متعدد البطاقات الرسومية، حدد معرفات أجهزة GPU التي ترغب في استخدامها.

!!! Example "أمثلة على التدريب متعدد البطاقات الرسومية"

    للتدريب باستخدام أجهزتي GPU، جهاز CUDA 0 و 1، استخدم الأوامر التالية. قم بتوسيعها لاستخدام المزيد من البطاقات.

    === "بايثون"
        ```python
        from ultralytics import YOLO

        # تحميل النموذج
        model = YOLO('yolov8n.pt')  # تحميل نموذج مدرب مسبقًا (الأكثر توصية للتدريب)

        # تدريب النموذج بأجهزة GPU 2
        results = model.train(data='coco128.yaml', epochs=100, imgsz=640, device=[0, 1])
        ```

    === "سطر الأوامر"
        ```bash
        # بدء التدريب من نموذج *.pt مدرب مسبقًا باستخدام بطاقات GPU 0 و 1
        yolo detect train data=coco128.yaml model=yolov8n.pt epochs=100 imgsz=640 device=0,1
        ```

### التدريب باستخدام Apple M1 و M2 MPS

مع دعم شرائح Apple M1 و M2 المدمج في نماذج Ultralytics YOLO، يمكنك الآن تدريب نماذجك على الأجهزة التي تستخدم نظام Metal Performance Shaders (MPS) القوي. يوفر MPS طريقة عالية الأداء لتنفيذ المهام الحسابية ومعالجة الصور على شرائح السيليكون المخصصة لعبة Apple.

لتمكين التدريب على شرائح Apple M1 و M2، يجب عليك تحديد "mps" كجهازك عند بدء عملية التدريب. فيما يلي مثال لكيفية القيام بذلك في بايثون وعبر سطر الأوامر:

!!! Example "مثال على التدريب بواسطة MPS"

    === "بايثون"
        ```python
        from ultralytics import YOLO

        # تحميل النموذج
        model = YOLO('yolov8n.pt')  # تحميل نموذج مدرب مسبقًا (الأكثر توصية للتدريب)

        # تدريب النموذج باستخدام 2 بطاقات GPU
        results = model.train(data='coco128.yaml', epochs=100, imgsz=640, device='mps')
        ```

    === "سطر الأوامر"
        ```bash
        # بدء التدريب من نموذج *.pt مدرب مسبقًا باستخدام بطاقات GPU 0 و 1
        yolo detect train data=coco128.yaml model=yolov8n.pt epochs=100 imgsz=640 device=mps
        ```

عند الاستفادة من قدرة المعالجة الحاسوبية لشرائح M1/M2، يتيح لك هذا الحمل أداءً أكثر كفاءة لمهام التدريب. للحصول على إرشادات أكثر تفصيلاً وخيارات تكوين متقدمة، يرجى الرجوع إلى [وثائق PyTorch MPS](https://pytorch.org/docs/stable/notes/mps.html).

### استئناف التدريب المقطوع

يعتبر استئناف التدريب من الحالات التخزين السابقة ميزة حاسمة عند العمل مع نماذج التعلم العميق. يمكن أن يكون هذا مفيدًا في العديد من السيناريوهات، مثل عند تعطل عملية التدريب بشكل غير متوقع، أو عند الرغبة في متابعة تدريب نموذج بيانات جديدة أو لفترة زمنية أطول.

عند استئناف التدريب، يقوم Ultralytics YOLO بتحميل الأوزان من آخر نموذج محفوظ وأيضًا استعادة حالة المحسن، وجدولة معدل التعلم، وعدد الحقبة. هذا يتيح لك متابعة عملية التدريب بشكل سلس من حيث توقفت.

يمكنك بسهولة استئناف التدريب في Ultralytics YOLO عن طريق تعيين الوسيطة `resume` إلى `True` عند استدعاء طريقة `train`، وتحديد المسار إلى ملف `.pt` الذي يحتوي على أوزان النموذج المدرب جزئيًا.

فيما يلي مثال لكيفية استئناف تدريب مقطوع باستخدام بايثون وعبر سطر الأوامر:

!!! Example "مثال على استئناف التدريب"

    === "بايثون"
        ```python
        from ultralytics import YOLO

        # تحميل النموذج
        model = YOLO('path/to/last.pt')  # تحميل نموذج مدرب جزئيًا

        # استئناف التدريب
        results = model.train(resume=True)
        ```

    === "سطر الأوامر"
        ```bash
        # استئناف تدريب متقطع
        yolo train resume model=path/to/last.pt
        ```

من خلال تعيين `resume=True`، ستواصل وظيفة 'train' التدريب من حيث توقفت، باستخدام الحالة المخزنة في ملف 'path/to/last.pt'. إذا تم حذف الوسيطة `resume` أو تعيينها على `False`، ستبدأ وظيفة 'train' جلسة تدريب جديدة.

تذكر أنه يتم حفظ نقاط التفتيش في نهاية كل حقبة افتراضياً، أو في فترة ثابتة باستخدام وسيطة 'save_period'، لذا يجب عليك إتمام حقبة واحدة على الأقل لاستئناف تشغيل تدريب.

## الوسائط

تتعلق إعدادات التدريب لنماذج YOLO بالمعلمات والتكوينات المختلفة المستخدمة لتدريب النموذج على مجموعة بيانات ما. يمكن أن تؤثر هذه الإعدادات على أداء النموذج وسرعته ودقته. تتضمن بعض إعدادات YOLO التدريب الشائعة حجم الدُفعات، معدل التعلم، الزخم، والتقليل القيمي للأوزان. العوامل الأخرى التي قد تؤثر في عملية التدريب تشمل اختيار المحسن، اختيار دالة الخسارة، وحجم وتركيب مجموعة البيانات التدريب. من المهم ضبط وتجربة هذه الإعدادات بعناية لتحقيق أفضل أداء ممكن لمهمة معينة.

| المفتاح           | القيمة   | الوصف                                                                                                                     |
|-------------------|----------|---------------------------------------------------------------------------------------------------------------------------|
| `model`           | `None`   | مسار إلى ملف النموذج، على سبيل المثال yolov8n.pt، yolov8n.yaml                                                            |
| `data`            | `None`   | مسار إلى ملف البيانات، على سبيل المثال coco128.yaml                                                                       |
| `epochs`          | `100`    | عدد الحقب للتدريب ل                                                                                                       |
| `patience`        | `50`     | حقب للانتظار بدون تحسن ظاهر لإيقاف التدريب مبكرا                                                                          |
| `batch`           | `16`     | عدد الصور في كل دُفعة (-1 for AutoBatch)                                                                                  |
| `imgsz`           | `640`    | حجم الصور الدخل بصورة مثالية                                                                                              |
| `save`            | `True`   | حال إنقاذ النقاط المفتوحة للتدريب ونتائج الكشف                                                                            |
| `save_period`     | `-1`     | حفظ النقطة الفاصلة كل x حقبة (تكون معطلة إذا كانت < 1)                                                                    |
| `cache`           | `False`  | صحيح / ذاكرة عشوائية أو قرص / غير صحيح. استخدم ذاكرة التخزين المؤقت في تحميل البيانات                                     |
| `device`          | `None`   | الجهاز لتشغيل التدريب عليه، على سبيل المثال جهاز الرسومات cuda=0 أو جهاز الرسومات cuda=0,1,2,3 أو جهاز المعالج المركزيcpu |
| `workers`         | `8`      | عدد خيوط العاملة لتحميل البيانات (لكل RANK إذا كان DDP)                                                                   |
| `project`         | `None`   | اسم المشروع                                                                                                               |
| `name`            | `None`   | اسم التجربة                                                                                                               |
| `exist_ok`        | `False`  | ما إذا كان سيتم الكتابة فوق تجربة موجودة                                                                                  |
| `pretrained`      | `True`   | (bool أو str) ما إذا كان سيتم استخدام نموذج متدرب مسبقًا (bool) أو نموذج لتحميل الأوزان منه (str)                         |
| `optimizer`       | `'auto'` | المحسن لاستخدامه، الخيارات=[SGD، Adam، Adamax، AdamW، NAdam، RAdam، RMSProp، Auto]                                        |
| `verbose`         | `False`  | ما إذا كان سيتم طباعة مخرجات مفصلة                                                                                        |
| `seed`            | `0`      | البذرة العشوائية لإعادة الإنتاجية                                                                                         |
| `deterministic`   | `True`   | ما إذا كان يتم تمكين الوضع المحدد                                                                                         |
| `single_cls`      | `False`  | يجب تدريب بيانات متعددة الفئات كفئة واحدة                                                                                 |
| `rect`            | `False`  | تدريب مستطيل باستخدام تجميع الدُفعات للحد الأدنى من الحشو                                                                 |
| `cos_lr`          | `False`  | استخدم جدولة معدل التعلم بتوقيت الكوسا                                                                                    |
| `close_mosaic`    | `10`     | (int) تعطيل التكبير التجانبي للحجم للحقب النهائية (0 للتعطيل)                                                             |
| `resume`          | `False`  | استأنف التدريب من النقطة الأخيرة                                                                                          |
| `amp`             | `True`   | تدريب دقة مختلطة تلقائية (AMP)، الخيارات=[True، False]                                                                    |
| `fraction`        | `1.0`    | نسبة مجموعة البيانات المراد تدريبها (الافتراضي هو 1.0، جميع الصور في مجموعة التدريب)                                      |
| `profile`         | `False`  | قم بتشغيل بروفايل السرعة لمشغلات ONNX و TensorRT أثناء التدريب للمسجلات                                                   |
| `freeze`          | `None`   | (int أو list، اختياري) تجميد أول n طبقة، أو قائمة طبقات الفهرس خلال التدريب                                               |
| `lr0`             | `0.01`   | معدل التعلم الأولي (على سبيل المثال SGD=1E-2، Adam=1E-3)                                                                  |
| `lrf`             | `0.01`   | معدل التعلم النهائي (lr0 * lrf)                                                                                           |
| `momentum`        | `0.937`  | الزخم SGD / Adam beta1                                                                                                    |
| `weight_decay`    | `0.0005` | تقليل الأوزان للمحسن (5e-4)                                                                                               |
| `warmup_epochs`   | `3.0`    | حقب الاحماء (الأجزاء المئوية مقبولة)                                                                                      |
| `warmup_momentum` | `0.8`    | الزخم الأولي للتدفق الأعلى                                                                                                |
| `warmup_bias_lr`  | `0.1`    | نسبة تعلم الانحياز الأولي للتدفق العلوي                                                                                   |
| `box`             | `7.5`    | وزن فاقد الصندوق                                                                                                          |
| `cls`             | `0.5`    | وزن فاقد التصنيف (تناسب مع البكسل)                                                                                        |
| `dfl`             | `1.5`    | وزن الخسارة الأمامية للتصنيف والصندوق                                                                                     |
| `pose`            | `12.0`   | وزن فاقد الوضع (الوضع فقط)                                                                                                |
| `kobj`            | `2.0`    | وزن فاقد نقطة المفتاح (الوضع فقط)                                                                                         |
| `label_smoothing` | `0.0`    | التسوية الغموض (كسر)                                                                                                      |
| `nbs`             | `64`     | حجم الدُفعة الاسمي                                                                                                        |
| `overlap_mask`    | `True`   | التحجيم يجب أن يتداخل أقنعة التدريب (التدريب الفصلي فقط)                                                                  |
| `mask_ratio`      | `4`      | معدل تحجيم أقنعة (التدريب الفصلي فقط)                                                                                     |
| `dropout`         | `0.0`    | استخدام تنظيم الإسقاط (التدريب التطبيقي فقط)                                                                              |
| `val`             | `True`   | التحقق/الاختبار خلال التدريب                                                                                              |

## تسجيل

عند تدريب نموذج YOLOv8، قد تجد أنه من المفيد تتبع أداء النموذج مع مرور الوقت. هنا يأتي دور تسجيل. يوفر Ultralytics' YOLO دعمًا لثلاثة أنواع من أجهزة السجل - Comet و ClearML و TensorBoard.

لاستخدام سجل، حدده من قائمة السحب أسفل الكود وقم بتشغيله. سيتم تثبيت السجل المختار وتهيئته.

### Comet

[Comet](../../../integrations/comet.md) هو منصة تسمح لعلماء البيانات والمطورين بمتابعة ومقارنة وشرح وتحسين التجارب والنماذج. يوفر وظائف مثل المقاييس الزمنية في الوقت الحقيقي وفروقات الشفرة وتتبع المعلمات.

لاستخدام Comet:

!!! Example "أمثلة بايثون"

    === "بايثون"
        ```python
        # pip install comet_ml
        import comet_ml

        comet_ml.init()
        ```

تذكر تسجيل الدخول إلى حسابك في Comet على موقعهم على الويب والحصول على مفتاح API الخاص بك. ستحتاج إلى إضافته إلى الإعدادات المتغيرة في البيئة الخاصة بك أو برنامج النص الخاص بك لتسجيل التجارب الخاصة بك.

### ClearML

[ClearML](https://www.clear.ml/) هي منصة مفتوحة المصدر تعمل على تتبع التجارب وتسهيل مشاركة الموارد بكفاءة. تم تصميمه لمساعدة الفرق في إدارة وتنفيذ وإعادة إنتاج عملهم في مجال تعلم الآلة بكفاءة أكبر.

لاستخدام ClearML:

!!! Example "أمثلة بايثون"

    === "بايثون"
        ```python
        # pip install clearml
        import clearml

        clearml.browser_login()
        ```

بعد تشغيل هذا السكريبت، ستحتاج إلى تسجيل الدخول إلى حساب ClearML الخاص بك على المستعرض ومصادقة جلستك.

## TensorBoard

[TensorBoard](https://www.tensorflow.org/tensorboard) هي مجموعة أدوات لتصور TensorFlow ، تسمح لك بتصور نموذج TensorFlow الخاص بك ، ورسم المقاييس الكمية حول تنفيذ النموذج الخاص بك ، وعرض بيانات إضافية مثل الصور التي تمر عبرها.

للاستفادة من TensorBoard في [Google Colab](https://colab.research.google.com/github/ultralytics/ultralytics/blob/main/examples/tutorial.ipynb):

!!! Example "أمثلة سطر الأوامر"

    === "سطر الأوامر"
        ```bash
        load_ext tensorboard
        tensorboard --logdir ultralytics/runs  # استبدل بالدليل 'runs'
        ```

لاستخدام TensorBoard محليًا، قم بتشغيل الأمر أدناه واعرض النتائج على الرابط http://localhost:6006/.

!!! Example "أمثلة سطر الأوامر"

    === "سطر الأوامر"
        ```bash
        tensorboard --logdir ultralytics/runs  # استبدل بالدليل 'runs'
        ```

سيتم تحميل TensorBoard وتوجيهه إلى الدليل الذي يتم حفظ سجلات التدريب فيه.

بعد إعداد السجل الخاص بك، يمكنك الاستمرار في تدريب النموذج. سيتم سجل جميع مقاييس التدريب تلقائيًا في المنصة التي اخترتها، ويمكنك الوصول إلى هذه السجلات لمراقبة أداء النموذج الخاص بك مع مرور الوقت ومقارنة نماذج مختلفة وتحديد المجالات التي يمكن تحسينها.
