---
comments: true
description: استكشف دليلنا التفصيلي على YOLOv4 ، وهو جهاز كشف الكائنات الحديثة في الوقت الحقيقي. فهم أبرز معالم التصميم المعماري الخاصة به ، والميزات المبتكرة ، وأمثلة التطبيق.
keywords: ultralytics ، yolo v4 ، كشف الكائنات ، شبكة عصبية ، كشف في الوقت الحقيقي ، كاشف الكائنات ، تعلم الآلة

---

# YOLOv4: الكشف العالي السرعة والدقة للكائنات

أهلاً بك في صفحة وثائق Ultralytics لـ YOLOv4 ، جهاز كشف الكائنات الحديث في الوقت الحقيقي الذي تم إطلاقه في عام 2020 من قبل Alexey Bochkovskiy على  [https://github.com/AlexeyAB/darknet](https://github.com/AlexeyAB/darknet). تم تصميم YOLOv4 لتوفير التوازن المثالي بين السرعة والدقة ، مما يجعله خيارًا ممتازًا للعديد من التطبيقات.

![رسم توضيحي لهندسة YOLOv4](https://user-images.githubusercontent.com/26833433/246185689-530b7fe8-737b-4bb0-b5dd-de10ef5aface.png)
**رسم توضيحي لهندسة YOLOv4**. يعرض التصميم المعماري المعقد لشبكة YOLOv4 ، بما في ذلك المكونات الرئيسية والرقبة والرأس ، والطبقات المترابطة للكشف الفعال في الوقت الحقيقي.

## مقدمة

تعني YOLOv4 "فقط تنظر مرة واحدة النسخة 4". هو نموذج كشف الكائنات الحقيقي الزمني الذي تم تطويره لمعالجة قيود الإصدارات السابقة لـ YOLO مثل [YOLOv3](yolov3.md) ونماذج كشف الكائنات الأخرى. على عكس كاشفات الكائنات الأخرى القائمة على الشبكات العصبية المتزاحمة المستخدمة للكشف عن الكائنات ، يمكن تطبيق YOLOv4 لأنظمة الوصية النصحية وكذلك لإدارة العملية المستقلة وتقليل الإدخالات البشرية. يتيح تشغيله على وحدات معالجة الرسومات القياسية (GPUs) الاستخدام الشامل بتكلفة معقولة ، وتم تصميمه للعمل في الوقت الفعلي على وحدة معالجة الرسومات التقليدية مع الحاجة إلى وحدة واحدة فقط من هذا النوع للتدريب.

## الهندسة

تستغل YOLOv4 العديد من الميزات المبتكرة التي تعمل معًا لتحسين أدائها. تشمل هذه الميزات الاتصالات المتبقية المرجحة (WRC) ، والاتصالات الجزئية عبر المرحلة المتقاطعة (CSP) ، والتطبيع المتقاطع المصغر لدُفع (CmBN) ، والتدريب المتنازع لنفسه (SAT) ، وتنشيط Mish ، وزيادة بيانات الزخم ، وتنظيم DropBlock ، وخسارة CIoU. يتم دمج هذه الميزات لتحقيق أحدث النتائج.

يتألف كاشف الكائنات النموذجي من عدة أجزاء بما في ذلك المدخل والظهر والرقبة والرأس. يتم تدريب الظهرية لـ YOLOv4 سلفًا على ImageNet ويستخدم لتوقع فئات ومربعات محيطة للكائنات. يمكن أن يكون الظهرية من عدة نماذج بما في ذلك VGG و ResNet و ResNeXt أو DenseNet. يتم استخدام جزء الرقبة من الكاشف لجمع خرائط الميزات من مراحل مختلفة وعادة ما يتضمن عدة مسارات لأسفل وعدة مسارات للأعلى. جزء الرأس هو ما يستخدم لإجراء اكتشاف الكائنات والتصنيف النهائي.

## الحقيبة المجانية

يستخدم YOLOv4 أيضًا طرقًا تعرف باسم "حقيبة المجانيات" وهي تقنيات تحسِّن دقة النموذج أثناء التدريب دون زيادة تكلفة الاستنتاج. تعد التعديلات في البيانات تقنية شائعة في كشف الكائنات ، والتي تزيد من تنوع صور الإدخال لتحسين قوة الموديل. بعض أمثلة التعديل في البيانات تشمل التشويهات البصرية (ضبط السطوع والتباين والدرجة والتشبع والضوضاء في الصورة) والتشويهات الهندسية (إضافة توزيع عشوائي للتغيير المقياسي والاقتصاص والانعكاس والتدوير). تساعد هذه التقنيات الموديل في التعميم على أنواع مختلفة من الصور.

## الميزات والأداء

تم تصميم YOLOv4 لتحقيق سرعة ودقة مثلى في كشف الكائنات. يتضمن تصميم YOLOv4 CSPDarknet53 كظهر ، PANet كرقبة ، و YOLOv3 كرأس كشف. يسمح هذا التصميم لـ YOLOv4 بأداء كشف الكائنات بسرعة مذهلة ، مما يجعله مناسبًا لتطبيقات الوقت الحقيقي. يتفوق YOLOv4 أيضًا في الدقة ، ويحقق نتائج عالية في مقاييس كشف الكائنات.

## أمثلة الاستخدام

في وقت كتابة هذا النص ، لا يدعم Ultralytics حاليًا نماذج YOLOv4. لذلك ، سيحتاج أي مستخدمين مهتمين باستخدام YOLOv4 إلى الرجوع مباشرة إلى مستودع YOLOv4 على GitHub للحصول على تعليمات التثبيت والاستخدام.

إليك نظرة عامة موجزة على الخطوات النموذجية التي يمكن أن تتخذها لاستخدام YOLOv4:

1. قم بزيارة مستودع YOLOv4 على GitHub: [https://github.com/AlexeyAB/darknet](https://github.com/AlexeyAB/darknet).

2. اتبع التعليمات المقدمة في ملف README لعملية التثبيت. ينطوي هذا عادة على استنساخ المستودع ، وتثبيت التبعيات اللازمة ، وإعداد أي متغيرات بيئة ضرورية.

3. بمجرد الانتهاء من التثبيت ، يمكنك تدريب واستخدام النموذج وفقًا لتعليمات الاستخدام المقدمة في المستودع. يتضمن ذلك عادة إعداد مجموعة البيانات الخاصة بك ، وتكوين معاملات النموذج ، وتدريب النموذج ، ثم استخدام النموذج المدرب لأداء اكتشاف الكائنات.

يرجى ملاحظة أن الخطوات النموذجية قد تختلف اعتمادًا على حالة الاستخدام الخاصة بك وحالة مستودع YOLOv4 الحالي. لذلك ، يُنصح بشدة بالرجوع مباشرة إلى التعليمات المقدمة في مستودع YOLOv4 على GitHub.

نؤسف على أي إزعاج ، وسنسعى لتحديث هذا المستند بأمثلة استخدام لـ Ultralytics بمجرد تنفيذ الدعم لـ YOLOv4.

## الاستنتاج

YOLOv4 هو نموذج قوي وفعال لكشف الكائنات يجمع بين السرعة والدقة. يستخدم الميزات الفريدة وتقنيات الزخم في التدريب للأداء بشكل ممتاز في مهام اكتشاف الكائنات في الوقت الفعلي. يمكن لأي شخص يمتلك وحدة معالجة رسومية تقليدية تدريب YOLOv4 واستخدامها ، مما يجعلها سهلة الوصول وعملية لمجموعة واسعة من التطبيقات.

## التنويه والتقديرات

نود أن نعترف بمساهمة أصحاب YOLOv4 في مجال كشف الكائنات الحقيقية الزمنية:

!!! Quote ""

    === "بيب تكس"

        ```bibtex
        @misc{bochkovskiy2020yolov4,
              title={YOLOv4: Optimal Speed and Accuracy of Object Detection},
              author={Alexey Bochkovskiy and Chien-Yao Wang and Hong-Yuan Mark Liao},
              year={2020},
              eprint={2004.10934},
              archivePrefix={arXiv},
              primaryClass={cs.CV}
        }
        ```

يمكن العثور على ورقة YOLOv4 الأصلية على [arXiv](https://arxiv.org/pdf/2004.10934.pdf). قام المؤلفون بتوفير عملهم بشكل عام ، ويمكن الوصول إلى قاعدة الشفرات على [GitHub](https://github.com/AlexeyAB/darknet). نقدر جهودهم في تعزيز الميدان وتوفير عملهم للمجتمع العريض.
