---
comments: true
description: От обучения до отслеживания - используйте все возможности YOLOv8 от Ultralytics. Получите информацию и примеры для каждого поддерживаемого режима, включая проверку, экспорт и бенчмаркинг.
keywords: Ultralytics, YOLOv8, Машинное обучение, Обнаружение объектов, Обучение, Проверка, Предсказание, Экспорт, Отслеживание, Бенчмаркинг
---

# Режимы Ultralytics YOLOv8

<img width="1024" src="https://github.com/ultralytics/assets/raw/main/yolov8/banner-integrations.png" alt="Экосистема Ultralytics YOLO и интеграции">

## Введение

Ultralytics YOLOv8 - это не просто еще одна модель обнаружения объектов; это многофункциональная платформа, предназначенная для охвата всего жизненного цикла моделей машинного обучения - от ввода данных и обучения модели до валидации, развертывания и отслеживания в реальном мире. Каждый режим служит определенной цели и разработан, чтобы предложить вам гибкость и эффективность, необходимую для различных задач и сценариев использования.

<p align="center">
  <br>
  <iframe width="720" height="405" src="https://www.youtube.com/embed/j8uQc0qB91s?si=dhnGKgqvs7nPgeaM"
    title="Плеер YouTube видео" frameborder="0"
    allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture; web-share"
    allowfullscreen>
  </iframe>
  <br>
  <strong>Смотрите:</strong> Руководство по режимам Ultralytics: Обучение, Проверка, Предсказание, Экспорт и Бенчмаркинг.
</p>

### Обзор режимов

Понимание различных **режимов**, которые поддерживает Ultralytics YOLOv8, критически важно для эффективного использования ваших моделей:

- **Режим обучения (Train mode)**: Настройте вашу модель на пользовательские или предзагруженные наборы данных.
- **Режим проверки (Val mode)**: Контрольная точка после обучения для валидации производительности модели.
- **Режим предсказания (Predict mode)**: Раскройте предсказательную мощь вашей модели на данных из реального мира.
- **Режим экспорта (Export mode)**: Подготовьте вашу модель к развертыванию в различных форматах.
- **Режим отслеживания (Track mode)**: Расширьте вашу модель обнаружения объектов до приложений отслеживания в реальном времени.
- **Режим бенчмаркинга (Benchmark mode)**: Проанализируйте скорость и точность вашей модели в разнообразных средах развертывания.

Это исчерпывающее руководство направлено на то, чтобы дать вам обзор и практические сведения о каждом режиме, помогая вам использовать полный потенциал YOLOv8.

## [Обучение (Train)](train.md)

Режим обучения используется для обучения модели YOLOv8 на пользовательском наборе данных. В этом режиме модель обучается с использованием указанного набора данных и гиперпараметров. Процесс обучения включает в себя оптимизацию параметров модели, чтобы она могла точно предсказывать классы и местоположения объектов на изображении.

[Примеры обучения](train.md){ .md-button .md-button--primary}

## [Проверка (Val)](val.md)

Режим проверки используется для валидации модели YOLOv8 после ее обучения. В этом режиме модель оценивается на наборе данных для валидации, чтобы измерить ее точность и способность к обобщению. Этот режим может быть использован для настройки гиперпараметров модели с целью улучшения ее производительности.

[Примеры проверки](val.md){ .md-button .md-button--primary}

## [Предсказание (Predict)](predict.md)

Режим предсказания используется для выполнения предсказаний с использованием обученной модели YOLOv8 на новых изображениях или видео. В этом режиме модель загружается из файла контрольной точки, и пользователь может предоставить изображения или видео для выполнения вывода. Модель предсказывает классы и местоположения объектов во входных изображениях или видео.

[Примеры предсказания](predict.md){ .md-button .md-button--primary}

## [Экспорт (Export)](export.md)

Режим экспорта используется для экспортирования модели YOLOv8 в формат, который может быть использован для развертывания. В этом режиме модель преобразуется в формат, который может быть использован другими программными приложениями или аппаратными устройствами. Этот режим полезен при развертывании модели в производственной среде.

[Примеры экспорта](export.md){ .md-button .md-button--primary}

## [Отслеживание (Track)](track.md)

Режим отслеживания используется для отслеживания объектов в реальном времени с использованием модели YOLOv8. В этом режиме модель загружается из файла контрольной точки, и пользователь может предоставить прямую видеотрансляцию для выполнения отслеживания объектов в реальном времени. Этот режим полезен для приложений, таких как системы видеонаблюдения или беспилотные автомобили.

[Примеры отслеживания](track.md){ .md-button .md-button--primary}

## [Бенчмаркинг (Benchmark)](benchmark.md)

Режим бенчмаркинга используется для профилирования скорости и точности различных форматов экспорта для YOLOv8. Бенчмарки предоставляют информацию о размере экспортируемого формата, его метриках `mAP50-95` (для обнаружения объектов, сегментации и позы) или метриках `accuracy_top5` (для классификации), а также время вывода в миллисекундах на изображение для различных форматов экспорта, таких как ONNX, OpenVINO, TensorRT и других. Эта информация может помочь пользователям выбрать оптимальный формат экспорта для их конкретного сценария использования на основе их требований к скорости и точности.

[Примеры бенчмаркинга](benchmark.md){ .md-button .md-button--primary}
