---
comments: true
description: Получите обзор моделей YOLOv3, YOLOv3-Ultralytics и YOLOv3u. Узнайте о их основных функциях, использовании и поддерживаемых задачах для обнаружения объектов.
keywords: YOLOv3, YOLOv3-Ultralytics, YOLOv3u, Обнаружение объектов, Вывод, Обучение, Ultralytics
---

# YOLOv3, YOLOv3-Ultralytics и YOLOv3u

## Обзор

Этот документ представляет обзор трех тесно связанных моделей обнаружения объектов: [YOLOv3](https://pjreddie.com/darknet/yolo/), [YOLOv3-Ultralytics](https://github.com/ultralytics/yolov3) и [YOLOv3u](https://github.com/ultralytics/ultralytics).

1. **YOLOv3:** Это третья версия алгоритма обнаружения объектов You Only Look Once (YOLO). Изначально разработанная Джозефом Редмоном (Joseph Redmon), YOLOv3 улучшила своих предшественников, внедрив такие функции, как многошкальные предсказания и три различных размера ядер детекции.

2. **YOLOv3-Ultralytics:** Это имплементация модели YOLOv3 от Ultralytics. Она воспроизводит оригинальную архитектуру YOLOv3 и предлагает дополнительные возможности, такие как поддержка большего числа предварительно обученных моделей и более простые варианты настройки.

3. **YOLOv3u:** Это обновленная версия YOLOv3-Ultralytics, которая включает в себя разделение головы на свободные от привязки якоря и объектности, используемое в моделях YOLOv8. YOLOv3u имеет такую же архитектуру основного модуля и модуля "шеи", как YOLOv3, но с обновленной головой детекции из YOLOv8.

![Ultralytics YOLOv3](https://raw.githubusercontent.com/ultralytics/assets/main/yolov3/banner-yolov3.png)

## Основные характеристики

- **YOLOv3:** Внедрение трех масштабов детекции позволило использовать три разных размера ядер детекции: 13x13, 26x26 и 52x52. Это значительно улучшило точность обнаружения объектов различных размеров. Кроме того, YOLOv3 добавила такие функции, как множественные предсказания для каждого ограничивающего прямоугольника и более высококачественную сеть экстрактора признаков.

- **YOLOv3-Ultralytics:** Имплементация YOLOv3 от Ultralytics обеспечивает такую же производительность, как у оригинальной модели, но дополнительно поддерживает больше предварительно обученных моделей, дополнительные методы обучения и более простые варианты настройки. Это делает ее более гибкой и удобной для практического применения.

- **YOLOv3u:** В этой обновленной модели использовано разделение головы на свободные от привязки якоря и объектности из YOLOv8. Путем устранения необходимости в предопределенных координатах привязки и оценках объектности эта архитектура головы детекции способна улучшить способность модели обнаруживать объекты различных размеров и форм. Это делает YOLOv3u более устойчивой и точной для задач обнаружения объектов.

## Поддерживаемые задачи и режимы

Серия YOLOv3, включая YOLOv3, YOLOv3-Ultralytics и YOLOv3u, специально разработана для задач обнаружения объектов. Эти модели заслужили признание своей эффективности в различных сценариях реального мира, обеспечивая баланс между точностью и скоростью. Каждый вариант предлагает уникальные функции и оптимизации, что делает их подходящими для широкого спектра приложений.

Все три модели поддерживают полный набор режимов, обеспечивая гибкость на разных этапах развертывания и разработки моделей. Эти режимы включают [Вывод](../modes/predict.md), [Проверку](../modes/val.md), [Обучение](../modes/train.md) и [Экспорт](../modes/export.md), что позволяет пользователям полноценно использовать эти модели для эффективного обнаружения объектов.

| Тип модели         | Поддерживаемые задачи                      | Вывод | Проверка | Обучение | Экспорт |
|--------------------|--------------------------------------------|-------|----------|----------|---------|
| YOLOv3             | [Обнаружение объектов](../tasks/detect.md) | ✅     | ✅        | ✅        | ✅       |
| YOLOv3-Ultralytics | [Обнаружение объектов](../tasks/detect.md) | ✅     | ✅        | ✅        | ✅       |
| YOLOv3u            | [Обнаружение объектов](../tasks/detect.md) | ✅     | ✅        | ✅        | ✅       |

Эта таблица предоставляет краткий обзор возможностей каждого варианта модели YOLOv3, подчеркивая их гибкость и пригодность для выполнения различных задач и операционных режимов в потоке обнаружения объектов.

## Примеры использования

Этот пример предоставляет простые примеры обучения и вывода с использованием YOLOv3. Полную документацию об этих и других [режимах](../modes/index.md) см. на страницах документации по [Predict](../modes/predict.md), [Train](../modes/train.md), [Val](../modes/val.md) и [Export](../modes/export.md).

!!! Example "Пример"

    === "Python"

        В Python можно передавать предварительно обученные модели `*.pt` PyTorch и конфигурационные файлы `*.yaml` в класс `YOLO()`, чтобы создать экземпляр модели:

        ```python
        from ultralytics import YOLO

        # Загрузка предварительно обученной модели YOLOv3n на наборе данных COCO
        model = YOLO('yolov3n.pt')

        # Отображение информации о модели (необязательно)
        model.info()

        # Обучение модели на примере набора данных COCO8 в течение 100 эпох
        results = model.train(data='coco8.yaml', epochs=100, imgsz=640)

        # Выполнение вывода модели YOLOv3n на изображении 'bus.jpg'
        results = model('path/to/bus.jpg')
        ```

    === "CLI"

        Имеются команды интерфейса командной строки для прямого запуска моделей:

        ```bash
        # Загрузить предварительно обученную модель YOLOv3n на наборе данных COCO и обучить ее на примере набора данных COCO8 в течение 100 эпох
        yolo train model=yolov3n.pt data=coco8.yaml epochs=100 imgsz=640

        # Загрузить предварительно обученную модель YOLOv3n на наборе данных COCO и выполнить вывод на изображении 'bus.jpg'
        yolo predict model=yolov3n.pt source=path/to/bus.jpg
        ```

## Цитаты и благодарности

Если вы используете YOLOv3 в своем исследовании, пожалуйста, цитируйте оригинальные статьи о YOLO и репозиторий Ultralytics YOLOv3:

!!! Quote ""

    === "BibTeX"

        ```bibtex
        @article{redmon2018yolov3,
          title={YOLOv3: An Incremental Improvement},
          author={Redmon, Joseph and Farhadi, Ali},
          journal={arXiv preprint arXiv:1804.02767},
          year={2018}
        }
        ```

Благодарим Джозефа Редмона и Али Фархади за разработку оригинальной модели YOLOv3.
