---
comments: true
description: YOLOv8モデルのバリデーションガイド。バリデーション設定とメトリクスを使用してYOLOモデルのパフォーマンスを評価する方法をPythonとCLIの例で学びましょう。
keywords: Ultralytics, YOLO ドキュメント, YOLOv8, バリデーション, モデル評価, ハイパーパラメータ, 正確性, メトリクス, Python, CLI
---

# Ultralytics YOLOによるモデルバリデーション

<img width="1024" src="https://github.com/ultralytics/assets/raw/main/yolov8/banner-integrations.png" alt="Ultralytics YOLOのエコシステムと統合機能">

## はじめに

バリデーションは、訓練されたモデルの品質を評価するために機械学習パイプラインで重要なステップです。Ultralytics YOLOv8のValモードは、モデルのパフォーマンスを評価するための堅牢なツールとメトリクスを提供します。このガイドは、Valモードを効果的に使用して、モデルが正確で信頼できることを確認するための完全なリソースとなっています。

## Ultralytics YOLOでバリデーションを行う利点

YOLOv8のValモードを使用することの利点は以下の通りです：

- **Precision（精度）：** mAP50、mAP75、mAP50-95といった正確なメトリクスを取得し、モデルを総合的に評価します。
- **Convenience（便利さ）：** 訓練設定を記憶する組み込みの機能を利用して、バリデーションプロセスを簡素化します。
- **Flexibility（柔軟性）：** 同じデータセットや異なるデータセット、画像サイズでモデルをバリデーションできます。
- **Hyperparameter Tuning（ハイパーパラメータチューニング）：** バリデーションメトリクスを利用してモデルのパフォーマンスを向上させるためのチューニングを行います。

### Valモードの主要機能

YOLOv8のValモードにより提供される注目すべき機能は以下の通りです：

- **Automated Settings（自動設定）：** 訓練時の設定をモデルが記憶しているため、バリデーションが直感的に行えます。
- **Multi-Metric Support（複数メトリックのサポート）：** 精度メトリックの範囲に基づいてモデルを評価します。
- **CLI and Python API：** バリデーションにコマンドラインインターフェイスもしくはPython APIのどちらかを選択できます。
- **Data Compatibility（データ互換性）：** 訓練段階で使われたデータセットはもちろん、カスタムデータセットともシームレスに動作します。

!!! Tip "Tip"

    * YOLOv8モデルは訓練設定を自動的に記憶しているので、`yolo val model=yolov8n.pt`や`model('yolov8n.pt').val()`だけで、元のデータセットと同じ画像サイズで簡単にバリデーション可能です。

## 使用例

COCO128データセット上で訓練済みのYOLOv8nモデルの精度を検証します。`model`はその訓練時の`data`及び引数をモデル属性として保持しているため、引数を渡す必要はありません。全てのエクスポート引数のリストについては、以下のArgumentsセクションをご覧ください。

!!! Example "例"

    === "Python"

        ```python
        from ultralytics import YOLO

        # モデルをロードする
        model = YOLO('yolov8n.pt')  # 公式モデルをロード
        model = YOLO('path/to/best.pt')  # カスタムモデルをロード

        # モデルをバリデーションする
        metrics = model.val()  # 引数は必要なし、データセットと設定は記憶持ち
        metrics.box.map    # map50-95
        metrics.box.map50  # map50
        metrics.box.map75  # map75
        metrics.box.maps   # 各カテゴリのmap50-95が含まれたリスト
        ```
    === "CLI"

        ```bash
        yolo detect val model=yolov8n.pt  # 公式モデルをバリデーション
        yolo detect val model=path/to/best.pt  # カスタムモデルをバリデーション
        ```

## 引数

YOLOモデルに対するバリデーション設定は、バリデーションデータセット上でのモデルのパフォーマンスを評価するために使用されるさまざまなハイパーパラメータと設定を指します。これらの設定は、モデルのパフォーマンス、スピード、そして精度に影響を与える可能性があります。一般的なYOLOのバリデーション設定には、バッチサイズや訓練中のバリデーション頻度、モデルのパフォーマンスを評価するために使用されるメトリックが含まれます。バリデーションプロセスに影響を与えるかもしれない他の要素には、バリデーションデータセットのサイズと構成、およびモデルが使用されている具体的なタスクなどがあります。モデルがバリデーションデータセット上でうまく動作していることを確認し、過学習を検出して防ぐために、これらの設定を慎重にチューニングして実験することが重要です。

| キー            | 値       | 説明                                               |
|---------------|---------|--------------------------------------------------|
| `data`        | `None`  | データファイルへのパス、例: coco128.yaml                      |
| `imgsz`       | `640`   | 入力画像のサイズを整数で                                     |
| `batch`       | `16`    | バッチごとの画像数（AutoBatchの場合は-1）                       |
| `save_json`   | `False` | JSONファイルに結果を保存                                   |
| `save_hybrid` | `False` | ハイブリッドバージョンのラベルを保存（ラベル＋追加の予測）                    |
| `conf`        | `0.001` | 検出のためのオブジェクト信頼度閾値                                |
| `iou`         | `0.6`   | NMS用の交差オーバーユニオン（IoU）閾値                           |
| `max_det`     | `300`   | 画像あたりの最大検出数                                      |
| `half`        | `True`  | 半精度（FP16）を使用する                                   |
| `device`      | `None`  | 実行デバイス、例: cuda device=0/1/2/3やdevice=cpu         |
| `dnn`         | `False` | ONNX推論用のOpenCV DNNを使用                            |
| `plots`       | `False` | 訓練中にプロットを表示                                      |
| `rect`        | `False` | 各バッチが最小限のパディングで整理された矩形バリデーション                    |
| `split`       | `val`   | バリデーションに使用するデータセットのスプリット、例: 'val'、'test'、'train' |
|               |         |                                                  |
