---
comments: true
description: YOLOv8 मॉडलों की मान्यता सत्यापन के लिए गाइड। यहाँ जानें कि कैसे पायथन और CLI उदाहरणों के साथ परीक्षण सेटिंग्स और मापों का उपयोग करके अपने YOLO मॉडलों के प्रदर्शन का मूल्यांकन करें।
keywords: Ultralytics, YOLO दस्तावेज़, YOLOv8, मान्यता, मॉडल मूल्यांकन, हाइपरपैरामीटर, सटीकता, माप, पायथन, सीएलआई
---

# Ultralytics YOLO के साथ मॉडल मान्यता

<img width="1024" src="https://github.com/ultralytics/assets/raw/main/yolov8/banner-integrations.png" alt="Ultralytics YOLO पारिस्थितिकी और एकीकरण">

## परिचय

मान्यता मशीन लर्निंग पाइपलाइन में एक महत्वपूर्ण चरण है, जो आपको अपने प्रशिक्षित मॉडलों की गुणवत्ता का मूल्यांकन करने की अनुमति देता है। Ultralytics YOLOv8 में Val मोड बहुत सारे टूल्स और मापों का प्रयोग करके आपके ऑब्जेक्ट डिटेक्शन मॉडलों के प्रदर्शन का मूल्यांकन करने के लिए है। यह गाइड योग्यता और विश्वसनीयता दोनों सुनिश्चित करने के लिए Val मोड का सविस्तर संसाधन के रूप में काम आता है।

## Ultralytics YOLO के साथ मान्यता करने के फायदे

यहाँ योलोवी8 के Val मोड का उपयोग करने के फायदे हैं:

- **सटीकता:** अपने मॉडल को पूरी तरह से मूल्यांकित करने के लिए mAP50, mAP75, और mAP50-95 जैसे टिकाऊ मापों को प्राप्त करें।
- **सुविधा:** मूल्यांकन प्रक्रिया को सरल बनाने के लिए ट्रेनिंग सेटिंग्स को याद करने वाली इनबिल्ट सुविधा का उपयोग करें।
- **लचीलापन:** अपने मॉडल को एक ही या अलग डेटासेट और छवि आकार के साथ मान्यता दें।
- **हाइपरपैरामीटर ट्यूनिंग:** मूल्यांकन मापों का उपयोग करके अपने मॉडल को बेहतर प्रदर्शन के लिए समायोजित करें।

### Val मोड की मुख्य विशेषताएं

ये हैं YOLOv8 के Val मोड द्वारा प्रदान की जाने वाली महत्वपूर्ण कार्यक्षमताएं:

- **स्वत: सेटिंग्स:** मॉडल योग्यता के लिए अपने प्रशिक्षण समायोजनों को स्वतः याद रखते हैं।
- **बहुमान्यता समर्थन:** विभिन्न सटीकता मापों के आधार पर अपने मॉडल की मूल्यांकन करें।
- **CLI और पायथन एपीआई:** मान्यता के लिए CLI या पायथन एपीआई में से एक का चयन करें।
- **डेटा सम्पर्कता:** कोकोविवक प्रशिक्षण चरण में उपयोग की जाने वाली डेटासेट के साथ सहजता से काम करता है।

!!! Tip "टिप"

    * YOLOv8 मॉडल अपने प्रशिक्षण सेटिंग्स को स्वतः याद रखते हैं, इसलिए आप केवल `yolo val model=yolov8n.pt` या `model('yolov8n.pt').val()` द्वारा सरलतापूर्वक एक मॉडल को समान छवि आकार के साथ और मूल डेटासेट पर मान्यता दे सकते हैं।

## उपयोग के उदाहरण

COCO128 डेटासेट पर प्रशिक्षित YOLOv8n मॉडल की सटीकता मान्यांकन करें। `model` को विद्यमान ट्रेनिंग `data` और तर्क बने रहते हैं, इसलिए कोई तर्क पास कराने की आवश्यकता नहीं है। पूरी सूची निर्यात तर्कों के लिए नीचे देखें।

!!! Example "उदाहरण"

    === "पायथन"

        ```python
        from ultralytics import YOLO

        # मॉडल लोड करें
        model = YOLO('yolov8n.pt')  # एक आधिकारिक मॉडल लोड करें
        model = YOLO('path/to/best.pt')  # एक कस्टम मॉडल लोड करें

        # मॉडल को मान्यांकन करें
        metrics = model.val()  # कोई तर्क आवश्यक नहीं होते हैं, डेटासेट और सेटिंग्स याद रखे जाते हैं
        metrics.box.map    # map50-95
        metrics.box.map50  # map50
        metrics.box.map75  # map75
        metrics.box.maps   # हर श्रेणी के map50-95 से बना एक सूची
        ```
    === "CLI"

        ```bash
        yolo detect val model=yolov8n.pt  # आधिकारिक मॉडल को मान्यांकन करें
        yolo detect val model=path/to/best.pt  # कस्टम मॉडल को मान्यांकन करें
        ```

## तर्क

YOLO मॉडल के लिए मान्यांकन सेटिंग्स निम्नलिखित होते हैं: हाइपरपैरामीटर और विन्यास जैसे, जो मॉडल की मान्यता को मूल्यांकित करने के लिए उपयोग होते हैं। ये सेटिंग्स मॉडल के प्रदर्शन, गति, और सटीकता पर प्रभाव डाल सकती हैं। कुछ आम YOLO मान्यांकन सेटिंग्स में दाल-दालत, ट्रेनिंग के दौरान मान्यांकन कब किया जाता है और मान्यांकन के लिए उपयोग किए जाने वाले माप शामिल हैं। मान्यांकन प्रक्रिया को प्रभावित कर सकने वाले अन्य कारकों में मान्यांकन डेटासेट का आकार और संरचना और मॉडल का विशेष कार्य शामिल हैं। ओवरफिटिंग का पता लगाने और रोकने के लिए इन सेटिंग्स को सावधानीपूर्वक समायोजित और प्रयोग करना महत्वपूर्ण है।

| कुंजी         | मान     | विवरण                                                                              |
|---------------|---------|------------------------------------------------------------------------------------|
| `data`        | `None`  | डेटा फ़ाइल का पथ, जैसे की coco128.yaml                                             |
| `imgsz`       | `640`   | प्रारूपिक छवि का आकार एक पूर्णांक के रूप में                                       |
| `batch`       | `16`    | प्रति बैच छवि की संख्या (-1 for AutoBatch)                                         |
| `save_json`   | `False` | परिणाम JSON फ़ाइल में सहेजें                                                       |
| `save_hybrid` | `False` | प्रकारों के हाइब्रिड संस्करण को सहेजें (लेबल + अतिरिक्त पूर्वानुमान)               |
| `conf`        | `0.001` | डिटेक्शन के लिए वस्तु का विश्वसनीयता थ्रेशहोल्ड                                    |
| `iou`         | `0.6`   | संयोग/संधि (IoU) के लिए थ्रेशहोल्ड डाकघर                                           |
| `max_det`     | `300`   | प्रति छवि के लिए अधिकतम निकासी संख्या                                              |
| `half`        | `True`  | अर्धसरलता (FP16) का उपयोग करें                                                     |
| `device`      | `None`  | चलाएं के लिए युक्ति, उदाहरण के लिए cuda device=0/1/2/3 या device=cpu               |
| `dnn`         | `False` | ओएनएनएक्स संज्ञानात्मक के लिए ओपेंसीवी डीएनएन का उपयोग करें                        |
| `plots`       | `False` | प्रशिक्षण के दौरान चित्रितियाँ दिखाएं                                              |
| `rect`        | `False` | न्यूनतम पैडिंग के लिए हर बैच को संकलित आयताकारक विमान करें                         |
| `split`       | `val`   | मान्यांकन के लिए उपयोग की जाने वाली डेटासेट स्प्लिट, जैसे 'val', 'test' या 'train' |
|
