---
comments: true
description: YOLOv3, YOLOv3-Ultralytics और YOLOv3u के बारे में जानें। इनकी प्रमुख विशेषताएँ, उपयोग और वस्तु डिटेक्शन के लिए समर्थित कार्यों की जानकारी प्राप्त करें।
keywords: YOLOv3, YOLOv3-Ultralytics, YOLOv3u, वस्तु डिटेक्शन, इनफेरेन्स, प्रशिक्षण, Ultralytics
---

# YOLOv3, YOLOv3-Ultralytics, और YOLOv3u

## सवाल

ये प्रदर्शनी में तीन प्रमुख वस्तु डिटेक्शन मॉडलों, यानी [YOLOv3](https://pjreddie.com/darknet/yolo/), [YOLOv3-Ultralytics](https://github.com/ultralytics/yolov3) और [YOLOv3u](https://github.com/ultralytics/ultralytics), की एक अवलोकन प्रस्तुत करती है।

1. **YOLOv3:** यह You Only Look Once (YOLO) वस्तु डिटेक्शन एल्गोरिदम का तीसरा संस्करण है। प्रारंभिक रूप में Joseph Redmon ने विकसित किया, YOLOv3 ने योग्यताओं का एक श्रेणी, जैसे कि मल्टीस्केल पूर्वानुमान और तीन भिन्न आकार के डिटेक्शन कर्नल्स, को शामिल करके अपने पूर्वजों पर सुधार किया।

2. **YOLOv3-Ultralytics:** यह YOLOv3 मॉडल का Ultralytics अनुपालन है। इसने मूल YOLOv3 की वास्तविकता को पुनर्जीवित किया है और अतिरिक्त कार्यक्षमताओं, जैसे कि अधिक पूर्व-प्रशिक्षित मॉडलों का समर्थन और और सुगठनितकरण विकल्पों की सुविधा भी प्रदान करता है।

3. **YOLOv3u:** यह YOLOv3-Ultralytics का एक अद्यतित संस्करण है जो YOLOv8 मॉडलों में उपयोग में लाया गया एंकर-मुक्त, टैग-न्यूमनेस स्प्लिट हेड को शामिल करता है। YOLOv3u में योग्यता योजना (backbone) और गर्दन (neck) की वास्तविकता तो बनाए रखती है, लेकिन डिटेक्शन हेड को YOLOv8 से अद्यतित कर देती है।

![Ultralytics YOLOv3](https://raw.githubusercontent.com/ultralytics/assets/main/yolov3/banner-yolov3.png)

## प्रमुख विशेषताएं

- **YOLOv3:** डिटेक्शन के लिए तीन भिन्न पैमाने का उपयोग करने की एकता वाला यह मॉडल, 13x13, 26x26 और 52x52 के तीन भिन्न आकाृ के डिटेक्शन कर्नल्स के उपयोग से जल्दी जाने जाने वाले वस्तुओं के लिए डिटेक्शन की योग्यता में सुधार करती है। इसके अतिरिक्त, YOLOv3 ने प्रति बाउंडिग बॉक्स के लिए मल्टी-लेबल पूर्वानुमान और एक बेहतर फ़ीचर एक्सट्रैक्टर नेटवर्क जैसी विशेषताएँ भी जोड़ी हैं।

- **YOLOv3-Ultralytics:** Ultralytics के YOLOv3 के अनुपालन में यह मॉडल मूल मॉडल की प्रदर्शन की समता प्रदान करता है, लेकिन इसके पास अतिरिक्त पूर्व-प्रशिक्षित मॉडलों, अधिक प्रशिक्षण विधियों और सुविधाजनक सुविधाएँ जैसे अतिरिक्त समर्थन होता है। इससे इसका विभिन्न अनुप्रयोगों में उपयोग करना संभव होता है।

- **YOLOv3u:** यह अद्यतित मॉडल YOLOv8 से योग्यता योजना का उपयोग करता है। योज्ञता के पूर्व-निर्धारित एंकर बॉक्स और पदार्थता स्कोर की आवश्यकता को मिटा कर, यह डिटेक्शन हेड का डिजाइन मॉडल की योग्यता को बेहतरीन आकार और आकृति के वस्तुओं की पहचान करने की क्षमता में सुधार कर सकता है। इससे वस्तु डिटेक्शन के कार्यों के लिए YOLOv3u मॉडलों में बढ़िया सुरक्षा और सटीकता प्राप्त हो सकती है।

## समर्थित कार्य और मोड

YOLOv3 श्रृंखला, इनमें YOLOv3, YOLOv3-Ultralytics और YOLOv3u शामिल हैं, विशेष रूप से वस्तु डिटेक्शन कार्यों के लिए विभिन्न प्रतिष्ठित हालत में डिज़ाइन किए गए हैं। ये मॉडल सटीकता और गति में संतुलन स्थापित करने के लिए प्रसिद्ध हैं। प्रत्येक वैरिएंट अद्वितीय सुविधाएँ और अनुकूलन प्रदान करती हैं, इसलिए इनका उपयोग विभिन्न अनुप्रयोगों के लिए संभव है।

तीनों मॉडलों को पूर्ण उपयोगता में उपयोग करने के लिए विभिन्न मोड हैं, इनमें [इनफेरेंस](../modes/predict.md), [मान्यकरण](../modes/val.md), [प्रशिक्षण](../modes/train.md) और [निर्यात](../modes/export.md) शामिल हैं, विभाजनित किये गए हैं। ये मोडल उपयोगकर्ताओं को वस्तू डिटेक्शन के प्रभावी आवागमन और विकास के विभाजन के विभाजन के लिए एक पूरी उपकरण पर्याप्तता प्रदान करते हैं।

| मॉडल प्रकार        | समर्थित कार्य                        | इनफेरेंस | मान्यकरण | प्रशिक्षण | निर्यात |
|--------------------|--------------------------------------|----------|----------|-----------|---------|
| YOLOv3             | [वस्तु डिटेक्शन](../tasks/detect.md) | ✅        | ✅        | ✅         | ✅       |
| YOLOv3-Ultralytics | [वस्तु डिटेक्शन](../tasks/detect.md) | ✅        | ✅        | ✅         | ✅       |
| YOLOv3u            | [वस्तु डिटेक्शन](../tasks/detect.md) | ✅        | ✅        | ✅         | ✅       |

यह तालिका प्रत्येक YOLOv3 वेरिएंट की क्षमताओं की क्षणभंगुर झलक प्रदान करती है, इसमें विभिन्न कार्यों और ऑपरेशनल मोड के लिए उपयुक्तता और विभाजन मानकों को प्रदर्शित किया गया है।

## उपयोग की उदाहरण

यह उदाहरण YOLOv3 प्रशिक्षण और इनफेरेंस के आसान उदाहरण प्रदान करता है। इन और अन्य [मोड](../modes/index.md) के बारे में विस्तारपूर्वक दस्तावेज़ीकरण के लिए इसके साथी [Predict](../modes/predict.md),  [Train](../modes/train.md), [Val](../modes/val.md) और [Export](../modes/export.md) दस्तावेज़ पेजेज़ की जांच करें।

!!! Example "उदाहरण"

    === "Python"

        `*.pt` प्रीट्रेन किए गए PyTorch मॉडल और कॉन्फ़िगरेशन *.yaml फ़ाइल Python में YOLO() क्लास कों यूज़ करके एक मॉडल इंस्टेंस तैयार करने के लिए पास कर सकते हैं:

        ```python
        from ultralytics import YOLO

        # COCO-pretrained YOLOv3n मॉडल लोड करें
        model = YOLO('yolov3n.pt')

        # मॉडल की जानकारी प्रदर्शित करें (वैकल्पिक)
        model.info()

        # COCO8 उदाहरण डेटासेट पर मॉडल 100 epochs के लिए प्रशिक्षण दें
        results = model.train(data='coco8.yaml', epochs=100, imgsz=640)

        # YOLOv3n मॉडल के साथ 'bus.jpg' छवि पर इनफेरेंस चलाएं
        results = model('path/to/bus.jpg')
        ```

    === "CLI"

        मॉडल पर चलाने के लिए CLI आदेश उपलब्ध हैं:

        ```bash
        # COCO-pretrained YOLOv3n मॉडल लोड करें और COCO8 उदाहरण डेटासेट पर इसे 100 epochs के लिए प्रशिक्षित करें
        yolo train model=yolov3n.pt data=coco8.yaml epochs=100 imgsz=640

        # COCO-pretrained YOLOv3n मॉडल लोड करें और 'bus.jpg' छवि पर इनफेरेंस चलाएं
        yolo predict model=yolov3n.pt source=path/to/bus.jpg
        ```

## उद्धरण और प्रशंसापत्र

अगर आप अपने शोध में YOLOv3 का उपयोग करते हैं, तो कृपया मूल YOLO पेपर्स और Ultralytics YOLOv3 रिपॉज़िटरी को उद्धृत करें।

!!! Quote ""

    === "BibTeX"

        ```bibtex
        @article{redmon2018yolov3,
          title={YOLOv3: An Incremental Improvement},
          author={Redmon, Joseph and Farhadi, Ali},
          journal={arXiv preprint arXiv:1804.02767},
          year={2018}
        }
        ```

Joseph Redmon और Ali Farhadi को मूल YOLOv3 विकसकर्ताओं के लिए धन्यवाद।
