---
comments: true
description:
  Baidu के RT-DETR का अवलोकन करें: विज़न ट्रांसफॉर्मर के द्वारा संचालित, उन्नत और अनुकूलनयोग्य वास्तविक समय ऑब्जेक्ट डिटेक्टर, जिसमें तैयार मॉडल शामिल हैं।
keywords: RT-DETR, Baidu, विज़न ट्रांसफॉर्मर्स, ऑब्जेक्ट डिटेक्शन, वास्तविक समय प्रदर्शन, CUDA, TensorRT, IoU-जागरूक क्वेरी चयन, Ultralytics, पायथन एपीआई, PaddlePaddle
---

# Baidu के RT-DETR: एक विज़न ट्रांसफॉर्मर के आधार पर वास्तविक समय ऑब्जेक्ट डिटेक्टर

## अवलोकन

Baidu द्वारा विकसित रियल-टाइम डिटेक्शन ट्रांसफॉर्मर (RT-DETR) एक उन्नत, end-to-end ऑब्जेक्ट डिटेक्टर है जो उच्च नि: शुल्कता बनाए रखते हुए वास्तविक समय प्रदर्शन प्रदान करता है। यह Vision ट्रांसफॉर्मर्स (ViT) की शक्ति का उपयोग करके बहुस्तरीय सुविधाओं की कुशलतापूर्वक प्रोसेसिंग करता है और इंट्रा-स्केल इंटरेक्शन और क्रॉस-स्केल फ्यूजन को अलग करके विभिन्न मापों की सुविधा प्रदान करता है। RT-DETR अत्यधिक अनुकूलनयोग्य है, जिसमें ब्यावसायिक लिंग के विभिन्न डिकोडर लेयर का उपयोग करके उपन्यासात्मक गति को समायोजित करने की समर्थन की गई है बिना पुनर्प्रशिक्षण के। इस मॉडल का परिणामस्वरूप, जो कि CUDA और TensorRT के समर्थनयुक्त बैकेंड पर अच्छा क्रियाशील ऑब्जैक्ट डिटेक्टरों से अधिक प्रदर्शन करता है।

![आदर्श छवि](https://user-images.githubusercontent.com/26833433/238963168-90e8483f-90aa-4eb6-a5e1-0d408b23dd33.png)
**Baidu के RT-DETR का अवलोकन।** RT-DETR मॉडल आर्किटेक्चर आवचेदक जैसे आखिरी तीन स्टेज {S3, S4, S5} को इंपुट टू एन्कोडर के रूप में दर्शाता है। कटिहरण योग्य हाइब्रिड एन्कोडर अंत: धारण विशिष्टताओं को Ekत्रित और इंत्राक्ष स्थलीय लक्षण (AIFI) और क्रॉस-स्केल लक्षण-संघटन मॉड्यूल (CCFM) द्वारा चित्र विशेषण में परिवर्तित करता है। IoU-जागरूक क्वेरी चयन का उपयोग आदर्श छवि चयन के लिए निर्धारित संख्या के चित्र विशेषताओं को कवल वस्त्रण स्वरूप में चयनित करने के लिए किया जाता है। अंत में, डिकोडर सहायक पूर्वानुमान मुद्दा किसी विशेष छवि को उपयुक्त ऑब्जेक्ट क्वेरी के रूप में आरम्भ करने के लिए संशोधित किया जाता है जिसके अंत में बॉक्स और विश्वास स्कोर पैदा किया जाता है ([स्रोत](https://arxiv.org/pdf/2304.08069.pdf))।

### मुख्य विशेषताएँ

- **कटिहरण योग्य हाइब्रिड एन्कोडर:** Baidu के RT-DETR ने इंत्रा-स्केल इंटरेक्शन और क्रॉस-स्केल फ्यूजन को अलग करके बहुस्तरीय विशेषताओं को प्रोसेस करने के लिए एक कटिहरण योग्य हाइब्रिड एन्कोडर का उपयोग किया है। यह अद्वितीय विज़न ट्रांसफॉर्मर से आधिक हिमांशीय लागत को कम करता है और वास्तविक समय ऑब्जेक्ट डिटेक्शन की अनुमति देता है।
- **IoU-जागरूक क्वेरी चयन:** Baidu के RT-DETR ने IoU-जागरूक क्वेरी चयन का उपयोग करके आदर्श छवि चयन को सुधारा है। इससे मॉडल द्वारा सीन में सबसे प्रासंगिक ऑब्जेक्ट पर केन्द्रित किया जा सकता है, जिससे डिटेक्शन की निशाना स्पष्टता में सुधार होती है।
- **अनुकूलनयोग्य अनुमान प्रदान:** Baidu के RT-DETR ने पुनर्प्रशिक्षण के आवश्यकता के बिना भिन्न डिकोडर लेयर का उपयोग करके अनुमान की गति की मान्यता में सुविधाएं समर्थित की हैं। यह अनुकूलनयोग्यता वास्तविक समय ऑब्जेक्ट डिटेक्शन स्थितियों में व्यावहारिक लागू करने की सहायता करती है।

## प्री-तारकित मॉडल

Ultralytics Python API विभिन्न स्केलों के साथ प्री-तारकित PaddlePaddle RT-DETR मॉडल प्रदान करता है:

- RT-DETR-L: COCO val2017 पर 53.0% AP, T4 GPU पर 114 FPS
- RT-DETR-X: COCO val2017 पर 54.8% AP, T4 GPU पर 74 FPS

## उपयोग उदाहरण

यह उदाहरण सरल RT-DETRR प्रशिक्षण और संदर्भ उदाहरण प्रदान करता है। पूरे दस्तावेज़ीकरण के लिए इन और अन्य [modes](../modes/index.md) पर देखें: [Predict](../modes/predict.md),  [Train](../modes/train.md), [Val](../modes/val.md) और [Export](../modes/export.md) दस्तावेज़ पृष्ठों।

!!! Example "उदाहरण"

    === "पायथन"

        ```python
        from ultralytics import RTDETR

        # COCO-प्री-तारकित RT-DETR-l मॉडल लोड करें
        model = RTDETR('rtdetr-l.pt')

        # मॉडल जानकारी प्रदर्शित करें (वैकल्पिक)
        model.info()

        # COCO8 उदाहरण डेटासेट पर मॉडल को 100 एपिसोड के लिए प्रशिक्षित करें
        results = model.train(data='coco8.yaml', epochs=100, imgsz=640)

        # RT-DETR-l मॉडल के साथ 'bus.jpg' छवि पर संदर्भ चलाएं
        results = model('path/to/bus.jpg')
        ```

    === "CLI"

        ```bash
        # COCO-प्री-तारकित RT-DETR-l मॉडल को लोड करें और उसे COCO8 उदाहरण डेटासेट पर 100 एपिसोड के लिए प्रशिक्षित करें
        yolo train model=rtdetr-l.pt data=coco8.yaml epochs=100 imgsz=640

        # COCO-प्री-तारकित RT-DETR-l मॉडल को लोड करें और 'bus.jpg' छवि पर संदर्भ चलाएं
        yolo predict model=rtdetr-l.pt source=path/to/bus.jpg
        ```

## समर्थित कार्य और मोड

इस तालिका में मॉडल प्रकार, विशेष प्री-तारकित भार, हर मॉडल द्वारा समर्थित कार्य, और [Train](../modes/train.md) , [Val](../modes/val.md), [Predict](../modes/predict.md), [Export](../modes/export.md) इत्यादि जैसे विभिन्न मोड्स विभाजित की गई हैं, ✅ इमोजियों द्वारा संकेतित हैं

| मॉडल प्रकार         | प्री-तारकित भार | समर्थित कार्य                           | संदर्भ | मान्यता | प्रशिक्षण | निर्यात |
|---------------------|-----------------|-----------------------------------------|--------|---------|-----------|---------|
| RT-DETR Large       | `rtdetr-l.pt`   | [ऑब्जेक्ट डिटेक्शन](../tasks/detect.md) | ✅      | ✅       | ✅         | ✅       |
| RT-DETR Extra-Large | `rtdetr-x.pt`   | [ऑब्जेक्ट डिटेक्शन](../tasks/detect.md) | ✅      | ✅       | ✅         | ✅       |

## प्रशंसापत्र और आभार

यदि आप अपने शोध या विकास कार्य में Baidu के RT-DETR का उपयोग करते हैं, कृपया [मूल पेपर](https://arxiv.org/abs/2304.08069) को उद्धृत करें:

!!! Quote ""

    === "BibTeX"

        ```bibtex
        @misc{lv2023detrs,
              title={DETRs Beat YOLOs on Real-time Object Detection},
              author={Wenyu Lv and Shangliang Xu and Yian Zhao and Guanzhong Wang and Jinman Wei and Cheng Cui and Yuning Du and Qingqing Dang and Yi Liu},
              year={2023},
              eprint={2304.08069},
              archivePrefix={arXiv},
              primaryClass={cs.CV}
        }
        ```

हम Baidu और [PaddlePaddle](https://github.com/PaddlePaddle/PaddleDetection) टीम को आभार प्रकट करना चाहेंगे जिन्होंने बिल्कुल लोक-दृष्टि समुदाय के लिए इस योग्य संसाधन को बनाने और संभालने का कार्य किया है। विज़न ट्रांसफॉर्मर्स-आधारित वास्तविक समय ऑब्जेक्ट डिटेक्टर RT-DETR के विकास के साथ उनके योगदान को बड़ा रूप से स्वीकार किया जाता है।

*Keywords: RT-DETR, ट्रांसफॉर्मर, ViT, विज़न ट्रांसफॉर्मर्स, Baidu RT-DETR, PaddlePaddle, PaddlePaddle RT-DETR, वास्तविक समय ऑब्जेक्ट डिटेक्शन, विज़न ट्रांसफॉर्मर्स आधारित ऑब्जेक्ट डिटेक्शन, प्री-तारकित PaddlePaddle RT-DETR मॉडल, Baidu के RT-DETR का उपयोग, Ultralytics Python API*
