---
comments: true
description: Ultralytics द्वारा समर्थित विभिन्न कंप्यूटर विज्ञान डेटासेट्स का अवलोकन | वस्त्र स्पष्टीकरण, संरेखण, पोज आकलन, छवि वर्गीकरण और बहु-वस्तु ट्रैकिंग के लिए।
keywords: computer vision, datasets, Ultralytics, YOLO, object detection, instance segmentation, pose estimation, image classification, multi-object tracking
---

# डेटासेट अवलोकन

Ultralytics कंप्यूटर विज्ञान कार्यों को सुविधाजनक बनाने के लिए विभिन्न डेटासेट्स का समर्थन प्रदान करता है। इसमें वस्त्र स्पष्टीकरण, संदर्भ बनाने, पोज आकलन, वर्गीकरण और बहु-वस्तु ट्रैकिंग जैसे कंप्यूटर विज्ञान कार्यों के लिए। नीचे मुख्य Ultralytics डेटासेट की सूची है, इसके पश्चात प्रत्येक कंप्यूटर विज्ञान कार्य और संबंधित डेटासेटों का संक्षेप दिया गया है।

!!! Note "नोट"

    🚧 हमारे बहुभाषी दस्तावेज़ीकरण वर्तमान में निर्माणाधीन है, और हम इसे सुधारने के लिए कड़ी मेहनत कर रहे हैं। आपकी सहकार्य के लिए आपका धन्यवाद! 🙏

## [वस्त्र स्पष्टीकरण डेटासेट (Detection Datasets)](../../datasets/detect/index.md)

बाउंडिंग बॉक्स ऑब्जेक्ट डिटेक्शन एक कंप्यूटर विज्ञान तकनीक है जिसमें प्रत्येक ऑब्जेक्ट के चारों ओर एक बाउंडिंग बॉक्स बनाकर छवि में ऑब्जेक्ट का पता लगाया जाता है।

- [Argoverse](../../datasets/detect/argoverse.md): एक डेटासेट जो शहरी वातावरणों से 3D ट्रैकिंग और मोशन फोरेकास्टिंग डेटा को समृद्ध एनोटेशन के साथ स्थानांतरित करता है।
- [COCO](../../datasets/detect/coco.md): एक बड़े पैमाने पर डिज़ाइन किए गए डेटासेट जिसमें ऑब्जेक्ट डिटेक्शन, सेगमेंटेशन और कैप्शनिंग के लिए 200K से अधिक लेबल चित्र हैं।
- [COCO8](../../datasets/detect/coco8.md): COCO प्रशिक्षण और COCO मूल्यांकन के पहले 4 छवियां हैं, जो त्वरित परीक्षणों के लिए उपयुक्त हैं।
- [Global Wheat 2020](../../datasets/detect/globalwheat2020.md): विश्वव्यापी गेहूँ शिर्ष छवियों का एक डेटासेट, जिसे ऑब्जेक्ट डिटेक्शन और स्थानांतरण कार्यों के लिए ऐच्छिक बनाया गया है।
- [Objects365](../../datasets/detect/objects365.md): ऑब्जेक्ट डिटेक्शन के लिए एक उच्च गुणवत्ता वाला बड़ा-स्केल डेटासेट जिसमें 365 ऑब्जेक्ट श्रेणियाँ और 600K से अधिक एनोटेटेड छवियां हैं।
- [OpenImagesV7](../../datasets/detect/open-images-v7.md): Google द्वारा एक व्यापक डेटासेट, जिसमें 1.7M प्रशिक्षण छवियां और 42k मान्यता छवियां हैं।
- [SKU-110K](../../datasets/detect/sku-110k.md): विपणनीय वातावरणों में घना ऑब्जेक्ट डिटेक्शन के तत्वों के साथ एक डेटासेट, जिसमें 11K छवियां और 1.7 मिलियन बाउंडिंग बॉक्स हैं।
- [VisDrone](../../datasets/detect/visdrone.md): ड्रोन द्वारा पकड़ी गई छवियों से ऑब्जेक्ट डिटेक्शन और बहु-ऑब्जेक्ट ट्रैकिंग डेटा का एक डेटासेट, जिसमें 10K से अधिक छवियां और वीडियो सीक्वेंसेस हैं।
- [VOC](../../datasets/detect/voc.md): Pascal Visual Object Classes (VOC) डेटासेट, जिसमें 20 ऑब्जेक्ट कक्षाएं और 11K से अधिक छवियां हैं, के लिए ऑब्जेक्ट डिटेक्शन और संवर्धन जैसे कार्यों के लिए है।
- [xView](../../datasets/detect/xview.md): ओवरहेड छवियों में ऑब्जेक्ट डिटेक्शन के लिए एक डेटासेट, जिसमें 60 ऑब्जेक्ट श्रेणियां और 1 मिलियन से अधिक एनोटेटेड ऑब्जेक्ट हैं।

## [संरेखण डेटासेट (Instance Segmentation Datasets)](../../datasets/segment/index.md)

संरेखण एक कंप्यूटर विज्ञान तकनीक है जिसमें छवि में ऑब्जेक्ट की उपयुक्त स्तर पर पहचान और स्थानांतरण होता है।

- [COCO](../../datasets/segment/coco.md): ऑब्जेक्ट डिटेक्शन, संरेखण, और कैप्शनिंग के लिए डिज़ाइन किए गए एक बड़े पैमाने पर डेटासेट जिसमें 200K से अधिक लेबल चित्र हैं।
- [COCO8-संरेखण](../../datasets/segment/coco8-seg.md): संरेखण कार्यों के लिए योग्यता युक्त 8 COCO छवियों के एक हल्का डेटासेट जिसमें संरेखण एनोटेशन्स हैं।

## [पोज आकलन (Pose Estimation)](../../datasets/pose/index.md)

पोज आकलन एक तकनीक है जिसमें ऑब्जेक्ट की पोज को कैमरे या विश्व संचालन सिद्धांत के मुकाबले आकलित किया जाता है।

- [COCO](../../datasets/pose/coco.md): पोज आकलन कार्यों के लिए मानव पोज एनोटेशन के साथ एक बड़े पैमाने पर डेटासेट।
- [COCO8-पोज](../../datasets/pose/coco8-pose.md): पोज आकलन कार्यों के लिए योग्यता युक्त 8 COCO छवियों के एक हल्का डेटासेट जिसमें मानव पोज एनोटेशन्स हैं।
- [Tiger-पोज](../../datasets/pose/tiger-pose.md): पोज आकलन कार्यों के लिए 12 कीपॉइंट्स प्रति बाघ के लिए 263 छवियों का एक संक्षिप्त डेटासेट।

## [वर्गीकरण (Classification)](../../datasets/classify/index.md)

छवि वर्गीकरण एक कंप्यूटर विज्ञान कार्य है जिसमें एक छवि को उसके विज़ुअल सामग्री के आधार पर एक या एक से अधिक पहले से निर्धारित कक्षाओं या श्रेणियों में वर्गीकृत किया जाता है।

- [Caltech 101](../../datasets/classify/caltech101.md): 101 ऑब्जेक्ट कक्षाओं की छवियां वर्गीकरण कार्यों के लिए एक डेटासेट।
- [Caltech 256](../../datasets/classify/caltech256.md): 256 ऑब्जेक्ट कक्षाओं के साथ Caltech 101 का विस्तारित संस्करण जिसमें अधिक चुनौतीपूर्ण छवियां हैं।
- [CIFAR-10](../../datasets/classify/cifar10.md): 10 कक्षाओं में 60K 32x32 रंगीन छवियों का डेटासेट, प्रति कक्षा 6K छवियां हैं।
- [CIFAR-100](../../datasets/classify/cifar100.md): 100 ऑब्जेक्ट कक्षाओं के साथ CIFAR-10 का विस्तारित संस्करण जिसमें प्रति कक्षा 600 छवियां हैं।
- [Fashion-MNIST](../../datasets/classify/fashion-mnist.md): छवि वर्गीकरण कार्यों के लिए 10 फैशन कक्षाओं के 70,000 सेंधांतरण छवि से बना एक डेटासेट।
- [ImageNet](../../datasets/classify/imagenet.md): ऑब्जेक्ट डिटेक्शन और छवि वर्गीकरण के लिए एक बड़े पैमाने पर डेटासेट, जिसमें 14 मिलियन से अधिक छवियां और 20,000 कक्षाएं हैं।
- [ImageNet-10](../../datasets/classify/imagenet10.md): छवि प्रायोगशाला में त्वरित प्रयोग और परीक्षण के लिए 10 कक्षाओं के ImageNet का एक छोटा संकलन।
- [Imagenette](../../datasets/classify/imagenette.md): त्वरित प्रशिक्षण और परीक्षण के लिए 10 आसानी से पहचाने जाने वाली कक्षाएं वाले ImageNet का एक छोटा संकलन।
- [Imagewoof](../../datasets/classify/imagewoof.md): छवि वर्गीकरण कार्यों के लिए 10 कुत्ते की नस्लों के आकृतियों के साथ ImageNet का एक अधिक चुनौतीपूर्ण संकलन।
- [MNIST](../../datasets/classify/mnist.md): छवि वर्गीकरण कार्यों के लिए हस्तलेखित अंकों के 70,000 सेंधांतरण छवि से बना एक डेटासेट।

## [उभयार्थित बाउंडिंग बॉक्सेस (Oriented Bounding Boxes, OBB)](../../datasets/obb/index.md)

उभयार्थित बाउंडिंग बॉक्सेस (OBB) एक कंप्यूटर विज्ञान में एक तरीका है जिसमें घुमे हुए बाउंडिंग बॉक्स का उपयोग करके छवियों में एंगल हुए ऑब्जेक्ट्स का पता लगाया जाता है, जो अक्सर आवक और उपग्रह प्रतिमाओं पर लागू होता है।

- [DOTAv2](../../datasets/obb/dota-v2.md): एक लोकप्रिय OBB आकाशीय छवि डेटासेट जिसमें 1.7 मिलियन आइंस्टेंसेज और 11,268 छवियां हैं।

## [बहु-ऑब्जेक्ट ट्रैकिंग (Multi-Object Tracking)](../../datasets/track/index.md)

बहु-ऑब्जेक्ट ट्रैकिंग एक कंप्यूटर विज्ञान तकनीक है जिसमें वीडियो सिक्वेंस में वक्त के साथ एक से अधिक ऑब्जेक्ट्स का पता लगाने और ट्रैक करने का शामिल है।

- [Argoverse](../../datasets/detect/argoverse.md): उच्च शहरी वातावरणों से 3D ट्रैकिंग और मोशन फोरेकास्टिंग डेटा के साथ रिच एनोटेशन के लिए एक डेटासेट।
- [VisDrone](../../datasets/detect/visdrone.md): ड्रोन-पकड़ी छवियों से ऑब्जेक्ट डिटेक्शन और बहु-ऑब्जेक्ट ट्रैकिंग डेटा का एक डेटासेट जिसमें 10K से अधिक छवियां और वीडियो सीक्वेंसेस हैं।

## नई डेटासेट का योगदान दें

नई डेटासेट का योगदान देना मौजूदा ढांचे के स्थानांतरण के साथ समर्थित होने के लिए कई चरणों का पालन करने की आवश्यकता होती है। नीचे दिए गए मानक कदम हैं:

### नई डेटासेट के योगदान के चरण

1. **छवियों का संग्रह करें**:
   डेटासेट में शामिल होने वाली छवियों का संग्रह करें। इन्हें पब्लिक डेटाबेस से या अपने संग्रह से इकट्ठा किया जा सकता है।

2. **छवि एनोटेशन करें**:
   इन छवियों को बाउंडिंग बॉक्स, संरेखण या कीपॉइंट्स के साथ थस्क करें, टास्क के आधार पर।

3. **एनोटेशन निर्यात करें**:
   इन एनोटेशन को योलो *.txt फ़ाइल प्रारूप में निर्यात करें, जिसे Ultralytics समर्थित करता है।

4. **डेटासेट व्यवस्थित करें**:
   अपने डेटासेट को सही फ़ोल्डर संरचना में व्यवस्थित करें। आपके पास `train/` और `val/` शीर्ष-स्तर निर्देशिकाएँ होनी चाहिए, और हर एक में `images/` और `labels/` उप-निर्देशिका होनी चाहिए।

    ```
    dataset/
    ├── train/
    │   ├── images/
    │   └── labels/
    └── val/
        ├── images/
        └── labels/
    ```

5. **एक `data.yaml` फ़ाइल बनाएं**:
   अपने डेटासेट के रूट निर्देशिका में, डेटासेट, कक्षाएँ, और अन्य आवश्यक जानकारी का वर्णन करने वाली `data.yaml` फ़ाइल बनाएं।

6. **छवियों को अवधित करें (वैकल्पिक)**:
   यदि आप प्रभावी प्रसंस्करण के लिए डेटासेट का आकार कम करना चाहते हैं, तो आप निम्नलिखित कोड का उपयोग करके छवियों को अवधित कर सकते हैं। यह अनिवार्य नहीं है, लेकिन छोटा डेटासेट आकार और तेज डाउनलोड की गति के लिए सिफारिश की जाती है।

7. **डेटासेट को ज़िप करें**:
   पूरे डेटासेट फ़ोल्डर को एक ज़िप फ़ाइल में संपीड़ित करें।

8. **दस्तावेज़ीकरण और पीआर**: अपने डेटासेट के बारे में एक दस्तावेज़ीकरण पेज बनाएं और उसके बारे में समर्थन करने वाली मौजूदा संरचना में कैसे समाविष्ट करें इसका वर्णन करें । उसके बाद, एक पुल अनुरोध (PR) सबमिट करें। पीआर जमा करने के लिए अधिक विवरण के लिए [उल्ट्रालिटिक्स योगदान दिशानिर्देशिका](https://docs.ultralytics.com/help/contributing) देखें।

### डेटासेट को अवधित करने और ज़िप करने के लिए उदाहरण कोड

!!! Example "डेटासेट को अवधित करने और ज़िप करने के लिए उदाहरण कोड"

    === "Python"

    ```python
    from pathlib import Path
    from ultralytics.data.utils import compress_one_image
    from ultralytics.utils.downloads import zip_directory

    # डेटासेट निर्देशिका को परिभाषित करें
    path = Path('path/to/dataset')

    # डेटासेट में छवि अवधित करें (वैकल्पिक)
    for f in path.rglob('*.jpg'):
        compress_one_image(f)

    # डेटासेट को 'path/to/dataset.zip' में ज़िप करें
    zip_directory(path)
    ```

इन कदमों का पालन करके, आप अपने डेटासेट का योगदान प्रदान कर सकते हैं जो Ultralytics के मौजूदा संरचना के अच्छी तरह से समाविष्ट होता है।
