---
comments: true
description: اكتشف كيفية استخدام وضع التنبؤ YOLOv8 لمهام مختلفة. تعرّف على مصادر التنبؤ المختلفة مثل الصور ومقاطع الفيديو وتنسيقات البيانات المختلفة.
keywords: Ultralytics، YOLOv8، وضع التنبؤ، مصادر التنبؤ، مهام التنبؤ، وضع التدفق، معالجة الصور، معالجة الفيديو، التعلم الآلي، الذكاء الاصطناعي
---

# التنبؤ بالنموذج باستخدام Ultralytics YOLO

<img width="1024" src="https://github.com/ultralytics/assets/raw/main/yolov8/banner-integrations.png" alt="البيئة والتكامل الخاصة بنظام Ultralytics YOLO">

## المقدمة

في عالم التعلم الآلي ورؤية الحاسوب، يُطلق على عملية استخلاص المعنى من البيانات البصرية اسم "الاستدلال" أو "التنبؤ". يوفر YOLOv8 من Ultralytics ميزة قوية تُعرف بـ**وضع التنبؤ** والتي تم تصميمها خصيصًا للاستدلال في الوقت الحقيقي وبأداء عال على مجموعة واسعة من مصادر البيانات.

<p align="center">
  <br>
  <iframe width="720" height="405" src="https://www.youtube.com/embed/QtsI0TnwDZs?si=ljesw75cMO2Eas14"
    title="مشغل الفيديو" frameborder="0"
    allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture; web-share"
    allowfullscreen>
  </iframe>
  <br>
  <strong>شاهد:</strong> كيفية استخراج النتائج من نموذج Ultralytics YOLOv8 لمشاريع مخصصة.
</p>

## التطبيقات في العالم الحقيقي

|                      التصنيع                      |                       الرياضة                        |                   السلامة                   |
|:-------------------------------------------------:|:----------------------------------------------------:|:-------------------------------------------:|
| ![Vehicle Spare Parts Detection][car spare parts] | ![Football Player Detection][football player detect] | ![People Fall Detection][human fall detect] |
|               كشف قطع غيار المركبات               |                 كشف لاعبي كرة القدم                  |              كشف سقوط الأشخاص               |

## لماذا يجب استخدام Ultralytics YOLO لعمليات التنبؤ؟

فيما يلي الأسباب التي يجب أخذها في الاعتبار عند الاستفادة من وضع التنبؤ YOLOv8 لاحتياجات التنبؤ المختلفة:

- **التنوع:** قادر على التنبؤ على الصور ومقاطع الفيديو، وحتى التدفقات الحية.
- **الأداء:** مصمم للتطبيقات في الوقت الحقيقي والمعالجة عالية السرعة دون التضحية بالدقة.
- **سهولة الاستخدام:** واجهات Python والواجهة السطرية لتسريع النشر والاختبار.
- **قابلية التخصيص العالية:** إعدادات ومعلمات مختلفة لضبط سلوك التنبؤ النموذج وفقًا لمتطلباتك المحددة.

### الميزات الرئيسية لوضع التنبؤ

تم تصميم وضع التنبؤ الخاص بـ YOLOv8 ليكون قويًا ومتعدد الاستخدامات، ويتميز بما يلي:

- **توافق متعدد مصادر البيانات:** سواء كانت بياناتك عبارة عن صور فردية أو مجموعة من الصور أو ملفات فيديو أو تدفقات فيديو في الوقت الحقيقي، سيتمكن وضع التنبؤ من التعامل معها جميعًا.
- **وضع التدفق الحي:** استخدم ميزة التدفق لإنشاء مولد فعّال لكائنات "النتائج" باستخدام الذاكرة. قم بتمكين هذا بتعيين `stream=True` في طريقة استدعاء المتنبئ.
- **معالجة دُفعات:** القدرة على معالجة العديد من الصور أو إطارات الفيديو في دُفعة واحدة، مما يزيد أكثر من سرعة التنبؤ.
- **سهل التكامل:** يسهل الدمج مع خطوط الأنابيب البيانية الحالية ومكونات البرامج الأخرى بفضل واجهة برمجة التطبيقات المرنة.

تُرجع نماذج Ultralytics YOLO إما قائمة Python من كائنات "النتائج" أو مُنشئ برمجياً فعّال لكائنات الـ "النتائج" في حال تم تمرير `stream=True` إلى النموذج أثناء عملية التنبؤ:

!!! Example "التنبؤ"

    === "العودة بقائمة واحدة باستخدام `stream=False`"
        ```python
        from ultralytics import YOLO

        # تحميل نموذج
        model = YOLO('yolov8n.pt')  # نموذج YOLOv8n المُدرَّب مسبقًا

        # تشغيل التنبؤ بدُفعة على قائمة من الصور
        results = model(['im1.jpg', 'im2.jpg'])  # العودة بقائمة من كائنات 'النتائج'

        # معالجة قائمة النتائج
        for result in results:
            boxes = result.boxes  # كائن Boxes لمخرجات bbox
            masks = result.masks  # كائن Masks لمخرجات قنوات الفصل العنقودي
            keypoints = result.keypoints  # كائن Keypoints لمخرجات الاتجاهات
            probs = result.probs  # كائن Probs لمخرجات التصنيف
        ```

    === "العودة بمُنشئ فعال مع `stream=True`"
        ```python
        from ultralytics import YOLO

        # تحميل نموذج
        model = YOLO('yolov8n.pt')  # نموذج YOLOv8n المُدرَّب مسبقًا

        # تشغيل التنبؤ بدُفعة على قائمة من الصور
        results = model(['im1.jpg', 'im2.jpg'], stream=True)  # العودة بمُنشئ فعال لكائنات 'النتائج'

        # معالجة المُنشئ الفعال
        for result in results:
            boxes = result.boxes  # كائن Boxes لمخرجات bbox
            masks = result.masks  # كائن Masks لمخرجات قنوات الفصل العنقودي
            keypoints = result.keypoints  # كائن Keypoints لمخرجات الاتجاهات
            probs = result.probs  # كائن Probs لمخرجات التصنيف
        ```

## مصادر التنبؤ

يمكن لـ YOLOv8 معالجة أنواع مختلفة من مصادر الإدخال لعملية الاستدلال، على النحو الموضح في الجدول أدناه. تشمل المصادر الصور الثابتة وتيارات الفيديو وتنسيقات مختلفة للبيانات. يشير الجدول أيضًا إلى ما إذا كان يمكن استخدام كل مصدر في وضع التدفق باستخدام الوسيط `stream=True` ✅. يعتبر وضع التدفق مفيدًا لمعالجة مقاطع الفيديو أو التدفقات الحية حيث يقوم بإنشاء مُنشئ للنتائج بدلاً من تحميل جميع الإطارات في الذاكرة.

!!! Tip "طراز"

    استخدم `stream=True` لمعالجة مقاطع الفيديو الطويلة أو مجموعات البيانات الكبيرة لإدارة الذاكرة بكفاءة. عندما تكون القيمة مساوية لـ `stream=False`، يتم تخزين النتائج لجميع الإطارات أو نقاط البيانات في الذاكرة، والتي يمكن أن تتراكم بسرعة وتُسبِّب أخطاء الذاكرة غير الكافية للمدخلات الكبيرة. على النقيض من ذلك، يستخدم التدفق `stream=True` مولدًا يُبقي نتائج الإطار الحالي أو نقطة البيانات الحالية في الذاكرة فقط، مما يقلل بشكل كبير من استهلاك الذاكرة ويمنع مشكلات عدم كفاية الذاكرة.

| مصدر             | الوسيط                                     | النوع           | الملاحظات                                                                                    |
|------------------|--------------------------------------------|-----------------|----------------------------------------------------------------------------------------------|
| صورة             | `'صورة.jpg'`                               | `str` or `Path` | ملف صورة واحدة.                                                                              |
| رابط URL         | `'https://ultralytics.com/images/bus.jpg'` | `str`           | رابط URL لصورة ما.                                                                           |
| لقطة شاشة برمجية | `'الشاشة'`                                 | `str`           | قم بالتقاط لقطة شاشة برمجية.                                                                 |
| PIL              | `Image.open('im.jpg')`                     | `PIL.Image`     | الصيغة HWC مع قنوات RGB.                                                                     |
| OpenCV           | `cv2.imread('im.jpg')`                     | `np.ndarray`    | الصيغة HWC مع قنوات BGR `uint8 (0-255)`.                                                     |
| numpy            | `np.zeros((640,1280,3))`                   | `np.ndarray`    | الصيغة HWC مع قنوات BGR `uint8 (0-255)`.                                                     |
| torch            | `torch.zeros(16,3,320,640)`                | `torch.Tensor`  | الصيغة BCHW مع قنوات RGB `float32 (0.0-1.0)`.                                                |
| CSV              | `'المصادر.csv'`                            | `str` or `Path` | ملف CSV يحتوي على مسارات الصور أو مقاطع الفيديو أو المجلدات.                                 |
| فيديو  ✅         | `'الفيديو.mp4'`                            | `str` or `Path` | ملف فيديو بتنسيقات مثل MP4 و AVI وما إلى ذلك.                                                |
| الدليل  ✅        | `'المسار/'`                                | `str` or `Path` | مسار إلى مجلد يحتوي على صور أو مقاطع فيديو.                                                  |
| glob ✅           | `'المسار/*.jpg'`                           | `str`           | نمط glob لمطابقة عدة ملفات. استخدم حرف `*` كحرطوم.                                           |
| يوتيوب ✅         | `'https://youtu.be/LNwODJXcvt4'`           | `str`           | رابط URL إلى فيديو يوتيوب.                                                                   |
| تدفق ✅           | `'rtsp://example.com/media.mp4'`           | `str`           | عنوان URL لبروتوكولات التدفق مثل RTSP و RTMP و TCP أو عنوان IP.                              |
| تدفق متعدد ✅     | `'list.streams'`                           | `str` or `Path` | ملف نصي `*.streams` مع عنوان تدفق URL في كل صف، على سبيل المثال 8 تدفقات ستعمل بحجم دُفعة 8. |

فيما يلي أمثلة تعليمات برمجية لاستخدام كل نوع من مصدر:

!!! Example "مصادر التنبؤ"

    === "الصورة"
        قم بأجراء عملية التنبؤ على ملف صورة.
        ```python
        from ultralytics import YOLO

        # تحميل نموذج YOLOv8n المدرب مسبقًا
        model = YOLO('yolov8n.pt')

        # تنشيط عملية التنبؤ لملف الصورة
        source = 'المسار/إلى/الصورة.jpg'

        # الجمع بين التنبؤ على المصدر
        results = model(source)  # قائمة كائنات النتائج
        ```

    === "لقطة شاشة برمجية"
        قم بأجراء عملية التنبؤ على محتوى الشاشة الحالي كلقطة شاشة.
        ```python
        from ultralytics import YOLO

        # تحميل نموذج YOLOv8n المدرب مسبقًا
        model = YOLO('yolov8n.pt')

        # تعريف اللقطة الحالية كمصدر
        source = 'الشاشة'

        # الجمع بين التنبؤ على المصدر
        results = model(source)  # قائمة كائنات النتائج
        ```

    === "رابط URL"
        قم بأجراء عملية التنبؤ على صورة موجودة على الإنترنت أو فيديو.
        ```python
        from ultralytics import YOLO

        # تحميل نموذج YOLOv8n المدرب مسبقًا
        model = YOLO('yolov8n.pt')

        # تعريف رابط الصورة أو الفيديو على الإنترنت
        source = 'https://ultralytics.com/images/bus.jpg'

        # الجمع بين التنبؤ على المصدر
        results = model(source)  # قائمة كائنات النتائج
        ```

    === "PIL"
        قم بأجراء عملية التنبؤ على صورة مفتوحة بواسطة مكتبة Python Imaging Library (PIL).
        ```python
        from PIL import Image
        from ultralytics import YOLO

        # تحميل نموذج YOLOv8n المدرب مسبقًا
        model = YOLO('yolov8n.pt')

        # فتح صورة باستخدام PIL
        source = Image.open('المسار/إلى/الصورة.jpg')

        # الجمع بين التنبؤ على المصدر
        results = model(source)  # قائمة كائنات النتائج
        ```

    === "OpenCV"
        قم بأجراء عملية التنبؤ على صورة مُقروءة بواسطة OpenCV.
        ```python
        import cv2
        from ultralytics import YOLO

        # تحميل نموذج YOLOv8n المدرب مسبقًا
        model = YOLO('yolov8n.pt')

        # قراءة صورة باستخدام OpenCV
        source = cv2.imread('المسار/إلى/الصورة.jpg')

        # الجمع بين التنبؤ على المصدر
        results = model(source)  # قائمة كائنات النتائج
        ```

    === "numpy"
        قم بأجراء عملية التنبؤ على صورة مُمثلة كمصفوفة numpy.
        ```python
        import numpy as np
        from ultralytics import YOLO

        # تحميل نموذج YOLOv8n المدرب مسبقًا
        model = YOLO('yolov8n.pt')

        # إنشاء مصفوفة numpy عشوائية في صيغة HWC (640, 640, 3) بقيم بين [0, 255] ونوع uint8
        source = np.random.randint(low=0, high=255, size=(640, 640, 3), dtype='uint8')

        # الجمع بين التنبؤ على المصدر
        results = model(source)  # قائمة كائنات النتائج
        ```

[car spare parts]: https://github.com/RizwanMunawar/ultralytics/assets/62513924/a0f802a8-0776-44cf-8f17-93974a4a28a1

[football player detect]: https://github.com/RizwanMunawar/ultralytics/assets/62513924/7d320e1f-fc57-4d7f-a691-78ee579c3442

[human fall detect]: https://github.com/RizwanMunawar/ultralytics/assets/62513924/86437c4a-3227-4eee-90ef-9efb697bdb43
