---
comments: true
description: Изучите Meituan YOLOv6 - современную модель обнаружения объектов, отличающуюся балансом между скоростью и точностью. Подробнее о функциях, предварительно обученных моделях и использовании Python.
keywords: Meituan YOLOv6, обнаружение объектов, Ultralytics, документация YOLOv6, двустороннее объединение, тренировка с использованием якорей, предварительно обученные модели, приложения в реальном времени
---

# Meituan YOLOv6

## Обзор

[Meituan](https://about.meituan.com/) YOLOv6 - это передовая модель обнаружения объектов, которая отлично сочетает в себе скорость и точность, что делает ее популярным выбором для приложений в реальном времени. Эта модель включает несколько значимых улучшений в своей архитектуре и схеме обучения, включая внедрение модуля двустороннего объединения (BiC), стратегию тренировки с использованием якорей (AAT) и улучшенный дизайн базовой и верхней частей для достижения передовой точности на наборе данных COCO.

![Meituan YOLOv6](https://user-images.githubusercontent.com/26833433/240750495-4da954ce-8b3b-41c4-8afd-ddb74361d3c2.png)
![Изображение примера модели](https://user-images.githubusercontent.com/26833433/240750557-3e9ec4f0-0598-49a8-83ea-f33c91eb6d68.png)
**Обзор YOLOv6.** Диаграмма архитектуры модели, показывающая переработанные компоненты сети и стратегии тренировки, которые приводят к значительному улучшению производительности. (a) Верхняя часть YOLOv6 (показаны N и S). Обратите внимание, что для M/L блок RepBlocks заменен на CSPStackRep. (b) Структура модуля BiC. (c) Блок SimCSPSPPF block. ([исходник](https://arxiv.org/pdf/2301.05586.pdf)).

### Основные функции

- **Модуль двустороннего объединения (BiC):** YOLOv6 включает модуль BiC в верхнюю часть детектора, улучшая сигналы локализации и обеспечивая прирост производительности при минимальном снижении скорости.
- **Стратегия тренировки с использованием якорей (AAT):** Эта модель предлагает AAT, чтобы воспользоваться преимуществами как якорных, так и бесконтурных парадигм без ущерба для эффективности вывода.
- **Улучшенный дизайн базовой и верхней частей:** Путем расширения YOLOv6 за счет добавления еще одной стадии в базовую и верхнюю часть модели достигается передовая производительность на наборе данных COCO при высоком разрешении входных изображений.
- **Стратегия самостоятельной стабилизации:** Внедряется новая стратегия самостоятельной стабилизации для повышения производительности меньших моделей YOLOv6, улучшая вспомогательное регрессионное ветвление во время тренировки и удаляя его во время вывода, чтобы избежать заметного снижения скорости.

## Метрики производительности

YOLOv6 предоставляет несколько предварительно обученных моделей различных масштабов:

- YOLOv6-N: 37.5% AP на наборе данных COCO val2017 при 1187 кадрах в секунду (FPS) с использованием графического процессора NVIDIA Tesla T4.
- YOLOv6-S: 45.0% AP при 484 FPS.
- YOLOv6-M: 50.0% AP при 226 FPS.
- YOLOv6-L: 52.8% AP при 116 FPS.
- YOLOv6-L6: Передовая точность в реальном времени.

YOLOv6 также предоставляет квантованные модели для разных точностей и модели, оптимизированные для мобильных платформ.

## Примеры использования

В этом примере приведены простые примеры тренировки и вывода с использованием YOLOv6. Полная документация по этим и другим [режимам](../modes/index.md) доступна на страницах документации [Predict](../modes/predict.md),  [Train](../modes/train.md), [Val](../modes/val.md) и [Export](../modes/export.md).

!!! Example "Пример"

    === "Python"

        Модели PyTorch, предварительно обученные с помощью файлов `*.pt`, а также файлы конфигурации `*.yaml` могут быть переданы в класс `YOLO()` для создания экземпляра модели на Python:

        ```python
        from ultralytics import YOLO

        # Построение модели YOLOv6n с нуля
        model = YOLO('yolov6n.yaml')

        # Отображение информации о модели (по желанию)
        model.info()

        # Тренировка модели на примере набора данных COCO8 в течение 100 эпох
        results = model.train(data='coco8.yaml', epochs=100, imgsz=640)

        # Вывод результатов с использованием модели YOLOv6n на изображении 'bus.jpg'
        results = model('path/to/bus.jpg')
        ```

    === "CLI"

        Доступны команды интерфейса командной строки для непосредственного запуска моделей:

        ```bash
        # Построение модели YOLOv6n с нуля и тренировка на примере набора данных COCO8 в течение 100 эпох
        yolo train model=yolov6n.yaml data=coco8.yaml epochs=100 imgsz=640

        # Построение модели YOLOv6n с нуля и вывод результатов на изображении 'bus.jpg'
        yolo predict model=yolov6n.yaml source=path/to/bus.jpg
        ```

## Поддерживаемые задачи и режимы

Серия моделей YOLOv6 предлагает широкий выбор моделей с оптимизацией для [обнаружения объектов](../tasks/detect.md) высокой производительности. Они удовлетворяют различным вычислительным потребностям и требованиям точности, что делает их универсальными для широкого спектра приложений.

| Тип модели | Предварительно обученные веса | Поддерживаемые задачи                      | Вывод результатов | Валидация | Тренировка | Экспорт |
|------------|-------------------------------|--------------------------------------------|-------------------|-----------|------------|---------|
| YOLOv6-N   | `yolov6-n.pt`                 | [Обнаружение объектов](../tasks/detect.md) | ✅                 | ✅         | ✅          | ✅       |
| YOLOv6-S   | `yolov6-s.pt`                 | [Обнаружение объектов](../tasks/detect.md) | ✅                 | ✅         | ✅          | ✅       |
| YOLOv6-M   | `yolov6-m.pt`                 | [Обнаружение объектов](../tasks/detect.md) | ✅                 | ✅         | ✅          | ✅       |
| YOLOv6-L   | `yolov6-l.pt`                 | [Обнаружение объектов](../tasks/detect.md) | ✅                 | ✅         | ✅          | ✅       |
| YOLOv6-L6  | `yolov6-l6.pt`                | [Обнаружение объектов](../tasks/detect.md) | ✅                 | ✅         | ✅          | ✅       |

Эта таблица предоставляет подробный обзор вариантов моделей YOLOv6, подчеркивая их возможности в задачах обнаружения объектов и совместимость с различными операционными режимами, такими как [Вывод результатов](../modes/predict.md), [Валидация](../modes/val.md), [Тренировка](../modes/train.md) и [Экспорт](../modes/export.md). Это обширная поддержка позволяет пользователям полностью использовать возможности моделей YOLOv6 в широком спектре сценариев обнаружения объектов.

## Цитирования и благодарности

Мы хотели бы выразить благодарность авторам исследования за их значительный вклад в области обнаружения объектов в реальном времени:

!!! Quote ""

    === "BibTeX"

        ```bibtex
        @misc{li2023yolov6,
              title={YOLOv6 v3.0: A Full-Scale Reloading},
              author={Chuyi Li and Lulu Li and Yifei Geng and Hongliang Jiang and Meng Cheng and Bo Zhang and Zaidan Ke and Xiaoming Xu and Xiangxiang Chu},
              year={2023},
              eprint={2301.05586},
              archivePrefix={arXiv},
              primaryClass={cs.CV}
        }
        ```

    Исходную статью об YOLOv6 можно найти на [arXiv](https://arxiv.org/abs/2301.05586). Авторы сделали свою работу общедоступной, и код доступен на [GitHub](https://github.com/meituan/YOLOv6). Мы ценим их усилия в развитии этой области и доступности их работы для широкого сообщества.
