---
comments: true
description: Изучите полное руководство по Ultralytics YOLOv8, модели обнаружения объектов и сегментации изображений с высокой скоростью и точностью. Учебники по установке, предсказаниям, тренировке и многое другое.
keywords: Ultralytics, YOLOv8, обнаружение объектов, сегментация изображений, машинное обучение, глубокое обучение, компьютерное зрение, установка YOLOv8, предсказание YOLOv8, тренировка YOLOv8, история YOLO, лицензии YOLO
---

<div align="center">
  <p>
    <a href="https://yolovision.ultralytics.com" target="_blank">
    <img width="1024" src="https://raw.githubusercontent.com/ultralytics/assets/main/yolov8/banner-yolov8.png" alt="Ultralytics YOLO banner"></a>
  </p>
  <a href="https://github.com/ultralytics"><img src="https://github.com/ultralytics/assets/raw/main/social/logo-social-github.png" width="3%" alt="GitHub Ultralytics"></a>
  <img src="https://github.com/ultralytics/assets/raw/main/social/logo-transparent.png" width="3%">
  <a href="https://www.linkedin.com/company/ultralytics/"><img src="https://github.com/ultralytics/assets/raw/main/social/logo-social-linkedin.png" width="3%" alt="LinkedIn Ultralytics"></a>
  <img src="https://github.com/ultralytics/assets/raw/main/social/logo-transparent.png" width="3%">
  <a href="https://twitter.com/ultralytics"><img src="https://github.com/ultralytics/assets/raw/main/social/logo-social-twitter.png" width="3%" alt="Twitter Ultralytics"></a>
  <img src="https://github.com/ultralytics/assets/raw/main/social/logo-transparent.png" width="3%">
  <a href="https://youtube.com/ultralytics"><img src="https://github.com/ultralytics/assets/raw/main/social/logo-social-youtube.png" width="3%" alt="YouTube Ultralytics"></a>
  <img src="https://github.com/ultralytics/assets/raw/main/social/logo-transparent.png" width="3%">
  <a href="https://www.tiktok.com/@ultralytics"><img src="https://github.com/ultralytics/assets/raw/main/social/logo-social-tiktok.png" width="3%" alt="TikTok Ultralytics"></a>
  <img src="https://github.com/ultralytics/assets/raw/main/social/logo-transparent.png" width="3%">
  <a href="https://www.instagram.com/ultralytics/"><img src="https://github.com/ultralytics/assets/raw/main/social/logo-social-instagram.png" width="3%" alt="Instagram Ultralytics"></a>
  <img src="https://github.com/ultralytics/assets/raw/main/social/logo-transparent.png" width="3%">
  <a href="https://ultralytics.com/discord"><img src="https://github.com/ultralytics/assets/raw/main/social/logo-social-discord.png" width="3%" alt="Discord Ultralytics"></a>
  <br>
  <br>
  <a href="https://github.com/ultralytics/ultralytics/actions/workflows/ci.yaml"><img src="https://github.com/ultralytics/ultralytics/actions/workflows/ci.yaml/badge.svg" alt="CI Ultralytics"></a>
  <a href="https://codecov.io/github/ultralytics/ultralytics"><img src="https://codecov.io/github/ultralytics/ultralytics/branch/main/graph/badge.svg?token=HHW7IIVFVY" alt="Покрытие кода Ultralytics"></a>
  <a href="https://zenodo.org/badge/latestdoi/264818686"><img src="https://zenodo.org/badge/264818686.svg" alt="Цитирование YOLOv8"></a>
  <a href="https://hub.docker.com/r/ultralytics/ultralytics"><img src="https://img.shields.io/docker/pulls/ultralytics/ultralytics?logo=docker" alt="Загрузки Docker"></a>
  <br>
  <a href="https://console.paperspace.com/github/ultralytics/ultralytics"><img src="https://assets.paperspace.io/img/gradient-badge.svg" alt="Запустить на Gradient"/></a>
  <a href="https://colab.research.google.com/github/ultralytics/ultralytics/blob/main/examples/tutorial.ipynb"><img src="https://colab.research.google.com/assets/colab-badge.svg" alt="Открыть в Colab"></a>
  <a href="https://www.kaggle.com/ultralytics/yolov8"><img src="https://kaggle.com/static/images/open-in-kaggle.svg" alt="Открыть в Kaggle"></a>
</div>

Представляем [Ultralytics](https://ultralytics.com) [YOLOv8](https://github.com/ultralytics/ultralytics) — последнюю версию знаменитой модели для обнаружения объектов в реальном времени и сегментации изображений. YOLOv8 основан на передовом прогрессе в области глубокого обучения и компьютерного зрения и предлагает непревзойденную производительность в отношении скорости и точности. Его оптимизированная конструкция делает его подходящим для различных приложений и легко адаптируемым к различным аппаратным платформам, от устройств на краю сети до облачных API.

Исследуйте документацию YOLOv8 — обширный ресурс, разработанный, чтобы помочь вам понять и использовать его функции и возможности. Независимо от того, являетесь ли вы опытным практиком машинного обучения или новичком в этой области, этот центр ресурсов нацелен на максимальное раскрытие потенциала YOLOv8 в ваших проектах.

!!! Note "Заметка"

    🚧 Наша многоязычная документация в настоящее время находится в стадии разработки, и мы усердно работаем над ее улучшением. Спасибо за ваше терпение! 🙏

## С чего начать

- **Установите** `ultralytics` с помощью pip и приступайте к работе за несколько минут &nbsp; [:material-clock-fast: Начать работу](quickstart.md){ .md-button }
- **Предскажите** новые изображения и видео с помощью YOLOv8 &nbsp; [:octicons-image-16: Предсказания для изображений](modes/predict.md){ .md-button }
- **Тренируйте** новую модель YOLOv8 на своих собственных наборах данных &nbsp; [:fontawesome-solid-brain: Тренировать модель](modes/train.md){ .md-button }
- **Исследуйте** задачи YOLOv8, такие как сегментация, классификация, оценка позы и отслеживание &nbsp; [:material-magnify-expand: Исследовать задачи](tasks/index.md){ .md-button }

<p align="center">
  <br>
  <iframe width="720" height="405" src="https://www.youtube.com/embed/LNwODJXcvt4?si=7n1UvGRLSd9p5wKs"
    title="Проигрыватель YouTube" frameborder="0"
    allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture; web-share"
    allowfullscreen>
  </iframe>
  <br>
  <strong>Смотрите:</strong> Как тренировать модель YOLOv8 на своем пользовательском наборе данных в <a href="https://colab.research.google.com/github/ultralytics/ultralytics/blob/main/examples/tutorial.ipynb" target="_blank">Google Colab</a>.
</p>

## YOLO: Краткая история

[YOLO](https://arxiv.org/abs/1506.02640) (You Only Look Once — «Смотришь только один раз»), популярная модель для обнаружения объектов и сегментации изображений, была разработана Джозефом Редмоном и Али Фархади из Вашингтонского университета. Запущенная в 2015 году, YOLO быстро обрела популярность благодаря своей высокой скорости и точности.

- [YOLOv2](https://arxiv.org/abs/1612.08242), выпущенная в 2016 году, улучшила оригинальную модель, включив в себя пакетную нормализацию, якорные окна и кластеры размеров.
- [YOLOv3](https://pjreddie.com/media/files/papers/YOLOv3.pdf), запущенная в 2018 году, дополнительно улучшила производительность модели, используя более эффективную основную сеть, множество якорей и пирамидальное пространственное пулинг.
- [YOLOv4](https://arxiv.org/abs/2004.10934) была выпущена в 2020 году, представив такие инновации, как увеличение данных Mosaic, новую свободную от якорьной голову детектирования и новую функцию потерь.
- [YOLOv5](https://github.com/ultralytics/yolov5) дальше улучшила производительность модели и добавила новые функции, такие как оптимизация гиперпараметров, интегрированнное отслеживание экспериментов и автоматический экспорт в популярные форматы.
- [YOLOv6](https://github.com/meituan/YOLOv6) была опубликована в открытом доступе компанией [Meituan](https://about.meituan.com/) в 2022 году и используется во многих автономных роботах доставки компании.
- [YOLOv7](https://github.com/WongKinYiu/yolov7) добавила дополнительные задачи, такие как оценка позы по набору данных ключевых точек COCO.
- [YOLOv8](https://github.com/ultralytics/ultralytics) — последняя версия YOLO от Ultralytics. Будучи передовой, современной моделью, YOLOv8 основана на успехе предыдущих версий, внедряя новые функции и усовершенствования для повышения производительности, гибкости и эффективности. YOLOv8 поддерживает полный спектр задач в области компьютерного зрения, включая [обнаружение](tasks/detect.md), [сегментацию](tasks/segment.md), [оценку позы](tasks/pose.md), [отслеживание](modes/track.md) и [классификацию](tasks/classify.md). Это многосторонность позволяет пользователям использовать возможности YOLOv8 в самых разнообразных приложениях и сферах деятельности.

## Лицензии YOLO: Как лицензируется YOLO от Ultralytics?

Ultralytics предлагает два варианта лицензирования для удовлетворения разнообразных сценариев использования:

- **Лицензия AGPL-3.0**: Эта одобренная [OSI](https://opensource.org/licenses/) лицензия с открытым исходным кодом идеально подходит для студентов и энтузиастов, способствуя открытому сотрудничеству и обмену знаниями. Подробную информацию смотрите в файле [LICENSE](https://github.com/ultralytics/ultralytics/blob/main/LICENSE).
- **Корпоративная лицензия**: Разработанная для коммерческого использования, эта лицензия позволяет беспрепятственно интегрировать программное обеспечение и AI-модели Ultralytics в товары и услуги коммерческого назначения, обходя требования открытого исходного кода AGPL-3.0. Если ваш сценарий включает внедрение наших решений в коммерческое предложение, обратитесь через [Лицензирование Ultralytics](https://ultralytics.com/license).

Наша стратегия лицензирования разработана, чтобы обеспечить возврат усовершенствований наших проектов с открытым исходным кодом обществу. Мы твердо привержены принципам открытого исходного кода ❤️ и наша миссия заключается в гарантировании того, что наши вклады могут быть использованы и расширены таким образом, который будет полезен для всех.
