---
comments: true
description: Ultralyticsがサポートするオブジェクト検出、セグメンテーション、ポーズ推定、画像分類、マルチオブジェクト追跡に対応した各種コンピュータビジョンデータセットを探求します。
keywords: コンピュータビジョン, データセット, Ultralytics, YOLO, オブジェクト検出, インスタンスセグメンテーション, ポーズ推定, 画像分類, マルチオブジェクト追跡
---

# データセット概要

Ultralyticsは、検出、インスタンスセグメンテーション、ポーズ推定、分類、マルチオブジェクト追跡などのコンピュータビジョンタスクを容易にするために、様々なデータセットをサポートしています。以下は主要なUltralyticsデータセットのリストであり、それに続いて各コンピュータビジョンタスクの概要と関連するデータセットが記載されています。

!!! Note "ノート"

    🚧 当社の多言語ドキュメントは現在作成中であり、改善のため頑張って作業しています。ご理解いただいてありがとうございます！ 🙏

## [検出データセット](../../datasets/detect/index.md)

バウンディングボックスオブジェクト検出は、画像内のオブジェクトを検出し、各オブジェクトの周りにバウンディングボックスを描くことによって局在化するコンピュータビジョン技術です。

- [Argoverse](../../datasets/detect/argoverse.md): 都市環境からの3D追跡と運動予測データを含むデータセットで、詳細なアノテーションが付けられています。
- [COCO](../../datasets/detect/coco.md): オブジェクト検出、セグメンテーション、キャプショニング用に設計された大規模データセットで、20万以上のラベル付き画像が含まれています。
- [COCO8](../../datasets/detect/coco8.md): COCO trainとCOCO valの最初の4画像を含み、クイックテストに適しています。
- [Global Wheat 2020](../../datasets/detect/globalwheat2020.md): 世界中から収集された小麦頭画像のデータセットで、オブジェクト検出と局在化タスク用です。
- [Objects365](../../datasets/detect/objects365.md): 365のオブジェクトカテゴリと60万以上のアノテート画像を含む高品質の大規模オブジェクト検出データセットです。
- [OpenImagesV7](../../datasets/detect/open-images-v7.md): Googleによる総合的なデータセットで、170万のトレイン画像と42kのバリデーション画像を含んでいます。
- [SKU-110K](../../datasets/detect/sku-110k.md): 小売環境での密集したオブジェクト検出を特徴とするデータセットで、11Kの画像と170万のバウンディングボックスがあります。
- [VisDrone](../../datasets/detect/visdrone.md): ドローンがキャプチャした映像からのオブジェクト検出とマルチオブジェクト追跡データを含むデータセットで、1万以上の画像とビデオシーケンスがあります。
- [VOC](../../datasets/detect/voc.md): パスカルビジュアルオブジェクトクラス（VOC）データセットで、オブジェクト検出とセグメンテーション用に、20のオブジェクトクラスと11K以上の画像が含まれています。
- [xView](../../datasets/detect/xview.md): 上空画像でのオブジェクト検出用データセットで、60のオブジェクトカテゴリを含み、100万以上のアノテートオブジェクトが含まれています。

## [インスタンスセグメンテーションデータセット](../../datasets/segment/index.md)

インスタンスセグメンテーションは、画像内のオブジェクトをピクセルレベルで識別し、局在化するコンピュータビジョン技術です。

- [COCO](../../datasets/segment/coco.md): オブジェクト検出、セグメンテーション、キャプショニングタスク用に設計された大規模データセットで、20万以上のラベル付き画像が含まれています。
- [COCO8-seg](../../datasets/segment/coco8-seg.md): セグメンテーションアノテーションを含む8つのCOCO画像を含んだ、より小さなインスタンスセグメンテーションタスク用データセットです。

## [ポーズ推定](../../datasets/pose/index.md)

ポーズ推定は、カメラや世界座標系に対するオブジェクトのポーズを決定するために使用される技術です。

- [COCO](../../datasets/pose/coco.md): ポーズ推定タスク用に設計された大規模データセットで、人間のポーズアノテーションが含まれています。
- [COCO8-pose](../../datasets/pose/coco8-pose.md): 人間のポーズアノテーションを含む8つのCOCO画像を含んだ、小規模のポーズ推定タスク用データセットです。
- [Tiger-pose](../../datasets/pose/tiger-pose.md): タイガーのポーズ推定タスク用に、263枚の画像で構成され、1匹のタイガーに対して12個のキーポイントがアノテートされたコンパクトなデータセットです。

## [分類](../../datasets/classify/index.md)

画像分類は、そのビジュアルコンテンツに基づいて一つまたは複数の定義済みクラスやカテゴリに画像を分類するコンピュータビジョンタスクです。

- [Caltech 101](../../datasets/classify/caltech101.md): 101のオブジェクトカテゴリを含む画像で構成された、画像分類タスク用データセッ トです。
- [Caltech 256](../../datasets/classify/caltech256.md): Caltech 101の拡張版で、256のオブジェクトカテゴリとより難易度の高い画像が含まれています。
- [CIFAR-10](../../datasets/classify/cifar10.md): 10クラスに60Kの32x32カラー画像が含まれるデータセットで、クラスごとに6Kの画像があります。
- [CIFAR-100](../../datasets/classify/cifar100.md): CIFAR-10の拡張版で、100のオブジェクトカテゴリとクラスごとに600の画像が含まれています。
- [Fashion-MNIST](../../datasets/classify/fashion-mnist.md): 画像分類タスク用の70,000枚のグレースケールのファッションカテゴリ画像で構成されるデータセットです。
- [ImageNet](../../datasets/classify/imagenet.md): オブジェクト検出および画像分類用の大規模データセットで、1400万枚を超える画像と20,000カテゴリが含まれています。
- [ImageNet-10](../../datasets/classify/imagenet10.md): ImageNetのより小さなサブセットで、高速な実験とテストに適した10カテゴリが含まれています。
- [Imagenette](../../datasets/classify/imagenette.md): ImageNetから抽出された10個の簡単に識別可能なクラスを含む、より小さなサブセットです。
- [Imagewoof](../../datasets/classify/imagewoof.md): ImageNetから抽出された10の犬種カテゴリを含む、画像分類タスクにさらに挑戦的なサブセットです。
- [MNIST](../../datasets/classify/mnist.md): 手書き数字の70,000枚のグレースケール画像で構成される画像分類タスク用データセットです。

## [指向性バウンディングボックス](../../datasets/obb/index.md)

指向性バウンディングボックス（OBB）は、回転したバウンディングボックスを使用して画像内の斜めのオブジェクトを検出するためのコンピュータビジョン手法で、主に航空写真や衛星画像へ適用されます。

- [DOTAv2](../../datasets/obb/dota-v2.md): 170万インスタンスと11,268枚の画像を含む人気のOBB航空画像データセットです。

## [マルチオブジェクト追跡](../../datasets/track/index.md)

マルチオブジェクト追跡は、複数オブジェクトをビデオシーケンスで時間を追って検出し、追跡するコンピュータビジョン技術です。

- [Argoverse](../../datasets/detect/argoverse.md): 都市環境からの3D追跡と運動予測データを含むデータセットで、マルチオブジェクト追跡タスクに富んだアノテーションがあります。
- [VisDrone](../../datasets/detect/visdrone.md): ドローンがキャプチャした映像からのオブジェクト検出とマルチオブジェクト追跡データを含むデータセットで、1万以上の画像とビデオシーケンスがあります。

## 新しいデータセットの提供

新しいデータセットを提供するには、既存のインフラと適合するように複数のステップが必要です。以下が必要なステップです：

### 新しいデータセットを提供する手順

1. **画像を収集**します：データセットに属する画像を収集します。これらは、公共データベースや自分のコレクションなど、さまざまなソースから収集することができます。

2. **画像をアノテート**します：これらの画像を、タスクに応じてバウンディングボックス、セグメント、またはキーポイントでアノテートします。

3. **アノテーションをエクスポート**します：これらのアノテーションを、UltralyticsがサポートしているYOLO *.txtファイルフォーマットに変換します。

4. **データセットを編成**します：データセットを正しいフォルダ構造に配置します。`train/` および `val/` のトップレベルディレクトリーを持ち、各ディレクトリー内に `images/` および `labels/` のサブディレクトリーがあるべきです。

    ```
    dataset/
    ├── train/
    │   ├── images/
    │   └── labels/
    └── val/
        ├── images/
        └── labels/
    ```

5. **`data.yaml`ファイルを作成**します：データセットのルートディレクトリに、データセット、クラス、その他の必要な情報を記述する`data.yaml`ファイルを作成します。

6. **画像を最適化（オプショナル）**します：データセットのサイズを削減してより効率的な処理を行いたい場合は、以下のコードを使用して画像を最適化することができます。これは必須ではありませんが、データセットのサイズを小さくし、ダウンロード速度を上げるために推奨されます。

7. **データセットをZip**します：データセットフォルダ全体をzipファイルに圧縮します。

8. **ドキュメントとPRを作成**します：データセットに関するドキュメンテーションページを作成し、既存のフレームワークにどのように適合するかを説明します。その後、Pull Request (PR)を提出します。PRを提出する方法の詳細については、[Ultralyticsの貢献ガイドライン](https://docs.ultralytics.com/help/contributing)を参照してください。

### データセットを最適化してZipするためのサンプルコード

!!! Example "データセットを最適化してZipする"

    === "Python"

    ```python
    from pathlib import Path
    from ultralytics.data.utils import compress_one_image
    from ultralytics.utils.downloads import zip_directory

    # データセットディレクトリを定義
    path = Path('path/to/dataset')

    # データセット内の画像を最適化 (オプショナル)
    for f in path.rglob('*.jpg'):
        compress_one_image(f)

    # 'path/to/dataset.zip'にデータセットをZip
    zip_directory(path)
    ```

これらのステップに従えば、Ultralyticsの既存の構造に適切に統合された新しいデータセットを提供することができます。
