---
comments: true
description: استكشف مجموعات بيانات الرؤية الحاسوبية المدعومة بواسطة Ultralytics لكشف الكائنات وتجزئة الصور وتقدير الركض وتصنيف الصور وتعقب الأجسام المتعددة.
keywords: الرؤية الحاسوبية ، مجموعات البيانات ، Ultralytics ، يوه ، كشف الكائنات ، تجزئة النموذج ، تقدير الركض ، تصنيف الصور ، تعقب الأجسام المتعددة
---

# نظرة عامة على مجموعات البيانات

توفر Ultralytics الدعم لمجموعة متنوعة من مجموعات البيانات لتسهيل المهام الخاصة بالرؤية الحاسوبية مثل الكشف وتجزئة الكائنات وتقدير الركض وتصنيف الصور وتعقب الأجسام المتعددة. فيما يلي قائمة بالمجموعات الرئيسية التي يدعمها Ultralytics ، تليها ملخص لكل مهمة في الرؤية الحاسوبية ومجموعات البيانات المتعلقة بها.

!!! Note "ملاحظة"

    🚧 قسم الوثائق ذو اللغات المتعددة قيد الإنشاء حاليًا ، ونعمل بجد لتحسينه. نشكرك على صبرك! 🙏

## [مجموعات بيانات الكشف](../../datasets/detect/index.md)

يعد كشف الكائنات بواسطة صندوق محيط هو تقنية في الرؤية الحاسوبية تتضمن كشف الكائنات وتمييزها في الصورة عن طريق رسم صندوق محيط حول كل كائن.

- [Argoverse](../../datasets/detect/argoverse.md): مجموعة بيانات تحتوي على بيانات تتبع ثلاثية الأبعاد وتنبؤ الحركة من البيئات الحضرية مع توجيه البيانات بشكل جيد.
- [COCO](../../datasets/detect/coco.md): مجموعة بيانات كبيرة مصممة للكشف والتجزئة والتسمية تحتوي على أكثر من 200 ألف صورة معتمدة.
- [COCO8](../../datasets/detect/coco8.md): يحتوي على أول 4 صور من COCO التدريب و COCO val ، مناسب للاختبار السريع.
- [Global Wheat 2020](../../datasets/detect/globalwheat2020.md): مجموعة بيانات من صور رؤوس القمح جمعت من جميع أنحاء العالم لمهام الكشف والتحديد الموضعي.
- [Objects365](../../datasets/detect/objects365.md): مجموعة بيانات كبيرة وعالية الجودة لاكتشاف الكائنات بتصنيفات 365 وأكثر من 600 ألف صورة مرتبطة.
- [OpenImagesV7](../../datasets/detect/open-images-v7.md): مجموعة بيانات شاملة من جوجل تحتوي على 1.7 مليون صورة للتدريب و 42 ألف صورة للتحقق.
- [SKU-110K](../../datasets/detect/sku-110k.md): مجموعة بيانات تتضمن الكشف المكثف للكائنات في بيئات البيع بالتجزئة مع أكثر من 11 ألف صورة و 1.7 مليون صندوق بيانات محيط.
- [VisDrone](../../datasets/detect/visdrone.md): مجموعة بيانات تحتوي على كشف الكائنات ونماذج تعقب لأجسام متعددة من الصور الملتقطة بواسطة طائرات بدون طيار بأكثر من 10 ألف صورة وتسلسلات فيديو.
- [VOC](../../datasets/detect/voc.md): مجموعة بيانات Pascal Visual Object Classes (VOC) لكشف الكائنات والتجزئة بـ20 فئة من الكائنات وأكثر من 11 ألف صورة.
- [xView](../../datasets/detect/xview.md): مجموعة بيانات لكشف الكائنات في الصور الملتقطة من الأعلى بـ 60 فئة من الكائنات وأكثر من مليون كائن محدد ملحوظ.

## [مجموعات بيانات التجزئة النمطية](../../datasets/segment/index.md)

تعتبر التجزئة النمطية تقنية في الرؤية الحاسوبية تتطلب تحديد أجسام وتحديد مكانها في مستوى البكسل في الصورة.

- [COCO](../../datasets/segment/coco.md): مجموعة بيانات كبيرة مصممة للكشف والتجزئة والتسمية تحتوي على أكثر من 200 ألف صورة معتمدة.
- [COCO8-seg](../../datasets/segment/coco8-seg.md): مجموعة بيانات أصغر لمهام التجزئة النمطية ، تحتوي على مجموعة فرعية من 8 صور COCO مع تسميات التجزئة.

## [تقدير الركض](../../datasets/pose/index.md)

تقدير الركض هو تقنية تُستخدم لتحديد وضع الكائن مقارنةً بالكاميرا أو نظام الإحداثيات العالمية.

- [COCO](../../datasets/pose/coco.md): مجموعة بيانات كبيرة بتعليقات وضع الإنسان المصممة لمهام تقدير الركض.
- [COCO8-pose](../../datasets/pose/coco8-pose.md): مجموعة بيانات أصغر لمهام تقدير الركض ، تحتوي على مجموعة فرعية من 8 صور COCO مع تغييرات في وضع الإنسان.
- [تقدير الركض النمر](../../datasets/pose/tiger-pose.md): مجموعة بيانات مدمجة تتكون من 263 صورة مركزة على النمور ، مع 12 نقطة مرجعية لكل نمر لمهام تقدير الركض.

## [التصنيف](../../datasets/classify/index.md)

تصنيف الصورة هو مهمة في الرؤية الحاسوبية تتضمن تصنيف صورة في فئة أو أكثر محددة مسبقًا بناءً على محتواها البصري.

- [كالتك 101](../../datasets/classify/caltech101.md): مجموعة بيانات تحتوي على صور لـ 101 فئة من الكائنات لمهام تصنيف الصور.
- [كالتك 256](../../datasets/classify/caltech256.md): نسخة موسعة من Caltech 101 بـ 256 فئة من الكائنات وصور أكثر تحديًا.
- [CIFAR-10](../../datasets/classify/cifar10.md): مجموعة بيانات تحتوي على 60 ألف صورة ملونة بحجم 32x32 بكسل في 10 فئات ، مع 6 آلاف صورة لكل فئة.
- [CIFAR-100](../../datasets/classify/cifar100.md): نسخة موسعة من CIFAR-10 بـ 100 فئة من الكائنات و 600 صورة لكل فئة.
- [Fashion-MNIST](../../datasets/classify/fashion-mnist.md): مجموعة بيانات تتكون من 70,000 صورة رمادية لـ 10 فئات من الملابس لمهام تصنيف الصور.
- [ImageNet](../../datasets/classify/imagenet.md): مجموعة بيانات بمقياس كبير لكشف الكائنات وتصنيف الصور بأكثر من 14 مليون صورة و 20,000 فئة.
- [ImageNet-10](../../datasets/classify/imagenet10.md): نسخة أصغر من ImageNet مع 10 فئات للاختبار والتجربة الأسرع.
- [Imagenette](../../datasets/classify/imagenette.md): مجموعة فرعية أصغر لـ ImageNet تحتوي على 10 فئات يمكن التمييز بينها بسهولة للتدريب والاختبار الأسرع.
- [Imagewoof](../../datasets/classify/imagewoof.md): نسخة أكثر تحديًا من ImageNet تحتوي على 10 فئات من فئات كلاب العنبر لمهام تصنيف الصور.
- [MNIST](../../datasets/classify/mnist.md): مجموعة بيانات تتكون من 70,000 صورة رمادية للأرقام المكتوبة يدويًا لمهام تصنيف الصور.

## [صناديق الحدود الموجهة (OBB)](../../datasets/obb/index.md)

صناديق الحدود الموجهة (OBB) هي طريقة في الرؤية الحاسوبية لاكتشاف الكائنات ذات زوايا في الصور باستخدام صناديق حدود مدورة تمت تدويرها ، وغالبًا ما يتم تطبيقها على صور الأقمار الصناعية والطائرات بدون طيار.

- [DOTAv2](../../datasets/obb/dota-v2.md): مجموعة بيانات OBB الجوية الشهيرة بـ 1.7 مليون حالة و 11,268 صورة.

## [تتبع الكائنات المتعددة](../../datasets/track/index.md)

تعتبر تتبع الكائنات المتعددة تقنية في الرؤية الحاسوبية تتضمن كشف وتتبع عدة كائنات معًا عبر الزمن في سلسلة فيديو.

- [Argoverse](../../datasets/detect/argoverse.md): مجموعة بيانات تحتوي على بيانات تتبع ثلاثية الأبعاد وتنبؤ الحركة من البيئات الحضرية مع توجيه البيانات بشكل جيد لمهام تتبع الكائنات المتعددة.
- [VisDrone](../../datasets/detect/visdrone.md): مجموعة بيانات تحتوي على كشف الكائنات ونماذج تتبع لأجسام متعددة من الصور الملتقطة بواسطة طائرات بدون طيار بأكثر من 10 ألف صورة وتسلسلات فيديو.

## المساهمة في مجموعات بيانات جديدة

تشمل المساهمة في مجموعة بيانات جديدة عدة خطوات لضمان توافقها مع البنية القائمة. فيما يلي الخطوات اللازمة:

### الخطوات المطلوبة للمساهمة في مجموعة بيانات جديدة

1. **جمع الصور**: اجمع الصور التي تنتمي إلى مجموعة البيانات. يمكن جمع هذه الصور من مصادر مختلفة مثل قواعد البيانات العامة أو مجموعتك الخاصة.

2. **وضع تعليقات على الصور**: قم بإضافة تعليقات على هذه الصور مع صناديق الحدود أو الشرائح أو النقاط التي تعتمد على المهمة.

3. **تصدير التعليقات**: قم بتحويل هذه التعليقات إلى تنسيق الملف *.txt *.txt المدعوم من Ultralytics.

4. **تنظيم مجموعة البيانات**: قم بترتيب مجموعة البيانات الخاصة بك في البنية المجلدات الصحيحة. يجب أن تحتوي على مجلدات أعلى المستوى `train/` و `val/` ، وداخل كل منهما ، مجلدات فرعية للـ `images/` و `labels/`.

    ```
    dataset/
    ├── train/
    │   ├── images/
    │   └── labels/
    └── val/
        ├── images/
        └── labels/
    ```

5. **إنشاء ملف `data.yaml`**: في المجلد الجذري لمجموعة البيانات الخاصة بك ، قم بإنشاء ملف `data.yaml` يصف المجموعة البيانات والفئات وغيرها من المعلومات الضرورية.

6. **تحسين الصور (اختياري)**: إذا كنت ترغب في تقليل حجم مجموعة البيانات لمزيد من الكفاءة في المعالجة ، فيمكنك تحسين الصور باستخدام الكود أدناه. لا يلزم ذلك ، ولكنه موصى به لأحجام مجموعات البيانات الأصغر وسرعات التنزيل الأسرعة.

7. **ضغط مجموعة البيانات**: قم بضغط مجلد مجموعة البيانات بالكامل وضعه في ملف zip.

8. **الوثائق وإرسال طلب السحب (PR)**: قم بإنشاء صفحة وثائق تصف مجموعة البيانات الخاصة بك وكيف تتوافق مع الإطار القائم. بعد ذلك ، قدم طلب سحب (PR). راجع [مبادئ المساهمة في Ultralytics](https://docs.ultralytics.com/help/contributing) لمزيد من التفاصيل حول كيفية تقديم طلب السحب (PR).

### كود مثال لتحسين وضغط مجموعة البيانات

!!! Example "تحسين وضغط مجموعة البيانات"

    === "Python"

    ```python
    from pathlib import Path
    from ultralytics.data.utils import compress_one_image
    from ultralytics.utils.downloads import zip_directory

    # تعيين مسار مجلد مجموعة البيانات
    path = Path('path/to/dataset')

    # تحسين الصور في مجموعة البيانات (اختياري)
    for f in path.rglob('*.jpg'):
        compress_one_image(f)

    # ضغط مجلد مجموعة البيانات في ملف زيب
    zip_directory(path)
    ```

باتباع هذه الخطوات ، يمكنك المساهمة في مجموعة بيانات جديدة تتكامل بشكل جيد مع البنية القائمة لـ Ultralytics.
