---
comments: true
description: Изучите наш подробный руководство по YOLOv4 - передовому обнаружителю объектов в режиме реального времени. Понимание его архитектурных особенностей, инновационных функций и примеров применения.
keywords: ultralytics, YOLOv4, обнаружение объектов, нейронные сети, обнаружение в реальном времени, детектор объектов, машинное обучение
---

# YOLOv4: Быстрое и точное обнаружение объектов

Добро пожаловать на страницу документации Ultralytics по YOLOv4 - передовому обнаружителю объектов в режиме реального времени, созданному в 2020 году Алексеем Бочковским на [https://github.com/AlexeyAB/darknet](https://github.com/AlexeyAB/darknet). YOLOv4 разработан для обеспечения оптимального баланса между скоростью и точностью, что делает его отличным выбором для многих приложений.

![Диаграмма архитектуры YOLOv4](https://user-images.githubusercontent.com/26833433/246185689-530b7fe8-737b-4bb0-b5dd-de10ef5aface.png)
**Диаграмма архитектуры YOLOv4**. Показана сложная сетевая архитектура YOLOv4, включая компоненты основной части, шеи и головы, а также их взаимосвязанные слои для оптимального обнаружения объектов в режиме реального времени.

## Введение

YOLOv4 означает You Only Look Once, версия 4. Эта модель обнаружения объектов в реальном времени была разработана для преодоления ограничений предыдущих версий YOLO, таких как [YOLOv3](yolov3.md) и других моделей обнаружения объектов. В отличие от других детекторов объектов на основе сверточных нейронных сетей (CNN), YOLOv4 применим как для систем рекомендаций, так и для автономного управления процессами и уменьшения человеческого ввода. Благодаря работе на обычных графических процессорах (GPU), YOLOv4 может использоваться массово по доступной цене и разработан для работы в реальном времени на обычном GPU, требуя для обучения лишь одного такого GPU.

## Архитектура

YOLOv4 использует несколько инновационных функций, которые работают вместе для оптимизации его производительности. Среди них встроенные связи с резильтатами (WRC), частичные соединения между этапами (CSP), нормализация на мини-пакетах (CmBN), самоадаптивное обучение (SAT), активация Mish, аугментация данных Mosaic, регуляризация DropBlock и функция потерь CIoU. Эти функции объединены для достижения передовых результатов.

Типичный детектор объектов состоит из нескольких частей, включая входные данные, основную часть, шейку и голову. Основа YOLOv4 предварительно обучена на наборе данных ImageNet и используется для предсказания классов и ограничивающих рамок объектов. Основа может быть представлена несколькими моделями, включая VGG, ResNet, ResNeXt или DenseNet. Часть шейки детектора используется для сбора карт признаков с разных этапов и обычно включает несколько путей снизу вверх и несколько путей сверху вниз. Головная часть используется для окончательного обнаружения и классификации объектов.

## Bag of Freebies

YOLOv4 также использует методы, известные как «bag of freebies», которые улучшают точность модели во время обучения без увеличения стоимости вывода. Аугментация данных - это общая техника "bag of freebies", используемая в обнаружении объектов, которая увеличивает изменчивость входных изображений для повышения устойчивости модели. Некоторые примеры аугментации данных включают фотометрические и геометрические искажения. Эти техники помогают модели лучше обобщаться для различных типов изображений.

## Особенности и производительность

YOLOv4 разработан для оптимальной скорости и точности обнаружения объектов. Архитектура YOLOv4 включает в себя CSPDarknet53 в качестве основы, PANet в качестве шейки и YOLOv3 в качестве головы. Это позволяет YOLOv4 выполнять обнаружение объектов с впечатляющей скоростью, что делает его подходящим для приложений в реальном времени. YOLOv4 также отличается точностью и достигает передовых результатов в тестовых бенчмарках для обнаружения объектов.

## Примеры использования

На момент написания данного документа Ultralytics пока не поддерживает модели YOLOv4. Поэтому все пользователи, заинтересованные в использовании YOLOv4, должны обращаться напрямую к репозиторию YOLOv4 на GitHub для инструкций по установке и использованию.

Вот краткий обзор типичных шагов, которые вы можете предпринять для использования YOLOv4:

1. Посетите репозиторий YOLOv4 на GitHub: [https://github.com/AlexeyAB/darknet](https://github.com/AlexeyAB/darknet).

2. Следуйте инструкциям, предоставленным в файле README для установки. Это обычно включает клонирование репозитория, установку необходимых зависимостей и настройку необходимых переменных среды.

3. После завершения установки вы можете обучать и использовать модель в соответствии с инструкциями использования, предоставленными в репозитории. Обычно это включает подготовку ваших данных, настройку параметров модели, обучение модели и затем использование обученной модели для выполнения обнаружения объектов.

Обратите внимание, что конкретные шаги могут отличаться в зависимости от вашего конкретного случая использования и текущего состояния репозитория YOLOv4. Поэтому настоятельно рекомендуется обращаться непосредственно к инструкциям, предоставленным в репозитории YOLOv4 на GitHub.

Приносим извинения за возможные неудобства, и мы постараемся обновить этот документ с примерами использования для Ultralytics, как только поддержка YOLOv4 будет реализована.

## Заключение

YOLOv4 - это мощная и эффективная модель обнаружения объектов, которая находит баланс между скоростью и точностью. Благодаря уникальным функциям и методам "bag of freebies" во время обучения, она превосходно справляется с задачами обнаружения объектов в реальном времени. YOLOv4 может быть обучена и использована всеми, у кого есть обычный GPU, что делает ее доступной и пригодной для широкого круга применений.

## Цитирование и благодарности

Мы хотели бы выразить благодарность авторам YOLOv4 за их значительный вклад в область обнаружения объектов в режиме реального времени:

!!! Quote ""

    === "BibTeX"

        ```bibtex
        @misc{bochkovskiy2020yolov4,
              title={YOLOv4: Optimal Speed and Accuracy of Object Detection},
              author={Alexey Bochkovskiy and Chien-Yao Wang and Hong-Yuan Mark Liao},
              year={2020},
              eprint={2004.10934},
              archivePrefix={arXiv},
              primaryClass={cs.CV}
        }
        ```

Оригинальная статья YOLOv4 доступна на [arXiv](https://arxiv.org/pdf/2004.10934.pdf). Авторы сделали свою работу общедоступной, и код доступен на [GitHub](https://github.com/AlexeyAB/darknet). Мы ценим их усилия в развитии области и доступности их работы для широкого сообщества.
