---
description: Explore comprehensive documentation for utilising Comet Callbacks in Ultralytics. Learn to optimise training, logging, and experiment workflows.
keywords: Ultralytics, Comet Callbacks, Training optimisation, Logging, Experiment Workflows
---

# Reference for `ultralytics/utils/callbacks/comet.py`

!!! Note

    This file is available at [https://github.com/ultralytics/ultralytics/blob/main/ultralytics/utils/callbacks/comet.py](https://github.com/ultralytics/ultralytics/blob/main/ultralytics/utils/callbacks/comet.py). If you spot a problem please help fix it by [contributing](https://docs.ultralytics.com/help/contributing/) a [Pull Request](https://github.com/ultralytics/ultralytics/edit/main/ultralytics/utils/callbacks/comet.py) 🛠️. Thank you 🙏!

---
## ::: ultralytics.utils.callbacks.comet._get_comet_mode
<br><br>

---
## ::: ultralytics.utils.callbacks.comet._get_comet_model_name
<br><br>

---
## ::: ultralytics.utils.callbacks.comet._get_eval_batch_logging_interval
<br><br>

---
## ::: ultralytics.utils.callbacks.comet._get_max_image_predictions_to_log
<br><br>

---
## ::: ultralytics.utils.callbacks.comet._scale_confidence_score
<br><br>

---
## ::: ultralytics.utils.callbacks.comet._should_log_confusion_matrix
<br><br>

---
## ::: ultralytics.utils.callbacks.comet._should_log_image_predictions
<br><br>

---
## ::: ultralytics.utils.callbacks.comet._get_experiment_type
<br><br>

---
## ::: ultralytics.utils.callbacks.comet._create_experiment
<br><br>

---
## ::: ultralytics.utils.callbacks.comet._fetch_trainer_metadata
<br><br>

---
## ::: ultralytics.utils.callbacks.comet._scale_bounding_box_to_original_image_shape
<br><br>

---
## ::: ultralytics.utils.callbacks.comet._format_ground_truth_annotations_for_detection
<br><br>

---
## ::: ultralytics.utils.callbacks.comet._format_prediction_annotations_for_detection
<br><br>

---
## ::: ultralytics.utils.callbacks.comet._fetch_annotations
<br><br>

---
## ::: ultralytics.utils.callbacks.comet._create_prediction_metadata_map
<br><br>

---
## ::: ultralytics.utils.callbacks.comet._log_confusion_matrix
<br><br>

---
## ::: ultralytics.utils.callbacks.comet._log_images
<br><br>

---
## ::: ultralytics.utils.callbacks.comet._log_image_predictions
<br><br>

---
## ::: ultralytics.utils.callbacks.comet._log_plots
<br><br>

---
## ::: ultralytics.utils.callbacks.comet._log_model
<br><br>

---
## ::: ultralytics.utils.callbacks.comet.on_pretrain_routine_start
<br><br>

---
## ::: ultralytics.utils.callbacks.comet.on_train_epoch_end
<br><br>

---
## ::: ultralytics.utils.callbacks.comet.on_fit_epoch_end
<br><br>

---
## ::: ultralytics.utils.callbacks.comet.on_train_end
<br><br>
