---
comments: true
description: استكشف نموذج Meituan YOLOv6 للكشف عن الكائنات الحديثة، والذي يوفر توازنًا مذهلاً بين السرعة والدقة، مما يجعله الخيار الأمثل لتطبيقات الوقت الحقيقي. تعرّف على الميزات والنماذج المُدربة مسبقًا واستخدام Python.
keywords: Meituan YOLOv6، الكشف عن الكائنات، Ultralytics، YOLOv6 docs، Bi-directional Concatenation، تدريب بمساعدة العناصر، النماذج المدربة مسبقا، تطبيقات الوقت الحقيقي
---

# Meituan YOLOv6

## نظرة عامة

[Meituan](https://about.meituan.com/) YOLOv6 هو منظّف الكائنات الحديثة الحديثة الذي يُقدم توازنًا ملحوظًا بين السرعة والدقة، مما يجعله خيارًا شائعًا لتطبيقات الوقت الحقيقي. يُقدم هذا النموذج العديد من التحسينات الملحوظة في بنيته ونظام التدريب، بما في ذلك تطبيق وحدة Bi-directional Concatenation (BiC)، واستراتيجية AAT (anchor-aided training) التي تعتمد على العناصر، وتصميم محسّن للأساس والرقبة لتحقيق أداء على مجموعة بيانات COCO يفوق جميع النماذج الأخرى.

![Meituan YOLOv6](https://user-images.githubusercontent.com/26833433/240750495-4da954ce-8b3b-41c4-8afd-ddb74361d3c2.png)
![Model example image](https://user-images.githubusercontent.com/26833433/240750557-3e9ec4f0-0598-49a8-83ea-f33c91eb6d68.png)
**نظرة عامة على YOLOv6.** مخطط بنية النموذج يوضح المكونات المعاد تصميمها واستراتيجيات التدريب التي أدت إلى تحسينات أداء كبيرة. (أ) الرقبة الخاصة بـ YOLOv6 (N و S معروضان). لاحظ أنه بالنسبة لم/n، يتم استبدال RepBlocks بـ CSPStackRep. (ب) هيكل وحدة BiC. (ج) مكون SimCSPSPPF. ([المصدر](https://arxiv.org/pdf/2301.05586.pdf)).

### ميزات رئيسية

- **وحدة Bi-directional Concatenation (BiC):** يقدم YOLOv6 وحدة BiC في الرقبة التابعة للكاشف، مما يعزز إشارات التحديد المحلية ويؤدي إلى زيادة الأداء دون التأثير على السرعة.
- **استراتيجية التدريب بمساعدة العناصر (AAT):** يقدم هذا النموذج استراتيجية AAT للاستفادة من فوائد النماذج المستندة إلى العناصر وغير المستندة إليها دون التضحية في كفاءة الاستدلال.
- **تصميم أساس ورقبة محسّن:** من خلال تعميق YOLOv6 لتشمل مرحلة أخرى في الأساس والرقبة، يحقق هذا النموذج أداءً يفوق جميع النماذج الأخرى على مجموعة بيانات COCO لإدخال عالي الدقة.
- **استراتيجية الاستنباط الذاتي:** يتم تنفيذ استراتيجية استنتاج ذاتي جديدة لتعزيز أداء النماذج الصغيرة من YOLOv6، وذلك عن طريق تعزيز فرع الانحدار المساعد خلال التدريب وإزالته في الاستنتاج لتجنب انخفاض السرعة الواضح.

## معايير الأداء

يوفر YOLOv6 مجموعة متنوعة من النماذج المدرّبة مسبقًا بمقاييس مختلفة:

- YOLOv6-N: ٣٧.٥٪ AP في COCO val2017 عندما يتم استخدام بطاقة NVIDIA Tesla T4 GPU وسرعة ١١٨٧ إطار في الثانية.
- YOLOv6-S: ٤٥.٠٪ AP وسرعة ٤٨٤ إطار في الثانية.
- YOLOv6-M: ٥٠.٠٪ AP وسرعة ٢٢٦ إطار في الثانية.
- YOLOv6-L: ٥٢.٨٪ AP وسرعة ١١٦ إطار في الثانية.
- YOLOv6-L6: دقة حديثة في الزمن الحقيقي.

كما يوفر YOLOv6 نماذج مؤنقة (quantized models) بدقات مختلفة ونماذج محسنة للمنصات المحمولة.

## أمثلة عن الاستخدام

يقدم هذا المثال أمثلة بسيطة لتدريب YOLOv6 واستنتاجه. للحصول على وثائق كاملة حول هذه وأوضاع أخرى [انظر](../modes/index.md) الى الصفحات التوضيحية لتوسعة الوثائق الفائقة ، [توقع](../modes/predict.md) ، [تدريب](../modes/train.md) ، [التحقق](../modes/val.md) و [التصدير](../modes/export.md).

!!! Example "مثال"

    === "Python"

        يمكن تمرير النماذج المدرّبة مسبقًا بتنسيق `*.pt` في PyTorch وملفات التكوين `*.yaml` لفئة `YOLO()` لإنشاء نموذج في Python:

        ```python
        from ultralytics import YOLO

        # إنشاء نموذج YOLOv6n من البداية
        model = YOLO('yolov6n.yaml')

        # عرض معلومات النموذج (اختياري)
        model.info()

        # تدريب النموذج على مجموعة بيانات مثال COCO8 لمدة 100 دورة تدريب
        results = model.train(data='coco8.yaml', epochs=100, imgsz=640)

        # تشغيل الاستنتاج بنموذج YOLOv6n على صورة 'bus.jpg'
        results = model('path/to/bus.jpg')
        ```

    === "CLI"

        يمكن استخدام أوامر CLI لتشغيل النماذج مباشرةً:

        ```bash
        # إنشاء نموذج YOLOv6n من البداية وتدريبه باستخدام مجموعة بيانات مثال COCO8 لمدة 100 دورة تدريب
        yolo train model=yolov6n.yaml data=coco8.yaml epochs=100 imgsz=640

        # إنشاء نموذج YOLOv6n من البداية وتشغيل الاستنتاج على صورة 'bus.jpg'
        yolo predict model=yolov6n.yaml source=path/to/bus.jpg
        ```

## المهام والأوضاع المدعومة

تقدم سلسلة YOLOv6 مجموعة من النماذج، والتي تم تحسينها للكشف عن الكائنات عالي الأداء. تلبي هذه النماذج احتياجات الكمبيوتيشن المتنوعة ومتطلبات الدقة، مما يجعلها متعددة الاستخدامات في مجموعة واسعة من التطبيقات.

| نوع النموذج | الأوزان المدربة مسبقًا | المهام المدعومة                         | الاستنتاج | التحقق | التدريب | التصدير |
|-------------|------------------------|-----------------------------------------|-----------|--------|---------|---------|
| YOLOv6-N    | `yolov6-n.pt`          | [الكشف عن الكائنات](../tasks/detect.md) | ✅         | ✅      | ✅       | ✅       |
| YOLOv6-S    | `yolov6-s.pt`          | [الكشف عن الكائنات](../tasks/detect.md) | ✅         | ✅      | ✅       | ✅       |
| YOLOv6-M    | `yolov6-m.pt`          | [الكشف عن الكائنات](../tasks/detect.md) | ✅         | ✅      | ✅       | ✅       |
| YOLOv6-L    | `yolov6-l.pt`          | [الكشف عن الكائنات](../tasks/detect.md) | ✅         | ✅      | ✅       | ✅       |
| YOLOv6-L6   | `yolov6-l6.pt`         | [الكشف عن الكائنات](../tasks/detect.md) | ✅         | ✅      | ✅       | ✅       |

توفر هذه الجدول نظرة عامة مفصلة على النماذج المختلفة لـ YOLOv6، مع تسليط الضوء على قدراتها في مهام الكشف عن الكائنات وتوافقها مع الأوضاع التشغيلية المختلفة مثل [الاستنتاج](../modes/predict.md) و [التحقق](../modes/val.md) و [التدريب](../modes/train.md) و [التصدير](../modes/export.md). هذا الدعم الشامل يضمن أن يمكن للمستخدمين الاستفادة الكاملة من قدرات نماذج YOLOv6 في مجموعة واسعة من سيناريوهات الكشف عن الكائنات.

## الاقتباسات والتقديرات

نحن نود أن نقدّم الشكر للمؤلفين على مساهماتهم الهامة في مجال كشف الكائنات في الوقت الحقيقي:

!!! Quote ""

    === "BibTeX"

        ```bibtex
        @misc{li2023yolov6,
              title={YOLOv6 v3.0: A Full-Scale Reloading},
              author={Chuyi Li and Lulu Li and Yifei Geng and Hongliang Jiang and Meng Cheng and Bo Zhang and Zaidan Ke and Xiaoming Xu and Xiangxiang Chu},
              year={2023},
              eprint={2301.05586},
              archivePrefix={arXiv},
              primaryClass={cs.CV}
        }
        ```

يمكن العثور على الورقة الأصلية لـ YOLOv6 على [arXiv](https://arxiv.org/abs/2301.05586). نشر المؤلفون عملهم بشكل عام، ويمكن الوصول إلى الشيفرة المصدرية على [GitHub](https://github.com/meituan/YOLOv6). نحن نقدّر جهودهم في تطوير هذا المجال وجعل عملهم متاحًا للمجتمع بأسره.
