---
comments: true
description: احصل على نظرة عامة حول YOLOv3 و YOLOv3-Ultralytics و YOLOv3u. تعرف على ميزاتها الرئيسية واستخدامها والمهام المدعومة للكشف عن الكائنات.
keywords: YOLOv3، YOLOv3-Ultralytics، YOLOv3u، الكشف عن الكائنات، إجراء، التدريب، Ultralytics
---

# YOLOv3 و YOLOv3-Ultralytics و YOLOv3u

## النظرة العامة

يقدم هذا الوثيقة نظرة عامة على ثلاث نماذج مرتبطة بكشف الكائنات ، وهي [YOLOv3](https://pjreddie.com/darknet/yolo/) و [YOLOv3-Ultralytics](https://github.com/ultralytics/yolov3) و [YOLOv3u](https://github.com/ultralytics/ultralytics).

1. **YOLOv3:** هذه هي الإصدار الثالث من خوارزمية You Only Look Once (YOLO) للكشف عن الكائنات. قام جوزيف ريدمون بتطويرها بالأصل ، وقد قامت YOLOv3 بتحسين سابقيها من خلال إدخال ميزات مثل التنبؤات متعددة المقياس وثلاثة أحجام مختلفة من نوى الكشف.

2. **YOLOv3-Ultralytics:** هذه هي تنفيذ Ultralytics لنموذج YOLOv3. يقوم بإعادة إنتاج بنية YOLOv3 الأصلية ويقدم وظائف إضافية ، مثل دعم المزيد من النماذج المدربة مسبقًا وخيارات تخصيص أسهل.

3. **YOLOv3u:** هذا هو الإصدار المُحدّث لـ YOLOv3-Ultralytics الذي يدمج رأس الكشف بدون مشتركات وبدون مستخدم الكائن الذي يستخدم في نماذج YOLOv8. يحتفظ YOLOv3u بنفس بنية العمود الفقري والعنق مثل YOLOv3 ولكن برأس الكشف المُحدث من YOLOv8.

![Ultralytics YOLOv3](https://raw.githubusercontent.com/ultralytics/assets/main/yolov3/banner-yolov3.png)

## الميزات الرئيسية

- **YOLOv3:** قدم استخدام ثلاث مقياسات مختلفة للكشف ، باستخدام ثلاثة أحجام مختلفة من نوى الكشف: 13x13 ، 26x26 و 52x52. هذا يحسن بشكل كبير دقة الكشف للكائنات ذات الأحجام المختلفة. بالإضافة إلى ذلك ، أضاف YOLOv3 ميزات مثل التنبؤات متعددة العلامات لكل مربع محاذاة وشبكة استخراج سمات أفضل.

- **YOLOv3-Ultralytics:** توفر تنفيذ Ultralytics لـ YOLOv3 نفس الأداء مثل النموذج الأصلي ولكنه يأتي مع دعم إضافي للمزيد من النماذج المدربة مسبقًا وطرق تدريب إضافية وخيارات أسهل للتخصيص. هذا يجعلها أكثر مرونة وسهولة استخداماً للتطبيقات العملية.

- **YOLOv3u:** يدمج هذا النموذج المُحدّث رأس الكشف بدون مشتركات وبدون مستخدم الكائن من YOLOv8. من خلال إزالة الحاجة إلى صناديق المرجع المحددة مسبقًا ودرجات تكون الكائن ، يمكن أن يحسن تصميم رأس الكشف هذا قدرة النموذج على كشف الكائنات ذات الأحجام والأشكال المتنوعة. هذا يجعل YOLOv3u أكثر مرونة ودقة لمهام كشف الكائنات.

## المهام المدعومة والأوضاع

تم تصميم سلسلة YOLOv3 ، بما في ذلك YOLOv3 و YOLOv3-Ultralytics و YOLOv3u ، خصيصًا لمهام الكشف عن الكائنات. يشتهر هذه النماذج بفعاليتها في سيناريوهات العالم الحقيقي المختلفة ، مع توازن دقة الكشف والسرعة. يوفر كل طراز ميزات وتحسينات فريدة ، مما يجعلها مناسبة لمجموعة متنوعة من التطبيقات.

يدعم النماذج الثلاثة وضعًا شاملاً من الأوضاع ، مما يضمن مرونة في مراحل مختلفة من نموذج النشر والتطوير. هذه الأوضاع تشمل [التمييز](../modes/predict.md) ، [التحقق](../modes/val.md) ، [التدريب](../modes/train.md) و [التصدير](../modes/export.md) ، مما يوفر للمستخدمين مجموعة كاملة من أدوات فعالة للكشف عن الكائنات.

| نوع النموذج        | المهام المدعومة                    | التمييز | التحقق | التدريب | التصدير |
|--------------------|------------------------------------|---------|--------|---------|---------|
| YOLOv3             | [كشف الكائنات](../tasks/detect.md) | ✅       | ✅      | ✅       | ✅       |
| YOLOv3-Ultralytics | [كشف الكائنات](../tasks/detect.md) | ✅       | ✅      | ✅       | ✅       |
| YOLOv3u            | [كشف الكائنات](../tasks/detect.md) | ✅       | ✅      | ✅       | ✅       |

توفر هذه الجدولة نظرة فورية على إمكانات كل نسخة من YOLOv3 ، مما يسلط الضوء على مرونتها وملاءمتها لمختلف المهام وأوضاع العمل العملية في سير العمل لكشف الكائنات.

## أمثلة الاستخدام

يقدم هذا المثال أمثلة بسيطة للتدريب والتنبؤ باستخدام YOLOv3. للحصول على وثائق كاملة حول هذه وغيرها من [الأوضاع](../modes/index.md) انظر صفحات الوثائق: [التنبؤ](../modes/predict.md) ، (../modes/train.md) [Val](../modes/val.md) و [التصدير](../modes/export.md) docs.

!!! Example "مثال"

    === "بيثون"

        يمكن تمرير نماذج PyTorch المدربة مسبقًا `*.pt` وملفات التكوين `*.yaml` إلى فئة `YOLO()` لإنشاء نموذج في Python:

        ```python
        من ultralytics استيراد YOLO

        # تحميل نموذج YOLOv3n المدرب مسبقًا على COCO
        model = YOLO('yolov3n.pt')

        # عرض معلومات النموذج (اختياري)
        model.info()

        # تدريب النموذج على مجموعة البيانات المثالية Coco8 لمدة 100 دورة تدريب
        results = model.train(data='coco8.yaml', epochs=100, imgsz=640)

        # قم بتشغيل التنبؤ باستخدام نموذج YOLOv3n على صورة 'bus.jpg'
        results = model('path/to/bus.jpg')
        ```

    === "CLI"

        تتوفر أوامر CLI لتشغيل النماذج مباشرة:

        ```bash
        # تحميل نموذج YOLOv3n المدرب مسبقًا على COCO وقم بتدريبه على مجموعة البيانات المثالية Coco8 لمدة 100 دورة تدريب
        yolo train model=yolov3n.pt data=coco8.yaml epochs=100 imgsz=640

        # تحميل نموذج YOLOv3n المدرب مسبقًا على COCO وتشغيل التنبؤ على صورة 'bus.jpg'
        yolo predict model=yolov3n.pt source=path/to/bus.jpg
        ```

## الاقتباسات والشكر

إذا قمت باستخدام YOLOv3 في بحثك ، فيرجى الاقتباس لأوراق YOLO الأصلية ومستودع Ultralytics YOLOv3:

!!! Quote ""

    === "بيب تيكس"

        ```bibtex
        @article{redmon2018yolov3,
          title={YOLOv3: An Incremental Improvement},
          author={Redmon, Joseph and Farhadi, Ali},
          journal={arXiv preprint arXiv:1804.02767},
          year={2018}
        }
        ```

شكراً لجوزيف ريدمون وعلي فرهادي على تطوير YOLOv3 الأصلي.
