# YOLOv8
## 论文
无
## 模型结构
yolov8是一种单阶段目标检测算法，该算法在YOLOV5的基础上添加了一些新的改进思路，使其速度与精度都得到了极大的性能提升。<br>
![block.jpg](asserts%2Fblock.jpg)
## 算法原理
YOLOv8算法通过将图像划分为不同大小的网格，预测每个网格中的目标类别和边界框，利用特征金字塔结构和自适应的模型缩放来实现高效准确的实时目标检测。
- 骨干网络和 Neck 部分将 YOLOv5 的 C3 结构换成了梯度流更丰富的 C2f 结构，并对不同尺度模型调整了不同的通道数，大幅提升了模型性能。
- Head 部分相比 YOLOv5 改动较大，换成了目前主流的解耦头结构，将分类和检测头分离，同时也从 Anchor-Based 换成了 Anchor-Free.
- Loss 计算方面采用了 TaskAlignedAssigner 正样本分配策略，并引入了 Distribution Focal Loss.
- 训练的数据增强部分引入了 YOLOX 中的最后 10 epoch 关闭 Mosiac 增强的操作，可以有效地提升精度
![model_framework.png](asserts%2Fmodel_framework.png)
## 环境配置
### Docker（方法一）

```
docker pull image.sourcefind.cn:5000/dcu/admin/base/paddlepaddle:2.6.1-py3.10-dtk24.04.3-ubuntu20.04
docker run -it -v /path/your_code_data/:/path/your_code_data/ -v /opt/hyhal/:/opt/hyhal/:ro --shm-size=128G --privileged=true --device=/dev/kfd --device=/dev/dri/ --group-add video --name docker_name --network=host imageID /bin/bash
```

### Anaconda（方法二）
1、关于本项目DCU显卡所需的特殊深度学习库可从光合开发者社区下载安装： https://developer.hpccube.com/tool/
```
DTK软件栈: dtk24.04.03
python: python3.10
paddlepaddle: 2.6.1
```

Tips：以上dtk软件栈、python、paddle等DCU相关工具版本需要严格一一对应

## 数据集
COCO2017（在网络良好的情况下，如果没有下载数据集，程序会默认在线下载数据集）

训练数据快速下载中心:[SCNet AIDatasets](http://113.200.138.88:18080/aidatasets/) ,项目中的训练数据下载地址[COCO2017](http://113.200.138.88:18080/aidatasets/coco2017)

[训练数据](http://images.cocodataset.org/zips/train2017.zip)

[验证数据](http://images.cocodataset.org/zips/val2017.zip)

[测试数据](http://images.cocodataset.org/zips/test2017.zip)

[标签数据](https://github.com/ultralytics/yolov5/releases/download/v1.0/coco2017labels.zip)

数据集的目录结构如下：

```
├── images 
│   ├── train2017
│   ├── val2017
│   ├── test2017
├── labels
│   ├── train2017
│   ├── val2017
├── annotations
│   ├── instances_val2017.json
├── LICENSE
├── README.txt 
├── test-dev2017.txt
├── train2017.txt
├── val2017.txt

```

## 训练
- 使用本地数据集请修改configs/datasets/coco_detection.yml下的dataset_dir路径。
### 单机多卡
```bash
cd /your_code_path/yolov8_paddle
# 使用混合精度训练YOLOv8, --amp表示开启混合精度训练以避免显存溢出，--eval表示边训边验证。
python -m paddle.distributed.launch --gpus 0,1,2,3,4,5,6,7 tools/train.py -c configs/yolov8/yolov8_s_500e_coco.yml --amp --eval
```

### 单机单卡
```bash
cd /your_code_path/yolov8_paddle
python tools/train.py -c configs/yolov8/yolov8_s_500e_coco.yml --eval --amp
```
## 评估
```bash
cd /your_code_path/yolov8_paddle
python tools/eval.py -c configs/yolov8/yolov8_s_500e_coco.yml -o weights=https://paddledet.bj.bcebos.com/models/yolov8_s_500e_coco.pdparams
```
## 推理
- 使用--infer_img推理单张图片以及使用--infer_dir推理文件中的所有图片。
```bash
# 推理单张图片
python tools/infer.py -c configs/yolov8/yolov8_s_500e_coco.yml -o weights=https://paddledet.bj.bcebos.com/models/yolov8_s_500e_coco.pdparams --infer_img=demo/000000014439_640x640.jpg
# 推理文件中的所有图片
python tools/infer.py -c configs/yolov8/yolov8_s_500e_coco.yml -o weights=https://paddledet.bj.bcebos.com/models/yolov8_s_500e_coco.pdparams --infer_dir=demo
```
## result
![result.jpg](asserts%2F000000014439.jpg)
### 精度
`无`

## 应用场景
### 算法类别
`目标检测`
### 热点应用行业
`金融,交通,教育`
## 源码仓库及问题反馈
- https://developer.hpccube.com/codes/modelzoo/yolov8_paddle
## 参考资料
- https://github.com/PaddlePaddle/PaddleYOLO
